package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.income.mapper.BudgetMeasureMapper;
import com.ejianc.business.pro.income.bean.BudgetMeasureEntity;
import com.ejianc.business.pro.income.service.IBudgetMeasureService;

import java.util.List;

/**
 * 措施项清单
 * 
 * @author generator
 * 
 */
@Service("budgetMeasureService")
public class BudgetMeasureServiceImpl extends BaseServiceImpl<BudgetMeasureMapper, BudgetMeasureEntity> implements IBudgetMeasureService{

    @Override
    public void delMeasureByBudgetId(Long budgetId) {
        baseMapper.delete(new QueryWrapper<BudgetMeasureEntity>().eq("budget_id", budgetId));
    }

    @Override
    public void delMeasureBatchByBudgetId(List<Long> ids) {
        baseMapper.delete(new QueryWrapper<BudgetMeasureEntity>().in("budget_id", ids));
    }

    @Override
    public List<BudgetMeasureEntity> queryMeasureByBudgetIds(List<Long> budegtIds) {
        return baseMapper.selectList(new QueryWrapper<BudgetMeasureEntity>()
                .eq("dr",0)
                .in("budget_id", budegtIds));
    }
}
