/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.pro.income.bean.ClaimEntity;
import com.ejianc.business.pro.income.service.IClaimService;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/claim"})
public class ClaimControllerApi {
    @Autowired
    private IClaimService claimService;

    @GetMapping(value={"/queryQzspMny"})
    public CommonResponse<BigDecimal> queryQzspMny(Long projectId) {
        LambdaQueryWrapper lambdaClaim = Wrappers.lambdaQuery();
        lambdaClaim.in(ClaimEntity::getBillState, new Object[]{1, 3});
        lambdaClaim.eq(ClaimEntity::getProjectId, (Object)projectId);
        List claimEntities = this.claimService.list((Wrapper)lambdaClaim);
        BigDecimal qzspMny = BigDecimal.ZERO;
        for (ClaimEntity entity : claimEntities) {
            BigDecimal taxMny = entity.getReplyTaxMny();
            if (taxMny == null) {
                taxMny = entity.getClaimTaxMny();
            }
            if (taxMny == null) continue;
            qzspMny = qzspMny.add(taxMny);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)qzspMny);
    }
}

