/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.home.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectSetVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.constants.MetaDataUrlconstants;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.refer.util.ExceptionUtil;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class OrgUtil {
    private static final String REFER_CACHE_KEY = "refer_cache_key:";
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IProjectApi projectApi;

    public OrgVO findById(Long orgId) {
        CommonResponse resp;
        OrgVO corp = new OrgVO();
        CommonResponse rootResp = this.orgApi.findOrgByType(InvocationInfoProxy.getTenantid(), Arrays.asList(1), null);
        HashMap corpMap = new HashMap();
        if (rootResp.isSuccess() && null != rootResp.getData()) {
            for (OrgVO root : (List)rootResp.getData()) {
                CommonResponse orgResp = this.orgApi.findChildrenByParentId(root.getId());
                if (!orgResp.isSuccess() || null == orgResp.getData()) continue;
                List orgList = (List)orgResp.getData();
                corpMap.putAll(orgList.stream().filter(e -> e.getOrgType() == 2).collect(Collectors.toMap(BaseVO::getId, Function.identity())));
            }
        }
        if ((resp = this.orgApi.detailById(orgId)).isSuccess() && null != resp.getData()) {
            String innerCode = ((OrgVO)resp.getData()).getInnerCode();
            for (Long key : corpMap.keySet()) {
                if (!innerCode.contains(String.valueOf(key)) || StringUtils.isNotEmpty((CharSequence)corp.getInnerCode()) && corp.getInnerCode().length() > innerCode.length()) continue;
                corp = (OrgVO)corpMap.get(key);
            }
        }
        return corp;
    }

    public Map<Long, OrgVO> findListByIds(List<Long> orgIds) {
        HashMap<Long, OrgVO> corp = new HashMap<Long, OrgVO>();
        CommonResponse rootResp = this.orgApi.findOrgByType(InvocationInfoProxy.getTenantid(), Arrays.asList(1), null);
        HashMap orgMap = new HashMap();
        HashMap corpMap = new HashMap();
        if (rootResp.isSuccess() && null != rootResp.getData()) {
            for (OrgVO root : (List)rootResp.getData()) {
                CommonResponse orgResp = this.orgApi.findChildrenByParentId(root.getId());
                if (!orgResp.isSuccess() || null == orgResp.getData()) continue;
                List orgList = (List)orgResp.getData();
                orgMap.putAll(orgList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())));
                corpMap.putAll(orgList.stream().filter(e -> e.getOrgType() == 2).collect(Collectors.toMap(BaseVO::getId, Function.identity())));
            }
        }
        for (Long orgId : orgIds) {
            if (!orgMap.containsKey(orgId)) continue;
            String innerCode = ((OrgVO)orgMap.get(orgId)).getInnerCode();
            for (Long key : corpMap.keySet()) {
                if (!innerCode.contains(String.valueOf(key)) || corp.containsKey(orgId) && ((OrgVO)corp.get(orgId)).getInnerCode().length() > ((OrgVO)corpMap.get(key)).getInnerCode().length()) continue;
                corp.put(orgId, (OrgVO)corpMap.get(key));
            }
        }
        return corp;
    }

    public Map<Long, OrgVO> getCorpMapByIds(List<Long> orgIds) {
        HashMap<Long, OrgVO> corp = new HashMap<Long, OrgVO>();
        CommonResponse rootResp = this.orgApi.findOrgByType(InvocationInfoProxy.getTenantid(), Arrays.asList(1), null);
        HashMap orgMap = new HashMap();
        HashMap corpMap = new HashMap();
        HashMap rootMap = new HashMap();
        if (rootResp.isSuccess() && null != rootResp.getData()) {
            for (OrgVO root : (List)rootResp.getData()) {
                CommonResponse orgResp = this.orgApi.findChildrenByParentId(root.getId());
                if (!orgResp.isSuccess() || null == orgResp.getData()) continue;
                List orgList = (List)orgResp.getData();
                orgMap.putAll(orgList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())));
                corpMap.putAll(orgList.stream().filter(e -> e.getOrgType() == 2 && 1 == StringUtils.countMatches((CharSequence)e.getInnerCode(), (CharSequence)"|")).collect(Collectors.toMap(BaseVO::getId, Function.identity())));
                rootMap.putAll(orgList.stream().filter(e -> e.getOrgType() == 1).collect(Collectors.toMap(BaseVO::getId, Function.identity())));
            }
        }
        for (Long orgId : orgIds) {
            if (!orgMap.containsKey(orgId)) continue;
            String innerCode = ((OrgVO)orgMap.get(orgId)).getInnerCode();
            for (Long key : corpMap.keySet()) {
                if (!innerCode.contains(String.valueOf(key))) continue;
                corp.put(orgId, (OrgVO)corpMap.get(key));
            }
            if (corp.containsKey(orgId)) continue;
            for (Long key : rootMap.keySet()) {
                if (!innerCode.contains(String.valueOf(key))) continue;
                corp.put(orgId, (OrgVO)rootMap.get(key));
            }
        }
        return corp;
    }

    public Map<String, List<Long>> getProvinceChild() {
        CommonResponse orgResp = this.orgApi.findOrgByType(InvocationInfoProxy.getTenantid(), Arrays.asList(3, 4, 5), null);
        List orgList = new ArrayList();
        if (orgResp.isSuccess() && null != orgResp.getData()) {
            orgList = (List)orgResp.getData();
        }
        Map orgMap = orgList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
        List corpList = orgList.stream().filter(x -> 3 == x.getOrgType()).collect(Collectors.toList());
        HashMap<String, List<Long>> result = new HashMap<String, List<Long>>();
        for (OrgVO org : corpList) {
            List childIds = orgMap.values().stream().filter(x -> x.getInnerCode().contains(String.valueOf(org.getId()))).map(x -> x.getId()).distinct().collect(Collectors.toList());
            result.put(org.getName(), childIds);
        }
        return result;
    }

    public static String getCreateUserId(String userCode) {
        block8: {
            try {
                MetaDataUrlconstants urlconstants = (MetaDataUrlconstants)ContextUtil.getBean(MetaDataUrlconstants.class);
                if (!StringUtils.isNotBlank((CharSequence)userCode) || !StringUtils.isNotBlank((CharSequence)urlconstants.getBaseHost())) break block8;
                String cacheKey = "refer_cache_key:idm-employee:" + userCode;
                RedisTemplate redisTemplate = (RedisTemplate)ContextUtil.getBean((String)"redisTemplate", RedisTemplate.class);
                Object cacheValue = redisTemplate.opsForValue().get((Object)cacheKey);
                JSONObject jsonObject = null;
                if (cacheValue != null) {
                    jsonObject = JSON.parseObject((String)cacheValue.toString());
                } else {
                    String referData = OrgUtil.getReferRestUrl("idm-employee");
                    JSONObject json = JSON.parseObject((String)referData);
                    String referUrl = json.get((Object)"projectName").toString();
                    Map<String, String> reflist = new HashMap();
                    reflist = (Map)json.get((Object)"refMapList");
                    reflist.put("userCode", userCode);
                    String url = urlconstants.getBaseHost() + referUrl + "/commonrefer/getAuditInfo";
                    String jsonbackstr = null;
                    try {
                        jsonbackstr = ReferHttpClientUtils.getAndHeader((String)url, reflist);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (StringUtils.isNotBlank((CharSequence)jsonbackstr)) {
                        jsonObject = JSON.parseObject((String)jsonbackstr);
                        redisTemplate.opsForValue().set((Object)cacheKey, (Object)jsonbackstr, 5L, TimeUnit.DAYS);
                    }
                }
                if (jsonObject != null) {
                    return jsonObject.getString("id");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return userCode;
    }

    public String getCreateUserName(Long userId) {
        try {
            MetaDataUrlconstants urlconstants = (MetaDataUrlconstants)ContextUtil.getBean(MetaDataUrlconstants.class);
            if (userId != null && StringUtils.isNotBlank((CharSequence)urlconstants.getBaseHost())) {
                String cacheKey = "refer_cache_key:idm-employee:" + userId;
                RedisTemplate redisTemplate = (RedisTemplate)ContextUtil.getBean((String)"redisTemplate", RedisTemplate.class);
                Object cacheValue = redisTemplate.opsForValue().get((Object)cacheKey);
                if (cacheValue != null) {
                    JSONArray jsonArray = JSONArray.parseArray((String)cacheValue.toString());
                    JSONObject jsonObject = JSONObject.parseObject((String)jsonArray.get(0).toString());
                    return jsonObject.getString("name");
                }
                CommonResponse resp = this.employeeApi.queryEmployeByUserId(userId);
                if (resp.isSuccess()) {
                    return ((EmployeeVO)resp.getData()).getUserName();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public JSONObject getCreateUser(String userCode) {
        block8: {
            try {
                MetaDataUrlconstants urlconstants = (MetaDataUrlconstants)ContextUtil.getBean(MetaDataUrlconstants.class);
                if (!StringUtils.isNotBlank((CharSequence)userCode) || !StringUtils.isNotBlank((CharSequence)urlconstants.getBaseHost())) break block8;
                String cacheKey = "refer_cache_key:idm-employee:" + userCode;
                RedisTemplate redisTemplate = (RedisTemplate)ContextUtil.getBean((String)"redisTemplate", RedisTemplate.class);
                Object cacheValue = redisTemplate.opsForValue().get((Object)cacheKey);
                JSONObject jsonObject = null;
                if (cacheValue != null) {
                    jsonObject = JSON.parseObject((String)cacheValue.toString());
                } else {
                    String referData = OrgUtil.getReferRestUrl("idm-employee");
                    JSONObject json = JSON.parseObject((String)referData);
                    String referUrl = json.get((Object)"projectName").toString();
                    Map<String, String> reflist = new HashMap();
                    reflist = (Map)json.get((Object)"refMapList");
                    reflist.put("userCode", userCode);
                    String url = urlconstants.getBaseHost() + referUrl + "/commonrefer/getAuditInfo";
                    String jsonbackstr = null;
                    try {
                        jsonbackstr = ReferHttpClientUtils.getAndHeader((String)url, reflist);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (StringUtils.isNotBlank((CharSequence)jsonbackstr)) {
                        jsonObject = JSON.parseObject((String)jsonbackstr);
                        redisTemplate.opsForValue().set((Object)cacheKey, (Object)jsonbackstr, 5L, TimeUnit.DAYS);
                    }
                }
                if (jsonObject != null) {
                    return jsonObject;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new JSONObject();
    }

    private static String getReferRestUrl(String referCode) {
        String data = null;
        MetaDataUrlconstants urlconstants = (MetaDataUrlconstants)ContextUtil.getBean(MetaDataUrlconstants.class);
        String backData = null;
        try {
            backData = ReferHttpClientUtils.getAndHeader((String)(urlconstants.getMetaDataBaseUrl() + referCode), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JSONObject jsonobject = JSON.parseObject(backData);
        if (jsonobject.getString("code").equals("0")) {
            if (jsonobject.getString("data") != null) {
                data = JSON.parseObject((String)jsonobject.getString("data")).toJSONString();
            }
        } else {
            ExceptionUtil.wrappBusinessException((String)("\u53c2\u7167\u7f16\u7801" + referCode + "\u7684\u5b9e\u4f53\u6ca1\u6709\u53d1\u5e03\u5143\u6570\u636e!"));
        }
        return data;
    }

    public String getBillCodeByCorp(Long orgId, Long projectId, String billCode) {
        CommonResponse resp;
        StringBuilder builder = new StringBuilder();
        OrgVO corp = this.findById(orgId);
        if (StringUtils.isNotEmpty((CharSequence)corp.getShortName())) {
            builder.append(corp.getShortName() + "-");
        }
        if ((resp = this.projectApi.queryProjectDetail(projectId)).isSuccess()) {
            String projectName = ((ProjectSetVO)resp.getData()).getShortName();
            builder.append(projectName + "-");
        }
        builder.append(billCode);
        return builder.toString();
    }
}

