package com.ejianc.business.pro.income.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.pro.income.bean.ClaimEntity;
import com.ejianc.business.pro.income.service.IClaimService;
import com.ejianc.business.pro.income.vo.BudgetReportVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.List;

@RestController
@RequestMapping("/api/claim")
public class ClaimControllersApi {

    @Autowired
    private IClaimService claimService;
    @GetMapping("/queryQzspMny")
    public CommonResponse<BigDecimal> queryQzspMny(Long projectId){
        //签证索赔金额
        LambdaQueryWrapper<ClaimEntity> lambdaClaim = Wrappers.<ClaimEntity>lambdaQuery();
        lambdaClaim.in(ClaimEntity::getBillState,1,3);
        lambdaClaim.eq(ClaimEntity::getProjectId,projectId);
        List<ClaimEntity> claimEntities = claimService.list(lambdaClaim);
        BigDecimal qzspMny = BigDecimal.ZERO;
        for (ClaimEntity entity : claimEntities) {
            // 优先取 eplyTaxMny，若为空则取 claimTaxMny
            BigDecimal taxMny = entity.getReplyTaxMny();
            if (taxMny == null) {
                taxMny = entity.getClaimTaxMny();
            }

            // 处理可能为 null 的情况（若两个字段均为空则视为0）
            if (taxMny != null) {
                qzspMny = qzspMny.add(taxMny);
            }
        }
        return CommonResponse.success("查询成功",qzspMny);
    }
}
