package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.income.bean.BudgetPriceEntity;
import com.ejianc.business.pro.income.mapper.BudgetPriceMapper;
import com.ejianc.business.pro.income.service.IBudgetPriceService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 造价指标
 * 
 * @author generator
 * 
 */
@Service("budgetPriceService")
public class BudgetPriceServiceImpl extends BaseServiceImpl<BudgetPriceMapper, BudgetPriceEntity> implements IBudgetPriceService{

    @Override
    public void delByBudgetId(Long budgetId) {
        baseMapper.delete(new QueryWrapper<BudgetPriceEntity>().eq("budget_id", budgetId));
    }

    @Override
    public void delBatchByBudgetId(List<Long> ids) {
        baseMapper.delete(new QueryWrapper<BudgetPriceEntity>().in("budget_id", ids));
    }

    @Override
    public List<BudgetPriceEntity> queryByBudgetIds(List<Long> budegtIds) {
        return baseMapper.selectList(new QueryWrapper<BudgetPriceEntity>()
                .eq("dr",0)
                .in("budget_id", budegtIds));
    }
}
