package com.ejianc.business.pro.income.service.impl;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
//import com.ejianc.business.bid.vo.DeptOrderApiVO;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.ContractReviewEntity;
import com.ejianc.business.pro.income.enums.BillStateEnum;
import com.ejianc.business.pro.income.enums.ContractStatusEnum;
import com.ejianc.business.pro.income.mapper.ContractRegisterMapper;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IContractReviewService;
import com.ejianc.business.pro.income.utils.BillTypeCodeEnum;
import com.ejianc.business.pro.income.utils.ValidateUtil;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.pro.income.vo.ContractReviewVO;
import com.ejianc.business.pro.income.vo.ImportContractVO;
import com.ejianc.business.pro.income.vo.RegisterSupplementHistoryVO;
import com.ejianc.business.pro.other.bean.OtherContractEntity;
import com.ejianc.business.pro.warn.SqlParam;
import com.ejianc.business.promaterial.contract.vo.ContractVO;
import com.ejianc.business.tender.api.ITenderApi;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 施工合同登记
 * 
 * @author generator
 * 
 */
@Service("contractRegisterService")
public class ContractRegisterServiceImpl extends BaseServiceImpl<ContractRegisterMapper, ContractRegisterEntity> implements IContractRegisterService{

    private static final String INCOME_CONTRACT_REGISTER = "INCOME_CONTRACT_REGISTER";//此处需要根据实际修改

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value("${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private ITenderApi tenderApi;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IContractReviewService contractReviewService;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ValidateUtil validateUtil;

    
    @Autowired
    private IContractReviewService reviewService;
    @Autowired
    private IContractPoolApi contractPoolApi;

    @Autowired
    public ContractRegisterMapper mapper;
    
    @Override
    public ContractRegisterVO saveOrUpdate(ContractRegisterVO saveorUpdateVO) {

        // 保存时校验合同version是否一致
        if (!Objects.equals(null, saveorUpdateVO.getReviewId())) {
            if(!validateUtil.validateUpStreamVersion(String.valueOf(saveorUpdateVO.getReviewId()),
                    BillTypeCodeEnum.施工合同评审.getCode(), saveorUpdateVO.getReviewVersion())){
                throw new BusinessException("该合同已被更新，请刷新后重做！");
            }
        }
        
        ContractRegisterEntity entity = BeanMapper.map(saveorUpdateVO, ContractRegisterEntity.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(entity.getId() == null || entity.getId() == 0){
            // 新增
            if (StringUtils.isBlank(entity.getBillCode())) {
                String billCode = null;
                if (Objects.equals(entity.getSupplementFlag(), ContractRegisterVO.CONTRACT_TYPE_SUPPLEMENT)) {
                    // 查询补充协议
                    LambdaQueryWrapper<ContractRegisterEntity> wrapper = new LambdaQueryWrapper<>();
                    wrapper.eq(ContractRegisterEntity::getMainContractId, entity.getMainContractId());
                    wrapper.in(ContractRegisterEntity::getBillState, Arrays.asList(1, 3));
                    List<ContractRegisterEntity> list = this.list(wrapper);

                    String supplementNum = "";
                    if (list.size() < 10) {
                        supplementNum += "0" + (list.size() + 1);
                    }else {
                        supplementNum += (list.size() + 1);
                    }

                    billCode = entity.getMainContractCode() + "-2-" + supplementNum;
                }else {
                    BillCodeParam billCodeParam = BillCodeParam.build(INCOME_CONTRACT_REGISTER, tenantId, saveorUpdateVO);
                    CommonResponse<String> response = billCodeApi.generateBillCode(billCodeParam);
                    if(response.isSuccess()) {
                        billCode = response.getData();
                    }else{
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                }

                entity.setBillCode(billCode);
            }
            // 校验合同编号是否重复
            LambdaQueryWrapper<ContractRegisterEntity> lambda = new LambdaQueryWrapper<>();
            lambda.eq(ContractRegisterEntity::getTenantId, tenantId);
            lambda.eq(ContractRegisterEntity::getBillCode, entity.getBillCode());
            List<ContractRegisterEntity> entityList = super.list(lambda);
            if(ListUtil.isNotEmpty(entityList)) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
            
            // 新增设置 竣工结算标志、解除状态、合同状态、变更状态
            entity.setIsFinish(0);
            entity.setIsRelieve(0);
            entity.setIsSuspend(0);
            entity.setContractStatus(ContractStatusEnum.未签订.getCode());
            entity.setChangeStatus("1");
        }else {
            // 修改
            if(StringUtils.isEmpty(entity.getBillCode())){
                throw new BusinessException("编码为空，不允许保存!");
            }
            
            // 校验合同编号是否重复
            LambdaQueryWrapper<ContractRegisterEntity> lambda = new LambdaQueryWrapper<>();
            lambda.eq(ContractRegisterEntity::getBillCode, entity.getBillCode());
            lambda.eq(ContractRegisterEntity::getTenantId, tenantId);
            lambda.ne(ContractRegisterEntity::getId, entity.getId());
            List<ContractRegisterEntity> entityList = super.list(lambda);
            if(ListUtil.isNotEmpty(entityList)) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }

            // 暂估合同用
            if (null == entity.getBillState()) {
                entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            }

        }

        entity.setContractTaxMny(entity.getBaseTaxMoney()); // 合同总金额
        entity.setContractMny(entity.getBaseMoney()); // 合同总金额(无税)
        entity.setTaxMny(entity.getBaseTax()); // 合同税额
        entity.setTotalAfterCostAdjustTaxMny(ComputeUtil.safeAdd(entity.getBaseTaxMoney(), entity.getTotalCostAdjustTaxMny()));
        entity.setTotalAfterCostAdjustMny(ComputeUtil.safeAdd(entity.getBaseMoney(), entity.getTotalCostAdjustMny()));
        entity.setTotalAfterCostAdjustTax(ComputeUtil.safeAdd(entity.getBaseTax(), entity.getTotalCostAdjustTax()));
        entity.setNicContractMny(ComputeUtil.safeAdd(entity.getNotIncludeProvisionalMny(), entity.getTotalCostAdjustTaxMny()));

        entity.setBeforeChangeTaxMny(entity.getContractTaxMny()); // 变更前金额(含税)
        entity.setBeforeChangeMny(entity.getContractMny()); // 变更前金额(不含税)
        super.saveOrUpdate(entity, false);
        
        return BeanMapper.map(entity, ContractRegisterVO.class);
    }

    @Override
    public JSONObject pageList(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        // 项合同编号、目名称、合同名称、经办人
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplement_flag", new Parameter("eq", 0));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<ContractRegisterEntity> pageData = this.queryPage(param, false);


        //页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = this.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ContractRegisterVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        page.put("contractCount", contractAmountMap);
        
        return page;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.select("round(sum(base_tax_money),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount");
        resp = super.getMap(wrapper);
//        String originalAmount = resp.get("originalAmount").toString();
//        String curAmount = resp.get("curAmount").toString();
//        resp.put("originalAmount",originalAmount);
//        resp.put("curAmount",curAmount);
        return resp;
    }

    @Override
    public List<ContractRegisterVO> excelExport(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        // 项合同编号、目名称、合同名称、经办人
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");

        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplement_flag", new Parameter("eq", 0));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        List<ContractRegisterEntity> entityList = this.queryList(param);
        List<ContractRegisterVO> voList = BeanMapper.mapList(entityList, ContractRegisterVO.class);

        for (ContractRegisterVO vo : voList) {
            String contractStatus = vo.getContractStatus();
            if (StringUtils.isNotBlank(contractStatus)) {
                if (Objects.equals(contractStatus, "1")) {
                    vo.setContractStatusName("履约中");
                }
                if (Objects.equals(contractStatus, "2")) {
                    vo.setContractStatusName("已封账");
                }
                if (Objects.equals(contractStatus, "3")) {
                    vo.setContractStatusName("已解除");
                }
            }else {
                vo.setContractStatusName("");
            }
            
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        }
        
        return voList;
    }

    @Override
    public ContractRegisterVO addRegisterByRevId(Long reviewId) {
        ContractReviewEntity entity = reviewService.selectById(reviewId);
        ContractRegisterVO vo = new ContractRegisterVO();
        vo.setReviewId(reviewId);
        vo.setProjectId(entity.getProjectId());
        vo.setProjectName(entity.getProjectName());
        vo.setProjectCode(entity.getProjectCode());
        vo.setOrgId(entity.getOrgId());
        vo.setOrgCode(entity.getOrgCode());
        vo.setOrgName(entity.getOrgName());
        vo.setParentOrgId(entity.getParentOrgId());
        vo.setParentOrgCode(entity.getParentOrgCode());
        vo.setParentOrgName(entity.getParentOrgName());
        vo.setContractName(entity.getContractName());
        vo.setSignDate(new Date());
        vo.setCustomerId(entity.getCustomerId());
        vo.setCustomerName(entity.getCustomerName());
        vo.setSupplierId(entity.getSupplierId());
        vo.setSupplierName(entity.getSupplierName());
        vo.setConstructionPartner(entity.getConstructionPartner());
        vo.setTaxRate(entity.getTaxRate());
        vo.setBaseTaxMoney(entity.getContractTaxMny());
        vo.setBaseMoney(entity.getContractMny());
        vo.setBaseTax(entity.getTaxMny());
//        vo.setTaxMny(entity.getTaxMny());
//        vo.setContractMny(entity.getContractMny());
//        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setStartDate(entity.getStartDate());
        vo.setEndDate(entity.getEndDate());
        vo.setSchedule(entity.getSchedule());
        vo.setContractPartyc(entity.getContractPartyc());
        vo.setConjoinedContractTotalMny(entity.getConjoinedContractTotalMny());
        vo.setEmployeeId(sessionManager.getUserContext().getEmployeeId());
        vo.setEmployeeName(sessionManager.getUserContext().getUserName());
        vo.setDeptId(sessionManager.getUserContext().getDeptId());
        vo.setDeptName(sessionManager.getUserContext().getDeptName());
        vo.setSignDate(new Date());
        
        
        // 查询主合同对应的合同登记
        LambdaQueryWrapper<ContractRegisterEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractRegisterEntity::getReviewId, entity.getMainContractId());
        wrapper.orderByDesc(ContractRegisterEntity::getCreateTime);
        List<ContractRegisterEntity> list = this.list(wrapper);
        if (ListUtil.isNotEmpty(list)) {
            ContractRegisterEntity registerEntity = list.get(0);
            vo.setMainContractId(registerEntity.getId());
            vo.setMainContractCode(registerEntity.getBillCode());
            vo.setMainContractName(registerEntity.getContractName());
        }
        
        return vo;
    }

    @Override
    public ContractRegisterVO addSupplementByConId(Long mainContractId) {
        ContractRegisterEntity entity = this.selectById(mainContractId);
        ContractRegisterVO vo = new ContractRegisterVO();
        vo.setProjectId(entity.getProjectId());
        vo.setProjectName(entity.getProjectName());
        vo.setProjectCode(entity.getProjectCode());
        vo.setOrgId(entity.getOrgId());
        vo.setOrgCode(entity.getOrgCode());
        vo.setOrgName(entity.getOrgName());
        vo.setParentOrgId(entity.getParentOrgId());
        vo.setParentOrgCode(entity.getParentOrgCode());
        vo.setParentOrgName(entity.getParentOrgName());
        vo.setContractType(entity.getContractType());
        vo.setCustomerId(entity.getCustomerId());
        vo.setCustomerName(entity.getCustomerName());
        vo.setSupplierId(entity.getSupplierId());
        vo.setSupplierName(entity.getSupplierName());
        vo.setConstructionPartner(entity.getConstructionPartner());
        vo.setTaxRate(entity.getTaxRate());
        vo.setContractPartyc(entity.getContractPartyc());
        vo.setConjoinedContractTotalMny(entity.getConjoinedContractTotalMny());
        vo.setEmployeeId(sessionManager.getUserContext().getEmployeeId());
        vo.setEmployeeName(sessionManager.getUserContext().getUserName());
        vo.setDeptId(sessionManager.getUserContext().getDeptId());
        vo.setDeptName(sessionManager.getUserContext().getDeptName());
        vo.setMainContractId(mainContractId);
        vo.setMainContractName(entity.getContractName());
        vo.setMainContractCode(entity.getBillCode());
        
        return vo;
    }

    @Override
    public RegisterSupplementHistoryVO querySupplementRecord(Long id) {
        ContractRegisterEntity entity = this.selectById(id);
        RegisterSupplementHistoryVO vo = new RegisterSupplementHistoryVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setContractMny(entity.getContractMny());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setIsFinish(entity.getIsFinish());
        vo.setIsRelieve(entity.getIsRelieve());
        
        // 查询补充协议
        LambdaQueryWrapper<ContractRegisterEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractRegisterEntity::getMainContractId, id);
        wrapper.orderByDesc(ContractRegisterEntity::getSignDate);
        List<ContractRegisterEntity> supplementList = super.list(wrapper);
        
        vo.setSupplementToalTaxMny(supplementList.stream().map(ContractRegisterEntity::getContractTaxMny).filter(x->x != null).reduce(BigDecimal.ZERO, BigDecimal::add));
        vo.setSupplementToalMny(supplementList.stream().map(ContractRegisterEntity::getContractMny).filter(x->x != null).reduce(BigDecimal.ZERO, BigDecimal::add));
        vo.setDetailList(BeanMapper.mapList(supplementList, ContractRegisterVO.class));
        
        return vo;
    }

    @Override
    public List<ContractRegisterEntity> queryRegisterByReviewId(Long reviewId) {
//        List<Integer> stateList = new ArrayList<>();
//        stateList.add(1);
//        stateList.add(3);
        
        LambdaQueryWrapper<ContractRegisterEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractRegisterEntity::getReviewId, reviewId);
//        wrapper.in(ContractRegisterEntity::getBillState, stateList);
        
        List<ContractRegisterEntity> list = this.list(wrapper);
        if (ListUtil.isEmpty(list)) {
            return new ArrayList<>();
        }

        return list;
    }

    @Override
    public boolean pushContract(ContractRegisterVO vo,Boolean updateLevel) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert(vo, data);
            /*if(updateLevel){ // 更新
                delContractFromPool(vo.getId());
            }*/
            if("1".equals(vo.getContractStatus())){
                data.setPerformanceStatus("2");
            }
            if("2".equals(vo.getContractStatus())){
                data.setPerformanceStatus("3");
            }
            if("3".equals(vo.getContractStatus())){
                data.setPerformanceStatus("4");
            }
            data.setChangeStatus(Integer.parseInt(vo.getChangeStatus()));
            data.setContractProperty(1);
            data.setSourceType(ContractTypeEnum.施工合同.getTypeCode());

            data.setUpdateLevel(UpdateLevelEnum.更新非空字段.getLevelCode());
            data.setSourceId(vo.getId());
            String url = null;
            if (vo.getSupplementFlag() == 0) {
                url = "/ejc-proincome-frontend/#/contractRegister/contractApprove?id=" + vo.getId();
            }else {
                url = "/ejc-proincome-frontend/#/contractRegister/supplementCard?id=";
            }
            data.setPcCardUrl(url);
            //data.setMobileCardUrl(baseHost+"ejc-proincome-mobile/#/contractRegister/card");
            data.setCategoryId(1524001989040545793L);// 施工合同类别是自定义档案，合同池写死
            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);

            if(transDataResp.isSuccess()) {
                return true;
            } else {
                logger.error("合同id-{}推送合同池失败，{}",vo.getId(), transDataResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", vo.getId(), e);
        }
        return false;
    }

    @Override
    public boolean delContractFromPool(Long id) {
        ContractPoolVO c = new ContractPoolVO();
        c.setSourceId(id);

        logger.info("将合同-{}从合同池中删除！", id);
        CommonResponse<String> delDataResp = contractPoolApi.deleteContract(c);
        if(delDataResp.isSuccess()) {
            return true;
        }

        logger.error("将合同-{}从合同池中删除失败, {}！", id, delDataResp.getMsg());
        return false;
    }

    @Override
    public List<Map<String,Object>> queryBudgetWarnContract(List<SqlParam> sqlParamList){
        return mapper.queryBudgetWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String,Object>> queryCostWarnContract(List<SqlParam> sqlParamList){
        return mapper.queryCostWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String,Object>> queryContractRegisterWarnContract(List<SqlParam> sqlParamList){
        return mapper.queryContractRegisterWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String,Object>> querySettleReportWarnContract(List<SqlParam> sqlParamList){
        return mapper.querySettleReportWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String,Object>> queryFinalizedWarnContract(List<SqlParam> sqlParamList){
        return mapper.queryFinalizedWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String,Object>> queryBudgetInWarnContract(List<SqlParam> sqlParamList){
        return mapper.queryBudgetInWarnContract(sqlParamList);
    }

    @Override
    public List<ContractRegisterVO> getAllValidConsByProjectId(Long projectId) {
        List<ContractRegisterVO> resp = new ArrayList<>();
        QueryWrapper<ContractRegisterEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        query.in("bill_state", new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        query.orderByDesc("create_time");

        List<ContractRegisterEntity> list = super.list(query);
        if(CollectionUtils.isNotEmpty(list)) {
            resp = BeanMapper.mapList(list, ContractRegisterVO.class);
        }

        return resp;
    }

    @Override
    public CommonResponse<JSONObject> excelImportProMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        Long tenantid = InvocationInfoProxy.getTenantid();
        // 用于存储从组织查询到的数据，key为当前行的所属组织，value为查询到的组织数据
        Map<String, OrgVO> orgVOMap = new HashMap<>();
        // 用于存储从项目池查询到的数据，key为 当前行的项目名称 ，value为查询到的项目池数据
        Map<String, ProjectPoolSetVO> projectPoolVoMap = new HashMap<>();
        // 用于存储从合同大类表查询到的数据，key为 当前行的 合同大类+&+合同类别，value为查询到的合同大类数据
//        Map<String, TemplateCategoryEntity> categoryMap = new HashMap<>();
        // 用于存储合同编码为空的数据查询到的合同数据，key为 当前行的合同名称
        Map<String, ContractRegisterEntity> contractPoolVoNoCodeMap = new HashMap<>();
        // 用于存储从供应商查询到的数据，key为 当前行的合同乙方 ，value为查询到的供应商数据
        Map<String, SupplierVO> supplierVOMap = new HashMap<>();
        // 用于存储从组织查询到的数据-用于获取当前项目所在项目部数据，key为 当前行的项目所在项目部id ，value为查询到的组织数据
        Map<String, OrgVO> projectOrgVoMap = new HashMap<>();

        Map<String, ContractReviewEntity> contractReviewEntityMap = new HashMap<>();

//        Map<String, SyncContractEntity> syncContractEntityMap = new HashMap<>();
//        Map<String, TemplateCategoryEntity> categoryMap = new HashMap<>();
        // 用于存储从员工查询到的数据，key为 当前行的 经办人，value为查询到的经办人数据
        Map<String, EmployeeVO> employeeVOMap = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            if (entity == null) {
                continue;
            }
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            if (mf == null) {
                throw new BusinessException("导入的文件中没有数据");
            }
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<ImportContractVO> successList = new ArrayList<>();
            List<ImportContractVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 23) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                if (result.size() >= 10000) {
                    throw new BusinessException("文件数据不能超过10000行，超过请分批次多次导入");
                }
                // 承揽方式 从自定义档案接口查询计价方式并封装成map
                Map<String, String> bearTypeDefMap = new HashMap<>();
                // 合同类型 从自定义档案接口查询计价方式并封装成map
                Map<String, String> contractTypeDefMap = new HashMap<>();
                // 合同计价形式 从自定义档案接口查询计价方式并封装成map
                Map<String, String> contractValuationTypeDefMap = new HashMap<>();
                // 承包模式 从自定义档案接口查询计价方式并封装成map
                Map<String, String> contractualModelDefMap = new HashMap<>();
                Map<String, Object> defParamMap = new HashMap<>();
                defParamMap.put("tenantId", tenantid);
                String defCondition = JSONObject.toJSONString(defParamMap);
                CommonResponse<List<Map<String, Object>>> defRes1 = defdocApi.queryDetailListByDefdocCode("bear_type", defCondition);
                if (defRes1.isSuccess() && defRes1.getData() != null) {
                    List<Map<String, Object>> defList = defRes1.getData();
                    bearTypeDefMap = defList.stream().collect(Collectors.toMap(item -> item.get("name") == null ? "" : item.get("name").toString(), item -> item.get("id") == null ? "" : item.get("id").toString()));
                }
                CommonResponse<List<Map<String, Object>>> defRes2 = defdocApi.queryDetailListByDefdocCode("contract_type", defCondition);
                if (defRes2.isSuccess() && defRes2.getData() != null) {
                    List<Map<String, Object>> defList = defRes2.getData();
                    contractTypeDefMap = defList.stream().collect(Collectors.toMap(item -> item.get("name") == null ? "" : item.get("name").toString(), item -> item.get("id") == null ? "" : item.get("id").toString()));
                }
                CommonResponse<List<Map<String, Object>>> defRes3 = defdocApi.queryDetailListByDefdocCode("contract-valuation-type", defCondition);
                if (defRes3.isSuccess() && defRes3.getData() != null) {
                    List<Map<String, Object>> defList = defRes3.getData();
                    contractValuationTypeDefMap = defList.stream().collect(Collectors.toMap(item -> item.get("name") == null ? "" : item.get("name").toString(), item -> item.get("id") == null ? "" : item.get("id").toString()));
                }
                CommonResponse<List<Map<String, Object>>> defRes4 = defdocApi.queryDetailListByDefdocCode("pro-market-project-type", defCondition);
                if (defRes4.isSuccess() && defRes4.getData() != null) {
                    List<Map<String, Object>> defList = defRes4.getData();
                    contractualModelDefMap = defList.stream().collect(Collectors.toMap(item -> item.get("name") == null ? "" : item.get("name").toString(), item -> item.get("id") == null ? "" : item.get("id").toString()));
                }
                for (int i = 1; i < result.size(); i++) {
                    Long orgIdP = 0L;
                    List<String> datas = result.get(i);
                    ImportContractVO detailVO = new ImportContractVO();
                    // 从Excel拿到的数据
//                    String parentOrgNameEx = datas.get(0);// 所属组织，必填项，与【组织管理】“组织名称”进行匹配
//                    detailVO.setParentOrgName(parentOrgNameEx);
                    String contractCodeEx = datas.get(0);// 合同编码，非必填
                    detailVO.setBillCode(contractCodeEx);
                    String reviewName = datas.get(1); //合同评审,非必填
                    detailVO.setReviewName(reviewName);
                    String bearTypeName = datas.get(2); //承揽方式,非必填
                    detailVO.setBearTypeName(bearTypeName);
                    String contractNameEx = datas.get(3);// 合同名称，必填项
                    detailVO.setContractName(contractNameEx);
                    String projectNameEx = datas.get(4);// 项目名称，必填项，与【项目池】的“项目名称”进行匹配
                    detailVO.setProjectName(projectNameEx);
                    String contractTypeName = datas.get(5);// 合同类别，必填项，合同类别与合同大类必须匹配
                    detailVO.setContractTypeName(contractTypeName);
                    String partyaNameEx = datas.get(6);// 合同甲方，必填项，与【客户库】的“客户名称”进行匹配，如果匹配多了，就提示
                    detailVO.setCustomerName(partyaNameEx);
                    String partybNameEx = datas.get(7);// 合同乙方，必填项，与【供应商库】的“供应商名称”进行匹配，如果匹配多了，就提示
                    detailVO.setSupplierName(partybNameEx);
                    String signDateStrEx = datas.get(8);// 签订日期，必填项，日期
                    String contractValuationTypeName = datas.get(9); //计价方式 非必填
                    detailVO.setContractValuationTypeName(contractValuationTypeName);
                    String contractualModelName = datas.get(10); // 承包模式,非必填
                    detailVO.setContractualModelName(contractualModelName);
                    String taxRateEx = datas.get(11);// 税率，数值，必填项，大于等于0，保留2位小数
                    String baseTaxMoney = datas.get(12); //合同签订金额,必填项，数值，保留2位小数
                    String baseMoney = datas.get(13);//*合同签订金额(无税),必填项，数值，保留2位小数
                    String baseTax = datas.get(14); //合同签订税额,非必填，数值，保留2位小数
                    String startDate = datas.get(15); //合同开工日期
                    String endDate = datas.get(16);//合同竣工日期
                    String contractStatus = datas.get(17); //合同履约状态,当计租方式为月租时必填
                    detailVO.setContractStatus(contractStatus);
                    String employeeName = datas.get(18); //经办人,必填
                    detailVO.setEmployeeName(employeeName);
                    String overReducedTaxMny = datas.get(19); //超报审减费
                    String meterType = datas.get(20); //计量方式
                    detailVO.setMeterType(meterType);
                    String progressPaymentClause = datas.get(21);//工程进度款支付条款
                    detailVO.setProgressPaymentClause(progressPaymentClause);
                    String memoEx = datas.get(22);// 备注，非必填
                    detailVO.setMemo(memoEx);

                    if (StringUtils.isNotBlank(contractCodeEx)){
                        LambdaQueryWrapper<ContractRegisterEntity> queryWrapper = new LambdaQueryWrapper<>();
                        queryWrapper.eq(ContractRegisterEntity::getBillCode, contractCodeEx);
                        queryWrapper.eq(ContractRegisterEntity::getDr, 0);
                        queryWrapper.eq(ContractRegisterEntity::getTenantId, tenantid);
                        if (!list(queryWrapper).isEmpty()) {
                            detailVO.setErrorMessage("合同编码已存在");
                        }
                    }
                    // 合同名称
                    if (org.apache.commons.lang3.StringUtils.isBlank(contractNameEx)) {
                        detailVO.setErrorMessage("合同名称不可为空");
                    } else {
                        detailVO.setContractName(contractNameEx);
                    }

                    //合同评审
                    if (StringUtils.isNotBlank(reviewName)){
                        if (MapUtils.isEmpty(contractReviewEntityMap) || contractReviewEntityMap.get(reviewName) == null){
                            LambdaQueryWrapper<ContractReviewEntity> queryWrapper = new LambdaQueryWrapper<>();
                            queryWrapper.eq(ContractReviewEntity::getContractName, reviewName);
                            queryWrapper.eq(ContractReviewEntity::getTenantId, tenantid);
                            queryWrapper.eq(ContractReviewEntity::getDr, 0);
                            List<ContractReviewEntity> list = contractReviewService.list(queryWrapper);
                            if (CollectionUtils.isEmpty(list)){
                                detailVO.setErrorMessage("根据合同评审名称查询不到合同评审信息");
                            }else{
                                contractReviewEntityMap.put(reviewName, list.get(0));
                                ContractReviewEntity contractReviewEntity = list.get(0);
                                detailVO.setReviewId(contractReviewEntity.getId());
                                detailVO.setReviewName(reviewName);
                            }
                        }else{
                            ContractReviewEntity contractReviewEntity = contractReviewEntityMap.get(reviewName);
                            detailVO.setReviewId(contractReviewEntity.getId());
                            detailVO.setReviewName(reviewName);
                        }

                    }
                    //承揽方式
                    if (StringUtils.isNotBlank(bearTypeName)){
                        if (MapUtils.isEmpty(bearTypeDefMap) || bearTypeDefMap.get(bearTypeName) == null){
                            detailVO.setErrorMessage("根据承揽方式名称查询不到承揽方式信息");
                        }else{
                            detailVO.setBearType(Long.parseLong(bearTypeDefMap.get(bearTypeName)));
                        }
                    }
                    // 项目名称
                    if (org.apache.commons.lang3.StringUtils.isBlank(projectNameEx)) {
                        detailVO.setErrorMessage("项目名称不可为空");
                    }else{
                        ProjectPoolSetVO projectPoolSetVOFlag=null;
                        if (MapUtils.isEmpty(projectPoolVoMap) || projectPoolVoMap.get(projectNameEx) == null) {
                            CommonResponse<List<ProjectPoolSetVO>> projectVOListRes = projectPoolApi.queryProjectListByNameAndTenantId(projectNameEx, tenantid);
                            if (projectVOListRes.isSuccess()) {
                                List<ProjectPoolSetVO> projectVOList = projectVOListRes.getData();
                                if (CollectionUtils.isEmpty(projectVOList)) {
                                    detailVO.setErrorMessage("根据项目名称查询不到项目信息");
                                }else{
                                    if (projectVOList.size() == 1) {
                                        ProjectPoolSetVO projectPoolSetVO = projectVOList.get(0);
                                        projectPoolSetVOFlag=projectPoolSetVO;
                                        Long orgId = projectPoolSetVO.getOrgId();
                                        String orgCode = projectPoolSetVO.getOrgCode();
                                        String orgName = projectPoolSetVO.getOrgName();
                                        Long projectDepartmentId1 = projectPoolSetVO.getProjectDepartmentId();
                                        String projectDepartmentName = projectPoolSetVO.getProjectDepartmentName();
                                        String projectDepartmentCode = projectPoolSetVO.getProjectDepartmentCode();
                                        detailVO.setOrgId(projectDepartmentId1);
                                        detailVO.setOrgCode(projectDepartmentCode);
                                        detailVO.setOrgName(projectDepartmentName);
                                        detailVO.setParentOrgId(orgId);
                                        detailVO.setParentOrgCode(orgCode);
                                        detailVO.setParentOrgName(orgName);
                                        detailVO.setProjectId(projectPoolSetVO.getId());
                                        detailVO.setProjectName(projectPoolSetVO.getName());
                                        projectPoolVoMap.put(projectNameEx, projectPoolSetVO);
                                    }else{
                                        detailVO.setErrorMessage("根据项目名称查询到多个项目信息");
                                    }
//
                                }
                            }else{
                                detailVO.setErrorMessage("根据项目名称查询不到项目信息");
                            }
                        }else{
                            ProjectPoolSetVO projectPoolSetVO = projectPoolVoMap.get(projectNameEx);
                            projectPoolSetVOFlag=projectPoolSetVO;
                            Long orgId = projectPoolSetVO.getOrgId();
                            String orgCode = projectPoolSetVO.getOrgCode();
                            String orgName = projectPoolSetVO.getOrgName();
                            Long projectDepartmentId1 = projectPoolSetVO.getProjectDepartmentId();
                            String projectDepartmentName = projectPoolSetVO.getProjectDepartmentName();
                            String projectDepartmentCode = projectPoolSetVO.getProjectDepartmentCode();
                            detailVO.setOrgId(projectDepartmentId1);
                            detailVO.setOrgCode(projectDepartmentCode);
                            detailVO.setOrgName(projectDepartmentName);
                            detailVO.setParentOrgId(orgId);
                            detailVO.setParentOrgCode(orgCode);
                            detailVO.setParentOrgName(orgName);
                            detailVO.setProjectId(projectPoolSetVO.getId());
                            detailVO.setProjectName(projectPoolSetVO.getName());
                        }
                        //组织id获取code
                        if (projectPoolSetVOFlag!=null){
                            Long orgId = projectPoolSetVOFlag.getOrgId();
                            Long projectDepartmentId1 = projectPoolSetVOFlag.getProjectDepartmentId();

                            if (projectOrgVoMap.isEmpty() || projectOrgVoMap.get(String.valueOf(orgId)) == null){
                                CommonResponse<OrgVO> orgVO = orgApi.detailById(orgId);
                                if (orgVO.isSuccess()){
                                    OrgVO data = orgVO.getData();
                                    projectOrgVoMap.put(String.valueOf(orgId),data);
                                    if(data==null){
                                        detailVO.setErrorMessage("根据组织id查询不到组织信息");
                                    }else{
                                        detailVO.setParentOrgCode(data.getCode());
                                    }
                                }else{
                                    detailVO.setErrorMessage(orgVO.getMsg());
                                }

                            }else{
                                detailVO.setParentOrgCode(projectOrgVoMap.get(String.valueOf(orgId)).getCode());
                            }
                            if (projectOrgVoMap.isEmpty() || projectOrgVoMap.get(String.valueOf(projectDepartmentId1)) == null){
                                CommonResponse<OrgVO> orgVO = orgApi.detailById(projectDepartmentId1);
                                if (orgVO.isSuccess()){
                                    OrgVO data = orgVO.getData();
                                    projectOrgVoMap.put(String.valueOf(projectDepartmentId1),data);
                                    if(data==null){
                                        detailVO.setErrorMessage("根据组织id查询不到组织信息");
                                    }else{
                                        detailVO.setOrgCode(data.getCode());
                                    }
                                }
                            }else{
                                detailVO.setOrgCode(projectOrgVoMap.get(String.valueOf(projectDepartmentId1)).getCode());
                            }
                        }
                        else{
                            detailVO.setErrorMessage("根据项目名称查询不到项目信息");
                        }

                    }

                    //合同类别
                    if (org.apache.commons.lang3.StringUtils.isBlank(contractTypeName)) {
                        detailVO.setErrorMessage("合同类别不能为空");
                    } else {
                        if (MapUtils.isEmpty(contractTypeDefMap) || contractTypeDefMap.get(contractTypeName) == null) {
                            detailVO.setErrorMessage("合同类别输入类型错误");
                        }else{
                            detailVO.setContractType(Long.parseLong(contractTypeDefMap.get(contractTypeName)));
                        }
                    }

                    // 合同甲方
                    if (org.apache.commons.lang3.StringUtils.isBlank(partyaNameEx)) {
                        detailVO.setErrorMessage("合同甲方不可为空");
                    } else {
                        // 与【客户库】的“客户名称”进行匹配---目前甲方暂时使用组织的数据
                        // 先从缓存map中查询，若map中有数据，优先从map中匹配，减少数据库查询次数
                        if (MapUtils.isEmpty(supplierVOMap) || supplierVOMap.get(partyaNameEx) == null) {
                            CommonResponse<SupplierVO> orgVORes = shareSupplierApi.findOneByName(partyaNameEx,tenantid);

                            // 缓存map为空或当前map中尚未存储当前行的数据，则调用接口查询
//                            CommonResponse<OrgVO> orgVORes = orgApi.findByNameAndTenantId(partyaNameEx, tenantid);
                            if (orgVORes.isSuccess()) {
                                SupplierVO orgVO = orgVORes.getData();
                                if (orgVO == null) {
                                    detailVO.setErrorMessage("根据合同甲方查询数据失败");
                                } else {
                                    // 将查询到的数据缓存到map中
                                    supplierVOMap.put(partyaNameEx, orgVO);
                                    // 封装数据
                                    detailVO.setCustomerId(orgVO.getId());
                                    detailVO.setCustomerName(orgVO.getName());

                                }
                            } else {
                                detailVO.setErrorMessage("根据合同甲方查询数据失败");
                            }
                        } else {
                            SupplierVO orgVO = supplierVOMap.get(partyaNameEx);
                            detailVO.setCustomerId(orgVO.getId());
                            detailVO.setCustomerName(orgVO.getName());

                        }
                    }
                    // 合同乙方
                    if (org.apache.commons.lang3.StringUtils.isBlank(partybNameEx)) {
                        detailVO.setErrorMessage("合同乙方不可为空");
                    } else {
                        // 与【供应商库】的“供应商名称”进行匹配
                        // 先从缓存map中查询，若map中有数据，优先从map中匹配，减少数据库查询次数
                        if (MapUtils.isEmpty(supplierVOMap) || supplierVOMap.get(partybNameEx) == null) {
                            // 缓存map为空或当前map中尚未存储当前行的数据，则调用接口查询
                            CommonResponse<SupplierVO> supplierVORes = shareSupplierApi.findOneByName(partybNameEx, tenantid);
                            if (supplierVORes.isSuccess()) {
                                SupplierVO supplierVO = supplierVORes.getData();
                                if (supplierVO == null) {
                                    detailVO.setErrorMessage("根据合同乙方查询数据失败");
                                } else {
                                    // 将查询到的数据缓存到map中
                                    supplierVOMap.put(partybNameEx, supplierVO);
                                    // 封装数据

                                    detailVO.setSupplierId(supplierVO.getId());
                                    detailVO.setSupplierName(supplierVO.getName());
                                }
                            } else {
                                detailVO.setErrorMessage("根据合同乙方查询数据失败");
                            }
                        } else {
                            SupplierVO supplierVO = supplierVOMap.get(partybNameEx);

                            detailVO.setSupplierId(supplierVO.getId());
                            detailVO.setSupplierName(supplierVO.getName());
                        }
                    }

                    // 签订日期
                    if (org.apache.commons.lang3.StringUtils.isBlank(signDateStrEx)) {
                        detailVO.setErrorMessage("签订日期不可为空");
                    } else {
                        try {
                            detailVO.setSignDate(HSSFDateUtil.getJavaDate(Double.parseDouble(signDateStrEx)));
                        } catch (Exception e) {
                            detailVO.setErrorMessage("签订日期填写不正确");
                        }
                    }
                    //计价方式
                    if (StringUtils.isNotBlank(contractValuationTypeName)){
                        if (MapUtils.isEmpty(contractValuationTypeDefMap) || contractValuationTypeDefMap.get(contractValuationTypeName) == null){
                            detailVO.setErrorMessage("计价方式输入类型错误");
                        }else{
                            detailVO.setContractValuationType(Long.parseLong(contractValuationTypeDefMap.get(contractValuationTypeName)));
                        }
                    }
                    //承包模式
                    if (StringUtils.isNotBlank(contractualModelName)){
                        if (MapUtils.isEmpty(contractualModelDefMap) || contractualModelDefMap.get(contractualModelName) == null){
                            detailVO.setErrorMessage("承包模式输入类型错误");
                        }else{
                            detailVO.setContractualModel(Long.parseLong(contractualModelDefMap.get(contractualModelName)));
                        }
                    }
                    // 税率
                    if (org.apache.commons.lang3.StringUtils.isBlank(taxRateEx)) {
                        detailVO.setErrorMessage("税率不可为空");
                    } else {
                        try {
                            BigDecimal taxRate = new BigDecimal(taxRateEx);
                            if (taxRate.compareTo(BigDecimal.ZERO) < 0) {
                                detailVO.setErrorMessage("税率不可小于0");
                            } else {
                                detailVO.setTaxRate(taxRate);
                            }
                        } catch (Exception e) {
                            detailVO.setErrorMessage("税率必须为数字");
                        }
                    }
                    //签订金额
                    if (StringUtils.isBlank(baseTaxMoney)){
                        detailVO.setErrorMessage("合同签订金额不可为空");
                    }else{
                        try {
                            BigDecimal taxMoney = new BigDecimal(baseTaxMoney);
                            if (taxMoney.compareTo(BigDecimal.ZERO) < 0){
                                detailVO.setErrorMessage("合同签订金额不可小于0");
                            }else{
                                detailVO.setBaseTaxMoney(taxMoney);
                                detailVO.setContractTaxMny(taxMoney);
                            }
                        }catch (Exception e){
                            detailVO.setErrorMessage("合同签订金额必须为数字");
                        }
                    }
                    //*合同签订金额(无税)
                    if (StringUtils.isBlank(baseMoney)){
                        detailVO.setErrorMessage("合同签订金额(无税)不可为空");
                    }else{
                        try {
                            BigDecimal money = new BigDecimal(baseMoney);
                            if (money.compareTo(BigDecimal.ZERO) < 0){
                                detailVO.setErrorMessage("合同签订金额(无税)不可小于0");
                            }else{
                                detailVO.setBaseMoney(money);
                                detailVO.setContractMny(money);
                            }
                        }catch (Exception e){
                            detailVO.setErrorMessage("合同签订金额(无税)必须为数字");
                        }
                    }
                    //合同签订税额
                    if (StringUtils.isNotBlank(baseTax)){
                        try {
                            BigDecimal tax = new BigDecimal(baseTax);
                            if (tax.compareTo(BigDecimal.ZERO) < 0){
                                detailVO.setErrorMessage("合同签订税额不可小于0");
                            }else{
                                detailVO.setBaseTax(tax);
                                detailVO.setTaxMny(tax);
                            }
                        }catch (Exception e){
                            detailVO.setErrorMessage("合同签订税额必须为数字");
                        }
                    }
                    //合同开工日期
                    if (StringUtils.isNotBlank(startDate)){
                        try {
                            detailVO.setStartDate(HSSFDateUtil.getJavaDate(Double.parseDouble(startDate)));
                        } catch (Exception e) {
                            detailVO.setErrorMessage("签订日期填写不正确");
                        }
                    }
                    if (StringUtils.isNotBlank(endDate)){
                        try {
                            detailVO.setEndDate(HSSFDateUtil.getJavaDate(Double.parseDouble(endDate)));
                        } catch (Exception e) {
                            detailVO.setErrorMessage("合同结束日期填写不正确");
                        }
                    }
                    if (StringUtils.isNotBlank(startDate) && StringUtils.isNotBlank(endDate)){
                        try {
                            Date start = HSSFDateUtil.getJavaDate(Double.parseDouble(startDate));
                            Date end = HSSFDateUtil.getJavaDate(Double.parseDouble(endDate));
                            if (start.compareTo(end) > 0){
                                detailVO.setErrorMessage("合同结束日期不能早于开始日期");
                            }else{
                                detailVO.setSchedule((int) DateUtil.between(start, end, DateUnit.DAY)+1);
                            }
                        }catch (Exception e){
                            detailVO.setErrorMessage("日期格式填写不正确");
                        }
                    }
                    //经办人
                    if (StringUtils.isBlank(employeeName)){
                        detailVO.setErrorMessage("经办人不可为空");
                    }else{
                        if (MapUtils.isEmpty(employeeVOMap) || employeeVOMap.get(employeeName)==null){
                            CommonResponse<Map<String, EmployeeVO>> map = employeeApi.getEmployeeMapByNames(Collections.singletonList(employeeName));
                            if (map.isSuccess() && null != map.getData()){
                                Map<String, EmployeeVO> employee = map.getData();
                                if (MapUtils.isEmpty(employee) || employee.get(employeeName)==null){
                                    detailVO.setErrorMessage("经办人不存在");
                                }else{
                                    EmployeeVO employeeVO = employee.get(employeeName);
                                    detailVO.setEmployeeId(employeeVO.getId());
                                    detailVO.setEmployeeName(employeeVO.getName());
                                    detailVO.setDeptId(employeeVO.getDeptId());
                                    detailVO.setDeptName(employeeVO.getDeptName());
                                }
                            }
                        }else{
                            EmployeeVO employeeVO = employeeVOMap.get(employeeName);
                            detailVO.setEmployeeId(employeeVO.getId());
                            detailVO.setEmployeeName(employeeVO.getName());
                            detailVO.setDeptId(employeeVO.getDeptId());
                            detailVO.setDeptName(employeeVO.getDeptName());
                        }
                    }

                    //超报审减费
                    if (StringUtils.isNotBlank(overReducedTaxMny)){
                        try {
                            BigDecimal mny = new BigDecimal(overReducedTaxMny);
                            if (mny.compareTo(BigDecimal.ZERO) < 0){
                                detailVO.setErrorMessage("超报审减费不可小于0");
                            }else{
                                detailVO.setOverReducedTaxMny(mny);
                            }
                        }catch (Exception e){
                            detailVO.setErrorMessage("超报审减费必须为数字");
                        }
                    }
                    //计量方式
                    if (StringUtils.isNotBlank(meterType)){
                        if ("按月计量".equals(meterType)){
                            detailVO.setMeterType("1");
                        } else if ("按节点计量".equals(meterType)) {
                            detailVO.setMeterType("2");
                        }
                    }
                    //工程进度款支付条款
                    detailVO.setProgressPaymentClause(progressPaymentClause);
                    //合同履约状态
                    if (org.apache.commons.lang.StringUtils.isBlank(contractStatus)) {
                        detailVO.setErrorMessage("合同履约状态不可为空");
                    } else{
                        if (org.apache.commons.lang3.StringUtils.isBlank(contractStatus)){
                            detailVO.setContractStatus(ContractStatusEnum.未签订.getCode());
                            detailVO.setContractStatusName(ContractStatusEnum.未签订.getDescription());
                        }
                        if (ContractStatusEnum.未签订.getDescription().equals(contractStatus)) {
                            detailVO.setContractStatus(ContractStatusEnum.未签订.getCode());
                            detailVO.setContractStatusName(ContractStatusEnum.未签订.getDescription());
                        } else if (ContractStatusEnum.履约中.getDescription().equals(contractStatus)) {
                            detailVO.setContractStatus(ContractStatusEnum.履约中.getCode());
                            detailVO.setContractStatusName(ContractStatusEnum.履约中.getDescription());
                        } else if (ContractStatusEnum.已终止.getDescription().equals(contractStatus)) {
                            detailVO.setContractStatus(ContractStatusEnum.已终止.getCode());
                            detailVO.setContractStatusName(ContractStatusEnum.已终止.getDescription());
                        } else if (ContractStatusEnum.已解除.getDescription().equals(contractStatus)) {
                            detailVO.setContractStatus(ContractStatusEnum.已解除.getCode());
                            detailVO.setContractStatusName(ContractStatusEnum.已解除.getDescription());
                        } else if (ContractStatusEnum.已冻结.getDescription().equals(contractStatus)) {
                            detailVO.setContractStatus(ContractStatusEnum.已冻结.getCode());
                            detailVO.setContractStatusName(ContractStatusEnum.已冻结.getDescription());
                        } else {
                            detailVO.setErrorMessage("合同履约状态填写不正确");
                        }
                    }


                    // 备注
                    if (org.apache.commons.lang3.StringUtils.isNotBlank(memoEx) && memoEx.length() > 100) {
                        detailVO.setErrorMessage("备注长度不可大于100");
                    } else {
                        detailVO.setMemo(memoEx);
                    }
                    // 封装返回的数据
                    if (org.apache.commons.lang3.StringUtils.isBlank(detailVO.getErrorMessage())) {
                        // 导入的数据默认为手动新增
//                        detailVO.setHandleType(1);
//                        detailVO.setHandleTypeName("是");
                        successList.add(detailVO);
                    } else {
                        errorList.add(detailVO);
                    }
                    //归档状态
                    detailVO.setSupplementFlag(0);
                    detailVO.setIsEstimation(0);
                    // 新增设置 竣工结算标志、解除状态、合同状态、变更状态
                    detailVO.setIsFinish(0);
                    detailVO.setIsRelieve(0);
                    detailVO.setIsSuspend(0);
//                    detailVO.setSupplementFlagName("否");
//                    detailVO.setFilingStatus(0);
//                    detailVO.setSignatureStatus("1");
//                    detailVO.setDraftType("3");
//                    detailVO.setPurchaseType("1");
                }


            }
            // 成功的数据直接入库，失败的数据不入库，返回前端查看错误原因
            errorList.forEach(detailVO -> {
                detailVO.setId(IdWorker.getId());
            });
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);

            // 拼接入库数据并入库
            Date createTime = new Date();
            UserContext userContext = sessionManager.getUserContext();
            String userCode = "";
            if (userContext != null) {
                userCode = userContext.getUserCode();
            }
            List<ContractRegisterVO> sucVoList = BeanMapper.mapList(successList, ContractRegisterVO.class);
            Long tenantId = InvocationInfoProxy.getTenantid();
            if (CollectionUtils.isNotEmpty(sucVoList)) {
                for (ContractRegisterVO vo : sucVoList) {
                    vo.setCreateTime(createTime);
                    vo.setCreateUserCode(userCode);
                    long contractId = IdWorker.getId();
//                    vo.setContractId(contractId);
//                    vo.setSourceId(contractId);
                    if (org.apache.commons.lang3.StringUtils.isBlank(vo.getBillCode())) {
                        String billCode = null;
                        if (Objects.equals(vo.getSupplementFlag(), ContractRegisterVO.CONTRACT_TYPE_SUPPLEMENT)) {
                            // 查询补充协议
                            LambdaQueryWrapper<ContractRegisterEntity> wrapper = new LambdaQueryWrapper<>();
                            wrapper.eq(ContractRegisterEntity::getMainContractId, vo.getMainContractId());
                            wrapper.in(ContractRegisterEntity::getBillState, Arrays.asList(1, 3));
                            List<ContractRegisterEntity> list = this.list(wrapper);

                            String supplementNum = "";
                            if (list.size() < 10) {
                                supplementNum += "0" + (list.size() + 1);
                            }else {
                                supplementNum += (list.size() + 1);
                            }

                            billCode = vo.getMainContractCode() + "-2-" + supplementNum;
                        }else {
                            BillCodeParam billCodeParam = BillCodeParam.build(INCOME_CONTRACT_REGISTER, tenantId, vo);
                            CommonResponse<String> responses = billCodeApi.generateBillCode(billCodeParam);
                            if(responses.isSuccess()) {
                                billCode = responses.getData();
                            }else{
                                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                            }
                        }

                        vo.setBillCode(billCode);
                    }
                }
                List<ContractRegisterEntity> sucEntityList = BeanMapper.mapList(sucVoList, ContractRegisterEntity.class);
                saveOrUpdateBatch(sucEntityList, sucEntityList.size(), false);
            }
            return CommonResponse.success(json);
        }
    }


    @Override
    public ContractReviewVO queryReviewByProject(Long projectId) {
        LambdaQueryWrapper<ContractReviewEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractReviewEntity::getProjectId, projectId);
        wrapper.eq(ContractReviewEntity::getSupplementFlag, 0);
        wrapper.eq(BaseEntity::getTenantId, InvocationInfoProxy.getTenantid());
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List<ContractReviewEntity> list = reviewService.list(wrapper);

        if (ListUtil.isEmpty(list)) {
            return new ContractReviewVO();
        }

        return BeanMapper.map(list.get(0), ContractReviewVO.class);
    }

}
