package com.ejianc.business.pro.income.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 工程定案
 * 
 * @author generator
 * 
 */
 @TableName("ejc_income_finalized")
public class FinalizedEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_bill_code")
    private String projectBillCode; // 项目标段
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="contract_id")
    private Long contractId; // 合同
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同签订金额(不含税)
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同签订金额
    @TableField(value="contract_valuation_type")
    private Long contractValuationType; // 合同计价形式
    @TableField(value="contract_valuation_type_name")
    private String contractValuationTypeName; // 合同计价形式
    @TableField(value="sum_production_mny")
    private BigDecimal sumProductionMny; // 累计产值(无税)
    @TableField(value="sum_production_tax_mny")
    private BigDecimal sumProductionTaxMny; // 累计产值
    @TableField(value="sum_cost_mny")
    private BigDecimal sumCostMny; // 累计成本(无税)
    @TableField(value="sum_cost_tax_mny")
    private BigDecimal sumCostTaxMny; // 累计成本
    @TableField(value="sum_receipt_mny")
    private BigDecimal sumReceiptMny; // 累计收款金额(无税)
    @TableField(value="sum_receipt_tax_mny")
    private BigDecimal sumReceiptTaxMny; // 累计收款金额
    @TableField(value="final_stage")
    private String finalStage; // 定案阶段：0-未报送，1-一审中，2-终审中，3-终审完成


    @TableField(value="end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 竣工验收日期
    @TableField(value="check_mny")
    private BigDecimal checkMny; // 审定金额
    @TableField(value="check_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date checkDate; // 审定日期
    @TableField(value="subtract_tax_rate")
    private BigDecimal subtractTaxRate; // 合同约定审减率
    @TableField(value="material_mny")
    private BigDecimal materialMny; // 其中甲供材金额
    @TableField(value="review_subtract_rate")
    private BigDecimal reviewSubtractRate; // 审减率
    @TableField(value="review_subtract_mny")
    private BigDecimal reviewSubtractMny; // 审减金额
    @TableField(value="return_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date returnDate; // 预计定案表返回日期
    @TableField(value="start_guarantee_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startGuaranteeDate; // 保修期起算日
    @TableField(value="end_guarantee_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endGuaranteeDate; // 防水保修期届满日
    @TableField(value="guarantee_rate")
    private BigDecimal guaranteeRate; // 保修金比例
    @TableField(value="guarantee_mny")
    private BigDecimal guaranteeMny; // 其中防水保修金额
    @TableField(value="total_economic_benefit_rate")
    private BigDecimal totalEconomicBenefitRate; // 总经济效益率
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="dept_id")
    private Long deptId; // 经办部门
    @TableField(value="dept_name")
    private String deptName; // 经办部门名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value = "settle_report_id")
    private Long settleReportId; //结算报审id
    @TableField(value="check_tax_mny")
    private BigDecimal checkTaxMny; // 审定金额
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="tax")
    private BigDecimal tax; // 税额

    @TableField(value="conservative_settlement_mny")
    private BigDecimal conservativeSettlementMny; // 保守结算金额
    @TableField(value="target_settlement_mny")
    private BigDecimal targetSettlementMny; // 目标结算金额
    @TableField(value="expect_settlement_mny")
    private BigDecimal expectSettlementMny; // 期望收款金额

    @TableField(value="report_settle_mny")
    private BigDecimal reportSettleMny; // 报审结算金额
    @TableField(value="report_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date reportDate; // 报审日期
    @TableField(value="report_settle_tax_mny")
    private BigDecimal reportSettleTaxMny; // 结算报送金额
    @TableField(value="censorship_memo")
    private String censorshipMemo; // 报送说明
    @TableField(value="censorship_person_id")
    private Long censorshipPersonId; // 报送人id
    @TableField(value="censorship_name")
    private String censorshipPersonName; // 报送人


    @TableField(value="first_instance_mny")
    private BigDecimal firstInstanceMny; // 一审金额
    @TableField(value="first_instance_date")
    private Date firstInstanceDate; // 一审日期
    @TableField(value="first_instance_person_id")
    private Long firstInstancePersonId; // 一审人id
    @TableField(value="first_instance_name")
    private String firstInstancePersonName; // 一审人名称


    @TableField(value="final_instance_mny")
    private BigDecimal finalInstanceMny; // 终审金额
    @TableField(value="final_instance_date")
    private Date finalInstanceDate; // 终审日期
    @TableField(value="final_instance_person_id")
    private Long finalInstancePersonId; // 终审人id
    @TableField(value="final_instance_name")
    private String finalInstancePersonName; // 终审人名称

    @TableField(value = "pub_unit_id")
    public Long pubUnitId; //发布单位
    @TableField(value = "pub_unit_name")
    private String pubUnitName; //发布单位名称

    public String getProjectBillCode() {
        return projectBillCode;
    }

    public void setProjectBillCode(String projectBillCode) {
        this.projectBillCode = projectBillCode;
    }

    public String getContractValuationTypeName() {
        return contractValuationTypeName;
    }

    public void setContractValuationTypeName(String contractValuationTypeName) {
        this.contractValuationTypeName = contractValuationTypeName;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Long getPubUnitId() {
        return pubUnitId;
    }

    public void setPubUnitId(Long pubUnitId) {
        this.pubUnitId = pubUnitId;
    }

    public String getPubUnitName() {
        return pubUnitName;
    }

    public void setPubUnitName(String pubUnitName) {
        this.pubUnitName = pubUnitName;
    }

    public BigDecimal getConservativeSettlementMny() {
        return conservativeSettlementMny;
    }

    public void setConservativeSettlementMny(BigDecimal conservativeSettlementMny) {
        this.conservativeSettlementMny = conservativeSettlementMny;
    }

    public BigDecimal getTargetSettlementMny() {
        return targetSettlementMny;
    }

    public void setTargetSettlementMny(BigDecimal targetSettlementMny) {
        this.targetSettlementMny = targetSettlementMny;
    }

    public BigDecimal getExpectSettlementMny() {
        return expectSettlementMny;
    }

    public void setExpectSettlementMny(BigDecimal expectSettlementMny) {
        this.expectSettlementMny = expectSettlementMny;
    }

    public String getCensorshipMemo() {
        return censorshipMemo;
    }

    public void setCensorshipMemo(String censorshipMemo) {
        this.censorshipMemo = censorshipMemo;
    }

    public Long getCensorshipPersonId() {
        return censorshipPersonId;
    }

    public void setCensorshipPersonId(Long censorshipPersonId) {
        this.censorshipPersonId = censorshipPersonId;
    }

    public String getCensorshipPersonName() {
        return censorshipPersonName;
    }

    public void setCensorshipPersonName(String censorshipPersonName) {
        this.censorshipPersonName = censorshipPersonName;
    }

    public BigDecimal getFirstInstanceMny() {
        return firstInstanceMny;
    }

    public void setFirstInstanceMny(BigDecimal firstInstanceMny) {
        this.firstInstanceMny = firstInstanceMny;
    }

    public Date getFirstInstanceDate() {
        return firstInstanceDate;
    }

    public void setFirstInstanceDate(Date firstInstanceDate) {
        this.firstInstanceDate = firstInstanceDate;
    }

    public Long getFirstInstancePersonId() {
        return firstInstancePersonId;
    }

    public void setFirstInstancePersonId(Long firstInstancePersonId) {
        this.firstInstancePersonId = firstInstancePersonId;
    }

    public String getFirstInstancePersonName() {
        return firstInstancePersonName;
    }

    public void setFirstInstancePersonName(String firstInstancePersonName) {
        this.firstInstancePersonName = firstInstancePersonName;
    }

    public BigDecimal getFinalInstanceMny() {
        return finalInstanceMny;
    }

    public void setFinalInstanceMny(BigDecimal finalInstanceMny) {
        this.finalInstanceMny = finalInstanceMny;
    }

    public Date getFinalInstanceDate() {
        return finalInstanceDate;
    }

    public void setFinalInstanceDate(Date finalInstanceDate) {
        this.finalInstanceDate = finalInstanceDate;
    }

    public Long getFinalInstancePersonId() {
        return finalInstancePersonId;
    }

    public void setFinalInstancePersonId(Long finalInstancePersonId) {
        this.finalInstancePersonId = finalInstancePersonId;
    }

    public String getFinalInstancePersonName() {
        return finalInstancePersonName;
    }

    public void setFinalInstancePersonName(String finalInstancePersonName) {
        this.finalInstancePersonName = finalInstancePersonName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public Long getContractValuationType() {
        return contractValuationType;
    }

    public void setContractValuationType(Long contractValuationType) {
        this.contractValuationType = contractValuationType;
    }
    public BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    public void setSumProductionMny(BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }
    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }
    public BigDecimal getSumCostMny() {
        return sumCostMny;
    }

    public void setSumCostMny(BigDecimal sumCostMny) {
        this.sumCostMny = sumCostMny;
    }
    public BigDecimal getSumCostTaxMny() {
        return sumCostTaxMny;
    }

    public void setSumCostTaxMny(BigDecimal sumCostTaxMny) {
        this.sumCostTaxMny = sumCostTaxMny;
    }
    public BigDecimal getSumReceiptMny() {
        return sumReceiptMny;
    }

    public void setSumReceiptMny(BigDecimal sumReceiptMny) {
        this.sumReceiptMny = sumReceiptMny;
    }
    public BigDecimal getSumReceiptTaxMny() {
        return sumReceiptTaxMny;
    }

    public void setSumReceiptTaxMny(BigDecimal sumReceiptTaxMny) {
        this.sumReceiptTaxMny = sumReceiptTaxMny;
    }
    public String getFinalStage() {
        return finalStage;
    }

    public void setFinalStage(String finalStage) {
        this.finalStage = finalStage;
    }
    public BigDecimal getReportSettleMny() {
        return reportSettleMny;
    }

    public void setReportSettleMny(BigDecimal reportSettleMny) {
        this.reportSettleMny = reportSettleMny;
    }
    public Date getReportDate() {
        return reportDate;
    }

    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }
    public BigDecimal getCheckMny() {
        return checkMny;
    }

    public void setCheckMny(BigDecimal checkMny) {
        this.checkMny = checkMny;
    }
    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    public BigDecimal getSubtractTaxRate() {
        return subtractTaxRate;
    }

    public void setSubtractTaxRate(BigDecimal subtractTaxRate) {
        this.subtractTaxRate = subtractTaxRate;
    }
    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }
    public BigDecimal getReviewSubtractRate() {
        return reviewSubtractRate;
    }

    public void setReviewSubtractRate(BigDecimal reviewSubtractRate) {
        this.reviewSubtractRate = reviewSubtractRate;
    }
    public BigDecimal getReviewSubtractMny() {
        return reviewSubtractMny;
    }

    public void setReviewSubtractMny(BigDecimal reviewSubtractMny) {
        this.reviewSubtractMny = reviewSubtractMny;
    }
    public Date getReturnDate() {
        return returnDate;
    }

    public void setReturnDate(Date returnDate) {
        this.returnDate = returnDate;
    }
    public Date getStartGuaranteeDate() {
        return startGuaranteeDate;
    }

    public void setStartGuaranteeDate(Date startGuaranteeDate) {
        this.startGuaranteeDate = startGuaranteeDate;
    }
    public Date getEndGuaranteeDate() {
        return endGuaranteeDate;
    }

    public void setEndGuaranteeDate(Date endGuaranteeDate) {
        this.endGuaranteeDate = endGuaranteeDate;
    }
    public BigDecimal getGuaranteeRate() {
        return guaranteeRate;
    }

    public void setGuaranteeRate(BigDecimal guaranteeRate) {
        this.guaranteeRate = guaranteeRate;
    }
    public BigDecimal getGuaranteeMny() {
        return guaranteeMny;
    }

    public void setGuaranteeMny(BigDecimal guaranteeMny) {
        this.guaranteeMny = guaranteeMny;
    }

    public BigDecimal getTotalEconomicBenefitRate() {
        return totalEconomicBenefitRate;
    }

    public void setTotalEconomicBenefitRate(BigDecimal totalEconomicBenefitRate) {
        this.totalEconomicBenefitRate = totalEconomicBenefitRate;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getSettleReportId() {
        return settleReportId;
    }

    public void setSettleReportId(Long settleReportId) {
        this.settleReportId = settleReportId;
    }

    public BigDecimal getCheckTaxMny() {
        return checkTaxMny;
    }

    public void setCheckTaxMny(BigDecimal checkTaxMny) {
        this.checkTaxMny = checkTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public BigDecimal getReportSettleTaxMny() {
        return reportSettleTaxMny;
    }

    public void setReportSettleTaxMny(BigDecimal reportSettleTaxMny) {
        this.reportSettleTaxMny = reportSettleTaxMny;
    }
}
