/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.service.impl;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.ContractReviewEntity;
import com.ejianc.business.pro.income.enums.BillStateEnum;
import com.ejianc.business.pro.income.enums.ContractStatusEnum;
import com.ejianc.business.pro.income.mapper.ContractRegisterMapper;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IContractReviewService;
import com.ejianc.business.pro.income.utils.BillTypeCodeEnum;
import com.ejianc.business.pro.income.utils.ValidateUtil;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.pro.income.vo.ContractReviewVO;
import com.ejianc.business.pro.income.vo.ImportContractVO;
import com.ejianc.business.pro.income.vo.RegisterSupplementHistoryVO;
import com.ejianc.business.pro.warn.SqlParam;
import com.ejianc.business.tender.api.ITenderApi;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="contractRegisterService")
public class ContractRegisterServiceImpl
extends BaseServiceImpl<ContractRegisterMapper, ContractRegisterEntity>
implements IContractRegisterService {
    private static final String INCOME_CONTRACT_REGISTER = "INCOME_CONTRACT_REGISTER";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private ITenderApi tenderApi;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IContractReviewService contractReviewService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ValidateUtil validateUtil;
    @Autowired
    private IContractReviewService reviewService;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    public ContractRegisterMapper mapper;

    @Override
    public ContractRegisterVO saveOrUpdate(ContractRegisterVO saveorUpdateVO) {
        if (!Objects.equals(null, saveorUpdateVO.getReviewId()) && !this.validateUtil.validateUpStreamVersion(String.valueOf(saveorUpdateVO.getReviewId()), BillTypeCodeEnum.\u65bd\u5de5\u5408\u540c\u8bc4\u5ba1.getCode(), saveorUpdateVO.getReviewVersion()).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
        }
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ContractRegisterEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (entity.getId() == null || entity.getId() == 0L) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)entity.getBillCode())) {
                String billCode = null;
                if (Objects.equals(entity.getSupplementFlag(), ContractRegisterVO.CONTRACT_TYPE_SUPPLEMENT)) {
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    wrapper.eq(ContractRegisterEntity::getMainContractId, (Object)entity.getMainContractId());
                    wrapper.in(ContractRegisterEntity::getBillState, Arrays.asList(1, 3));
                    List list = this.list((Wrapper)wrapper);
                    String supplementNum = "";
                    supplementNum = list.size() < 10 ? supplementNum + "0" + (list.size() + 1) : supplementNum + (list.size() + 1);
                    billCode = entity.getMainContractCode() + "-2-" + supplementNum;
                } else {
                    BillCodeParam billCodeParam = BillCodeParam.build((String)INCOME_CONTRACT_REGISTER, (Long)tenantId, (BaseVO)saveorUpdateVO);
                    CommonResponse response = this.billCodeApi.generateBillCode(billCodeParam);
                    if (response.isSuccess()) {
                        billCode = (String)response.getData();
                    } else {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                }
                entity.setBillCode(billCode);
            }
            LambdaQueryWrapper lambda = new LambdaQueryWrapper();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(ContractRegisterEntity::getBillCode, (Object)entity.getBillCode());
            List entityList = super.list((Wrapper)lambda);
            if (ListUtil.isNotEmpty((List)entityList)) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            entity.setIsFinish(0);
            entity.setIsRelieve(0);
            entity.setIsSuspend(0);
            entity.setContractStatus(ContractStatusEnum.\u672a\u7b7e\u8ba2.getCode());
            entity.setChangeStatus("1");
        } else {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
                throw new BusinessException("\u7f16\u7801\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            LambdaQueryWrapper lambda = new LambdaQueryWrapper();
            lambda.eq(ContractRegisterEntity::getBillCode, (Object)entity.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)entity.getId());
            List entityList = super.list((Wrapper)lambda);
            if (ListUtil.isNotEmpty((List)entityList)) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            if (null == entity.getBillState()) {
                entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            }
        }
        entity.setContractTaxMny(entity.getBaseTaxMoney());
        entity.setContractMny(entity.getBaseMoney());
        entity.setTaxMny(entity.getBaseTax());
        entity.setTotalAfterCostAdjustTaxMny(ComputeUtil.safeAdd((BigDecimal)entity.getBaseTaxMoney(), (BigDecimal)entity.getTotalCostAdjustTaxMny()));
        entity.setTotalAfterCostAdjustMny(ComputeUtil.safeAdd((BigDecimal)entity.getBaseMoney(), (BigDecimal)entity.getTotalCostAdjustMny()));
        entity.setTotalAfterCostAdjustTax(ComputeUtil.safeAdd((BigDecimal)entity.getBaseTax(), (BigDecimal)entity.getTotalCostAdjustTax()));
        entity.setNicContractMny(ComputeUtil.safeAdd((BigDecimal)entity.getNotIncludeProvisionalMny(), (BigDecimal)entity.getTotalCostAdjustTaxMny()));
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny());
        super.saveOrUpdate((Object)entity, false);
        return (ContractRegisterVO)BeanMapper.map((Object)((Object)entity), ContractRegisterVO.class);
    }

    @Override
    public JSONObject pageList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage pageData = this.queryPage(param, false);
        Map<String, Object> contractAmountMap = this.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), ContractRegisterVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        page.put("contractCount", contractAmountMap);
        return page;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        HashMap<String, Object> resp = new HashMap();
        QueryWrapper wrapper = ContractRegisterServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"round(sum(base_tax_money),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount"});
        resp = super.getMap((Wrapper)wrapper);
        return resp;
    }

    @Override
    public List<ContractRegisterVO> excelExport(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List entityList = this.queryList(param);
        List voList = BeanMapper.mapList((Iterable)entityList, ContractRegisterVO.class);
        for (ContractRegisterVO vo : voList) {
            String contractStatus = vo.getContractStatus();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)contractStatus)) {
                if (Objects.equals(contractStatus, "1")) {
                    vo.setContractStatusName("\u5c65\u7ea6\u4e2d");
                }
                if (Objects.equals(contractStatus, "2")) {
                    vo.setContractStatusName("\u5df2\u5c01\u8d26");
                }
                if (Objects.equals(contractStatus, "3")) {
                    vo.setContractStatusName("\u5df2\u89e3\u9664");
                }
            } else {
                vo.setContractStatusName("");
            }
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        }
        return voList;
    }

    @Override
    public ContractRegisterVO addRegisterByRevId(Long reviewId) {
        ContractReviewEntity entity = (ContractReviewEntity)((Object)this.reviewService.selectById(reviewId));
        ContractRegisterVO vo = new ContractRegisterVO();
        vo.setReviewId(reviewId);
        vo.setProjectId(entity.getProjectId());
        vo.setProjectName(entity.getProjectName());
        vo.setProjectCode(entity.getProjectCode());
        vo.setOrgId(entity.getOrgId());
        vo.setOrgCode(entity.getOrgCode());
        vo.setOrgName(entity.getOrgName());
        vo.setParentOrgId(entity.getParentOrgId());
        vo.setParentOrgCode(entity.getParentOrgCode());
        vo.setParentOrgName(entity.getParentOrgName());
        vo.setContractName(entity.getContractName());
        vo.setSignDate(new Date());
        vo.setCustomerId(entity.getCustomerId());
        vo.setCustomerName(entity.getCustomerName());
        vo.setSupplierId(entity.getSupplierId());
        vo.setSupplierName(entity.getSupplierName());
        vo.setConstructionPartner(entity.getConstructionPartner());
        vo.setTaxRate(entity.getTaxRate());
        vo.setBaseTaxMoney(entity.getContractTaxMny());
        vo.setBaseMoney(entity.getContractMny());
        vo.setBaseTax(entity.getTaxMny());
        vo.setStartDate(entity.getStartDate());
        vo.setEndDate(entity.getEndDate());
        vo.setSchedule(entity.getSchedule());
        vo.setContractPartyc(entity.getContractPartyc());
        vo.setConjoinedContractTotalMny(entity.getConjoinedContractTotalMny());
        vo.setEmployeeId(this.sessionManager.getUserContext().getEmployeeId());
        vo.setEmployeeName(this.sessionManager.getUserContext().getUserName());
        vo.setDeptId(this.sessionManager.getUserContext().getDeptId());
        vo.setDeptName(this.sessionManager.getUserContext().getDeptName());
        vo.setSignDate(new Date());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractRegisterEntity::getReviewId, (Object)entity.getMainContractId());
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.list((Wrapper)wrapper);
        if (ListUtil.isNotEmpty((List)list)) {
            ContractRegisterEntity registerEntity = (ContractRegisterEntity)((Object)list.get(0));
            vo.setMainContractId(registerEntity.getId());
            vo.setMainContractCode(registerEntity.getBillCode());
            vo.setMainContractName(registerEntity.getContractName());
        }
        return vo;
    }

    @Override
    public ContractRegisterVO addSupplementByConId(Long mainContractId) {
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)this.selectById(mainContractId));
        ContractRegisterVO vo = new ContractRegisterVO();
        vo.setProjectId(entity.getProjectId());
        vo.setProjectName(entity.getProjectName());
        vo.setProjectCode(entity.getProjectCode());
        vo.setOrgId(entity.getOrgId());
        vo.setOrgCode(entity.getOrgCode());
        vo.setOrgName(entity.getOrgName());
        vo.setParentOrgId(entity.getParentOrgId());
        vo.setParentOrgCode(entity.getParentOrgCode());
        vo.setParentOrgName(entity.getParentOrgName());
        vo.setContractType(entity.getContractType());
        vo.setCustomerId(entity.getCustomerId());
        vo.setCustomerName(entity.getCustomerName());
        vo.setSupplierId(entity.getSupplierId());
        vo.setSupplierName(entity.getSupplierName());
        vo.setConstructionPartner(entity.getConstructionPartner());
        vo.setTaxRate(entity.getTaxRate());
        vo.setContractPartyc(entity.getContractPartyc());
        vo.setConjoinedContractTotalMny(entity.getConjoinedContractTotalMny());
        vo.setEmployeeId(this.sessionManager.getUserContext().getEmployeeId());
        vo.setEmployeeName(this.sessionManager.getUserContext().getUserName());
        vo.setDeptId(this.sessionManager.getUserContext().getDeptId());
        vo.setDeptName(this.sessionManager.getUserContext().getDeptName());
        vo.setMainContractId(mainContractId);
        vo.setMainContractName(entity.getContractName());
        vo.setMainContractCode(entity.getBillCode());
        return vo;
    }

    @Override
    public RegisterSupplementHistoryVO querySupplementRecord(Long id) {
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)this.selectById(id));
        RegisterSupplementHistoryVO vo = new RegisterSupplementHistoryVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setContractMny(entity.getContractMny());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setIsFinish(entity.getIsFinish());
        vo.setIsRelieve(entity.getIsRelieve());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractRegisterEntity::getMainContractId, (Object)id);
        wrapper.orderByDesc(ContractRegisterEntity::getSignDate);
        List supplementList = super.list((Wrapper)wrapper);
        vo.setSupplementToalTaxMny(supplementList.stream().map(ContractRegisterEntity::getContractTaxMny).filter(x -> x != null).reduce(BigDecimal.ZERO, BigDecimal::add));
        vo.setSupplementToalMny(supplementList.stream().map(ContractRegisterEntity::getContractMny).filter(x -> x != null).reduce(BigDecimal.ZERO, BigDecimal::add));
        vo.setDetailList(BeanMapper.mapList((Iterable)supplementList, ContractRegisterVO.class));
        return vo;
    }

    @Override
    public List<ContractRegisterEntity> queryRegisterByReviewId(Long reviewId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractRegisterEntity::getReviewId, (Object)reviewId);
        List list = this.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            return new ArrayList<ContractRegisterEntity>();
        }
        return list;
    }

    @Override
    public boolean pushContract(ContractRegisterVO vo, Boolean updateLevel) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert((Object)vo, (Object)data);
            if ("1".equals(vo.getContractStatus())) {
                data.setPerformanceStatus("2");
            }
            if ("2".equals(vo.getContractStatus())) {
                data.setPerformanceStatus("3");
            }
            if ("3".equals(vo.getContractStatus())) {
                data.setPerformanceStatus("4");
            }
            data.setChangeStatus(Integer.valueOf(Integer.parseInt(vo.getChangeStatus())));
            data.setContractProperty(Integer.valueOf(1));
            data.setSourceType(ContractTypeEnum.\u65bd\u5de5\u5408\u540c.getTypeCode());
            data.setUpdateLevel(UpdateLevelEnum.\u66f4\u65b0\u975e\u7a7a\u5b57\u6bb5.getLevelCode());
            data.setSourceId(vo.getId());
            String url = null;
            url = vo.getSupplementFlag() == 0 ? "/ejc-proincome-frontend/#/contractRegister/contractApprove?id=" + vo.getId() : "/ejc-proincome-frontend/#/contractRegister/supplementCard?id=";
            data.setPcCardUrl(url);
            data.setCategoryId(Long.valueOf(1524001989040545793L));
            CommonResponse transDataResp = this.contractPoolApi.saveOrUpdateContract(data);
            if (transDataResp.isSuccess()) {
                return true;
            }
            this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)vo.getId(), (Object)transDataResp.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)vo.getId(), (Object)e);
        }
        return false;
    }

    @Override
    public boolean delContractFromPool(Long id) {
        ContractPoolVO c = new ContractPoolVO();
        c.setSourceId(id);
        this.logger.info("\u5c06\u5408\u540c-{}\u4ece\u5408\u540c\u6c60\u4e2d\u5220\u9664\uff01", (Object)id);
        CommonResponse delDataResp = this.contractPoolApi.deleteContract(c);
        if (delDataResp.isSuccess()) {
            return true;
        }
        this.logger.error("\u5c06\u5408\u540c-{}\u4ece\u5408\u540c\u6c60\u4e2d\u5220\u9664\u5931\u8d25, {}\uff01", (Object)id, (Object)delDataResp.getMsg());
        return false;
    }

    @Override
    public List<Map<String, Object>> queryBudgetWarnContract(List<SqlParam> sqlParamList) {
        return this.mapper.queryBudgetWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryCostWarnContract(List<SqlParam> sqlParamList) {
        return this.mapper.queryCostWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryContractRegisterWarnContract(List<SqlParam> sqlParamList) {
        return this.mapper.queryContractRegisterWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> querySettleReportWarnContract(List<SqlParam> sqlParamList) {
        return this.mapper.querySettleReportWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryFinalizedWarnContract(List<SqlParam> sqlParamList) {
        return this.mapper.queryFinalizedWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryBudgetInWarnContract(List<SqlParam> sqlParamList) {
        return this.mapper.queryBudgetInWarnContract(sqlParamList);
    }

    @Override
    public List<ContractRegisterVO> getAllValidConsByProjectId(Long projectId) {
        List<Object> resp = new ArrayList<ContractRegisterVO>();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        query.in((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        query.orderByDesc((Object)"create_time");
        List list = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resp = BeanMapper.mapList((Iterable)list, ContractRegisterVO.class);
        }
        return resp;
    }

    @Override
    public CommonResponse<JSONObject> excelImportProMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Long tenantid = InvocationInfoProxy.getTenantid();
        HashMap orgVOMap = new HashMap();
        HashMap<String, ProjectPoolSetVO> projectPoolVoMap = new HashMap<String, ProjectPoolSetVO>();
        HashMap contractPoolVoNoCodeMap = new HashMap();
        HashMap<String, SupplierVO> supplierVOMap = new HashMap<String, SupplierVO>();
        HashMap<String, OrgVO> projectOrgVoMap = new HashMap<String, OrgVO>();
        HashMap contractReviewEntityMap = new HashMap();
        HashMap employeeVOMap = new HashMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            if (entity == null) continue;
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        if (mf == null) {
            throw new BusinessException("\u5bfc\u5165\u7684\u6587\u4ef6\u4e2d\u6ca1\u6709\u6570\u636e");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<ImportContractVO> successList = new ArrayList<ImportContractVO>();
        ArrayList<ImportContractVO> errorList = new ArrayList<ImportContractVO>();
        if (result != null && result.size() > 0) {
            CommonResponse defRes4;
            CommonResponse defRes3;
            CommonResponse defRes2;
            if (((List)result.get(0)).size() != 23) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            if (result.size() >= 10000) {
                throw new BusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u8d85\u8fc710000\u884c\uff0c\u8d85\u8fc7\u8bf7\u5206\u6279\u6b21\u591a\u6b21\u5bfc\u5165");
            }
            Map<Object, Object> bearTypeDefMap = new HashMap();
            Map<Object, Object> contractTypeDefMap = new HashMap();
            Map<Object, Object> contractValuationTypeDefMap = new HashMap();
            Map<Object, Object> contractualModelDefMap = new HashMap();
            HashMap<String, Long> defParamMap = new HashMap<String, Long>();
            defParamMap.put("tenantId", tenantid);
            String defCondition = JSONObject.toJSONString(defParamMap);
            CommonResponse defRes1 = this.defdocApi.queryDetailListByDefdocCode("bear_type", defCondition);
            if (defRes1.isSuccess() && defRes1.getData() != null) {
                List defList = (List)defRes1.getData();
                bearTypeDefMap = defList.stream().collect(Collectors.toMap(item -> item.get("name") == null ? "" : item.get("name").toString(), item -> item.get("id") == null ? "" : item.get("id").toString()));
            }
            if ((defRes2 = this.defdocApi.queryDetailListByDefdocCode("contract_type", defCondition)).isSuccess() && defRes2.getData() != null) {
                List defList = (List)defRes2.getData();
                contractTypeDefMap = defList.stream().collect(Collectors.toMap(item -> item.get("name") == null ? "" : item.get("name").toString(), item -> item.get("id") == null ? "" : item.get("id").toString()));
            }
            if ((defRes3 = this.defdocApi.queryDetailListByDefdocCode("contract-valuation-type", defCondition)).isSuccess() && defRes3.getData() != null) {
                List defList = (List)defRes3.getData();
                contractValuationTypeDefMap = defList.stream().collect(Collectors.toMap(item -> item.get("name") == null ? "" : item.get("name").toString(), item -> item.get("id") == null ? "" : item.get("id").toString()));
            }
            if ((defRes4 = this.defdocApi.queryDetailListByDefdocCode("pro-market-project-type", defCondition)).isSuccess() && defRes4.getData() != null) {
                List defList = (List)defRes4.getData();
                contractualModelDefMap = defList.stream().collect(Collectors.toMap(item -> item.get("name") == null ? "" : item.get("name").toString(), item -> item.get("id") == null ? "" : item.get("id").toString()));
            }
            for (int i = 1; i < result.size(); ++i) {
                LambdaQueryWrapper queryWrapper;
                Long orgIdP = 0L;
                List datas = (List)result.get(i);
                ImportContractVO detailVO2 = new ImportContractVO();
                String contractCodeEx = (String)datas.get(0);
                detailVO2.setBillCode(contractCodeEx);
                String reviewName = (String)datas.get(1);
                detailVO2.setReviewName(reviewName);
                String bearTypeName = (String)datas.get(2);
                detailVO2.setBearTypeName(bearTypeName);
                String contractNameEx = (String)datas.get(3);
                detailVO2.setContractName(contractNameEx);
                String projectNameEx = (String)datas.get(4);
                detailVO2.setProjectName(projectNameEx);
                String contractTypeName = (String)datas.get(5);
                detailVO2.setContractTypeName(contractTypeName);
                String partyaNameEx = (String)datas.get(6);
                detailVO2.setCustomerName(partyaNameEx);
                String partybNameEx = (String)datas.get(7);
                detailVO2.setSupplierName(partybNameEx);
                String signDateStrEx = (String)datas.get(8);
                String contractValuationTypeName = (String)datas.get(9);
                detailVO2.setContractValuationTypeName(contractValuationTypeName);
                String contractualModelName = (String)datas.get(10);
                detailVO2.setContractualModelName(contractualModelName);
                String taxRateEx = (String)datas.get(11);
                String baseTaxMoney = (String)datas.get(12);
                String baseMoney = (String)datas.get(13);
                String baseTax = (String)datas.get(14);
                String startDate = (String)datas.get(15);
                String endDate = (String)datas.get(16);
                String contractStatus = (String)datas.get(17);
                detailVO2.setContractStatus(contractStatus);
                String employeeName = (String)datas.get(18);
                detailVO2.setEmployeeName(employeeName);
                String overReducedTaxMny = (String)datas.get(19);
                String meterType = (String)datas.get(20);
                detailVO2.setMeterType(meterType);
                String progressPaymentClause = (String)datas.get(21);
                detailVO2.setProgressPaymentClause(progressPaymentClause);
                String memoEx = (String)datas.get(22);
                detailVO2.setMemo(memoEx);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)contractCodeEx)) {
                    queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(ContractRegisterEntity::getBillCode, (Object)contractCodeEx);
                    queryWrapper.eq(BaseEntity::getDr, (Object)0);
                    queryWrapper.eq(BaseEntity::getTenantId, (Object)tenantid);
                    if (!this.list((Wrapper)queryWrapper).isEmpty()) {
                        detailVO2.setErrorMessage("\u5408\u540c\u7f16\u7801\u5df2\u5b58\u5728");
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)contractNameEx)) {
                    detailVO2.setErrorMessage("\u5408\u540c\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    detailVO2.setContractName(contractNameEx);
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reviewName)) {
                    if (MapUtils.isEmpty(contractReviewEntityMap) || contractReviewEntityMap.get(reviewName) == null) {
                        queryWrapper = new LambdaQueryWrapper();
                        queryWrapper.eq(ContractReviewEntity::getContractName, (Object)reviewName);
                        queryWrapper.eq(BaseEntity::getTenantId, (Object)tenantid);
                        queryWrapper.eq(BaseEntity::getDr, (Object)0);
                        List list = this.contractReviewService.list((Wrapper)queryWrapper);
                        if (CollectionUtils.isEmpty((Collection)list)) {
                            detailVO2.setErrorMessage("\u6839\u636e\u5408\u540c\u8bc4\u5ba1\u540d\u79f0\u67e5\u8be2\u4e0d\u5230\u5408\u540c\u8bc4\u5ba1\u4fe1\u606f");
                        } else {
                            contractReviewEntityMap.put(reviewName, list.get(0));
                            ContractReviewEntity contractReviewEntity = (ContractReviewEntity)((Object)list.get(0));
                            detailVO2.setReviewId(contractReviewEntity.getId());
                            detailVO2.setReviewName(reviewName);
                        }
                    } else {
                        ContractReviewEntity contractReviewEntity = (ContractReviewEntity)((Object)contractReviewEntityMap.get(reviewName));
                        detailVO2.setReviewId(contractReviewEntity.getId());
                        detailVO2.setReviewName(reviewName);
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bearTypeName)) {
                    if (MapUtils.isEmpty(bearTypeDefMap) || bearTypeDefMap.get(bearTypeName) == null) {
                        detailVO2.setErrorMessage("\u6839\u636e\u627f\u63fd\u65b9\u5f0f\u540d\u79f0\u67e5\u8be2\u4e0d\u5230\u627f\u63fd\u65b9\u5f0f\u4fe1\u606f");
                    } else {
                        detailVO2.setBearType(Long.valueOf(Long.parseLong((String)bearTypeDefMap.get(bearTypeName))));
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)projectNameEx)) {
                    detailVO2.setErrorMessage("\u9879\u76ee\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    ProjectPoolSetVO projectPoolSetVOFlag = null;
                    if (MapUtils.isEmpty(projectPoolVoMap) || projectPoolVoMap.get(projectNameEx) == null) {
                        CommonResponse projectVOListRes = this.projectPoolApi.queryProjectListByNameAndTenantId(projectNameEx, tenantid);
                        if (projectVOListRes.isSuccess()) {
                            List projectVOList = (List)projectVOListRes.getData();
                            if (CollectionUtils.isEmpty((Collection)projectVOList)) {
                                detailVO2.setErrorMessage("\u6839\u636e\u9879\u76ee\u540d\u79f0\u67e5\u8be2\u4e0d\u5230\u9879\u76ee\u4fe1\u606f");
                            } else if (projectVOList.size() == 1) {
                                ProjectPoolSetVO projectPoolSetVO;
                                projectPoolSetVOFlag = projectPoolSetVO = (ProjectPoolSetVO)projectVOList.get(0);
                                Long orgId = projectPoolSetVO.getOrgId();
                                String orgCode = projectPoolSetVO.getOrgCode();
                                String orgName = projectPoolSetVO.getOrgName();
                                Long projectDepartmentId1 = projectPoolSetVO.getProjectDepartmentId();
                                String projectDepartmentName = projectPoolSetVO.getProjectDepartmentName();
                                String projectDepartmentCode = projectPoolSetVO.getProjectDepartmentCode();
                                detailVO2.setOrgId(projectDepartmentId1);
                                detailVO2.setOrgCode(projectDepartmentCode);
                                detailVO2.setOrgName(projectDepartmentName);
                                detailVO2.setParentOrgId(orgId);
                                detailVO2.setParentOrgCode(orgCode);
                                detailVO2.setParentOrgName(orgName);
                                detailVO2.setProjectId(projectPoolSetVO.getId());
                                detailVO2.setProjectName(projectPoolSetVO.getName());
                                projectPoolVoMap.put(projectNameEx, projectPoolSetVO);
                            } else {
                                detailVO2.setErrorMessage("\u6839\u636e\u9879\u76ee\u540d\u79f0\u67e5\u8be2\u5230\u591a\u4e2a\u9879\u76ee\u4fe1\u606f");
                            }
                        } else {
                            detailVO2.setErrorMessage("\u6839\u636e\u9879\u76ee\u540d\u79f0\u67e5\u8be2\u4e0d\u5230\u9879\u76ee\u4fe1\u606f");
                        }
                    } else {
                        ProjectPoolSetVO projectPoolSetVO;
                        projectPoolSetVOFlag = projectPoolSetVO = (ProjectPoolSetVO)projectPoolVoMap.get(projectNameEx);
                        Long orgId = projectPoolSetVO.getOrgId();
                        String orgCode = projectPoolSetVO.getOrgCode();
                        String orgName = projectPoolSetVO.getOrgName();
                        Long projectDepartmentId1 = projectPoolSetVO.getProjectDepartmentId();
                        String projectDepartmentName = projectPoolSetVO.getProjectDepartmentName();
                        String projectDepartmentCode = projectPoolSetVO.getProjectDepartmentCode();
                        detailVO2.setOrgId(projectDepartmentId1);
                        detailVO2.setOrgCode(projectDepartmentCode);
                        detailVO2.setOrgName(projectDepartmentName);
                        detailVO2.setParentOrgId(orgId);
                        detailVO2.setParentOrgCode(orgCode);
                        detailVO2.setParentOrgName(orgName);
                        detailVO2.setProjectId(projectPoolSetVO.getId());
                        detailVO2.setProjectName(projectPoolSetVO.getName());
                    }
                    if (projectPoolSetVOFlag != null) {
                        OrgVO data;
                        CommonResponse orgVO;
                        Long orgId = projectPoolSetVOFlag.getOrgId();
                        Long projectDepartmentId1 = projectPoolSetVOFlag.getProjectDepartmentId();
                        if (projectOrgVoMap.isEmpty() || projectOrgVoMap.get(String.valueOf(orgId)) == null) {
                            orgVO = this.orgApi.detailById(orgId);
                            if (orgVO.isSuccess()) {
                                data = (OrgVO)orgVO.getData();
                                projectOrgVoMap.put(String.valueOf(orgId), data);
                                if (data == null) {
                                    detailVO2.setErrorMessage("\u6839\u636e\u7ec4\u7ec7id\u67e5\u8be2\u4e0d\u5230\u7ec4\u7ec7\u4fe1\u606f");
                                } else {
                                    detailVO2.setParentOrgCode(data.getCode());
                                }
                            } else {
                                detailVO2.setErrorMessage(orgVO.getMsg());
                            }
                        } else {
                            detailVO2.setParentOrgCode(((OrgVO)projectOrgVoMap.get(String.valueOf(orgId))).getCode());
                        }
                        if (projectOrgVoMap.isEmpty() || projectOrgVoMap.get(String.valueOf(projectDepartmentId1)) == null) {
                            orgVO = this.orgApi.detailById(projectDepartmentId1);
                            if (orgVO.isSuccess()) {
                                data = (OrgVO)orgVO.getData();
                                projectOrgVoMap.put(String.valueOf(projectDepartmentId1), data);
                                if (data == null) {
                                    detailVO2.setErrorMessage("\u6839\u636e\u7ec4\u7ec7id\u67e5\u8be2\u4e0d\u5230\u7ec4\u7ec7\u4fe1\u606f");
                                } else {
                                    detailVO2.setOrgCode(data.getCode());
                                }
                            }
                        } else {
                            detailVO2.setOrgCode(((OrgVO)projectOrgVoMap.get(String.valueOf(projectDepartmentId1))).getCode());
                        }
                    } else {
                        detailVO2.setErrorMessage("\u6839\u636e\u9879\u76ee\u540d\u79f0\u67e5\u8be2\u4e0d\u5230\u9879\u76ee\u4fe1\u606f");
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)contractTypeName)) {
                    detailVO2.setErrorMessage("\u5408\u540c\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a");
                } else if (MapUtils.isEmpty(contractTypeDefMap) || contractTypeDefMap.get(contractTypeName) == null) {
                    detailVO2.setErrorMessage("\u5408\u540c\u7c7b\u522b\u8f93\u5165\u7c7b\u578b\u9519\u8bef");
                } else {
                    detailVO2.setContractType(Long.valueOf(Long.parseLong((String)contractTypeDefMap.get(contractTypeName))));
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)partyaNameEx)) {
                    detailVO2.setErrorMessage("\u5408\u540c\u7532\u65b9\u4e0d\u53ef\u4e3a\u7a7a");
                } else if (MapUtils.isEmpty(supplierVOMap) || supplierVOMap.get(partyaNameEx) == null) {
                    CommonResponse orgVORes = this.shareSupplierApi.findOneByName(partyaNameEx, tenantid);
                    if (orgVORes.isSuccess()) {
                        SupplierVO orgVO = (SupplierVO)orgVORes.getData();
                        if (orgVO == null) {
                            detailVO2.setErrorMessage("\u6839\u636e\u5408\u540c\u7532\u65b9\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                        } else {
                            supplierVOMap.put(partyaNameEx, orgVO);
                            detailVO2.setCustomerId(orgVO.getId());
                            detailVO2.setCustomerName(orgVO.getName());
                        }
                    } else {
                        detailVO2.setErrorMessage("\u6839\u636e\u5408\u540c\u7532\u65b9\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                    }
                } else {
                    SupplierVO orgVO = (SupplierVO)supplierVOMap.get(partyaNameEx);
                    detailVO2.setCustomerId(orgVO.getId());
                    detailVO2.setCustomerName(orgVO.getName());
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)partybNameEx)) {
                    detailVO2.setErrorMessage("\u5408\u540c\u4e59\u65b9\u4e0d\u53ef\u4e3a\u7a7a");
                } else if (MapUtils.isEmpty(supplierVOMap) || supplierVOMap.get(partybNameEx) == null) {
                    CommonResponse supplierVORes = this.shareSupplierApi.findOneByName(partybNameEx, tenantid);
                    if (supplierVORes.isSuccess()) {
                        SupplierVO supplierVO = (SupplierVO)supplierVORes.getData();
                        if (supplierVO == null) {
                            detailVO2.setErrorMessage("\u6839\u636e\u5408\u540c\u4e59\u65b9\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                        } else {
                            supplierVOMap.put(partybNameEx, supplierVO);
                            detailVO2.setSupplierId(supplierVO.getId());
                            detailVO2.setSupplierName(supplierVO.getName());
                        }
                    } else {
                        detailVO2.setErrorMessage("\u6839\u636e\u5408\u540c\u4e59\u65b9\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                    }
                } else {
                    SupplierVO supplierVO = (SupplierVO)supplierVOMap.get(partybNameEx);
                    detailVO2.setSupplierId(supplierVO.getId());
                    detailVO2.setSupplierName(supplierVO.getName());
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)signDateStrEx)) {
                    detailVO2.setErrorMessage("\u7b7e\u8ba2\u65e5\u671f\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    try {
                        detailVO2.setSignDate(HSSFDateUtil.getJavaDate((double)Double.parseDouble(signDateStrEx)));
                    }
                    catch (Exception e) {
                        detailVO2.setErrorMessage("\u7b7e\u8ba2\u65e5\u671f\u586b\u5199\u4e0d\u6b63\u786e");
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)contractValuationTypeName)) {
                    if (MapUtils.isEmpty(contractValuationTypeDefMap) || contractValuationTypeDefMap.get(contractValuationTypeName) == null) {
                        detailVO2.setErrorMessage("\u8ba1\u4ef7\u65b9\u5f0f\u8f93\u5165\u7c7b\u578b\u9519\u8bef");
                    } else {
                        detailVO2.setContractValuationType(Long.valueOf(Long.parseLong((String)contractValuationTypeDefMap.get(contractValuationTypeName))));
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)contractualModelName)) {
                    if (MapUtils.isEmpty(contractualModelDefMap) || contractualModelDefMap.get(contractualModelName) == null) {
                        detailVO2.setErrorMessage("\u627f\u5305\u6a21\u5f0f\u8f93\u5165\u7c7b\u578b\u9519\u8bef");
                    } else {
                        detailVO2.setContractualModel(Long.valueOf(Long.parseLong((String)contractualModelDefMap.get(contractualModelName))));
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)taxRateEx)) {
                    detailVO2.setErrorMessage("\u7a0e\u7387\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    try {
                        BigDecimal taxRate = new BigDecimal(taxRateEx);
                        if (taxRate.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO2.setErrorMessage("\u7a0e\u7387\u4e0d\u53ef\u5c0f\u4e8e0");
                        } else {
                            detailVO2.setTaxRate(taxRate);
                        }
                    }
                    catch (Exception e) {
                        detailVO2.setErrorMessage("\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)baseTaxMoney)) {
                    detailVO2.setErrorMessage("\u5408\u540c\u7b7e\u8ba2\u91d1\u989d\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    try {
                        BigDecimal taxMoney = new BigDecimal(baseTaxMoney);
                        if (taxMoney.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO2.setErrorMessage("\u5408\u540c\u7b7e\u8ba2\u91d1\u989d\u4e0d\u53ef\u5c0f\u4e8e0");
                        } else {
                            detailVO2.setBaseTaxMoney(taxMoney);
                            detailVO2.setContractTaxMny(taxMoney);
                        }
                    }
                    catch (Exception e) {
                        detailVO2.setErrorMessage("\u5408\u540c\u7b7e\u8ba2\u91d1\u989d\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)baseMoney)) {
                    detailVO2.setErrorMessage("\u5408\u540c\u7b7e\u8ba2\u91d1\u989d(\u65e0\u7a0e)\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    try {
                        BigDecimal money = new BigDecimal(baseMoney);
                        if (money.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO2.setErrorMessage("\u5408\u540c\u7b7e\u8ba2\u91d1\u989d(\u65e0\u7a0e)\u4e0d\u53ef\u5c0f\u4e8e0");
                        } else {
                            detailVO2.setBaseMoney(money);
                            detailVO2.setContractMny(money);
                        }
                    }
                    catch (Exception e) {
                        detailVO2.setErrorMessage("\u5408\u540c\u7b7e\u8ba2\u91d1\u989d(\u65e0\u7a0e)\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)baseTax)) {
                    try {
                        BigDecimal tax = new BigDecimal(baseTax);
                        if (tax.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO2.setErrorMessage("\u5408\u540c\u7b7e\u8ba2\u7a0e\u989d\u4e0d\u53ef\u5c0f\u4e8e0");
                        } else {
                            detailVO2.setBaseTax(tax);
                            detailVO2.setTaxMny(tax);
                        }
                    }
                    catch (Exception e) {
                        detailVO2.setErrorMessage("\u5408\u540c\u7b7e\u8ba2\u7a0e\u989d\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)startDate)) {
                    try {
                        detailVO2.setStartDate(HSSFDateUtil.getJavaDate((double)Double.parseDouble(startDate)));
                    }
                    catch (Exception e) {
                        detailVO2.setErrorMessage("\u7b7e\u8ba2\u65e5\u671f\u586b\u5199\u4e0d\u6b63\u786e");
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)endDate)) {
                    try {
                        detailVO2.setEndDate(HSSFDateUtil.getJavaDate((double)Double.parseDouble(endDate)));
                    }
                    catch (Exception e) {
                        detailVO2.setErrorMessage("\u5408\u540c\u7ed3\u675f\u65e5\u671f\u586b\u5199\u4e0d\u6b63\u786e");
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)startDate) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)endDate)) {
                    try {
                        Date start = HSSFDateUtil.getJavaDate((double)Double.parseDouble(startDate));
                        Date end = HSSFDateUtil.getJavaDate((double)Double.parseDouble(endDate));
                        if (start.compareTo(end) > 0) {
                            detailVO2.setErrorMessage("\u5408\u540c\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65e5\u671f");
                        } else {
                            detailVO2.setSchedule(Integer.valueOf((int)DateUtil.between((Date)start, (Date)end, (DateUnit)DateUnit.DAY) + 1));
                        }
                    }
                    catch (Exception e) {
                        detailVO2.setErrorMessage("\u65e5\u671f\u683c\u5f0f\u586b\u5199\u4e0d\u6b63\u786e");
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)employeeName)) {
                    detailVO2.setErrorMessage("\u7ecf\u529e\u4eba\u4e0d\u53ef\u4e3a\u7a7a");
                } else if (MapUtils.isEmpty(employeeVOMap) || employeeVOMap.get(employeeName) == null) {
                    CommonResponse map = this.employeeApi.getEmployeeMapByNames(Collections.singletonList(employeeName));
                    if (map.isSuccess() && null != map.getData()) {
                        Map employee = (Map)map.getData();
                        if (MapUtils.isEmpty((Map)employee) || employee.get(employeeName) == null) {
                            detailVO2.setErrorMessage("\u7ecf\u529e\u4eba\u4e0d\u5b58\u5728");
                        } else {
                            EmployeeVO employeeVO = (EmployeeVO)employee.get(employeeName);
                            detailVO2.setEmployeeId(employeeVO.getId());
                            detailVO2.setEmployeeName(employeeVO.getName());
                            detailVO2.setDeptId(employeeVO.getDeptId());
                            detailVO2.setDeptName(employeeVO.getDeptName());
                        }
                    }
                } else {
                    EmployeeVO employeeVO = (EmployeeVO)employeeVOMap.get(employeeName);
                    detailVO2.setEmployeeId(employeeVO.getId());
                    detailVO2.setEmployeeName(employeeVO.getName());
                    detailVO2.setDeptId(employeeVO.getDeptId());
                    detailVO2.setDeptName(employeeVO.getDeptName());
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)overReducedTaxMny)) {
                    try {
                        BigDecimal mny = new BigDecimal(overReducedTaxMny);
                        if (mny.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO2.setErrorMessage("\u8d85\u62a5\u5ba1\u51cf\u8d39\u4e0d\u53ef\u5c0f\u4e8e0");
                        } else {
                            detailVO2.setOverReducedTaxMny(mny);
                        }
                    }
                    catch (Exception e) {
                        detailVO2.setErrorMessage("\u8d85\u62a5\u5ba1\u51cf\u8d39\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)meterType)) {
                    if ("\u6309\u6708\u8ba1\u91cf".equals(meterType)) {
                        detailVO2.setMeterType("1");
                    } else if ("\u6309\u8282\u70b9\u8ba1\u91cf".equals(meterType)) {
                        detailVO2.setMeterType("2");
                    }
                }
                detailVO2.setProgressPaymentClause(progressPaymentClause);
                if (StringUtils.isBlank((String)contractStatus)) {
                    detailVO2.setErrorMessage("\u5408\u540c\u5c65\u7ea6\u72b6\u6001\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)contractStatus)) {
                        detailVO2.setContractStatus(ContractStatusEnum.\u672a\u7b7e\u8ba2.getCode());
                        detailVO2.setContractStatusName(ContractStatusEnum.\u672a\u7b7e\u8ba2.getDescription());
                    }
                    if (ContractStatusEnum.\u672a\u7b7e\u8ba2.getDescription().equals(contractStatus)) {
                        detailVO2.setContractStatus(ContractStatusEnum.\u672a\u7b7e\u8ba2.getCode());
                        detailVO2.setContractStatusName(ContractStatusEnum.\u672a\u7b7e\u8ba2.getDescription());
                    } else if (ContractStatusEnum.\u5c65\u7ea6\u4e2d.getDescription().equals(contractStatus)) {
                        detailVO2.setContractStatus(ContractStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                        detailVO2.setContractStatusName(ContractStatusEnum.\u5c65\u7ea6\u4e2d.getDescription());
                    } else if (ContractStatusEnum.\u5df2\u7ec8\u6b62.getDescription().equals(contractStatus)) {
                        detailVO2.setContractStatus(ContractStatusEnum.\u5df2\u7ec8\u6b62.getCode());
                        detailVO2.setContractStatusName(ContractStatusEnum.\u5df2\u7ec8\u6b62.getDescription());
                    } else if (ContractStatusEnum.\u5df2\u89e3\u9664.getDescription().equals(contractStatus)) {
                        detailVO2.setContractStatus(ContractStatusEnum.\u5df2\u89e3\u9664.getCode());
                        detailVO2.setContractStatusName(ContractStatusEnum.\u5df2\u89e3\u9664.getDescription());
                    } else if (ContractStatusEnum.\u5df2\u51bb\u7ed3.getDescription().equals(contractStatus)) {
                        detailVO2.setContractStatus(ContractStatusEnum.\u5df2\u51bb\u7ed3.getCode());
                        detailVO2.setContractStatusName(ContractStatusEnum.\u5df2\u51bb\u7ed3.getDescription());
                    } else {
                        detailVO2.setErrorMessage("\u5408\u540c\u5c65\u7ea6\u72b6\u6001\u586b\u5199\u4e0d\u6b63\u786e");
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)memoEx) && memoEx.length() > 100) {
                    detailVO2.setErrorMessage("\u5907\u6ce8\u957f\u5ea6\u4e0d\u53ef\u5927\u4e8e100");
                } else {
                    detailVO2.setMemo(memoEx);
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)detailVO2.getErrorMessage())) {
                    successList.add(detailVO2);
                } else {
                    errorList.add(detailVO2);
                }
                detailVO2.setSupplementFlag(Integer.valueOf(0));
                detailVO2.setIsEstimation(Integer.valueOf(0));
                detailVO2.setIsFinish(Integer.valueOf(0));
                detailVO2.setIsRelieve(Integer.valueOf(0));
                detailVO2.setIsSuspend(Integer.valueOf(0));
            }
        }
        errorList.forEach(detailVO -> detailVO.setId(Long.valueOf(IdWorker.getId())));
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        Date createTime = new Date();
        UserContext userContext = this.sessionManager.getUserContext();
        String userCode = "";
        if (userContext != null) {
            userCode = userContext.getUserCode();
        }
        List sucVoList = BeanMapper.mapList(successList, ContractRegisterVO.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (CollectionUtils.isNotEmpty((Collection)sucVoList)) {
            for (ContractRegisterVO vo : sucVoList) {
                vo.setCreateTime(createTime);
                vo.setCreateUserCode(userCode);
                long contractId = IdWorker.getId();
                if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)vo.getBillCode())) continue;
                String billCode = null;
                if (Objects.equals(vo.getSupplementFlag(), ContractRegisterVO.CONTRACT_TYPE_SUPPLEMENT)) {
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    wrapper.eq(ContractRegisterEntity::getMainContractId, (Object)vo.getMainContractId());
                    wrapper.in(ContractRegisterEntity::getBillState, Arrays.asList(1, 3));
                    List list = this.list((Wrapper)wrapper);
                    String supplementNum = "";
                    supplementNum = list.size() < 10 ? supplementNum + "0" + (list.size() + 1) : supplementNum + (list.size() + 1);
                    billCode = vo.getMainContractCode() + "-2-" + supplementNum;
                } else {
                    BillCodeParam billCodeParam = BillCodeParam.build((String)INCOME_CONTRACT_REGISTER, (Long)tenantId, (BaseVO)vo);
                    CommonResponse responses = this.billCodeApi.generateBillCode(billCodeParam);
                    if (responses.isSuccess()) {
                        billCode = (String)responses.getData();
                    } else {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                }
                vo.setBillCode(billCode);
            }
            List sucEntityList = BeanMapper.mapList((Iterable)sucVoList, ContractRegisterEntity.class);
            this.saveOrUpdateBatch(sucEntityList, sucEntityList.size(), false);
        }
        return CommonResponse.success((Object)json);
    }

    @Override
    public ContractReviewVO queryReviewByProject(Long projectId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractReviewEntity::getProjectId, (Object)projectId);
        wrapper.eq(ContractReviewEntity::getSupplementFlag, (Object)0);
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.reviewService.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            return new ContractReviewVO();
        }
        return (ContractReviewVO)BeanMapper.map(list.get(0), ContractReviewVO.class);
    }
}

