/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.home.util;

import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.util.CamelAndUnderLineConverter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ParamUtil {
    public static <T> String paramToString(Map<String, Parameter> params) {
        StringBuilder builder = new StringBuilder();
        builder.append("dr = 0");
        for (Map.Entry<String, Parameter> entry : params.entrySet()) {
            Parameter param = entry.getValue();
            String type = param.getType();
            String key = CamelAndUnderLineConverter.humpToLine((String)entry.getKey());
            switch (type) {
                case "eq": {
                    if (null == param.getValue()) {
                        builder.append(" and " + key + " is null");
                        break;
                    }
                    builder.append(" and " + key + " = '" + param.getValue() + "'");
                    break;
                }
                case "ne": {
                    if (null == param.getValue()) {
                        builder.append(" and " + key + " is not null");
                        break;
                    }
                    builder.append(" and " + key + " <> '" + param.getValue() + "'");
                    break;
                }
                case "sql": {
                    if (param.getValue() == null) break;
                    builder.append(param.getValue().toString());
                    break;
                }
                case "in": {
                    if (param.getValue() instanceof List) {
                        builder.append(" and " + key + " in ('" + StringUtils.join((Iterable)((List)param.getValue()), (String)"', '") + "')");
                        break;
                    }
                    if (!(param.getValue() instanceof String)) break;
                    Object[] paramArr = param.getValue().toString().split(",");
                    builder.append(" and " + key + " in ('" + StringUtils.join((Object[])paramArr, (String)"', '") + "')");
                    break;
                }
                case "not_in": {
                    if (param.getValue() instanceof List) {
                        builder.append(" and " + key + " not in ('" + StringUtils.join((Iterable)((List)param.getValue()), (String)"', '") + "')");
                        break;
                    }
                    if (!(param.getValue() instanceof String)) break;
                    Object[] paramArr = param.getValue().toString().split(",");
                    builder.append(" and " + key + " not in ('" + StringUtils.join((Object[])paramArr, (String)"', '") + "')");
                    break;
                }
                case "like": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    builder.append(" and " + key + " like '%" + param.getValue() + "%'");
                    break;
                }
                case "not_like": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    builder.append(" and " + key + " not like '%" + param.getValue() + "%'");
                    break;
                }
                case "like_left": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    builder.append(" and " + key + " like '%" + param.getValue() + "'");
                    break;
                }
                case "like_right": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    builder.append(" and " + key + " like '" + param.getValue() + "%'");
                    break;
                }
                case "between": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    Object[] paramArr = param.getValue().toString().split(",");
                    if ("dateInSelect".equals(param.getInputType()) && paramArr[0].length() == 7) {
                        if (((String)paramArr[0]).equals(paramArr[1])) {
                            builder.append(" and " + key + " = '" + (String)paramArr[0] + "'");
                            break;
                        }
                        builder.append(" and " + key + " in ('" + StringUtils.join(ParamUtil.getMonthRange((String)paramArr[0], (String)paramArr[1]), (String)"', '") + "')");
                        break;
                    }
                    builder.append(" and " + key + " between '" + (String)paramArr[0] + "' and '" + (String)paramArr[1] + "'");
                    break;
                }
                case "lt": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    builder.append(" and " + key + " < '" + param.getValue() + "'");
                    break;
                }
                case "le": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    builder.append(" and " + key + " <= '" + param.getValue() + "'");
                    break;
                }
                case "gt": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    builder.append(" and " + key + " > '" + param.getValue() + "'");
                    break;
                }
                case "ge": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    builder.append(" and " + key + " >= '" + param.getValue() + "'");
                }
            }
        }
        return builder.toString();
    }

    public static List<String> getMonthRange(String startDateStr, String endDateStr) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = sdf.parse(startDateStr);
            endDate = sdf.parse(endDateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        ArrayList<String> monthList = new ArrayList<String>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        while (!calendar.getTime().after(endDate)) {
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            String monthStr = String.format("%04d-%02d", year, month);
            monthList.add(monthStr);
            calendar.add(2, 1);
        }
        return monthList;
    }
}

