/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.recipetApply.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.recipetApply.bean.RecipetApplyEntity;
import com.ejianc.business.pro.recipetApply.service.IRecipetApplyService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="recipetApply")
public class RecipetApplyBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IRecipetApplyService service;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.service.wbActualReceivedMny(billId, true);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            RecipetApplyEntity entity = (RecipetApplyEntity)((Object)this.service.selectById(billId));
            QueryWrapper listQuery = new QueryWrapper();
            listQuery.eq((Object)"contract_id", (Object)entity.getContractId());
            listQuery.eq((Object)"bill_state", (Object)BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            int resultCount = this.service.count((Wrapper)listQuery);
            if (resultCount > 0) {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5df2\u5b58\u5728\u81ea\u7531\u6001\u7684\u6536\u6b3e\u7533\u8bf7\u5355,\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
            }
            QueryWrapper listQueryOrderByTime = new QueryWrapper();
            listQueryOrderByTime.eq((Object)"contract_id", (Object)entity.getContractId());
            listQueryOrderByTime.in((Object)"bill_state", new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
            listQueryOrderByTime.orderByDesc((Object)"create_time");
            List listOrderByTime = this.service.list((Wrapper)listQueryOrderByTime);
            if (CollectionUtils.isNotEmpty((Collection)listOrderByTime) && null != listOrderByTime.get(0) && !((RecipetApplyEntity)((Object)listOrderByTime.get(0))).getId().equals(billId)) {
                return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u4e0d\u662f\u6700\u65b0\u7684\u6536\u6b3e\u7533\u8bf7\u5355,\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
            }
            this.service.wbActualReceivedMny(billId, false);
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

