package com.ejianc.business.pro.g9.service.impl;

import com.ejianc.business.constructor.api.INbzzContractApi;
import com.ejianc.business.constructor.vo.NbzzContractVO;
import com.ejianc.business.pro.g9.bean.SettleReportG9Entity;
import com.ejianc.business.pro.g9.service.ISettleReportG9Service;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("settleReportG9") 
public class SettleReportG9BpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private ISettleReportG9Service reportG9Service;
	@Autowired
	private INbzzContractApi nbzzContractApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		SettleReportG9Entity entity = reportG9Service.selectById(billId);
		CommonResponse<NbzzContractVO> commonResponse = nbzzContractApi.queryDetail(entity.getContractId());
		if(!commonResponse.isSuccess()){
			throw new BusinessException("查询历史合同失败");
		}
		NbzzContractVO nbzzContractVO = commonResponse.getData();
		nbzzContractVO.setReportSettleMny(entity.getReportSettleMny());
		nbzzContractVO.setReportDate(entity.getReportDate());
		CommonResponse<NbzzContractVO> saveRes = nbzzContractApi.saveOrUpdate(nbzzContractVO);
		if(!saveRes.isSuccess()){
			throw new BusinessException("回写历史合同结算报审数据失败");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
