package com.ejianc.business.pro.income.controller.api;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.deskTop.vo.ProincomeDynamicVO;
import com.ejianc.business.pro.income.api.IProincomeContractApi;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.ContractReviewEntity;
import com.ejianc.business.pro.income.bean.ProductionEntity;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IContractReviewService;
import com.ejianc.business.pro.income.service.IProductionService;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.pro.income.vo.CustomerCountWithYearVO;
import com.ejianc.business.pro.income.vo.ProductionVO;
import com.ejianc.foundation.support.vo.CustomerIncomeInfoVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/proincomeContrantApi/")
public class ProincomeContrantApi {

    @Autowired
    private IContractRegisterService service;

    @Autowired
    private IProductionService productionService;

    @Autowired
    private IContractReviewService contractReviewService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 根据项目ID(projectID)查询该项目最新生效的施工合同
     * @param projectId
     * @return
     */
    @GetMapping("/queryContranct")
    public CommonResponse<BigDecimal> queryContranct(@RequestParam(value = "projectId") Long projectId) {
        LambdaQueryWrapper<ContractRegisterEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ContractRegisterEntity::getProjectId,projectId);
        queryWrapper.eq(ContractRegisterEntity::getDr,0);
        queryWrapper.eq(ContractRegisterEntity::getSupplementFlag,0);
        queryWrapper.eq(ContractRegisterEntity::getTenantId, InvocationInfoProxy.getTenantid());
//        queryWrapper.eq(ContractRegisterEntity::getIsEstimation,0);
        queryWrapper.in(ContractRegisterEntity::getBillState, 1, 3);
        List<ContractRegisterEntity> contractRegisterEntities = service.list(queryWrapper);
        BigDecimal totalContractTaxMny = new BigDecimal("0.00");
        if(ListUtil.isNotEmpty(contractRegisterEntities)){
            totalContractTaxMny = contractRegisterEntities.stream().filter(e -> e.getNicContractMny() != null).map(ContractRegisterEntity::getNicContractMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalContractTaxMny = totalContractTaxMny.setScale(2,BigDecimal.ROUND_HALF_UP);
        }else {
            return CommonResponse.error("查询失败,没有查询到该项目下的施工合同！");
        }
        return CommonResponse.success("查询成功！", totalContractTaxMny);
    }

    /**
     * 根据项目部组织ID(orgId)查询该项目部下已生效的产值金额(含税)汇总
     * @param orgId
     * @return
     */
    @GetMapping("/queryProduction")
    public CommonResponse<BigDecimal> queryProduction(@RequestParam(value = "orgId",required = false) Long orgId) {
        Map<String, BigDecimal> totalMny = new HashMap<>();
        //项目部下已生效的产值金额(含税)汇总
        QueryWrapper<ProductionEntity> query = new QueryWrapper<>();
        query.select("IFNULL(SUM(production_tax_mny), 0) AS totalProductionMny");
        if (orgId != null){
            query.eq("org_id", orgId);
        }else {
            query.eq("org_id", InvocationInfoProxy.getOrgId());
        }
        query.eq("dr",0);
        query.eq("tenant_id",InvocationInfoProxy.getTenantid());
        query.in("bill_state",  Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()));
        Map resultMap = productionService.getMap(query);
        totalMny.put("totalProductionMny", null != resultMap && null != resultMap.get("totalProductionMny") ? new BigDecimal(resultMap.get("totalProductionMny").toString()) : BigDecimal.ZERO);
        return CommonResponse.success("查询成功！",totalMny.get("totalProductionMny"));
    }

    /**
     * 查询已生效的产值金额(含税)汇总
     * @return
     */
    @GetMapping("/queryTotalProduction")
    public CommonResponse<Map<Long,ProductionVO>> queryTotalProduction() {
        QueryWrapper<ProductionEntity> query = new QueryWrapper<>();
        query.eq("dr",0);
        query.eq("tenant_id",InvocationInfoProxy.getTenantid());
        query.in("bill_state",  Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()));
        List<ProductionEntity> list = productionService.list(query);
        if (CollectionUtils.isEmpty(list)){
            return CommonResponse.error("查询失败,没有查询到产值报量！");
        }
        Map<Long,List<ProductionEntity>> map = list.stream().collect(Collectors.groupingBy(ProductionEntity::getProjectId));
        Map<Long,ProductionVO> pMap = new HashMap<>();
        map.forEach((k,v)->{
            ProductionVO vo = new ProductionVO();
            vo.setProductionTaxMny(v.stream().filter(x -> x.getProductionTaxMny() != null)
                    .map(ProductionEntity::getProductionTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setProjectId(k);
            vo.setProjectName(v.get(0).getProjectName());
            vo.setProjectCode(v.get(0).getProjectCode());
            pMap.put(k,vo);
        });
        return CommonResponse.success("查询成功！",pMap);
    }

    /**
     * 根据项目ID(projectID)查询该项目最新生效的正式施工合同
     * @param projectId
     * @return
     */
    @GetMapping("/queryContranctMny")
    public CommonResponse<ContractRegisterVO> queryContranctMny(@RequestParam(value = "projectId") Long projectId) {
        LambdaQueryWrapper<ContractRegisterEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ContractRegisterEntity::getProjectId, projectId);
        queryWrapper.eq(ContractRegisterEntity::getDr, 0);
        queryWrapper.eq(ContractRegisterEntity::getTenantId, InvocationInfoProxy.getTenantid());
        queryWrapper.in(ContractRegisterEntity::getBillState, 1, 3);
        queryWrapper.eq(ContractRegisterEntity::getSupplementFlag,0);
//        queryWrapper.eq(ContractRegisterEntity::getIsEstimation,0);
        queryWrapper.orderByDesc(ContractRegisterEntity::getCreateTime);
        List<ContractRegisterEntity> contractRegisterEntities = service.list(queryWrapper);
        ContractRegisterVO vo = null;
        if (ListUtil.isNotEmpty(contractRegisterEntities)) {
            List<ContractRegisterEntity> zsht = contractRegisterEntities.stream().filter(x->x.getIsEstimation() == 0 && x.getContractTaxMny()!=null).collect(Collectors.toList());
            List<ContractRegisterEntity> zght = contractRegisterEntities.stream().filter(x->x.getIsEstimation() == 1 && x.getContractTaxMny()!=null).collect(Collectors.toList());
            if(CollUtil.isEmpty(zsht) && CollUtil.isEmpty(zght)){
                vo = new ContractRegisterVO();
                vo.setContractTaxMny(BigDecimal.ZERO);
            }else{
                vo= new ContractRegisterVO();
                if (CollUtil.isNotEmpty(zsht)) {
                    vo.setContractTaxMny(zsht.stream().map(ContractRegisterEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                } else {
                    vo.setContractTaxMny(zght.stream().map(ContractRegisterEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                }
//                vo = BeanMapper.map(CollUtil.isNotEmpty(zsht)?zsht.get(0):zght.get(0), ContractRegisterVO.class);
            }
        }
        if (vo == null) {
            return CommonResponse.error("查询失败,没有查询到该项目下的施工合同！");
        }
        return CommonResponse.success("查询成功！", vo);
    }


    /**
     * 根据项目ID查询该项目部下已生效的产值金额(含税)汇总
     * @param projectId
     * @return
     */
    @GetMapping("/queryProductionByProject")
    public CommonResponse<BigDecimal> queryProductionByProject(@RequestParam(value = "projectId") Long projectId) {
        Map<String, BigDecimal> totalMny = new HashMap<>();
        //根据项目ID查询该项目部下已生效的产值金额(含税)汇总
        QueryWrapper<ProductionEntity> query = new QueryWrapper<>();
        query.select("IFNULL(SUM(production_tax_mny), 0) AS totalProductionMny");
        query.eq("project_id", projectId);
        query.eq("dr",0);
        query.eq("tenant_id",InvocationInfoProxy.getTenantid());
        query.in("bill_state",  Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()));
        Map resultMap = productionService.getMap(query);
        totalMny.put("totalProductionMny", null != resultMap && null != resultMap.get("totalProductionMny") ? new BigDecimal(resultMap.get("totalProductionMny").toString()) : BigDecimal.ZERO);
        return CommonResponse.success("查询成功！",totalMny.get("totalProductionMny"));
    }



    /**
     * 根据甲方id获取改客户近5年的合同签订数量
     * @param customerId
     * @return
     */
    @GetMapping("/queryCountByCustomerId")
    CommonResponse<List<CustomerCountWithYearVO>> queryCountByCustomerId(@RequestParam(value = "customerId") Long customerId,
            @RequestParam(value = "dateIn") String dateIn
    ){
        return CommonResponse.success("查询成功",service.queryCountByCustomerId(customerId,dateIn)) ;
    }

    /**
     * @param
     * @Description queryCustomerLevel
     *      根据施工合同查询客户等级:
     *          1、普通客户:合同额5亿元以内
     *          2、大客户:合同额5-10亿元
     *          3、战略客户:合同额10亿元以上
     */
    @RequestMapping(value = "/queryCustomerSum", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryCustomerSum(@RequestBody QueryParam param) {

        QueryWrapper<ContractRegisterEntity> queryWrapper = BaseServiceImpl.changeToQueryWrapper(param);
        List<CustomerIncomeInfoVO> vos = service.queryCustomerSum(queryWrapper);

        ArrayList<JSONObject> list = new ArrayList<>();
        //普通客户:合同额5亿元以内
        long lowCustom = vos.stream().filter(s -> s.getSum() != null
                && s.getSum().compareTo(new BigDecimal(500000000)) < 0).count();
        JSONObject lowCustomJSON = new JSONObject();
        lowCustomJSON.put("name","普通客户");
        lowCustomJSON.put("value",lowCustom);
        list.add(lowCustomJSON);

        //大客户:合同额5-10亿元
        long middleCustom = vos.stream().filter(s -> s.getSum() != null
                && s.getSum().compareTo(new BigDecimal(500000000)) >= 0
                && s.getSum().compareTo(new BigDecimal(1000000000) ) < 0
        ).count();
        JSONObject middleCustomJSON = new JSONObject();
        middleCustomJSON.put("name","大客户");
        middleCustomJSON.put("value",middleCustom);
        list.add(middleCustomJSON);

        //战略客户:合同额10亿元以上
        long heightCustom = vos.stream().filter(s -> s.getSum() != null
                && s.getSum().compareTo(new BigDecimal(1000000000) ) >= 0
        ).count();
        JSONObject heightCustomJSON = new JSONObject();
        heightCustomJSON.put("name","战略客户");
        heightCustomJSON.put("value",heightCustom);
        list.add(heightCustomJSON);


        return CommonResponse.success("查询客户数据情况数据成功！", list);
    }


    /**
     * 经营部门户-查询施工合同动态管理列表
     * @param param
     * @return
     */
    @RequestMapping(value = "/queryDynamic", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ProincomeDynamicVO>> queryDynamic(@RequestBody QueryParam param) {


        List<ProincomeDynamicVO> proincomeDynamicVOS = service.queryDynamic();
        return CommonResponse.success("查询客户数据情况数据成功！", proincomeDynamicVOS);
    }

    /**
     * 根据项目ID(projectID)修改建造师
     * @param projectId
     * @return
     */
    @GetMapping("/updateJzs")
    public CommonResponse<BigDecimal> updateJzs(@RequestParam(value = "projectId") Long projectId,
                                                @RequestParam(value = "userId") Long userId,
                                                @RequestParam(value = "userName") String userName) {
//        LambdaQueryWrapper<ContractRegisterEntity> queryWrapper = new LambdaQueryWrapper<>();
//        queryWrapper.eq(ContractRegisterEntity::getProjectId,projectId);
//        queryWrapper.eq(ContractRegisterEntity::getDr,0);
//        queryWrapper.eq(ContractRegisterEntity::getSupplementFlag,0);
//        queryWrapper.eq(ContractRegisterEntity::getTenantId, InvocationInfoProxy.getTenantid());
//        queryWrapper.in(ContractRegisterEntity::getBillState, 1, 3);
//        List<ContractRegisterEntity> contractRegisterEntities = service.list(queryWrapper);
//        if (CollectionUtil.isNotEmpty(contractRegisterEntities)){
//            ContractRegisterEntity contractRegisterEntity = contractRegisterEntities.get(0);
//            contractRegisterEntity.set
//        }

        LambdaQueryWrapper<ContractReviewEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ContractReviewEntity::getProjectId,projectId);
        queryWrapper.eq(ContractReviewEntity::getDr,0);
        //queryWrapper.eq(ContractReviewEntity::getSupplementFlag,0);
        queryWrapper.eq(ContractReviewEntity::getTenantId, InvocationInfoProxy.getTenantid());
        queryWrapper.in(ContractReviewEntity::getBillState, 1, 3);
        List<ContractReviewEntity> list = contractReviewService.list(queryWrapper);
        logger.info("list=====================:{}", JSON.toJSONString(list));
        if (CollectionUtil.isNotEmpty(list)){
            for (ContractReviewEntity contractReviewEntity : list) {
                contractReviewEntity.setArchitectId(userId);
                contractReviewEntity.setArchitectName(userName);
                contractReviewService.saveOrUpdate(contractReviewEntity);
            }
        }
        return CommonResponse.success("查询成功！");
    }

}
