package com.ejianc.business.pro.income.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.hr.vo.TypeVO;
import com.ejianc.business.pro.deskTop.vo.ProincomeDynamicVO;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.pro.income.vo.CustomerCountWithYearVO;
import com.ejianc.business.pro.income.vo.CustomerInfoVO;
import com.ejianc.business.pro.warn.SqlParam;
import com.ejianc.foundation.support.vo.CustomerIncomeInfoVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Update;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 施工合同登记
 * 
 * @author generator
 * 
 */
@Mapper
public interface ContractRegisterMapper extends BaseCrudMapper<ContractRegisterEntity> {

    List<Map<String,Object>> queryBudgetWarnContract(@Param("sqlParamList") List<SqlParam> sqlParamList);

    List<Map<String,Object>> queryCostWarnContract(@Param("sqlParamList") List<SqlParam> sqlParamList);

    List<Map<String,Object>> queryContractRegisterWarnContract(@Param("sqlParamList") List<SqlParam> sqlParamList);

    List<ContractRegisterVO> querySettleReportWarnContract(@Param("tenantId") Long tenantId);

    List<ContractRegisterVO> queryFinalizedWarnContract(@Param("tenantId") Long tenantId);

//    List<Map<String,Object>> queryBudgetInWarnContract(@Param("sqlParamList") List<SqlParam> sqlParamList);
    CustomerIncomeInfoVO queryCustomerInfo(@Param("customerId") Long customerId);

    /**
     * 根据customerId分组，查询施工合同累计金额
     * @param wrapper
     * @return
     */
    List<CustomerIncomeInfoVO> queryCustomerSum(@Param(Constants.WRAPPER) QueryWrapper wrapper);


    List<CustomerCountWithYearVO> queryCountByCustomerId(@Param("customerId") List<Long> customerId);

    //根据项目id更改计划开工日期、计划竣工日期、工期
    @Update("UPDATE `ejc-promarket`.ejc_promarket_project_set " +
            "SET plan_start_date = #{planStartDate}," +
            "plan_end_date = #{planEndDate}," +
            "plan_date_num = #{planDateNum} " +
            "WHERE id = #{projectId}")
    Boolean updatePlanDate(@Param("projectId") Long projectId,
                        @Param("planStartDate") Date planStartDate,
                        @Param("planEndDate") Date planEndDate,
                        @Param("planDateNum") Integer planDateNum);


    /**
     * 查询施工合同登记and导入历史导入合同数据
     * @param page
     * @param wrapper
     * @return
     */
    List<ContractRegisterVO> queryPageContractAndHistoryExport(Page<ContractRegisterVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);


    /**
     * 施工合同评审-根据评审类型查询
     *      审批中数量
     *      待用印数量
     *      待返还数量
     *      登记中数量
     *      待交底数量
     */
    List<ProincomeDynamicVO> queryApproving();
    List<ProincomeDynamicVO> querySealing();
    List<ProincomeDynamicVO> queryFilling();
    List<ProincomeDynamicVO> queryRegistering();
    List<ProincomeDynamicVO> queryConfessing();


    List<Long> queryListByProjectId(@Param("ids") List<Long> ids);

    /**
     * 经营部门户查询定案阶段分类
     */
    List<TypeVO> querySettleReportProgressType();
}
