package com.ejianc.business.pro.income.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 工程造价调整
 *
 * @author generator
 */
@TableName("ejc_income_cost_adjust")
public class CostAdjustEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "bill_code")
    private String billCode; // 单据编号
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态
    @TableField(value = "contract_id")
    private Long contractId; // 合同ID
    @TableField(value = "contract_code")
    private String contractCode; // 合同编码
    @TableField(value = "contract_name")
    private String contractName; // 合同名称
    @TableField(value = "project_id")
    private Long projectId; // 项目ID
    @TableField(value = "project_code")
    private String projectCode; // 项目编码
    @TableField(value = "project_name")
    private String projectName; // 项目名称
    @TableField(value = "org_id")
    private Long orgId; // 项目组织ID
    @TableField(value = "org_code")
    private String orgCode; // 项目组织编码
    @TableField(value = "org_name")
    private String orgName; // 项目组织名称
    @TableField(value = "parent_org_id")
    private Long parentOrgId; // 组织ID
    @TableField(value = "parent_org_code")
    private String parentOrgCode; // 组织编码ID
    @TableField(value = "parent_org_name")
    private String parentOrgName; // 组织名称ID
    @TableField(value = "apply_adjust_date")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date applyAdjustDate; // 申请调整日期
    @TableField(value = "base_mny")
    private BigDecimal baseMny; // 初始版本金额(无税)
    @TableField(value = "base_tax_mny")
    private BigDecimal baseTaxMny; // 初始版本金额
    @TableField(value = "contract_mny")
    private BigDecimal contractMny; // 合同签订金额(无税)
    @TableField(value = "contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同签订金额
    @TableField(value = "tax_rate")
    private BigDecimal taxRate; // 合同税率
    @TableField(value = "total_supplement_mny")
    private BigDecimal totalSupplementMny; // 补充协议总金额(无税)
    @TableField(value = "total_supplement_tax_mny")
    private BigDecimal totalSupplementTaxMny; // 补充协议总金额
    @TableField(value = "employee_id")
    private Long employeeId; // 经办人
    @TableField(value = "employee_name")
    private String employeeName; // 经办人名称
    @TableField(value = "department_id")
    private Long departmentId; // 经办部门
    @TableField(value = "department_name")
    private String departmentName; // 经办部门名称
    @TableField(value = "apply_change_mny")
    private BigDecimal applyChangeMny; // 申请变动金额(无税)
    @TableField(value = "apply_change_tax_mny")
    private BigDecimal applyChangeTaxMny; // 申请变动金额
    @TableField(value = "reply_mny")
    private BigDecimal replyMny; // 甲方批复金额(无税)
    @TableField(value = "reply_tax_mny")
    private BigDecimal replyTaxMny; // 甲方批复金额
    @TableField(value = "last_apply_change_mny")
    private BigDecimal lastApplyChangeMny; // 不含本期累计申请变动金额(无税)
    @TableField(value = "last_apply_change_tax_mny")
    private BigDecimal lastApplyChangeTaxMny; // 不含本期累计申请变动金额
    @TableField(value = "total_apply_change_mny")
    private BigDecimal totalApplyChangeMny; // 累计申请变动金额(无税)
    @TableField(value = "total_apply_change_tax_mny")
    private BigDecimal totalApplyChangeTaxMny; // 累计申请变动金额
    @TableField(value = "cost_change_total_mny")
    private BigDecimal costChangeTotalMny; // 工程造价及变动合计总金额(无税)
    @TableField(value = "cost_change_total_tax_mny")
    private BigDecimal costChangeTotalTaxMny; // 工程造价及变动合计总金额
    @TableField(value = "memo")
    private String memo; // 备注
    @TableField(value = "approval_flag")
    private Integer approvalFlag; // 是否需要领导审批
    @TableField(value="not_reply_mny")
    private BigDecimal notReplyMny; // 甲方未批复金额(无税)
    @TableField(value="not_reply_tax_mny")
    private BigDecimal notReplyTaxMny; // 甲方未批复金额


    @TableField(exist = false)
    @SubEntity(serviceName = "costAdjustDetailService", pidName = "adjustId")
    private List<CostAdjustDetailEntity> detailList = new ArrayList<>(); // 工程造价调整-调整来源


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Date getApplyAdjustDate() {
        return applyAdjustDate;
    }

    public void setApplyAdjustDate(Date applyAdjustDate) {
        this.applyAdjustDate = applyAdjustDate;
    }

    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }

    public BigDecimal getBaseTaxMny() {
        return baseTaxMny;
    }

    public void setBaseTaxMny(BigDecimal baseTaxMny) {
        this.baseTaxMny = baseTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTotalSupplementMny() {
        return totalSupplementMny;
    }

    public void setTotalSupplementMny(BigDecimal totalSupplementMny) {
        this.totalSupplementMny = totalSupplementMny;
    }

    public BigDecimal getTotalSupplementTaxMny() {
        return totalSupplementTaxMny;
    }

    public void setTotalSupplementTaxMny(BigDecimal totalSupplementTaxMny) {
        this.totalSupplementTaxMny = totalSupplementTaxMny;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public BigDecimal getApplyChangeMny() {
        return applyChangeMny;
    }

    public void setApplyChangeMny(BigDecimal applyChangeMny) {
        this.applyChangeMny = applyChangeMny;
    }

    public BigDecimal getApplyChangeTaxMny() {
        return applyChangeTaxMny;
    }

    public void setApplyChangeTaxMny(BigDecimal applyChangeTaxMny) {
        this.applyChangeTaxMny = applyChangeTaxMny;
    }

    public BigDecimal getReplyMny() {
        return replyMny;
    }

    public void setReplyMny(BigDecimal replyMny) {
        this.replyMny = replyMny;
    }

    public BigDecimal getReplyTaxMny() {
        return replyTaxMny;
    }

    public void setReplyTaxMny(BigDecimal replyTaxMny) {
        this.replyTaxMny = replyTaxMny;
    }

    public BigDecimal getLastApplyChangeMny() {
        return lastApplyChangeMny;
    }

    public void setLastApplyChangeMny(BigDecimal lastApplyChangeMny) {
        this.lastApplyChangeMny = lastApplyChangeMny;
    }

    public BigDecimal getLastApplyChangeTaxMny() {
        return lastApplyChangeTaxMny;
    }

    public void setLastApplyChangeTaxMny(BigDecimal lastApplyChangeTaxMny) {
        this.lastApplyChangeTaxMny = lastApplyChangeTaxMny;
    }

    public BigDecimal getTotalApplyChangeMny() {
        return totalApplyChangeMny;
    }

    public void setTotalApplyChangeMny(BigDecimal totalApplyChangeMny) {
        this.totalApplyChangeMny = totalApplyChangeMny;
    }

    public BigDecimal getTotalApplyChangeTaxMny() {
        return totalApplyChangeTaxMny;
    }

    public void setTotalApplyChangeTaxMny(BigDecimal totalApplyChangeTaxMny) {
        this.totalApplyChangeTaxMny = totalApplyChangeTaxMny;
    }

    public BigDecimal getCostChangeTotalMny() {
        return costChangeTotalMny;
    }

    public void setCostChangeTotalMny(BigDecimal costChangeTotalMny) {
        this.costChangeTotalMny = costChangeTotalMny;
    }

    public BigDecimal getCostChangeTotalTaxMny() {
        return costChangeTotalTaxMny;
    }

    public void setCostChangeTotalTaxMny(BigDecimal costChangeTotalTaxMny) {
        this.costChangeTotalTaxMny = costChangeTotalTaxMny;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<CostAdjustDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<CostAdjustDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public Integer getApprovalFlag() {
        return approvalFlag;
    }

    public void setApprovalFlag(Integer approvalFlag) {
        this.approvalFlag = approvalFlag;
    }

    public BigDecimal getNotReplyMny() {
        return notReplyMny;
    }

    public void setNotReplyMny(BigDecimal notReplyMny) {
        this.notReplyMny = notReplyMny;
    }

    public BigDecimal getNotReplyTaxMny() {
        return notReplyTaxMny;
    }

    public void setNotReplyTaxMny(BigDecimal notReplyTaxMny) {
        this.notReplyTaxMny = notReplyTaxMny;
    }
}
