package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.pro.income.bean.AccountEntity;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.service.IAccountService;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.utils.MathUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;

@Service("account") 
public class AccountBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IAccountService accountService;

	@Autowired
	private IContractRegisterService contractRegisterService;

	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		AccountEntity accountEntity = accountService.selectById(billId);
		ContractRegisterEntity contractEntity = contractRegisterService.selectById(accountEntity.getContractId());
		LambdaUpdateWrapper<ContractRegisterEntity> wrapper = new LambdaUpdateWrapper<>();
		//累计甲供材结算金额（不含税）
		BigDecimal sumMaterialSettleMny =  MathUtil.safeAdd(contractEntity.getSumMaterialSettleMny(),accountEntity.getMaterialSettleMny());
		wrapper.eq(ContractRegisterEntity::getId,accountEntity.getContractId());
		wrapper.set(ContractRegisterEntity::getSumMaterialSettleMny,sumMaterialSettleMny);
		contractRegisterService.update(wrapper);
//		LambdaUpdateWrapper<ContractRegisterEntity> qwrapper = new LambdaUpdateWrapper<>();
//		//本次甲供材已扣金额（不含税）
//		BigDecimal sumMaterialDeductMny =  MathUtil.safeAdd(contractEntity.getSumMaterialDeductMny(),accountEntity.getMaterialDeductMny());
//		qwrapper.eq(ContractRegisterEntity::getId,accountEntity.getContractId());
//		qwrapper.set(ContractRegisterEntity::getSumNegotiateMny,sumMaterialSettleMny);
//		contractRegisterService.update(qwrapper);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		AccountEntity accountEntity = accountService.selectById(billId);
		ContractRegisterEntity contractEntity = contractRegisterService.selectById(accountEntity.getContractId());
		LambdaUpdateWrapper<ContractRegisterEntity> wrapper = new LambdaUpdateWrapper<>();
		//累计甲供材结算金额（不含税）
		BigDecimal sumMaterialSettleMny =  MathUtil.safeSub(contractEntity.getSumMaterialSettleMny(),accountEntity.getMaterialSettleMny());
		wrapper.eq(ContractRegisterEntity::getId,accountEntity.getContractId());
		wrapper.set(ContractRegisterEntity::getSumMaterialSettleMny,sumMaterialSettleMny);
		contractRegisterService.update(wrapper);
		return CommonResponse.success();
	}

}
