package com.ejianc.business.pro.income.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.cwdataexchange.PMContractPush.api.IPMContractApi;
import com.ejianc.business.cwdataexchange.PMContractPush.vo.PMContractVO;
import com.ejianc.business.hr.vo.TypeVO;
import com.ejianc.business.market.vo.ProjectSetVO;
import com.ejianc.business.pro.deskTop.vo.ProincomeDynamicVO;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.ContractReviewEntity;
import com.ejianc.business.pro.income.enums.BillStateEnum;
import com.ejianc.business.pro.income.enums.ContractStatusEnum;
import com.ejianc.business.pro.income.mapper.ContractRegisterMapper;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IContractReviewService;
import com.ejianc.business.pro.income.utils.BillTypeCodeEnum;
import com.ejianc.business.pro.income.utils.ValidateUtil;
import com.ejianc.business.pro.income.vo.*;
import com.ejianc.business.pro.warn.SqlParam;
import com.ejianc.business.project.api.IProjectMarketSetApi;
import com.ejianc.business.salary.api.IAcSetApi;
import com.ejianc.business.salary.vo.AcSetRelateVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.ICustomerProApi;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.CustomerIncomeInfoVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 施工合同登记
 *
 * @author generator
 */
@Service("contractRegisterService")
public class ContractRegisterServiceImpl extends BaseServiceImpl<ContractRegisterMapper, ContractRegisterEntity> implements IContractRegisterService {

    private static final String INCOME_CONTRACT_REGISTER = "INCOME_CONTRACT_REGISTER";//此处需要根据实际修改

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ValidateUtil validateUtil;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IContractReviewService reviewService;
    @Autowired
    private IContractPoolApi contractPoolApi;

    @Autowired
    public ContractRegisterMapper mapper;

    @Autowired
    private IProjectSetApi projectSetApi;

    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private IPMContractApi contractApi;
    @Autowired
    private ICustomerProApi customerProApi;

    @Autowired
    private IProjectMarketSetApi projectMarketSetApi;

    @Autowired
    private IAcSetApi acSetApi;

    @Override
    public ContractRegisterVO saveOrUpdate(ContractRegisterVO saveorUpdateVO) {


        //保存时校验联合体相关金额是否相等
        if (saveorUpdateVO.getConjoinedManageType() != null) {
            if (saveorUpdateVO.getConjoinedManageType().equals(1)
                    && saveorUpdateVO.getBaseTaxMoney() != null
                    && saveorUpdateVO.getContractBaseTaxMnyNoConjoined() != null
                    && saveorUpdateVO.getBaseTaxMoney().compareTo(saveorUpdateVO.getContractBaseTaxMnyNoConjoined()) != 0) {
                throw new BusinessException("并列关系时，‘合同签订金额’与‘含税合同签订金额（不含联合体）’应相等！");
            }
            if (saveorUpdateVO.getConjoinedManageType().equals(2)
                    && saveorUpdateVO.getBaseTaxMoney() != null
                    && saveorUpdateVO.getContractBaseTaxMny() != null
                    && saveorUpdateVO.getBaseTaxMoney().compareTo(saveorUpdateVO.getContractBaseTaxMny()) != 0) {
                throw new BusinessException("合并关系时，‘合同签订金额’与‘含税合同签订总金额’应相等！");
            }
        }
        // 保存时校验合同version是否一致
        if (!Objects.equals(null, saveorUpdateVO.getReviewId())) {
            if (!validateUtil.validateUpStreamVersion(String.valueOf(saveorUpdateVO.getReviewId()),
                    BillTypeCodeEnum.施工合同评审.getCode(), saveorUpdateVO.getReviewVersion())) {
                throw new BusinessException("该合同已被更新，请刷新后重做！");
            }
        }

        ContractRegisterEntity entity = BeanMapper.map(saveorUpdateVO, ContractRegisterEntity.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (entity.getId() == null || entity.getId() == 0) {
            // 新增
            if (StringUtils.isBlank(entity.getBillCode())) {
                String billCode = null;
                if (Objects.equals(entity.getSupplementFlag(), ContractRegisterVO.CONTRACT_TYPE_SUPPLEMENT)) {
                    // 查询补充协议
                    LambdaQueryWrapper<ContractRegisterEntity> wrapper = new LambdaQueryWrapper<>();
                    wrapper.eq(ContractRegisterEntity::getMainContractId, entity.getMainContractId());
                    wrapper.in(ContractRegisterEntity::getBillState, Arrays.asList(1, 3));
                    List<ContractRegisterEntity> list = this.list(wrapper);

                    String supplementNum = "";
                    if (list.size() < 10) {
                        supplementNum += "0" + (list.size() + 1);
                    } else {
                        supplementNum += (list.size() + 1);
                    }

                    billCode = entity.getMainContractCode() + "-2-" + supplementNum;
                } else {
                    BillCodeParam billCodeParam = BillCodeParam.build(INCOME_CONTRACT_REGISTER, tenantId, saveorUpdateVO);
                    CommonResponse<String> response = billCodeApi.generateBillCode(billCodeParam);
                    if (response.isSuccess()) {
                        billCode = response.getData();
                    } else {
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                }

                entity.setBillCode(billCode);
            }

            // 校验合同编号是否重复
            LambdaQueryWrapper<ContractRegisterEntity> lambda = new LambdaQueryWrapper<>();
            lambda.eq(ContractRegisterEntity::getTenantId, tenantId);
            lambda.eq(ContractRegisterEntity::getBillCode, entity.getBillCode());
            List<ContractRegisterEntity> entityList = super.list(lambda);
            if (ListUtil.isNotEmpty(entityList)) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }

            // 新增设置 竣工结算标志、解除状态、合同状态、变更状态
            entity.setIsFinish(0);
            entity.setIsRelieve(0);
            entity.setIsSuspend(0);
            entity.setContractStatus(ContractStatusEnum.未签订.getCode());
            entity.setChangeStatus("1");
        } else {
            // 修改
            if (StringUtils.isEmpty(entity.getBillCode())) {
                throw new BusinessException("编码为空，不允许保存!");
            }

            // 校验合同编号是否重复
            LambdaQueryWrapper<ContractRegisterEntity> lambda = new LambdaQueryWrapper<>();
            lambda.eq(ContractRegisterEntity::getBillCode, entity.getBillCode());
            lambda.eq(ContractRegisterEntity::getTenantId, tenantId);
            lambda.ne(ContractRegisterEntity::getId, entity.getId());
            List<ContractRegisterEntity> entityList = super.list(lambda);
            if (ListUtil.isNotEmpty(entityList)) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }

            // 暂估合同用
            if (null == entity.getBillState()) {
                entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            }

        }

        /**
         * @Author jiang
         * @Date 2023-3-20 17:33:46
         *
         * 根据是否是联合体、重新计算其他金额信息中的取数逻辑：
         *
         *      合同总金额(无税)、合同总金额、合同税额
         *      工程造价调整后总金额（无税）、工程造价调整后总金额、工程造价调整后税额
         *      工程造价调整后总金额(不含暂列金额)
         *
         *      并列关系取非联合方、合并关系取联合方+非联合方；
         *      合同总金额（无税）和并列关系、合并关系无关
         *
         */
        //只有自由态时触发计算逻辑
        if(entity.getBillState() == null || (entity.getBillState() != null && entity.getBillState() != 3 && entity.getBillState() != 1)){
            //非联合体项目
            if (entity.getIsConjioned() == 0) {
                entity.setContractTaxMny(entity.getBaseTaxMoney()); // 合同总金额
                entity.setContractMny(entity.getBaseMoney()); // 合同总金额(无税)
                entity.setTaxMny(entity.getBaseTax()); // 合同税额
                //工程造价调整后总金额（含税） = 合同签订金额（含税） + 工程造价调整金额合计（含税）
                entity.setTotalAfterCostAdjustTaxMny(ComputeUtil.safeAdd(entity.getBaseTaxMoney(), entity.getTotalCostAdjustTaxMny()));
                //工程造价调整后总金额(无税) = 合同签订金额（无税） + 工程造价调整金额合计（无税）
                entity.setTotalAfterCostAdjustMny(ComputeUtil.safeAdd(entity.getBaseMoney(), entity.getTotalCostAdjustMny()));
                //工程造价调整后税额 = 合同税额 + 工程造价调整税额
                entity.setTotalAfterCostAdjustTax(ComputeUtil.safeAdd(entity.getBaseTax(), entity.getTotalCostAdjustTax()));
                //entity.setNicContractMny(ComputeUtil.safeAdd(entity.getNotIncludeProvisionalMny(), entity.getTotalCostAdjustTaxMny()));
                //工程造价调整后总金额(不含暂列金额)”=【合同签订金额(无税)-暂列金额】*(1+税率）(baseMoney-provisionalMny)*(1+taxRate)
                entity.setNicContractMny(ComputeUtil.safeMultiply(
                        ComputeUtil.safeSub(entity.getBaseMoney(), entity.getProvisionalMny()), ComputeUtil.safeAdd(entity.getTaxRate(), new BigDecimal(100)), new BigDecimal(0.01)
                ));
            }
            //联合体项目
            else {

                BigDecimal contractMny = entity.getContractBaseMnyConjoined().add(entity.getContractBaseMnyNoConjoined());
                entity.setContractMny(entity.getBaseMoney());//合同总金额
                entity.setContractTaxMny(entity.getBaseTaxMoney());//合同总金额(无税)
                //并列关系
                if (entity.getConjoinedManageType() == 1) {
                    BigDecimal taxMonty = entity.getContractBaseTaxMnyNoConjoined().subtract(entity.getContractBaseMnyNoConjoined());
                    entity.setTaxMny(taxMonty); // 合同税额
                    //工程造价调整后总金额（含税） = 含税合同签订金额（不含联合体部分） + 工程造价调整金额合计（含税）
                    entity.setTotalAfterCostAdjustTaxMny(ComputeUtil.safeAdd(entity.getContractBaseTaxMnyNoConjoined(), entity.getTotalCostAdjustTaxMny()));
                    entity.setTotalAfterCostAdjustMny(ComputeUtil.safeAdd(entity.getContractBaseMnyNoConjoined(), entity.getTotalCostAdjustMny()));
                    entity.setTotalAfterCostAdjustTax(ComputeUtil.safeAdd(taxMonty, entity.getTotalCostAdjustTax()));
                    //工程造价调整后总金额(不含暂列金额)=【不含税合同签订金额（不含联合体）-暂列金额】*(1+非联合方税率)
                    entity.setNicContractMny(ComputeUtil.safeMultiply(
                            ComputeUtil.safeSub(entity.getContractBaseMnyNoConjoined(), entity.getProvisionalMny()),
                            ComputeUtil.safeAdd(entity.getNoConjoinedTax(), new BigDecimal(100)),
                            new BigDecimal(0.01)
                    ));
                }
                //合并关系
                if (entity.getConjoinedManageType() == 2) {
                    BigDecimal taxMonty = entity.getContractBaseTaxMny().subtract(entity.getContractMny());
                    entity.setTaxMny(taxMonty); // 合同税额
                    entity.setTotalAfterCostAdjustTaxMny(ComputeUtil.safeAdd(entity.getBaseTaxMoney(), entity.getTotalCostAdjustTaxMny()));
                    entity.setTotalAfterCostAdjustMny(ComputeUtil.safeAdd(entity.getContractMny(), entity.getTotalCostAdjustMny()));
                    entity.setTotalAfterCostAdjustTax(ComputeUtil.safeAdd(taxMonty, entity.getTotalCostAdjustTax()));
                    //工程造价调整后总金额(不含暂列金额)=【不含税合同签订金额（不含联合体）-暂列金额】*(1+非联合方税率)+含税联合体合同
                    entity.setNicContractMny(ComputeUtil.safeAdd(
                            (ComputeUtil.safeMultiply(
                                    ComputeUtil.safeSub(entity.getContractBaseMnyNoConjoined(), entity.getProvisionalMny()),
                                    ComputeUtil.safeAdd(entity.getNoConjoinedTax(), new BigDecimal(100)),
                                    new BigDecimal(0.01))),
                            entity.getContractBaseTaxMnyConjoined())
                    );
                }
            }

        }

        entity.setBeforeChangeTaxMny(entity.getContractTaxMny()); // 变更前金额(含税)
        entity.setBeforeChangeMny(entity.getContractMny()); // 变更前金额(不含税)
        super.saveOrUpdate(entity, false);

        //财务账套信息推送项目基本信息
        if (entity.getCwAccountCode() != null || entity.getCwProjectCode() != null){
            ProjectSetVO projectSetVO = new ProjectSetVO();
            projectSetVO.setId(entity.getProjectId());
            projectSetVO.setCwProjectCode(entity.getCwProjectCode());
            projectSetVO.setCwProjectName(entity.getCwProjectName());
            projectSetVO.setCwAccountCode(entity.getCwAccountCode());
            projectSetVO.setCwAccountName(entity.getCwAccountName());
            projectMarketSetApi.updateProjectCwAccountInfo(projectSetVO);

            //同步推送至薪资系统账套表单
            if(entity.getOrgId() != null ){
                AcSetRelateVO acSetRelateVO = new AcSetRelateVO();
                acSetRelateVO.setAcSet(entity.getCwAccountCode());
                acSetRelateVO.setAcSetCode(entity.getCwAccountName());
                acSetRelateVO.setOrgId(entity.getOrgId());
                acSetRelateVO.setOrgCode(entity.getOrgCode());
                acSetRelateVO.setOrgName(entity.getOrgName());

                acSetApi.updateProjectCwAccountInfo(acSetRelateVO);
            }
        }
        return BeanMapper.map(entity, ContractRegisterVO.class);
    }

    @Override
    public JSONObject pageList(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        // 项合同编号、项目名称、合同名称、经办人、合同甲方名称、施工联合方、合作乙方名称
        fuzzyFields.add("billCode");//单据编号
        fuzzyFields.add("projectName");//工程名称
        fuzzyFields.add("contractName");//合同名称
        fuzzyFields.add("employeeName");//经办人
        fuzzyFields.add("customerName");//合同甲方名称
        fuzzyFields.add("constructionPartner");//施工联合方
        fuzzyFields.add("supplierName");//合作乙方名称

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //修改为能够查出补充协议（附加合同）
        //param.getParams().put("supplement_flag", new Parameter("eq", 0));


        /**
         * 项目层级手机端发送的请求InvocationInfoProxy.getOrgType()一直为1
         */
        String orgType = InvocationInfoProxy.getOrgType();
        if (param != null) {
            Map<String, Parameter> params = param.getParams();
            if (params.containsKey("orgType")) {
                orgType = params.get("orgType").getValue().toString();
                params.remove("orgType");
            }
        }

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(orgType)) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<ContractRegisterEntity> pageData = this.queryPage(param, false);


        //页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = this.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ContractRegisterVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        page.put("contractCount", contractAmountMap);

        return page;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.select("round(sum(base_tax_money),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount");
        resp = super.getMap(wrapper);
//        String originalAmount = resp.get("originalAmount").toString();
//        String curAmount = resp.get("curAmount").toString();
//        resp.put("originalAmount",originalAmount);
//        resp.put("curAmount",curAmount);
        return resp;
    }

    @Override
    public List<ContractRegisterVO> excelExport(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        // 项合同编号、目名称、合同名称、经办人
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");

        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplement_flag", new Parameter("eq", 0));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        List<ContractRegisterEntity> entityList = this.queryList(param);
        List<ContractRegisterVO> voList = BeanMapper.mapList(entityList, ContractRegisterVO.class);

        for (ContractRegisterVO vo : voList) {
            String contractStatus = vo.getContractStatus();
            if (StringUtils.isNotBlank(contractStatus)) {
                if (Objects.equals(contractStatus, "1")) {
                    vo.setContractStatusName("履约中");
                }
                if (Objects.equals(contractStatus, "2")) {
                    vo.setContractStatusName("已封账");
                }
                if (Objects.equals(contractStatus, "3")) {
                    vo.setContractStatusName("已解除");
                }
            } else {
                vo.setContractStatusName("");
            }

            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        }

        return voList;
    }

    @Override
    public ContractRegisterVO addRegisterByRevId(Long reviewId) {
        ContractReviewEntity entity = reviewService.selectById(reviewId);
        ContractRegisterVO vo = new ContractRegisterVO();
        vo.setReviewId(reviewId);
        vo.setProjectId(entity.getProjectId());
        vo.setProjectName(entity.getProjectName());
        vo.setProjectCode(entity.getProjectCode());
        vo.setOrgId(entity.getOrgId());
        vo.setOrgCode(entity.getOrgCode());
        vo.setOrgName(entity.getOrgName());
        vo.setParentOrgId(entity.getParentOrgId());
        vo.setParentOrgCode(entity.getParentOrgCode());
        vo.setParentOrgName(entity.getParentOrgName());
        vo.setContractName(entity.getContractName());
        vo.setSignDate(new Date());
        vo.setCustomerId(entity.getCustomerId());
        vo.setCustomerName(entity.getCustomerName());
        vo.setSupplierId(entity.getSupplierId());
        vo.setSupplierName(entity.getSupplierName());
        vo.setConstructionPartner(entity.getConstructionPartner());
        vo.setTaxRate(entity.getTaxRate());
        vo.setBaseTaxMoney(entity.getContractTaxMny());
        vo.setBaseMoney(entity.getContractMny());
        vo.setBaseTax(entity.getTaxMny());
//        vo.setTaxMny(entity.getTaxMny());
//        vo.setContractMny(entity.getContractMny());
//        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setStartDate(entity.getStartDate());
        vo.setEndDate(entity.getEndDate());
        vo.setSchedule(entity.getSchedule());
        vo.setContractPartyc(entity.getContractPartyc());
        vo.setConjoinedContractTotalMny(entity.getConjoinedContractTotalMny());
        vo.setEmployeeId(sessionManager.getUserContext().getEmployeeId());
        vo.setEmployeeName(sessionManager.getUserContext().getUserName());
        vo.setDeptId(sessionManager.getUserContext().getDeptId());
        vo.setDeptName(sessionManager.getUserContext().getDeptName());
        vo.setSignDate(new Date());


        // 查询主合同对应的合同登记
        LambdaQueryWrapper<ContractRegisterEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractRegisterEntity::getReviewId, entity.getMainContractId());
        wrapper.orderByDesc(ContractRegisterEntity::getCreateTime);
        List<ContractRegisterEntity> list = this.list(wrapper);
        if (ListUtil.isNotEmpty(list)) {
            ContractRegisterEntity registerEntity = list.get(0);
            vo.setMainContractId(registerEntity.getId());
            vo.setMainContractCode(registerEntity.getBillCode());
            vo.setMainContractName(registerEntity.getContractName());
        }

        return vo;
    }

    @Override
    public ContractRegisterVO addSupplementByConId(Long mainContractId) {
        ContractRegisterEntity entity = this.selectById(mainContractId);
        ContractRegisterVO vo = new ContractRegisterVO();
        vo.setProjectId(entity.getProjectId());
        vo.setProjectName(entity.getProjectName());
        vo.setProjectCode(entity.getProjectCode());
        vo.setOrgId(entity.getOrgId());
        vo.setOrgCode(entity.getOrgCode());
        vo.setOrgName(entity.getOrgName());
        vo.setParentOrgId(entity.getParentOrgId());
        vo.setParentOrgCode(entity.getParentOrgCode());
        vo.setParentOrgName(entity.getParentOrgName());
        vo.setContractType(entity.getContractType());
        vo.setCustomerId(entity.getCustomerId());
        vo.setCustomerName(entity.getCustomerName());
        vo.setSupplierId(entity.getSupplierId());
        vo.setSupplierName(entity.getSupplierName());
        vo.setConstructionPartner(entity.getConstructionPartner());
        vo.setTaxRate(entity.getTaxRate());
        vo.setContractPartyc(entity.getContractPartyc());
        vo.setConjoinedContractTotalMny(entity.getConjoinedContractTotalMny());
        vo.setEmployeeId(sessionManager.getUserContext().getEmployeeId());
        vo.setEmployeeName(sessionManager.getUserContext().getUserName());
        vo.setDeptId(sessionManager.getUserContext().getDeptId());
        vo.setDeptName(sessionManager.getUserContext().getDeptName());
        vo.setMainContractId(mainContractId);
        vo.setMainContractName(entity.getContractName());
        vo.setMainContractCode(entity.getBillCode());

        //新增财务数据
        vo.setContractBaseTaxMnyNoConjoined(entity.getContractBaseTaxMnyNoConjoined());
        vo.setContractBaseTaxMny(entity.getContractBaseTaxMny());
        vo.setContractBaseMnyNoConjoined(entity.getContractBaseMnyNoConjoined());
        vo.setContractBaseMnyConjoined(entity.getContractBaseMnyConjoined());
        vo.setContractBaseMny(entity.getContractBaseMny());
        vo.setConjoinedManageType(entity.getConjoinedManageType());
        vo.setContractTypeName(entity.getContractTypeName());
        vo.setEstimationTaxMny(entity.getEstimationTaxMny());
        vo.setCostAccounting(entity.getCostAccounting());
        vo.setAccountingProjectId(entity.getAccountingProjectId());
        vo.setAccountingProject(entity.getAccountingProject());
        vo.setRegisterPursuant(entity.getRegisterPursuant());
        vo.setCwProjectId(entity.getCwProjectId());
        vo.setCwProjectCode(entity.getCwProjectCode());
        vo.setCwProjectName(entity.getCwProjectName());
        vo.setCwAccountCode(entity.getCwAccountCode());
        vo.setCwProjectTypeId(entity.getCwProjectTypeId());
        vo.setCwProjectType(entity.getCwProjectType());
        vo.setCwNatureAccounting(entity.getCwNatureAccounting());
        vo.setContractBaseTaxMnyConjoined(entity.getContractBaseTaxMnyConjoined());
        vo.setEngineeringTypeId(entity.getEngineeringTypeId());
        vo.setEngineeringType(entity.getEngineeringType());
        return vo;
    }

    @Override
    public RegisterSupplementHistoryVO querySupplementRecord(Long id) {
        ContractRegisterEntity entity = this.selectById(id);
        RegisterSupplementHistoryVO vo = new RegisterSupplementHistoryVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setContractMny(entity.getContractMny());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setIsFinish(entity.getIsFinish());
        vo.setIsRelieve(entity.getIsRelieve());

        // 查询补充协议
        LambdaQueryWrapper<ContractRegisterEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractRegisterEntity::getMainContractId, id);
        wrapper.orderByDesc(ContractRegisterEntity::getSignDate);
        List<ContractRegisterEntity> supplementList = super.list(wrapper);

        vo.setSupplementToalTaxMny(supplementList.stream().map(ContractRegisterEntity::getContractTaxMny).filter(x -> x != null).reduce(BigDecimal.ZERO, BigDecimal::add));
        vo.setSupplementToalMny(supplementList.stream().map(ContractRegisterEntity::getContractMny).filter(x -> x != null).reduce(BigDecimal.ZERO, BigDecimal::add));
        vo.setDetailList(BeanMapper.mapList(supplementList, ContractRegisterVO.class));

        return vo;
    }

    @Override
    public List<ContractRegisterEntity> queryRegisterByReviewId(Long reviewId) {
//        List<Integer> stateList = new ArrayList<>();
//        stateList.add(1);
//        stateList.add(3);

        LambdaQueryWrapper<ContractRegisterEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractRegisterEntity::getReviewId, reviewId);
//        wrapper.in(ContractRegisterEntity::getBillState, stateList);

        List<ContractRegisterEntity> list = this.list(wrapper);
        if (ListUtil.isEmpty(list)) {
            return new ArrayList<>();
        }

        return list;
    }

    @Override
    public boolean pushContract(ContractRegisterVO vo, Boolean updateLevel) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert(vo, data);
            /*if(updateLevel){ // 更新
                delContractFromPool(vo.getId());
            }*/
            if ("1".equals(vo.getContractStatus())) {
                data.setPerformanceStatus("2");
            }
            if ("2".equals(vo.getContractStatus())) {
                data.setPerformanceStatus("3");
            }
            if ("3".equals(vo.getContractStatus())) {
                data.setPerformanceStatus("4");
            }
            data.setChangeStatus(Integer.parseInt(vo.getChangeStatus()));
            data.setContractProperty(1);
            data.setSourceType(ContractTypeEnum.施工合同.getTypeCode());

            data.setUpdateLevel(UpdateLevelEnum.更新非空字段.getLevelCode());
            data.setSourceId(vo.getId());
            String url = null;
            if (vo.getSupplementFlag() == 0) {
                url = "/ejc-proincome-frontend/#/contractRegister/contractApprove?id=" + vo.getId();
            } else {
                url = "/ejc-proincome-frontend/#/contractRegister/supplementCard?id=";
            }
            data.setPcCardUrl(url);
            //data.setMobileCardUrl(baseHost+"ejc-proincome-mobile/#/contractRegister/card");
            data.setCategoryId(1524001989040545793L);// 施工合同类别是自定义档案，合同池写死

            data.setEstimationTaxMny(vo.getEstimationTaxMny());
            //从项目池中获取数据获取
            CommonResponse<ProjectPoolSetVO> projectPoolSetVO = projectSetApi.getProjectId(data.getProjectId());
            if (projectPoolSetVO != null && projectPoolSetVO.getData() != null) {
                ProjectPoolSetVO data1 = projectPoolSetVO.getData();
                if (data1.getAreaName() != null) {
                    data.setAreaName(data1.getAreaName());//所在地区
                }
                if (data1.getAddress() != null) {
                    data.setAddress(data1.getAddress());//详细地址
                }
                if (data1.getEngineeringType() != null) {
                    CommonResponse<DefdocDetailVO> defDocById = defdocApi.getDefDocById(data1.getEngineeringTypeId());
                    if (defDocById.getCode() == 0 && defDocById.getData() != null) {
                        data.setEngineeringType(defDocById.getData().getName());//工程类别
                    }
                }
//                if (data1.getMeasureType() != null  && data1.getMeasureType().equals(1506803511994617857L) && data1.getMeasureValue() != null){
//                    pmContractVO.setJzmj(data.getMeasureValue());//建筑面积
//                }
//                if (data1.getPlanStartDate() != null){
//                    pmContractVO.setKgrq(sdf.format(data1.getPlanStartDate()));//开工日期
//                }
//                if (data1.getPlanEndDate() != null){
//                    pmContractVO.setJgrq(sdf.format(data1.getPlanEndDate()));//竣工日期
//                }
//                if (data1.getProjectManagementName() != null){
//                    pmContractVO.setXmfzr(data1.getProjectManagementName());//项目负责人
//                }
//                if (data1.getProjectManagementPhone() != null){
//                    pmContractVO.setXmfzedh(data1.getProjectManagementPhone());//项目负责人电话
//                }
            }


            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);

            if (transDataResp.isSuccess()) {
                logger.info("要推送合同池的数据，{}", JSONObject.toJSONString(data));
                logger.info("合同id-{}推送合同池成功，{}", vo.getId(), transDataResp.getMsg());
                return true;
            } else {
                logger.error("合同id-{}推送合同池失败，{}", vo.getId(), transDataResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", vo.getId(), e);
        }
        return false;
    }

    @Override
    public boolean delContractFromPool(Long id) {
        ContractPoolVO c = new ContractPoolVO();
        c.setSourceId(id);

        logger.info("将合同-{}从合同池中删除！", id);
        CommonResponse<String> delDataResp = contractPoolApi.deleteContract(c);
        if (delDataResp.isSuccess()) {
            return true;
        }

        logger.error("将合同-{}从合同池中删除失败, {}！", id, delDataResp.getMsg());
        return false;
    }

    @Override
    public List<Map<String, Object>> queryBudgetWarnContract(List<SqlParam> sqlParamList) {
        return mapper.queryBudgetWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryCostWarnContract(List<SqlParam> sqlParamList) {
        return mapper.queryCostWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryContractRegisterWarnContract(List<SqlParam> sqlParamList) {
        return mapper.queryContractRegisterWarnContract(sqlParamList);
    }

    @Override
    public ContractReviewVO queryReviewByProject(Long projectId) {
        LambdaQueryWrapper<ContractReviewEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractReviewEntity::getProjectId, projectId);
        wrapper.eq(ContractReviewEntity::getSupplementFlag, 0);
        wrapper.eq(BaseEntity::getTenantId, InvocationInfoProxy.getTenantid());
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List<ContractReviewEntity> list = reviewService.list(wrapper);

        if (ListUtil.isEmpty(list)) {
            return new ContractReviewVO();
        }

        return BeanMapper.map(list.get(0), ContractReviewVO.class);
    }

    public CommonResponse<ContractRegisterVO> pushToCw(ContractRegisterEntity contractEntity) {
        /**
         * 推送财务中间表  ------------------------开始
         * 主合同
         * 补充协议
         * 暂估合同
         */
        logger.info("推送财务中间表  ------------------------开始");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

        Integer supplementFlag = contractEntity.getSupplementFlag();//是否补充协议 1是 0否
        Integer isEstimation = contractEntity.getIsEstimation();//是否暂估合同 1是 0否

        //从项目池中获取数据获取
        CommonResponse<ProjectPoolSetVO> projectPoolSetVO = projectSetApi.getProjectId(contractEntity.getProjectId());
        PMContractVO pmContractVO = BeanMapper.map(contractEntity, PMContractVO.class);
        if (isEstimation != null && isEstimation.equals(1)) {
            pmContractVO.setZgbz(1);//是否是暂估合同  是
            pmContractVO.setBslx("暂估合同");
            pmContractVO.setContractStatus(0);//暂估合同都是未签订
        } else {
            pmContractVO.setZgbz(0);//是否是暂估合同  否
            if (supplementFlag.equals(0)) {
                pmContractVO.setBslx("正式合同");
            } else {
                pmContractVO.setBslx("补充协议");
            }

        }

        pmContractVO.setContractId(String.valueOf(contractEntity.getId()));//合同id
        if (contractEntity.getSignDate() != null) {
            pmContractVO.setDjrq(sdf.format(contractEntity.getSignDate()));//单据日期
            pmContractVO.setSignDate(sdf.format(contractEntity.getSignDate()));//合同签订日期
        }
        pmContractVO.setContractCode(contractEntity.getBillCode());//合同编号

        if (contractEntity.getBaseTaxMoney() != null) {
            pmContractVO.setHtljhsje(contractEntity.getBaseTaxMoney());//合同累计含税金额字段取 合同签订金额字段
        }
        if (contractEntity.getContractType() != null) {
            CommonResponse<DefdocDetailVO> defDocBy = defdocApi.getDefDocById(contractEntity.getContractType());
            if (defDocBy.getCode() == 0 && defDocBy.getData() != null) {
                pmContractVO.setContractType(defDocBy.getData().getName());//合同类型
            }
        }
        pmContractVO.setContractTypeName("施工合同");//合同类型2
        /**
         * 项目池中获取数据
         */
        if (projectPoolSetVO != null && projectPoolSetVO.getData() != null) {
            ProjectPoolSetVO data = projectPoolSetVO.getData();
            if (data.getAreaName() != null) {
                pmContractVO.setSzs(data.getAreaName());//所在地区
            }
            if (data.getAddress() != null) {
                pmContractVO.setXxdz(data.getAddress());//详细地址
            }
            if (data.getEngineeringType() != null) {
                CommonResponse<DefdocDetailVO> defDocById = defdocApi.getDefDocById(data.getEngineeringType());
                if (defDocById.getCode() == 0 && defDocById.getData() != null) {
                    pmContractVO.setGclb(defDocById.getData().getName());//工程类别
                }
            }
            if (data.getMeasureType() != null && data.getMeasureType().equals(1506803511994617857L) && data.getMeasureValue() != null) {
                pmContractVO.setJzmj(data.getMeasureValue());//建筑面积
            }
            if (data.getPlanStartDate() != null) {
                pmContractVO.setKgrq(sdf.format(data.getPlanStartDate()));//开工日期
            }
            if (data.getPlanEndDate() != null) {
                pmContractVO.setJgrq(sdf.format(data.getPlanEndDate()));//竣工日期
            }
            if (data.getProjectManagementName() != null) {
                pmContractVO.setXmfzr(data.getProjectManagementName());//项目负责人
            }
            if (data.getProjectManagementPhone() != null) {
                pmContractVO.setXmfzedh(data.getProjectManagementPhone());//项目负责人电话
            }
        }


        CommonResponse<PMContractVO> pmContractVOCommonResponse = contractApi.saveContract(pmContractVO);


        logger.info("推送财务中间表  ------------------------结束" + JSON.toJSONString(pmContractVOCommonResponse));
        /**
         * 推送财务中间表  ------------------------结束
         */
        return CommonResponse.success("推送财务中间表成功！", BeanMapper.map(contractEntity, ContractRegisterVO.class));
    }

    @Override
    public CustomerIncomeInfoVO queryCustomerInfo(Long customerId) {
        return mapper.queryCustomerInfo(customerId);
    }

    @Override
    public List<CustomerCountWithYearVO> queryCountByCustomerId(Long customerId, String dateIn) {
        ArrayList<Long> longs = new ArrayList<>();
        longs.add(customerId);

        //获取子客户的id
        if ("all".equals(dateIn)) {
            CommonResponse<List<Long>> listCommonResponse = customerProApi.queryChildrenId(customerId);
            if (listCommonResponse.getCode() == 0) {
                List<Long> data = listCommonResponse.getData();
                longs.addAll(data);
            }
        }

        List<CustomerCountWithYearVO> customerCountWithYearVOS = mapper.queryCountByCustomerId(longs);

        for (CustomerCountWithYearVO customerCountWithYearVO : customerCountWithYearVOS) {
            BigDecimal bigDecimal = customerCountWithYearVO.getSum().divide(new BigDecimal(10000)).setScale(2, BigDecimal.ROUND_HALF_UP);
            customerCountWithYearVO.setSum(bigDecimal);
        }
        return customerCountWithYearVOS;
    }

    @Override
    public List<CustomerIncomeInfoVO> queryCustomerSum(QueryWrapper wrapper) {
        return baseMapper.queryCustomerSum(wrapper);
    }

    @Override
    public List<ContractRegisterVO> queryPageContractAndHistoryExport(Page<ContractRegisterVO> page, QueryWrapper wrapper) {
        return baseMapper.queryPageContractAndHistoryExport(page, wrapper);
    }

    @Override
    public List<ProincomeDynamicVO> queryDynamic() {


        ArrayList<ProincomeDynamicVO> dynamicVOS = new ArrayList<>();

        ProincomeDynamicVO dynamicVO = new ProincomeDynamicVO();
        ProincomeDynamicVO easyDynamicVO = new ProincomeDynamicVO();
        dynamicVO.setApproveTypeName("简易评审");
        easyDynamicVO.setApproveTypeName("正常评审");
        dynamicVOS.add(dynamicVO);
        dynamicVOS.add(easyDynamicVO);


        List<ProincomeDynamicVO> approving = baseMapper.queryApproving();
        List<ProincomeDynamicVO> sealing = baseMapper.querySealing();
        List<ProincomeDynamicVO> filling = baseMapper.queryFilling();
        List<ProincomeDynamicVO> registering = baseMapper.queryRegistering();
        List<ProincomeDynamicVO> confessing = baseMapper.queryConfessing();

        setDynamicVOS(dynamicVOS,approving);
        setDynamicVOS(dynamicVOS,sealing);
        setDynamicVOS(dynamicVOS,filling);
        setDynamicVOS(dynamicVOS,registering);
        setDynamicVOS(dynamicVOS,confessing);

        return dynamicVOS;
    }

    /**
     * 将vos非空数据放入dynamicVOS中
     * @param dynamicVOS
     * @param vos
     * @return
     */
    private void setDynamicVOS(List<ProincomeDynamicVO> dynamicVOS,
                                          List<ProincomeDynamicVO> vos) {

        for (ProincomeDynamicVO dynamicVO : dynamicVOS) {
            for (ProincomeDynamicVO vo : vos) {
                if(dynamicVO.getApproveTypeName().equals(vo.getApproveTypeName())){
                    dynamicVO.setApproveType(vo.getApproveType());
                    if(vo.getApproving() != null){
                        dynamicVO.setApproving(vo.getApproving());
                    }
                    if(vo.getSealing() != null){
                        dynamicVO.setSealing(vo.getSealing());
                    }
                    if(vo.getFilling() != null){
                        dynamicVO.setFilling(vo.getFilling());
                    }
                    if(vo.getRegistering() != null){
                        dynamicVO.setRegistering(vo.getRegistering());
                    }
                    if(vo.getConfessing() != null){
                        dynamicVO.setConfessing(vo.getConfessing());
                    }
                }
            }
        }
    }
    @Override
    public List<Long> queryListByProjectId(List<Long> ids){
        return baseMapper.queryListByProjectId(ids);
    }

    @Override
    public List<TypeVO> querySettleReportProgressType(){
        return baseMapper.querySettleReportProgressType();
    }
}
