package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.bean.BudgetEntity;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.enums.BudgetEnum;
import com.ejianc.business.pro.income.service.IBudgetService;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.utils.MathUtil;
import com.ejianc.business.pro.income.utils.ParamUtil;
import com.ejianc.business.pro.income.vo.BudgetDetailReportVO;
import com.ejianc.business.pro.income.vo.BudgetHistoryVO;
import com.ejianc.business.pro.income.vo.BudgetVO;
import com.ejianc.business.procost.vo.SubjectReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目预算书
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("budget")
public class BudgetController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IBudgetService service;

    @Autowired
    private IContractRegisterService contractService;

    /**
     * @Description saveOrUpdate (编辑保存)
     * 编辑保存全部，编辑保存单独的表体，新增表体保存，修订
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetVO> saveOrUpdate(@RequestBody BudgetVO saveorUpdateVO) {

        BudgetVO vo = service.saveOrUpdate(saveorUpdateVO);
        return CommonResponse.success("编辑保存数据成功！",vo);
    }
    /**
     * @Description  新增表头
     */
    @RequestMapping(value = "/saveBudget", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetVO> saveBudget(@RequestBody BudgetVO saveorUpdateVO) {

        BudgetVO vo = service.saveBudget(saveorUpdateVO);
        return CommonResponse.success("编辑保存数据成功！",vo);
    }

    /**
     * 保存校验提醒
     */
    @RequestMapping(value = "/checkBudget", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> checkBudget(Long projectId) {
        List<BudgetEntity> budgetEntities = service.list(Wrappers.<BudgetEntity>lambdaQuery()
                .eq(BudgetEntity::getDr, 0)
                .eq(BudgetEntity::getProjectId,projectId)
        );
        BigDecimal totalBudgetTaxMny = BigDecimal.ZERO;//累计项目预算书金额（有税）
        BigDecimal totalNicContractMny = BigDecimal.ZERO;//工程造价调整后总金额(不含暂列金额)
        for (BudgetEntity budgetEntity : budgetEntities) {
            BigDecimal budgetTaxMny = budgetEntity.getBudgetTaxMny();
            if(budgetTaxMny != null){
                totalBudgetTaxMny = totalBudgetTaxMny.add(budgetTaxMny);
            } else {
                totalBudgetTaxMny = totalBudgetTaxMny.add(BigDecimal.ZERO);
            }
        }
        List<ContractRegisterEntity> registerEntities = contractService.list(Wrappers.<ContractRegisterEntity>lambdaQuery()
                .eq(ContractRegisterEntity::getDr, 0)
                .eq(ContractRegisterEntity::getProjectId, projectId)
        );
        for (ContractRegisterEntity contractRegisterEntity : registerEntities) {
            BigDecimal nicContractMny = contractRegisterEntity.getNicContractMny();
            if(nicContractMny != null){
                totalNicContractMny = totalNicContractMny.add(nicContractMny);
            } else {
                totalBudgetTaxMny = totalBudgetTaxMny.add(BigDecimal.ZERO);
            }

        }

        BigDecimal above = totalBudgetTaxMny.subtract(totalNicContractMny);//超出金额
        if(above.compareTo(BigDecimal.ZERO) > 0){
            return CommonResponse.success("累计预算书金额超出,确认是否提交！",false);
        } else {
            return CommonResponse.success("累计预算书金额正常，确认是否提交！",true);
        }
    }


    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetVO> queryDetail(Long id) {
        BudgetVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * @Description queryDetail 查询表头详情
     * @param id
     */
    @RequestMapping(value = "/queryBudgetDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetVO> queryBudgetDetail(Long id) {
        BudgetVO vo = service.queryBudgetDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetVO> vos) {
        service.delete(vos);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BudgetVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("budgetName");
        fuzzyFields.add("contractName");//合同名称


        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /**
         * 项目层级手机端发送的请求InvocationInfoProxy.getOrgType()一直为1
         */
        String orgType = InvocationInfoProxy.getOrgType();
        if(param != null ){
            Map<String, Parameter> params = param.getParams();
            if (params.containsKey("orgType")){
                orgType = (String)params.get("orgType").getValue();
                params.remove("orgType");
            }
        }


        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(orgType)){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<BudgetEntity> page = service.queryPage(param,false);
        IPage<BudgetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<BudgetEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Budget-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refBudgetData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BudgetVO>> refBudgetData(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                         @RequestParam(defaultValue = "10") Integer pageSize,
                                                         @RequestParam(value = "searchText", required = false) String searchText,
                                                         @RequestParam(value = "condition", required = false) String condition) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        /** 模糊搜索配置字段示例 */
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("budgetName");

        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("org_id", new Parameter("in", iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
            if (null != conditionMap.get("contractId")) {
                Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
                queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
            }
            if (null != conditionMap.get("budgetSource")) {
                Integer budgetSource = Integer.parseInt(conditionMap.get("budgetSource").toString());
                queryParam.getParams().put("budgetSource", new Parameter(QueryParam.EQ, budgetSource));
            }
            if (null != conditionMap.get("incomeFlag")) {
                Integer incomeFlag = Integer.parseInt(conditionMap.get("incomeFlag").toString());
                queryParam.getParams().put("incomeFlag", new Parameter(QueryParam.EQ, incomeFlag));
            }
            if (null != conditionMap.get("useFlag")) {
                Integer useFlag = Integer.parseInt(conditionMap.get("useFlag").toString());
                if(useFlag == 1){
                    if (null != conditionMap.get("claimId")){
                        Long claimId = Long.valueOf(conditionMap.get("claimId").toString());
                        ComplexParam useId = ParamUtil.getOrParam("useId",  new Parameter(QueryParam.EQ, null),new Parameter(QueryParam.EQ, claimId));
                        queryParam.getComplexParams().add(useId);
                    }else{
                        queryParam.getParams().put("useId", new Parameter(QueryParam.EQ, null));
                    }
                } else {
                    queryParam.getParams().put("useId", new Parameter(QueryParam.NE, null));
                }
            }
            // 变更洽商、经济签证、索赔单据查询已生效和为生效、其他的查询已生效
            if (null == conditionMap.get("operateFlag")) {
                queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
            }
        }
//        List<Integer> billStatus = new ArrayList<>();
//        billStatus.add(1);
//        billStatus.add(3);
//        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, billStatus));
        queryParam.getOrderMap().put("createTime", "desc");
        IPage<BudgetEntity> pageData = service.queryPage(queryParam, false);
        IPage<BudgetVO> result = new Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        List<BudgetVO> budgetVOS = BeanMapper.mapList(pageData.getRecords(), BudgetVO.class);
        for(BudgetVO vo : budgetVOS){
            vo.setBudgetSourceName(BudgetEnum.getEnumByStateCode(vo.getBudgetSource()).getName());
        }
        result.setRecords(budgetVOS);
        return CommonResponse.success("查询参照数据成功！", result);
     }

    /**
     * 导入模板下载(清单模式)
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadInfo")
    @ResponseBody
    public void downloadInfo(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "budget-info-import.xlsx", "项目预算书导入模板(清单模式)");
    }
    /**
     * 导入模板下载(费用项模式)
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadCost")
    @ResponseBody
    public void downloadCost(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "budget-cost-import.xlsx", "项目预算书导入模板(费用项模式)");
    }
    /**
     * 导入模板下载(郑州一建预算清单)
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadZzyjInfo")
    @ResponseBody
    public void downloadZzyjInfo(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "budget-zzyj-import.xlsx", "项目预算书导入模板(郑州一建预算清单)");
    }

    /**
     * excel导入(费用项模式)
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImportCost(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImportCost(request,response);
    }
    /**
     * excel导入(清单模式)
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImportInfo(request,response);
    }
    /**
     * excel导入(郑州一建预算清单)
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportZzyjInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImportZzyjInfo(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImportZzyjInfo(request,response);
    }

    /**
     * 查询合同下预算分类节点【是否收入】字段为“是"的已生效的预算书
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryBudgetHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetHistoryVO> queryBudgetHistory(@RequestParam(value = "id")Long id,
                                                              @RequestParam(value = "accountingId", required = false)Long accountingId
    ) {
        return CommonResponse.success("查询列表数据成功！",service.queryBudgetHistory(id,accountingId));
    }

    @RequestMapping(value = "/queryBudgetList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<BudgetVO>> queryBudgetList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("budgetName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        param.getParams().put("billState", new Parameter(QueryParam.IN, billStatus));
        param.getParams().put("incomeFlag", new Parameter(QueryParam.EQ, 1));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        List<BudgetEntity> list = service.queryList(param,false);

        List<BudgetVO> budgetVOS = BeanMapper.mapList(list, BudgetVO.class);
        Long contractId = Long.parseLong(param.getParams().get("contractId").getValue().toString());

        BudgetHistoryVO budgetHistoryVO = service.queryBudgetHistory(contractId, null);
        for(BudgetVO vo : budgetVOS){
            BigDecimal budgetRate = MathUtil.safeMultiply(MathUtil.safeDiv(vo.getBudgetTaxMny(),budgetHistoryVO.getAllTaxMny()),new BigDecimal(100));
            vo.setBudgetRate(budgetRate);
        }

        return CommonResponse.success("查询列表数据成功！",budgetVOS);
    }

    /**
     * @Description  根据项目获取科目树汇总成本
     * @param
     */
    @RequestMapping(value = "/getCostAllDetails", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SubjectReportVO>> getCostAllDetails(@RequestBody QueryParam param) {
        return CommonResponse.success("查询详情数据成功！", service.getCostAllDetails(param));
    }

    /**
     * @Description  根据项目和单据状态查询预算明细
     * @param
     */
    @RequestMapping(value = "/getBudgetReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BudgetDetailReportVO>> getBudgetReport(@RequestBody QueryParam param) {
        return CommonResponse.success("查询详情数据成功！", service.getBudgetReport(param, false));
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/budgetDetailExport", method = RequestMethod.POST)
    @ResponseBody
    public void budgetDetailExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage<BudgetDetailReportVO> page = service.getBudgetReport(param, true);
        Map<String, Object> beans = new HashMap<>();
        if(CollectionUtils.isNotEmpty(page.getRecords())){
            page.getRecords().forEach(vo->{
                if(null!=vo.getBudgetModel()&&0==vo.getBudgetModel()){
                    vo.setBudgetModelName("清单模式");
                }else  if(null!=vo.getBudgetModel()&&1==vo.getBudgetModel()){
                    vo.setBudgetModelName("费用项模式");
                }else  if(null!=vo.getBudgetModel()&&2==vo.getBudgetModel()){
                    vo.setBudgetModelName("郑州一建预算清单");
                }
            });
        }
        beans.put("records", page.getRecords());

        ExcelExport.getInstance().export("budget-detail-export.xlsx", beans, response);
    }
}
