package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.income.bean.ContractExportEntity;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.ContractRegisterPayNodeEntity;
import com.ejianc.business.pro.income.bean.ContractRegisterPayRemarkEntity;
import com.ejianc.business.pro.income.service.*;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("contractExport") 
public class ContractExportBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IContractRegisterService registerService;

	@Autowired
	private IContractRegisterPayRemarkService registerPayRemarkService;

	@Autowired
	private IContractRegisterPayNodeService registerPayNodeService;

	@Autowired
	private IContractExportService exportService;

	@Autowired
	private IContractExportPayRemarkService exportPayRemarkService;

	@Autowired
	private IContractExportPayNodeService exportPayNodeService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		ContractExportEntity exportEntity = exportService.selectById(billId);
		// 合同登记主表
		ContractRegisterEntity registerEntity = registerService.selectById(exportEntity.getContractId());

		boolean payNodeFlag = registerPayNodeService.remove(new QueryWrapper<ContractRegisterPayNodeEntity>().eq("zhu_id", registerEntity.getId()), false);
		logger.info("payNodeFlag{}",payNodeFlag);
		boolean payRemarkFlag = registerPayRemarkService.remove(new QueryWrapper<ContractRegisterPayRemarkEntity>().eq("zhu_id", registerEntity.getId()), false);
		logger.info("payRemarkFlag{}",payRemarkFlag);

		//回写合同子表
		List<ContractRegisterPayNodeEntity> changePayNodeEntity = BeanMapper.mapList(exportEntity.getContractExportPayNodeList(), ContractRegisterPayNodeEntity.class);
		for (ContractRegisterPayNodeEntity entity : changePayNodeEntity) {
			entity.setZhuId(registerEntity.getId());
			entity.setId(null);
		}
		List<ContractRegisterPayRemarkEntity> changePayRemarkEntity = BeanMapper.mapList(exportEntity.getContractExportPayRemarkList(), ContractRegisterPayRemarkEntity.class);
		for (ContractRegisterPayRemarkEntity entity : changePayRemarkEntity) {
			entity.setZhuId(registerEntity.getId());
			entity.setId(null);
		}
		registerEntity.setContractRegisterPayRemarkList(changePayRemarkEntity);
		registerEntity.setContractRegisterPayNodeList(changePayNodeEntity);



		registerService.saveOrUpdate(registerEntity,false);

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
