package com.ejianc.business.pro.income.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.cwdataexchange.PMContractPush.api.IPMContractApi;
import com.ejianc.business.cwdataexchange.PMContractPush.vo.PMContractVO;
import com.ejianc.business.market.api.IProjectPartApi;
import com.ejianc.business.market.vo.ProjectPartVO;
import com.ejianc.business.pro.income.bean.*;
import com.ejianc.business.pro.income.enums.BillPushStatusEnum;
import com.ejianc.business.pro.income.service.*;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Service("contractRegisterChange") 
public class ContractRegisterChangeBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	
	@Autowired
	private IContractRegisterChangeService changeService;
	
	@Autowired
	private IContractRegisterService registerService;
	
	@Autowired
	private IContractRegisterHistoryService historyService;

	@Autowired
	private IAttachmentApi attachmentApi;

	@Autowired
	private IPMContractApi contractApi;

	@Autowired
	private IProjectSetApi projectSetApi;

	@Autowired
	private IDefdocApi defdocApi;

	@Autowired
	private IContractReviewService reviewService;

	@Autowired
	private IContractRegisterPayRemarkService registerPayRemarkService;

	@Autowired
	private IContractRegisterPayNodeService registerPayNodeService;

	@Autowired
	private IContractHistoryPayRemarkService historyPayRemarkService;

	@Autowired
	private IContractHistoryPayNodeService historyPayNodeService;

	@Autowired
	private IContractChangePayRemarkService changePayRemarkService;

	@Autowired
	private IContractChangePayNodeService changePayNodeService;

	@Autowired
	private IProjectPartApi projectPartApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 变更表
		ContractRegisterChangeEntity changeEntity = changeService.selectById(billId);
		// 合同登记主表
		ContractRegisterEntity registerEntity = registerService.selectById(changeEntity.getRegisterId());
		
		// 同步原合同到记录表
		ContractRegisterHistoryEntity historyEntity = BeanMapper.map(registerEntity, ContractRegisterHistoryEntity.class);
		historyEntity.setRegisterId(changeEntity.getRegisterId());
		historyEntity.setId(null);


		//同步合同到子表记录表
		List<ContractHistoryPayNodeEntity> historyPayNodeEntity = BeanMapper.mapList(registerEntity.getContractRegisterPayNodeList(), ContractHistoryPayNodeEntity.class);
		for (ContractHistoryPayNodeEntity entity : historyPayNodeEntity) {
			entity.setId(null);
		}
		List<ContractHistoryPayRemarkEntity> historyPayRemarkEntity = BeanMapper.mapList(registerEntity.getContractRegisterPayRemarkList(), ContractHistoryPayRemarkEntity.class);
		for (ContractHistoryPayRemarkEntity entity : historyPayRemarkEntity) {
			entity.setId(null);
		}
		historyEntity.setContractHistoryPayNodeList(historyPayNodeEntity);
		historyEntity.setContractHistoryPayRemarkList(historyPayRemarkEntity);

		historyService.saveOrUpdate(historyEntity,false);

		//回写合同子表
		List<ContractRegisterPayNodeEntity> changePayNodeEntity = BeanMapper.mapList(changeEntity.getContractChangePayNodeList(), ContractRegisterPayNodeEntity.class);
		for (ContractRegisterPayNodeEntity entity : changePayNodeEntity) {
			entity.setId(null);
		}
		List<ContractRegisterPayRemarkEntity> changePayRemarkEntity = BeanMapper.mapList(changeEntity.getContractChangePayRemarkList(), ContractRegisterPayRemarkEntity.class);
		for (ContractRegisterPayRemarkEntity entity : changePayRemarkEntity) {
			entity.setId(null);
		}
		registerEntity.setContractRegisterPayRemarkList(changePayRemarkEntity);
		registerEntity.setContractRegisterPayNodeList(changePayNodeEntity);

		boolean payNodeFlag = registerPayNodeService.remove(new QueryWrapper<ContractRegisterPayNodeEntity>().eq("zhu_id", registerEntity.getId()), false);
		logger.info("payNodeFlag{}",payNodeFlag);
		boolean payRemarkFlag = registerPayRemarkService.remove(new QueryWrapper<ContractRegisterPayRemarkEntity>().eq("zhu_id", registerEntity.getId()), false);
		logger.info("payRemarkFlag{}",payRemarkFlag);


		// 回写合同主表
		registerEntity.setBeforeChangeTaxMny(registerEntity.getContractTaxMny());
		registerEntity.setBeforeChangeMny(registerEntity.getContractMny());
		registerEntity.setChangingTaxMny(null);//变更中金额清空
		registerEntity.setChangingMny(null);//变更中金额清空
		registerEntity.setChangeStatus("3");//状态改为已变更
		registerEntity.setChangeCode(registerEntity.getChangeCode());
		registerEntity.setChangeId(registerEntity.getChangeId());
		registerEntity.setBillState(registerEntity.getBillState());
		registerEntity.setSumProductionTaxMny(registerEntity.getSumProductionTaxMny());
		registerEntity.setSumProductionMny(registerEntity.getSumProductionMny());
		registerEntity.setSumQuoteTaxMny(registerEntity.getSumQuoteTaxMny());
		registerEntity.setSumQuoteMny(registerEntity.getSumQuoteMny());
		registerEntity.setSumCollectMny(registerEntity.getSumCollectMny());
		registerEntity.setSumInvoicingTaxMny(registerEntity.getSumInvoicingTaxMny());
		registerEntity.setSumInvoicingMny(registerEntity.getSumInvoicingMny());
		
		registerEntity.setBearType(changeEntity.getBearType());
		registerEntity.setContractName(changeEntity.getContractName());
		/**
		 * 2023-12-8 08:13:48
		 * 	魏玲玲需求，不再更改合同类型
		 */
//		registerEntity.setContractType(changeEntity.getContractType());
		registerEntity.setSignDate(changeEntity.getSignDate());
		registerEntity.setCustomerId(changeEntity.getCustomerId());
		registerEntity.setCustomerName(changeEntity.getCustomerName());
		registerEntity.setSupplierId(changeEntity.getSupplierId());
		registerEntity.setSupplierName(changeEntity.getSupplierName());
		registerEntity.setConstructionPartner(changeEntity.getConstructionPartner());
		registerEntity.setTaxRate(changeEntity.getTaxRate());
		registerEntity.setContractTaxMny(changeEntity.getContractTaxMny());
		registerEntity.setContractMny(changeEntity.getContractMny());
		registerEntity.setTaxMny(changeEntity.getTaxMny());
		registerEntity.setStartDate(changeEntity.getStartDate());
		registerEntity.setEndDate(changeEntity.getEndDate());
		registerEntity.setSchedule(changeEntity.getSchedule());
		registerEntity.setContractValuationType(changeEntity.getContractValuationType());
		registerEntity.setContractStatus(changeEntity.getContractStatus());
		registerEntity.setContractPartyc(changeEntity.getContractPartyc());
		registerEntity.setProvisionalMny(changeEntity.getProvisionalMny()); // 暂列金额
		registerEntity.setContractPromisePaymentRate(changeEntity.getContractPromisePaymentRate());
		registerEntity.setEmployeeId(changeEntity.getEmployeeId());
		registerEntity.setEmployeeName(changeEntity.getEmployeeName());
		registerEntity.setDeptId(changeEntity.getDeptId());
		registerEntity.setDeptName(changeEntity.getDeptName());
		registerEntity.setChangeId(registerEntity.getChangeId());
		registerEntity.setChangeReason(changeEntity.getChangeReason());
		registerEntity.setChangeVersion(changeEntity.getChangeVersion());
		registerEntity.setSupplierPhone(changeEntity.getSupplierPhone());
		registerEntity.setCustomerPhone(changeEntity.getCustomerPhone());
		registerEntity.setCustomerEntrustedAgent(changeEntity.getCustomerEntrustedAgent());
		registerEntity.setSupplierEntrustedAgent(changeEntity.getSupplierEntrustedAgent());
		registerEntity.setDisputeResolution(changeEntity.getDisputeResolution());
		registerEntity.setDisputeResolutionAgency(changeEntity.getDisputeResolutionAgency());
		registerEntity.setNotIncludeProvisionalMny(changeEntity.getNotIncludeProvisionalMny()); // 施工合同金额(不含暂列金额)


		// 历史记录主键、生效时间、变更前合同名称
		changeEntity.setUsedTime(new Date());
		changeEntity.setBeforeContractName(registerEntity.getContractName());
		changeService.saveOrUpdate(changeEntity, false);
		
		// 同步附件
		logger.info("同步附件");
		CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
				String.valueOf(billId), "BT211214000000009", null,
				String.valueOf(registerEntity.getId()), "BT211214000000005", null);
		logger.info("同步附件::::::::::::结果::" + JSONObject.toJSONString(response).toString());

		//合同推送合同池
		boolean pushResult = registerService.pushContract(BeanMapper.map(registerEntity, ContractRegisterVO.class),true);
		if(pushResult) {
			registerEntity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
		} else {
			registerEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
		}
		registerService.saveOrUpdate(registerEntity, false);


		/**
		 * 修改文件评审归档状态
		 */
		if(changeEntity.getReviewId() != null  && changeEntity.getIsEstimation() != 1){
			LambdaUpdateWrapper<ContractReviewEntity> wrapper = new LambdaUpdateWrapper<>();
			wrapper.set(ContractReviewEntity::getFilingFlag,1);
			wrapper.set(ContractReviewEntity::getFilingId,changeEntity.getId());
			wrapper.set(ContractReviewEntity::getFilingDate,new Date());
			wrapper.eq(ContractReviewEntity::getId, changeEntity.getReviewId());
			reviewService.update(wrapper);
		}

		/**
		 * 推送财务中间表  ------------------------开始
		 * 变更合同
		 */
		logger.info("推送财务中间表  ------------------------开始");
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");


		//从项目池中获取数据获取
		CommonResponse<ProjectPoolSetVO> projectPoolSetVO = projectSetApi.getProjectId(changeEntity.getProjectId());
		PMContractVO pmContractVO = BeanMapper.map(changeEntity, PMContractVO.class);

			pmContractVO.setZgbz(0);//是否是暂估合同  不是
			pmContractVO.setBslx("变更合同");
			pmContractVO.setContractStatus(null);//变更合同都是不赋值


		pmContractVO.setContractId(String.valueOf(billId));//合同id

		pmContractVO.setZhuContractId(String.valueOf(changeEntity.getMainContractId()));//主合同id

		if (changeEntity.getChangeTime() != null) {
			pmContractVO.setDjrq(sdf.format(changeEntity.getChangeTime()));//单据日期
		}
		if (changeEntity.getSignDate() != null) {
			pmContractVO.setSignDate(sdf.format(changeEntity.getSignDate()));//合同签订日期
		}
		pmContractVO.setContractCode(changeEntity.getBillCode());//合同编号

		if(changeEntity.getBaseTaxMoney() != null) {
			pmContractVO.setHtljhsje(changeEntity.getBaseTaxMoney());//合同累计含税金额字段取 合同签订金额字段
		}
		pmContractVO.setContractTypeName("施工合同");//合同类型2
		/**
		 * 项目池中获取数据
		 */
		if (projectPoolSetVO != null && projectPoolSetVO.getData() != null){
			ProjectPoolSetVO data = projectPoolSetVO.getData();
			if (data.getAreaName() != null){
				pmContractVO.setSzs(data.getAreaName());//所在地区
			}
			if (data.getAddress() != null){
				pmContractVO.setXxdz(data.getAddress());//详细地址
			}
			if (data.getEngineeringType() != null){
				CommonResponse<DefdocDetailVO> defDocById = defdocApi.getDefDocById(data.getEngineeringType());
				if (defDocById.getCode() == 0 && defDocById.getData() != null) {
					pmContractVO.setGclb(defDocById.getData().getName());//工程类别
				}
			}
			if (data.getMeasureType() != null  && data.getMeasureType().equals(1506803511994617857L) && data.getMeasureValue() != null){
				pmContractVO.setJzmj(data.getMeasureValue());//建筑面积
			}
			if (data.getPlanStartDate() != null){
				pmContractVO.setKgrq(sdf.format(data.getPlanStartDate()));//开工日期
			}
			if (data.getPlanEndDate() != null){
				pmContractVO.setJgrq(sdf.format(data.getPlanEndDate()));//竣工日期
			}
			if (data.getProjectManagementName() != null){
				pmContractVO.setXmfzr(data.getProjectManagementName());//项目负责人
			}
			if (data.getProjectManagementPhone() != null){
				pmContractVO.setXmfzedh(data.getProjectManagementPhone());//项目负责人电话
			}
		}
		if (changeEntity.getThisChangeTaxMny() != null){
			pmContractVO.setBcbgje(changeEntity.getThisChangeTaxMny());//本次变更金额
		}

		if (changeEntity.getChangeName() != null){
			pmContractVO.setChangeName(changeEntity.getChangeName());//变更名称 -》 变更名称
		}

		if (changeEntity.getChangeReason() != null){
			pmContractVO.setChangeReason(changeEntity.getChangeReason());//变更原因 -》 变更影响
		}

		if (changeEntity.getChangeType() != null){
			pmContractVO.setChangeType(changeEntity.getChangeType()+"");//变更类型 -》 变更类型
		}

		CommonResponse<PMContractVO> pmContractVOCommonResponse = contractApi.saveContract(pmContractVO);




		logger.info("推送财务中间表  ------------------------结束"+ JSON.toJSONString(pmContractVOCommonResponse));
		/**
		 * 推送财务中间表  ------------------------结束
		 */

		/**
		 * 推送生成执行标段子表
		 */
		logger.info("执行标段推送开始===============");
		ProjectPartVO projectPartVO = new ProjectPartVO();
		projectPartVO.setBidSummaryId(changeEntity.getSummaryId());
		projectPartVO.setEnrollId(changeEntity.getEnrollId());
		projectPartVO.setProjectId(changeEntity.getProjectId());
		projectPartVO.setProjectName(changeEntity.getProjectName());
		projectPartVO.setProjectName(changeEntity.getProjectName());
		projectPartVO.setContractId(changeEntity.getId());
		projectPartVO.setContractMny(changeEntity.getContractMny());
		projectPartVO.setContractType(changeEntity.getContractType());
		CommonResponse<DefdocDetailVO> defDocBy = defdocApi.getDefDocById(changeEntity.getContractType());
		if (defDocBy.getCode() == 0 && defDocBy.getData() != null) {
			projectPartVO.setContractTypeName(defDocBy.getData().getName());
		}
//        projectPartVO.setChangeMny(contractEntity.getBeforeChangeMny());
		projectPartVO.setCwProjectCode(changeEntity.getCwProjectCode());
		projectPartVO.setCwProjectName(changeEntity.getCwProjectName());
		projectPartVO.setCwAccountCode(changeEntity.getCwAccountCode());
		projectPartVO.setCwProjectTypeName(changeEntity.getContractTypeName());
		projectPartVO.setSourceType("施工合同变更");
		if (projectPoolSetVO.getCode() == 0 && projectPoolSetVO.getData() != null) {
			ProjectPoolSetVO data = projectPoolSetVO.getData();
			if (data.getEngineeringTypeId() != null){
				CommonResponse<DefdocDetailVO> defDocById = defdocApi.getDefDocById(data.getEngineeringTypeId());
				if (defDocById.getCode() == 0 && defDocById.getData() != null) {
					projectPartVO.setContractualModel(data.getEngineeringTypeId());
					projectPartVO.setContractualModelName(defDocById.getData().getName());
				}
			}
			projectPartVO.setProjectType(data.getProjectType());

		}
		projectPartVO.setBidSummaryId(changeEntity.getSummaryId());
		projectPartApi.saveOrUpdate(projectPartVO);
		logger.info("执行标段推送结束===============");
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("合同变更单暂不支持回退功能!");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
