package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.pro.income.bean.ContractReviewEntity;
import com.ejianc.business.pro.income.service.IContractReviewService;
import com.ejianc.business.sealm.api.IInstoreApi;
import com.ejianc.business.sealm.vo.HtyysxVO;
import com.ejianc.business.sealm.vo.YysqVO;
import com.ejianc.business.sealm.vo.YzdjVO;
import com.ejianc.business.sealm.vo.ZcyysqVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("contractReview") 
public class ContractReviewBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillTypeApi billTypeApi;
	
	@Autowired
	private IContractReviewService service;

	@Autowired
	private IInstoreApi iInstoreApi;
	@Autowired
	private SessionManager sessionManager;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
//		ContractReviewEntity entity = service.getById(billId);
//		if(entity != null) {
//			//审批通过对项目用印申请新增一条数据
//			YysqVO yysqVO = new YysqVO();
//			ZcyysqVO zcyysqVO = new ZcyysqVO();
//			zcyysqVO.setHtId(billId);  //施工合同评审id
//			zcyysqVO.setHtName(entity.getContractName());//合同名称
//			if(entity.getSupplementFlag() == 0){
//				zcyysqVO.setHtlb(0);
//			}else {
//				zcyysqVO.setHtlb(1);
//			}//合同类别
//			zcyysqVO.setHtje(entity.getContractTaxMny());//合同金额
//			zcyysqVO.setJbrName(entity.getEmployeeName());//经办人名称
//			zcyysqVO.setOrgId(entity.getOrgId());  //组织id
//			zcyysqVO.setOrgName(entity.getOrgName());  //组织名称
//			zcyysqVO.setHtCode(entity.getBillCode());  //施工合同评审编码
//			zcyysqVO.setHtlxId(556486214727770129L);
//			zcyysqVO.setHtlxName("施工合同登记");
//			//zcyysqVO.setHtlxCode("/ejc-proincome-frontend/#/contractReview/card");
//			zcyysqVO.setYyReason("施工合同评审-" + entity.getBillCode());  //用印事由
//			zcyysqVO.setDjlj("/ejc-proincome-frontend/#/contractReview/card");//表单链接
//			zcyysqVO.setSqdwId(entity.getOrgId());  //申请单位id
//			zcyysqVO.setSqdwName(entity.getOrgName());  //申请单位name
//			zcyysqVO.setSqrId(sessionManager.getUserContext().getUserId());  //负责人id
//			zcyysqVO.setSqrName(sessionManager.getUserContext().getUserName());  //负责人name
//			zcyysqVO.setCreateUserCode(entity.getCreateUserCode());  //创建人
//			zcyysqVO.setCreateUserName(sessionManager.getUserContext().getUserName());  //负责人名称
//			//zcyysqVO.setSqxmId(entity.getProjectId());  // 工程id
//			//zcyysqVO.setSqxmName(entity.getProjectName());  // 工程名称
//			//审批通过的都是集团公章,所以，印章类别是实体章，印章级别是集团，用印类型是集团公章
//			//因为设计时，印章类别，印章级别，用印类型都是自定义档案，所以ID很长
//			CommonResponse<YzdjVO> yzdjVOCommonResponse = iInstoreApi.selectYzxxByCode("YZ-001");
//			if (!yzdjVOCommonResponse.isSuccess()) {
//				throw new BusinessException("通过印章编号获取印章登记信息失败！" + yzdjVOCommonResponse);
//			}
//			YzdjVO data = yzdjVOCommonResponse.getData();
//			zcyysqVO.setYzbhId(data.getId());//印章（编号）id
//			//Long yzlbId = 1472851128843505665L;
//			zcyysqVO.setYzlbId(data.getYzlbId());//印章类别
//			zcyysqVO.setYzlbName(data.getYzlbName());
//			//Long yzjbId = 1476389609762983938L;
//			zcyysqVO.setYzjbId(data.getYzjbId());//印章级别
//			zcyysqVO.setYzjbName(data.getYzjbName());
//			//Long yylxId = 1472859270440554497L;
//			zcyysqVO.setYylxId(data.getYylxId());//用印类型
//			zcyysqVO.setYylxName(data.getYylxName());
//			zcyysqVO.setBillState(0);  //推送数据默认为审批通过的
//			zcyysqVO.setMessageFrom(1);// 数据来源：0自建，1投标报名
//			zcyysqVO.setZkbmId(1502571153481273346L);//主控部门ID
//			zcyysqVO.setZkbmName("经营部");//主控部门name
//			yysqVO.setXgcs(0);//修改次数
//
//			CommonResponse<String> htyysqBack = iInstoreApi.addHtyysq(zcyysqVO);
//			if (!htyysqBack.isSuccess()) {
//				throw new BusinessException("新增合同用印申请表数据失败，原因：xxxx" + htyysqBack);
//			}
//			logger.info("发送施工合同评审数据：{终审审核完回调}");
//		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		ContractReviewEntity entity = service.selectById(billId);

		// 主合同存在补充协议时不允许撤回
		LambdaQueryWrapper<ContractReviewEntity> wrapper = new LambdaQueryWrapper<>();
		wrapper.eq(ContractReviewEntity::getMainContractId, billId);
		wrapper.eq(ContractReviewEntity::getSupplementFlag, 1);
		List<ContractReviewEntity> list = service.list(wrapper);
		if (ListUtil.isNotEmpty(list)) {
			return CommonResponse.error("存在补充协议，暂不支持回退功能!");
		}
		
		if (entity.getSupplementFlag() == 1) {
			return CommonResponse.error("补充协议暂不支持回退功能!");
		}else {
			// 合同是否被其他单据引用
			CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
			logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
			if(res.isSuccess()) {//单据未被下游单据引用
				return CommonResponse.success();
			}else{
				return CommonResponse.error(res.getMsg());
			}
		}
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
