package com.ejianc.business.pro.income.service.impl;

import com.ejianc.business.pro.income.bean.BudgetEntity;
import com.ejianc.business.pro.income.bean.ProductionDetailEntity;
import com.ejianc.business.pro.income.bean.ProductionEntity;
import com.ejianc.business.pro.income.mapper.ProductionDetailMapper;
import com.ejianc.business.pro.income.service.IBudgetService;
import com.ejianc.business.pro.income.service.IProductionDetailService;
import com.ejianc.business.pro.income.service.IProductionService;
import com.ejianc.business.pro.income.utils.DetailListUtil;
import com.ejianc.business.pro.income.utils.IncomeSortUtil;
import com.ejianc.business.pro.income.utils.TreeNodeBUtil;
import com.ejianc.business.pro.income.vo.*;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 产值报量子表
 * 
 * @author generator
 * 
 */
@Service("productionDetailService")
public class ProductionDetailServiceImpl extends BaseServiceImpl<ProductionDetailMapper, ProductionDetailEntity> implements IProductionDetailService{

    @Autowired
    private IProductionService productionService;

    @Autowired
    private IBudgetService budgetService;

    @Autowired
    private DetailListUtil detailListUtil;

    @Override
    public ProductionDetailVO queryBudgetDetail(Long id) {
        Map<Long, ProductionDetailPubVO> pubMap = this.getPubVOSumMap(id);// 已生效预算书明细累计值
        BudgetEntity entity = budgetService.selectById(id);
        ProductionDetailVO vo = BeanMapper.map(entity, ProductionDetailVO.class);
        List<ProductionDetailCostVO> costList = BeanMapper.mapList(entity.getCostVos(), ProductionDetailCostVO.class);
        List<ProductionDetailSubVO> subList = BeanMapper.mapList(entity.getSubVos(), ProductionDetailSubVO.class);
        List<ProductionDetailMeasureVO> measureList = BeanMapper.mapList(entity.getMeasureVos(), ProductionDetailMeasureVO.class);
        List<ProductionDetailOtherVO> otherList = BeanMapper.mapList(entity.getOtherVos(), ProductionDetailOtherVO.class);
        List<ProductionDetailFeeVO> feeList = BeanMapper.mapList(entity.getFeeVos(), ProductionDetailFeeVO.class);
        LastVO lastVO = new LastVO();
        if (CollectionUtils.isNotEmpty(costList)) {
            for (ProductionDetailCostVO dvo : costList) {
                dvo.setTid(dvo.getId().toString());
                dvo.setTpid(dvo.getParentId() != null && dvo.getParentId() > 0 ? dvo.getParentId().toString() : "");
                dvo.setRowState("edit");
                if(pubMap.containsKey(dvo.getId())){
                    ProductionDetailPubVO pub = pubMap.get(dvo.getId());
                    dvo.setLastProductionNum(pub.getProductionNum());
                    dvo.setLastProductionMny(pub.getProductionMny());
                    dvo.setLastProductionTaxMny(pub.getProductionTaxMny());
                    if(dvo.getLeafFlag()) this.computeLast(lastVO, pub);// 汇总截止上期累计
                }
            }
            new IncomeSortUtil<ProductionDetailCostVO>().entryListToSort(costList);
            vo.setCostList(TreeNodeBUtil.buildTree(costList));
        }
        if (CollectionUtils.isNotEmpty(subList)) {
            for (ProductionDetailSubVO dvo : subList) {
                dvo.setTid(dvo.getId().toString());
                dvo.setTpid(dvo.getParentId() != null && dvo.getParentId() > 0 ? dvo.getParentId().toString() : "");
                dvo.setRowState("edit");
                if(pubMap.containsKey(dvo.getId())){
                    ProductionDetailPubVO pub = pubMap.get(dvo.getId());
                    dvo.setLastProductionNum(pub.getProductionNum());
                    dvo.setLastProductionMny(pub.getProductionMny());
                    dvo.setLastProductionTaxMny(pub.getProductionTaxMny());
                    if(dvo.getLeafFlag()) this.computeLast(lastVO, pub);// 汇总截止上期累计
                }
            }
            new IncomeSortUtil<ProductionDetailSubVO>().entryListToSort(subList);
            vo.setSubList(TreeNodeBUtil.buildTree(subList));
        }
        if (CollectionUtils.isNotEmpty(measureList)) {
            for (ProductionDetailMeasureVO dvo : measureList) {
                dvo.setTid(dvo.getId().toString());
                dvo.setTpid(dvo.getParentId() != null && dvo.getParentId() > 0 ? dvo.getParentId().toString() : "");
                dvo.setRowState("edit");
                if(pubMap.containsKey(dvo.getId())){
                    ProductionDetailPubVO pub = pubMap.get(dvo.getId());
                    dvo.setLastProductionNum(pub.getProductionNum());
                    dvo.setLastProductionMny(pub.getProductionMny());
                    dvo.setLastProductionTaxMny(pub.getProductionTaxMny());
                    if(dvo.getLeafFlag()) this.computeLast(lastVO, pub);// 汇总截止上期累计
                }
            }
            new IncomeSortUtil<ProductionDetailMeasureVO>().entryListToSort(measureList);
            vo.setMeasureList(TreeNodeBUtil.buildTree(measureList));
        }
        if (CollectionUtils.isNotEmpty(otherList)) {
            for (ProductionDetailOtherVO dvo : otherList) {
                dvo.setTid(dvo.getId().toString());
                dvo.setTpid(dvo.getParentId() != null && dvo.getParentId() > 0 ? dvo.getParentId().toString() : "");
                dvo.setRowState("edit");
                if(pubMap.containsKey(dvo.getId())){
                    ProductionDetailPubVO pub = pubMap.get(dvo.getId());
                    dvo.setLastProductionNum(pub.getProductionNum());
                    dvo.setLastProductionMny(pub.getProductionMny());
                    dvo.setLastProductionTaxMny(pub.getProductionTaxMny());
                    if(dvo.getLeafFlag()) this.computeLast(lastVO, pub);// 汇总截止上期累计
                }
            }
            new IncomeSortUtil<ProductionDetailOtherVO>().entryListToSort(otherList);
            vo.setOtherList(TreeNodeBUtil.buildTree(otherList));
        }
        if (CollectionUtils.isNotEmpty(feeList)) {
            for (ProductionDetailFeeVO dvo : feeList) {
                dvo.setTid(dvo.getId().toString());
                dvo.setTpid(dvo.getParentId() != null && dvo.getParentId() > 0 ? dvo.getParentId().toString() : "");
                dvo.setRowState("edit");
                if(pubMap.containsKey(dvo.getId())){
                    ProductionDetailPubVO pub = pubMap.get(dvo.getId());
                    dvo.setLastProductionNum(pub.getProductionNum());
                    dvo.setLastProductionMny(pub.getProductionMny());
                    dvo.setLastProductionTaxMny(pub.getProductionTaxMny());
                    if(dvo.getLeafFlag()) this.computeLast(lastVO, pub);// 汇总截止上期累计
                }
            }
            new IncomeSortUtil<ProductionDetailFeeVO>().entryListToSort(feeList);
            vo.setFeeList(TreeNodeBUtil.buildTree(feeList));
        }
        vo.setLastProductionMny(lastVO.getLastMny());
        vo.setLastProductionTaxMny(lastVO.getLastTaxMny());
        return vo;
    }

    /**
     * 汇总截止上期累计
     * @param lastVO
     * @param pub
     */
    private void computeLast(LastVO lastVO, ProductionDetailPubVO pub) {
        lastVO.setLastMny(ComputeUtil.safeAdd(lastVO.getLastMny(), pub.getProductionMny()));
        lastVO.setLastTaxMny(ComputeUtil.safeAdd(lastVO.getLastTaxMny(), pub.getProductionTaxMny()));
    }

    /**
     * 已生效预算书明细累计值
     * @param id
     * @return
     */
    private Map<Long, ProductionDetailPubVO> getPubVOSumMap(Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<ProductionEntity> productionList = productionService.queryList(queryParam);
        Map<Long, ProductionDetailPubVO> pubMap = new HashMap<>();// key-预算书明细主键，value-截止本期累计值
        if(CollectionUtils.isNotEmpty(productionList)){
            List<Long> productionIds = productionList.stream().map(ProductionEntity::getId).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("productionId", new Parameter(QueryParam.IN, productionIds));
            param.getParams().put("budgetId", new Parameter(QueryParam.EQ, id));
            List<ProductionDetailEntity> detailList = super.queryList(param);
            detailListUtil.setDetailList(detailList);
            if(CollectionUtils.isNotEmpty(detailList)){
                detailList.forEach(detail->{
                    List<ProductionDetailPubVO> pubList = new ArrayList<>();
                    if(CollectionUtils.isNotEmpty(detail.getCostList())){
                        pubList.addAll(BeanMapper.mapList(detail.getCostList(), ProductionDetailPubVO.class));
                    }
                    if(CollectionUtils.isNotEmpty(detail.getSubList())){
                        pubList.addAll(BeanMapper.mapList(detail.getSubList(), ProductionDetailPubVO.class));
                    }
                    if(CollectionUtils.isNotEmpty(detail.getMeasureList())){
                        pubList.addAll(BeanMapper.mapList(detail.getMeasureList(), ProductionDetailPubVO.class));
                    }
                    if(CollectionUtils.isNotEmpty(detail.getOtherList())){
                        pubList.addAll(BeanMapper.mapList(detail.getOtherList(), ProductionDetailPubVO.class));
                    }
                    if(CollectionUtils.isNotEmpty(detail.getFeeList())){
                        pubList.addAll(BeanMapper.mapList(detail.getFeeList(), ProductionDetailPubVO.class));
                    }
                    pubList.forEach(vo->{
                        ProductionDetailPubVO pub = new ProductionDetailPubVO();
                        if(!pubMap.containsKey(vo.getBudgetDetailId())){
                            pub.setBudgetDetailId(vo.getBudgetDetailId());
                            pub.setProductionNum(vo.getProductionNum());
                            pub.setProductionMny(vo.getProductionMny());
                            pub.setProductionTaxMny(vo.getProductionTaxMny());
                            pubMap.put(vo.getBudgetDetailId(), pub);
                        } else {
                            pub = pubMap.get(vo.getBudgetDetailId());
                            pub.setProductionNum(ComputeUtil.safeAdd(pub.getProductionNum(), vo.getProductionNum()));
                            pub.setProductionMny(ComputeUtil.safeAdd(pub.getProductionMny(), vo.getProductionMny()));
                            pub.setProductionTaxMny(ComputeUtil.safeAdd(pub.getProductionTaxMny(), vo.getProductionTaxMny()));
                        }
                    });
                });
            }
        }
        return pubMap;
    }
}
