package com.ejianc.business.pro.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.pro.other.vo.OtherContractVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.other.mapper.OtherContractMapper;
import com.ejianc.business.pro.other.bean.OtherContractEntity;
import com.ejianc.business.pro.other.service.IOtherContractService;

import java.util.*;

/**
 * 其他收入合同
 * 
 * @author generator
 * 
 */
@Service("otherContractService")
public class OtherContractServiceImpl extends BaseServiceImpl<OtherContractMapper, OtherContractEntity> implements IOtherContractService{

    private static final String INCOME_CONTRACT_BILL_CODE = "OTHER_CONTRACT";

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private OtherContractMapper contractMapper;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IProjectSetApi projectSetApi;

    @Autowired
    private IDefdocApi defdocApi;

    @Override
    public OtherContractVO saveOrUpdate(OtherContractVO otherContractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        OtherContractEntity entity = BeanMapper.map(otherContractVO, OtherContractEntity.class);
        if(otherContractVO.getId() != null && otherContractVO.getId() > 0) { //修改
            if(StringUtils.isEmpty(otherContractVO.getBillCode())){
                throw new BusinessException("编码为空，不允许保存!");
            }
        }else{
            //新增
            if(StringUtils.isEmpty(otherContractVO.getBillCode())){
                BillCodeParam billCodeParam = BillCodeParam.build(INCOME_CONTRACT_BILL_CODE, tenantId, otherContractVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
//            entity.setContractStatus("1");
            //新增设置 竣工结算标志
            entity.setIsFinish(0);
        }
        if(otherContractVO.getId() != null && otherContractVO.getId() > 0) {
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<OtherContractEntity> lambda = Wrappers.<OtherContractEntity>lambdaQuery();
            lambda.eq(OtherContractEntity::getBillCode, otherContractVO.getBillCode());
            lambda.eq(OtherContractEntity::getTenantId, tenantId);
            lambda.ne(OtherContractEntity::getId, otherContractVO.getId());
            List<OtherContractEntity> entities = super.list(lambda);
            if(entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }else{
            //校验合同编号是否重复
            LambdaQueryWrapper<OtherContractEntity> lambda = Wrappers.<OtherContractEntity>lambdaQuery();
            lambda.eq(OtherContractEntity::getTenantId, tenantId);
            lambda.eq(OtherContractEntity::getBillCode, otherContractVO.getBillCode());
            List<OtherContractEntity> entities = super.list(lambda);
            if(entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }
        entity.setSupplementFlag(0);
        entity.setIsSuspend(0);
        entity.setIsRelieve(0);
        entity.setBaseTaxMoney(entity.getContractTaxMny());//初始版本金额(含税)
        entity.setBaseMoney(entity.getContractMny());//初始版本金额(不含税)
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());//变更前金额(含税)
        entity.setBeforeChangeMny(entity.getContractMny());//变更前金额(不含税)
        this.saveOrUpdate(entity,false);
        OtherContractVO vo = BeanMapper.map(entity, OtherContractVO.class);
        return vo;
    }


    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.select("round(sum(base_tax_money),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount");
        resp = super.getMap(wrapper);
//        String originalAmount = resp.get("originalAmount").toString();
//        String curAmount = resp.get("curAmount").toString();
//        resp.put("originalAmount",originalAmount);
//        resp.put("curAmount",curAmount);
        return resp;
    }

    /**
     * 获取合同签订时间
     * @param id
     * @return
     */
    @Override
    public Date getSignDate(Long id) {
        return contractMapper.getSignDate(id);
    }

    @Override
    public OtherContractVO contractDetail(Long id) {
        OtherContractEntity entity = contractMapper.selectById(id);
        OtherContractVO otherContractVO = BeanMapper.map(entity, OtherContractVO.class);
        OtherContractVO vo = new OtherContractVO();
        vo.setId(otherContractVO.getId());
        vo.setContractName(otherContractVO.getContractName());
        vo.setContractTaxMny(otherContractVO.getContractTaxMny());
        vo.setTaxRate(otherContractVO.getTaxRate());
        vo.setProjectId(otherContractVO.getProjectId());
        vo.setProjectName(otherContractVO.getProjectName());
        vo.setCustomerId(otherContractVO.getCustomerId());
        vo.setCustomerName(otherContractVO.getCustomerName());
        vo.setSupplierId(otherContractVO.getSupplierId());
        vo.setSupplierName(otherContractVO.getSupplierName());
        vo.setOrgId(otherContractVO.getOrgId());
        vo.setOrgName(otherContractVO.getOrgName());
        vo.setVersion(otherContractVO.getVersion());
        return vo;
    }


    @Override
    public boolean pushContract(OtherContractVO vo,Boolean updateLevel) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert(vo, data);
            if(updateLevel){ // 更新
                delContractFromPool(vo.getId());
            }
            if("1".equals(vo.getContractStatus())){
                data.setPerformanceStatus("1");
            }
            if("2".equals(vo.getContractStatus())){
                data.setPerformanceStatus("2");
            }
            if("3".equals(vo.getContractStatus())){
                data.setPerformanceStatus("3");
            }
            if("4".equals(vo.getContractStatus())){
                data.setPerformanceStatus("5");
            }
            if("5".equals(vo.getContractStatus())){
                data.setPerformanceStatus("4");
            }
            data.setChangeStatus(Integer.parseInt(vo.getChangeStatus()));
            data.setContractProperty(1);
            data.setSourceType(ContractTypeEnum.其他收入合同.getTypeCode());
            String url = null;
            if (vo.getSupplementFlag() == 0) {
                url = "/ejc-proincome-frontend/#/otherContract/otherContractApprove?id=" + vo.getId();
            }else {
                url = "/ejc-proincome-frontend/#/otherContract/otherContractSupplement?id=" + vo.getId();
            }
            data.setPcCardUrl(url);
            data.setCategoryId(1524002474627813378L);// 其他收入合同类别为空，合同池写死




            //从项目池中获取数据获取
            CommonResponse<ProjectPoolSetVO> projectPoolSetVO = projectSetApi.getProjectId(data.getProjectId());
            if (projectPoolSetVO != null && projectPoolSetVO.getData() != null){
                ProjectPoolSetVO data1 = projectPoolSetVO.getData();
                if (data1.getAreaName() != null){
                    data.setAreaName(data1.getAreaName());//所在地区
                }
                if (data1.getAddress() != null){
                    data.setAddress(data1.getAddress());//详细地址
                }
                if (data1.getEngineeringType() != null){
                    CommonResponse<DefdocDetailVO> defDocById = defdocApi.getDefDocById(data1.getEngineeringTypeId());
                    if (defDocById.getCode() == 0 && defDocById.getData() != null) {
                        data.setEngineeringType(defDocById.getData().getName());//工程类别
                    }
                }
//                if (data1.getMeasureType() != null  && data1.getMeasureType().equals(1506803511994617857L) && data1.getMeasureValue() != null){
//                    pmContractVO.setJzmj(data.getMeasureValue());//建筑面积
//                }
//                if (data1.getPlanStartDate() != null){
//                    pmContractVO.setKgrq(sdf.format(data1.getPlanStartDate()));//开工日期
//                }
//                if (data1.getPlanEndDate() != null){
//                    pmContractVO.setJgrq(sdf.format(data1.getPlanEndDate()));//竣工日期
//                }
//                if (data1.getProjectManagementName() != null){
//                    pmContractVO.setXmfzr(data1.getProjectManagementName());//项目负责人
//                }
//                if (data1.getProjectManagementPhone() != null){
//                    pmContractVO.setXmfzedh(data1.getProjectManagementPhone());//项目负责人电话
//                }
            }



            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);

            if(transDataResp.isSuccess()) {
                return true;
            } else {
                logger.error("合同id-{}推送合同池失败，{}",vo.getId(), transDataResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", vo.getId(), e);
        }
        return false;
    }

    @Override
    public boolean delContractFromPool(Long id) {
        ContractPoolVO c = new ContractPoolVO();
        c.setSourceId(id);

        logger.info("将合同-{}从合同池中删除！", id);
        CommonResponse<String> delDataResp = contractPoolApi.deleteContract(c);
        if(delDataResp.isSuccess()) {
            return true;
        }

        logger.error("将合同-{}从合同池中删除失败, {}！", id, delDataResp.getMsg());
        return false;
    }


}
