/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.business.pro.income.bean.ClaimEntity;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.CostAdjustDetailEntity;
import com.ejianc.business.pro.income.bean.CostAdjustEntity;
import com.ejianc.business.pro.income.mapper.CostAdjustMapper;
import com.ejianc.business.pro.income.service.IClaimService;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.ICostAdjustDetailService;
import com.ejianc.business.pro.income.service.ICostAdjustService;
import com.ejianc.business.pro.income.utils.BillTypeCodeEnum;
import com.ejianc.business.pro.income.utils.ValidateUtil;
import com.ejianc.business.pro.income.vo.ClaimVO;
import com.ejianc.business.pro.income.vo.CostAdjustDetailVO;
import com.ejianc.business.pro.income.vo.CostAdjustVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="costAdjustService")
public class CostAdjustServiceImpl
extends BaseServiceImpl<CostAdjustMapper, CostAdjustEntity>
implements ICostAdjustService {
    private static final String COST_ADJUST_APPLY = "COST_ADJUST_APPLY";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICostAdjustDetailService detailService;
    @Autowired
    private IContractRegisterService registerService;
    @Autowired
    private IClaimService claimService;
    @Autowired
    private ValidateUtil validateUtil;
    @Autowired
    private IContractPoolApi contractPoolApi;

    @Override
    public CostAdjustVO saveOrUpdate(CostAdjustVO saveOrUpdateVO) {
        if (!Objects.equals(null, saveOrUpdateVO.getContractId()) && !this.validateUtil.validateUpStreamVersion(String.valueOf(saveOrUpdateVO.getContractId()), BillTypeCodeEnum.\u65bd\u5de5\u5408\u540c.getCode(), saveOrUpdateVO.getContractVersion()).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
        }
        String operateType = null;
        CostAdjustEntity entity = (CostAdjustEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CostAdjustEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)COST_ADJUST_APPLY, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            operateType = "add";
        } else {
            operateType = "edit";
        }
        if (entity.getApprovalFlag() == null) {
            entity.setApprovalFlag(0);
        }
        this.saveOrUpdate((Object)entity);
        List<CostAdjustDetailEntity> detailList = entity.getDetailList();
        ArrayList<CostAdjustDetailEntity> newDetailList = new ArrayList<CostAdjustDetailEntity>();
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        for (CostAdjustDetailEntity vo : detailList) {
            if (Objects.equals("del", vo.getRowState())) {
                deleteIds.add(vo.getId());
            }
            if (Objects.equals("add", vo.getRowState())) {
                vo.setId(null);
                vo.setAdjustId(entity.getId());
                newDetailList.add(vo);
            }
            if (!Objects.equals("edit", vo.getRowState())) continue;
            newDetailList.add(vo);
        }
        if (CollectionUtil.isNotEmpty(newDetailList)) {
            this.detailService.saveOrUpdateBatch(newDetailList, newDetailList.size(), false);
        }
        if (CollectionUtil.isNotEmpty(deleteIds)) {
            this.detailService.removeByIds(deleteIds, false);
        }
        this.claimService.updateCostAdjustId(entity.getId(), entity.getDetailList().stream().map(CostAdjustDetailEntity::getClaimId).collect(Collectors.toList()));
        return this.queryDetail(entity.getId());
    }

    @Override
    public CostAdjustVO queryDetail(Long id) {
        CostAdjustEntity entity = (CostAdjustEntity)((Object)this.selectById(id));
        CostAdjustVO vo = (CostAdjustVO)BeanMapper.map((Object)((Object)entity), CostAdjustVO.class);
        List detailList = vo.getDetailList();
        if (ListUtil.isNotEmpty((List)detailList)) {
            List idList = detailList.stream().map(CostAdjustDetailVO::getClaimId).collect(Collectors.toList());
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.in(BaseEntity::getId, idList);
            List claimList = this.claimService.list((Wrapper)wrapper);
            Map claimMap = claimList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
            for (CostAdjustDetailVO detailVO : detailList) {
                ClaimEntity claimEntity = (ClaimEntity)((Object)claimMap.get(detailVO.getClaimId()));
                detailVO.setReplyMny(claimEntity.getReplyMny());
                detailVO.setReplyTaxMny(claimEntity.getReplyTaxMny());
                detailVO.setReplyStatus(claimEntity.getReplyStatus());
                detailVO.setRowState("edit");
            }
            BigDecimal replyMny = claimList.stream().filter(e -> e.getReplyMny() != null).map(ClaimEntity::getReplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal replyTaxMny = claimList.stream().filter(e -> e.getReplyTaxMny() != null).map(ClaimEntity::getReplyTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setReplyMny(replyMny);
            vo.setReplyTaxMny(replyTaxMny);
        }
        return vo;
    }

    @Override
    public Boolean validateContract(Long contractId, Long id) {
        List list;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getParams().put("billState", new Parameter("not_in", (Object)"1,3"));
        if (!Objects.equals(null, id)) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)id));
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = super.queryList(queryParam, false)))) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u5de5\u7a0b\u9020\u4ef7\u8c03\u6574\u7533\u8bf7\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
        return true;
    }

    @Override
    public CostAdjustVO queryMny(Long contractId) {
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(1);
        billStateList.add(3);
        LambdaQueryWrapper contractWrapper = new LambdaQueryWrapper();
        contractWrapper.eq(ContractRegisterEntity::getMainContractId, (Object)contractId);
        contractWrapper.in(ContractRegisterEntity::getBillState, billStateList);
        List supplementList = this.registerService.list((Wrapper)contractWrapper);
        BigDecimal totalSupplementMny = supplementList.stream().filter(e -> e.getContractMny() != null).map(ContractRegisterEntity::getContractMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalSupplementTaxMny = supplementList.stream().filter(e -> e.getContractTaxMny() != null).map(ContractRegisterEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(CostAdjustEntity::getContractId, (Object)contractId);
        wrapper.in(CostAdjustEntity::getBillState, billStateList);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.list((Wrapper)wrapper);
        CostAdjustEntity entity = null;
        if (ListUtil.isNotEmpty((List)list)) {
            entity = (CostAdjustEntity)((Object)list.get(0));
        }
        CostAdjustVO vo = new CostAdjustVO();
        vo.setTotalSupplementMny(totalSupplementMny);
        vo.setTotalSupplementTaxMny(totalSupplementTaxMny);
        if (Objects.equals(null, (Object)entity)) {
            vo.setLastApplyChangeMny(null);
            vo.setLastApplyChangeTaxMny(null);
        } else {
            vo.setLastApplyChangeMny(entity.getTotalApplyChangeMny());
            vo.setLastApplyChangeTaxMny(entity.getTotalApplyChangeTaxMny());
            vo.setApplyAdjustDate(entity.getApplyAdjustDate());
        }
        return vo;
    }

    @Override
    public List<ClaimVO> queryClaimList(Long contractId, String applyAdjustDate, String lastApplyAdjustDate) {
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(1);
        billStateList.add(3);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ClaimEntity::getContractId, (Object)contractId);
        wrapper.in(ClaimEntity::getBillState, billStateList);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        if (StringUtils.isBlank((CharSequence)lastApplyAdjustDate)) {
            wrapper.le(ClaimEntity::getCommitDate, (Object)applyAdjustDate);
        } else {
            wrapper.between(ClaimEntity::getCommitDate, (Object)lastApplyAdjustDate, (Object)applyAdjustDate);
        }
        List list = this.claimService.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            return new ArrayList<ClaimVO>();
        }
        return BeanMapper.mapList((Iterable)list, ClaimVO.class);
    }

    @Override
    public Boolean updateContractPool(ContractRegisterEntity entity) {
        ContractPoolVO poolVO = new ContractPoolVO();
        poolVO.setId(entity.getId());
        poolVO.setSourceId(entity.getId());
        poolVO.setTotalCostAdjustTaxMny(entity.getTotalCostAdjustTaxMny());
        poolVO.setTotalCostAdjustMny(entity.getTotalCostAdjustMny());
        poolVO.setTotalCostAdjustTax(entity.getTotalCostAdjustTax());
        poolVO.setUpdateLevel(UpdateLevelEnum.\u66f4\u65b0\u975e\u7a7a\u5b57\u6bb5.getLevelCode());
        CommonResponse transDataResp = this.contractPoolApi.saveOrUpdateContract(poolVO);
        if (transDataResp.isSuccess()) {
            return true;
        }
        this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)entity.getId(), (Object)transDataResp.getMsg());
        throw new BusinessException("\u66f4\u65b0\u5408\u540c\u6c60\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
    }
}

