/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.ProductionDetailCostEntity;
import com.ejianc.business.pro.income.bean.ProductionDetailEntity;
import com.ejianc.business.pro.income.bean.ProductionDetailFeeEntity;
import com.ejianc.business.pro.income.bean.ProductionDetailMeasureEntity;
import com.ejianc.business.pro.income.bean.ProductionDetailOtherEntity;
import com.ejianc.business.pro.income.bean.ProductionDetailSubEntity;
import com.ejianc.business.pro.income.bean.ProductionEntity;
import com.ejianc.business.pro.income.mapper.ProductionMapper;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IProductionDetailService;
import com.ejianc.business.pro.income.service.IProductionService;
import com.ejianc.business.pro.income.utils.BillTypeCodeEnum;
import com.ejianc.business.pro.income.utils.DetailListUtil;
import com.ejianc.business.pro.income.utils.TreeNodeBUtil;
import com.ejianc.business.pro.income.utils.TreeSortUtil;
import com.ejianc.business.pro.income.utils.ValidateUtil;
import com.ejianc.business.pro.income.vo.ProductionDetailVO;
import com.ejianc.business.pro.income.vo.ProductionHistoryVO;
import com.ejianc.business.pro.income.vo.ProductionVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="productionService")
public class ProductionServiceImpl
extends BaseServiceImpl<ProductionMapper, ProductionEntity>
implements IProductionService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "PRO_INCOME_PRODUCTION";
    @Autowired
    private ValidateUtil validateUtil;
    @Autowired
    private DetailListUtil detailListUtil;
    @Autowired
    private IContractRegisterService registerService;
    @Autowired
    private IProductionDetailService detailService;
    @Autowired
    private ISettlePoolApi settlePoolApi;

    @Override
    public ProductionVO saveOrUpdate(ProductionVO saveorUpdateVO) {
        List list;
        if (!this.validateUtil.validateUpStreamVersion(String.valueOf(saveorUpdateVO.getContractId()), BillTypeCodeEnum.\u65bd\u5de5\u5408\u540c.getCode(), saveorUpdateVO.getContractVersion()).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
        }
        List detailVOList = saveorUpdateVO.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailVOList)) {
            for (ProductionDetailVO detail : detailVOList) {
                if (!"add".equals(detail.getRowState()) || this.validateUtil.validateUpStreamVersion(String.valueOf(detail.getBudgetId()), BillTypeCodeEnum.\u9879\u76ee\u9884\u7b97\u4e66.getCode(), detail.getBudgetVersion()).booleanValue()) continue;
                throw new BusinessException("\u3010" + detail.getBudgetCode() + "\u3011\u9879\u76ee\u9884\u7b97\u4e66\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
            }
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)saveorUpdateVO.getContractId()));
        queryParam.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        if (saveorUpdateVO.getId() != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)saveorUpdateVO.getId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = super.queryList(queryParam, false)))) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u4ea7\u503c\u62a5\u91cf\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        ProductionEntity entity = (ProductionEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ProductionEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveorUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity);
        List<ProductionDetailEntity> detailList = entity.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (ProductionDetailEntity detail : detailList) {
                detail.setProductionId(entity.getId());
                if ("del".equals(detail.getRowState())) {
                    this.detailService.removeById(detail.getId(), false);
                    continue;
                }
                this.detailService.saveOrUpdate((Object)detail, false);
                this.dealParentId(detail);
                this.detailService.saveOrUpdate((Object)detail, false);
            }
        }
        return this.queryDetail(entity.getId());
    }

    private void dealParentId(ProductionDetailEntity detail) {
        List<ProductionDetailFeeEntity> feeList;
        List<ProductionDetailOtherEntity> otherList;
        List<ProductionDetailMeasureEntity> measureList;
        List<ProductionDetailSubEntity> subList;
        List<ProductionDetailCostEntity> costList = detail.getCostList();
        if (CollectionUtils.isNotEmpty(costList)) {
            HashMap idMap = new HashMap();
            costList.forEach(i -> idMap.put(i.getTid(), i.getId()));
            costList.forEach(i -> {
                if (StringUtils.isNotEmpty((CharSequence)i.getTpid())) {
                    i.setParentId((Long)idMap.get(i.getTpid()));
                }
            });
        }
        if (CollectionUtils.isNotEmpty(subList = detail.getSubList())) {
            HashMap idMap = new HashMap();
            subList.forEach(i -> idMap.put(i.getTid(), i.getId()));
            subList.forEach(i -> {
                if (StringUtils.isNotEmpty((CharSequence)i.getTpid())) {
                    i.setParentId((Long)idMap.get(i.getTpid()));
                }
            });
        }
        if (CollectionUtils.isNotEmpty(measureList = detail.getMeasureList())) {
            HashMap idMap = new HashMap();
            measureList.forEach(i -> idMap.put(i.getTid(), i.getId()));
            measureList.forEach(i -> {
                if (StringUtils.isNotEmpty((CharSequence)i.getTpid())) {
                    i.setParentId((Long)idMap.get(i.getTpid()));
                }
            });
        }
        if (CollectionUtils.isNotEmpty(otherList = detail.getOtherList())) {
            HashMap idMap = new HashMap();
            otherList.forEach(i -> idMap.put(i.getTid(), i.getId()));
            otherList.forEach(i -> {
                if (StringUtils.isNotEmpty((CharSequence)i.getTpid())) {
                    i.setParentId((Long)idMap.get(i.getTpid()));
                }
            });
        }
        if (CollectionUtils.isNotEmpty(feeList = detail.getFeeList())) {
            HashMap idMap = new HashMap();
            feeList.forEach(i -> idMap.put(i.getTid(), i.getId()));
            feeList.forEach(i -> {
                if (StringUtils.isNotEmpty((CharSequence)i.getTpid())) {
                    i.setParentId((Long)idMap.get(i.getTpid()));
                }
            });
        }
    }

    @Override
    public ProductionVO queryDetail(Long id) {
        List detailList;
        ProductionEntity entity = (ProductionEntity)((Object)super.selectById((Serializable)id));
        this.detailListUtil.setDetailList(entity.getDetailList());
        ProductionVO vo = (ProductionVO)BeanMapper.map((Object)((Object)entity), ProductionVO.class);
        if (entity != null && CollectionUtils.isNotEmpty((Collection)(detailList = vo.getDetailList()))) {
            for (ProductionDetailVO detail : detailList) {
                List feeList;
                List otherList;
                List measureList;
                List subList;
                List costList = detail.getCostList();
                if (CollectionUtils.isNotEmpty((Collection)costList)) {
                    costList.forEach(i -> {
                        i.setTid(i.getId().toString());
                        i.setTpid(i.getParentId() != null && i.getParentId() > 0L ? i.getParentId().toString() : "");
                        i.setShadowId(i.getTid());
                        i.setRowState("edit");
                    });
                    new TreeSortUtil().entryListToSort(costList);
                    detail.setCostList(TreeNodeBUtil.buildTree((List)costList));
                }
                if (CollectionUtils.isNotEmpty((Collection)(subList = detail.getSubList()))) {
                    subList.forEach(i -> {
                        i.setTid(i.getId().toString());
                        i.setTpid(i.getParentId() != null && i.getParentId() > 0L ? i.getParentId().toString() : "");
                        i.setShadowId(i.getTid());
                        i.setRowState("edit");
                    });
                    new TreeSortUtil().entryListToSort(subList);
                    detail.setSubList(TreeNodeBUtil.buildTree((List)subList));
                }
                if (CollectionUtils.isNotEmpty((Collection)(measureList = detail.getMeasureList()))) {
                    measureList.forEach(i -> {
                        i.setTid(i.getId().toString());
                        i.setTpid(i.getParentId() != null && i.getParentId() > 0L ? i.getParentId().toString() : "");
                        i.setShadowId(i.getTid());
                        i.setRowState("edit");
                    });
                    new TreeSortUtil().entryListToSort(measureList);
                    detail.setMeasureList(TreeNodeBUtil.buildTree((List)measureList));
                }
                if (CollectionUtils.isNotEmpty((Collection)(otherList = detail.getOtherList()))) {
                    otherList.forEach(i -> {
                        i.setTid(i.getId().toString());
                        i.setTpid(i.getParentId() != null && i.getParentId() > 0L ? i.getParentId().toString() : "");
                        i.setShadowId(i.getTid());
                        i.setRowState("edit");
                    });
                    new TreeSortUtil().entryListToSort(otherList);
                    detail.setOtherList(TreeNodeBUtil.buildTree((List)otherList));
                }
                if (!CollectionUtils.isNotEmpty((Collection)(feeList = detail.getFeeList()))) continue;
                feeList.forEach(i -> {
                    i.setTid(i.getId().toString());
                    i.setTpid(i.getParentId() != null && i.getParentId() > 0L ? i.getParentId().toString() : "");
                    i.setShadowId(i.getTid());
                    i.setRowState("edit");
                });
                new TreeSortUtil().entryListToSort(feeList);
                detail.setFeeList(TreeNodeBUtil.buildTree((List)feeList));
            }
        }
        return vo;
    }

    @Override
    public String validateContract(Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)id));
        queryParam.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        List list = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u4ea7\u503c\u62a5\u91cf\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public ProductionHistoryVO queryProductionHistory(Long id) {
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)this.registerService.selectById(id));
        ProductionHistoryVO vo = new ProductionHistoryVO();
        vo.setContractId(id);
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setIsFinish(entity.getIsFinish());
        vo.setIsRelieve(entity.getIsRelieve());
        vo.setIsSuspend(entity.getIsSuspend());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)id));
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        queryParam.getOrderMap().put("productionDate", "desc");
        queryParam.getOrderMap().put("createTime", "desc");
        List list = super.queryList(queryParam);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return vo;
        }
        BigDecimal sumProductionMny = list.stream().map(ProductionEntity::getProductionMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumProductionTaxMny = list.stream().map(ProductionEntity::getProductionTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        vo.setSumProductionMny(sumProductionMny);
        vo.setSumProductionTaxMny(sumProductionTaxMny);
        vo.setProductionRecord(BeanMapper.mapList((Iterable)list, ProductionVO.class));
        return vo;
    }

    @Override
    public boolean pushSettleToPool(ProductionVO vo) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u5f00\u59cb-----" + JSONObject.toJSONString((Object)vo));
            BeanConvertorUtil.convert((Object)vo, (Object)spv);
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u7ed3\u675f\uff0c\u4e0b\u9762\u5f00\u59cb\u624b\u52a8\u8f6c\u6362");
            this.convertSettleVOToSettlePoolVO(vo, spv);
            this.logger.info("\u63a8\u9001\u53c2\u6570----" + JSONObject.toJSONString((Object)spv));
            CommonResponse res = this.settlePoolApi.saveOrUpdateSettle(spv);
            if (res.isSuccess()) {
                flag = true;
                this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u6210\u529f---{}", (Object)res.getMsg());
            } else {
                this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)vo.getId(), (Object)res.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)vo.getId(), (Object)e);
            throw new BusinessException("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5f02\u5e38!");
        }
        return flag;
    }

    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        spv.setSourceId(id);
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5f00\u59cb,\u7ed3\u7b97\u5355id-{}", (Object)id);
            CommonResponse res = this.settlePoolApi.deleteSettle(spv);
            if (res.isSuccess()) {
                flag = true;
                this.logger.info("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u6210\u529f---{}", (Object)res.getMsg());
            } else {
                this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)id, (Object)res.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)id, (Object)e);
            throw new BusinessException("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5f02\u5e38!");
        }
        return flag;
    }

    private void convertSettleVOToSettlePoolVO(ProductionVO vo, SettlePoolVO spv) {
        spv.setSourceType("product_value");
        spv.setSourceId(vo.getId());
        spv.setId(vo.getId());
        spv.setSettleProperty(Integer.valueOf(1));
        spv.setUltimateFlag(Integer.valueOf(0));
        spv.setCreateUserCode(vo.getCreateUserCode());
        spv.setCreateTime(vo.getCreateTime());
        spv.setUpdateUserCode(vo.getUpdateUserCode());
        spv.setUpdateTime(vo.getUpdateTime());
        spv.setBillCodeUrl("/ejc-proincome-frontend/#/production/card?id=" + vo.getId());
        if (vo.getContractId() != null) {
            ContractRegisterEntity contractEntity = (ContractRegisterEntity)((Object)this.registerService.selectById(vo.getContractId()));
            spv.setContractType("contraction");
            spv.setContractFlag(Integer.valueOf(1));
            spv.setSupplementFlag(contractEntity.getSupplementFlag());
            spv.setMaiContractId(contractEntity.getMainContractId());
            spv.setMaiContractName(contractEntity.getMainContractName());
            spv.setMaiContractCode(contractEntity.getMainContractCode());
            spv.setContractCode(contractEntity.getBillCode());
            spv.setPartyaId(contractEntity.getCustomerId());
            spv.setPartyaName(contractEntity.getCustomerName());
            spv.setPartybId(contractEntity.getSupplierId());
            spv.setPartybName(contractEntity.getSupplierName());
            spv.setSignDate(contractEntity.getSignDate());
            BigDecimal lastTaxMny = BigDecimal.ZERO;
            BigDecimal lastMny = BigDecimal.ZERO;
            BigDecimal lastTax = BigDecimal.ZERO;
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.orderByDesc(BaseEntity::getCreateTime);
            wrapper.in(ProductionEntity::getBillState, new Object[]{1, 3});
            wrapper.eq(BaseEntity::getDr, (Object)0);
            wrapper.eq(ProductionEntity::getContractId, (Object)vo.getContractId());
            wrapper.ne(BaseEntity::getId, (Object)vo.getId());
            List list = super.list((Wrapper)wrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (ProductionEntity settlementEntity : list) {
                    BigDecimal settTaxMny = settlementEntity.getProductionTaxMny() == null ? BigDecimal.ZERO : settlementEntity.getProductionTaxMny();
                    BigDecimal settMny = settlementEntity.getProductionMny() == null ? BigDecimal.ZERO : settlementEntity.getProductionMny();
                    BigDecimal settTax = settlementEntity.getTaxMny() == null ? BigDecimal.ZERO : settlementEntity.getTaxMny();
                    lastTaxMny = lastTaxMny.add(settTaxMny);
                    lastMny = lastMny.add(settMny);
                    lastTax = lastTax.add(settTax);
                }
            }
            spv.setLastTaxMny(lastTaxMny);
            spv.setLastMny(lastMny);
            spv.setLastTax(lastTax);
        }
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5b8c\u6210");
    }
}

