package com.ejianc.business.pro.g9.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.constructor.api.INbzzContractApi;
import com.ejianc.business.constructor.vo.NbzzContractVO;
import com.ejianc.business.pro.g9.bean.FinalizedG9Entity;
import com.ejianc.business.pro.g9.service.IFinalizedG9Service;
import com.ejianc.business.pro.income.bean.FinalizedEntity;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;
import java.util.Map;

@Service("finalizedG9") 
public class FinalizedG9BpmServiceImpl implements ICommonBusinessService {


	private final Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IFinalizedG9Service service;
	@Autowired
	private INbzzContractApi nbzzContractApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}
	/**
	 * 审批--获取当前节点的审批人---从服务中选择
	 *
	 * @param billId 单据id
	 * @param billTypeCode 单据类型编码
	 * @param sign 节点标志
	 * @return
	 */
	@Override
	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other){
		JSONArray arr = new JSONArray();
		logger.info("sign:{}",sign);

		//根据标识判断是否（）节点
		if ("businessUser".equals(sign)){
			//获取表单详情数据

			FinalizedG9Entity entity = service.selectById(billId);
			Long contractId = entity.getContractId();

			JSONObject jsonObject = new JSONObject();
			QueryParam queryParam = new QueryParam();
			queryParam.getParams().put("id",new Parameter(QueryParam.EQ,contractId));
			CommonResponse<JSONArray> commonResponse = nbzzContractApi.queryListByParam(queryParam);


			if(!commonResponse.isSuccess()){
				throw new BusinessException("查询项目失败!");
			}
			JSONArray array = commonResponse.getData();
			List<NbzzContractVO> vos = JSONObject.parseArray(array.toJSONString(), NbzzContractVO.class);

			logger.info("vos:{}",JSONObject.toJSONString(vos));

			NbzzContractVO vo = vos.get(0);
			Long user = vo.getBusinessManager();
			String userName = vo.getBusinessManagerName();

			logger.info("userId:{}",user);
			logger.info("userName:{}",userName);


			jsonObject.put("userId",user);
			jsonObject.put("userName",userName);

			arr.add(jsonObject);

		}
		return CommonResponse.success(arr);
	}
}
