package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.QuoteEntity;
import com.ejianc.business.pro.income.service.IQuoteService;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.pro.income.vo.QuoteHistoryVO;
import com.ejianc.business.pro.income.vo.QuoteVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 对甲报量
 * 
 * @author generator
 * 
 */
@RestController
@RequestMapping("quote")
public class QuoteController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IQuoteService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<QuoteVO> saveOrUpdate(@RequestBody QuoteVO saveorUpdateVO) {
        QuoteVO vo = service.saveOrUpdate(saveorUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<QuoteVO> queryDetail(Long id) {
        QuoteVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<QuoteVO> vos) {
        service.removeByIds(vos.stream().map(QuoteVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<QuoteVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 默认根据创建时间排序
        param.getOrderMap().put("createTime", param.getOrderMap().containsKey("quoteDate") ? param.getOrderMap().get("quoteDate") : QueryParam.DESC);

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<QuoteEntity> page = service.queryPage(param,false);
        IPage<QuoteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), QuoteVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        // 默认根据创建时间排序
        param.getOrderMap().put("createTime", param.getOrderMap().containsKey("quoteDate") ? param.getOrderMap().get("quoteDate") : QueryParam.DESC);
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        List<QuoteEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<QuoteVO> voList = BeanMapper.mapList(list, QuoteVO.class);
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("quote-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refQuoteData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<QuoteVO>> refQuoteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<QuoteEntity> page = service.queryPage(param,false);
        IPage<QuoteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), QuoteVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description validateContract 校验合同
     * @param id
     */
    @RequestMapping(value = "/validateContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> validateContract(Long id) {
        String msg = service.validateContract(id);
        return CommonResponse.success("校验成功！", msg);
    }

    /**
     * 对甲报量历史记录
     * @param id 合同ID
     * @return
     */
    @RequestMapping(value = "/queryQuoteHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<QuoteHistoryVO> queryQuoteHistory(@RequestParam Long id) {
        QuoteHistoryVO vo = service.queryQuoteHistory(id);
        return CommonResponse.success(vo);
    }

    @PostMapping("saveReply")
    @ResponseBody
    public CommonResponse<String> saveReply(@RequestBody QuoteVO vo){
        QuoteEntity entity = service.selectById(vo.getId());
        if (entity!=null){
            LambdaUpdateWrapper<QuoteEntity> wrapper = new LambdaUpdateWrapper();
            wrapper.eq(QuoteEntity::getId, vo.getId());
            wrapper.set(QuoteEntity::getReplyDate,vo.getReplyDate());
            wrapper.set(QuoteEntity::getReplyStatus,vo.getReplyStatus());
            wrapper.set(QuoteEntity::getReplyMny,vo.getReplyMny());
            wrapper.set(QuoteEntity::getReplyTaxMny,vo.getReplyTaxMny());
            service.update(wrapper);
            // 重新查询
            entity = service.selectById(vo.getId());
            // 已批复时推送结算池
            if(new Integer(1).equals(vo.getReplyStatus())){
                boolean pool = service.pushSettleToPool(BeanMapper.map(entity, QuoteVO.class));
                if(!pool){
                    return CommonResponse.error("推送结算池失败");
                }
            }
            return CommonResponse.success();
        }else{
            return CommonResponse.error("单据不存在！");
        }
    }

    /**
     * 同步结算池
     * @param id
     * @return
     */
    @GetMapping(value = "/syncPushSettlePool")
    @ResponseBody
    public CommonResponse<Boolean> syncPushSettlePool(@RequestParam(value = "id") Long id) {
        QuoteEntity quoteEntity = service.selectById(id);
        QuoteVO vo = BeanMapper.map(quoteEntity, QuoteVO.class);
        // 已批复时推送结算池
        if(new Integer(1).equals(vo.getReplyStatus())){
            boolean pool = service.pushSettleToPool(vo);
            if(!pool){
                return CommonResponse.error("推送结算池失败");
            }
        } else {
            return CommonResponse.success("无需推送！", true);
        }
        return CommonResponse.success("同步结算池成功！", true);
    }
    
}
