package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.income.service.IBudgetService;
import com.ejianc.business.pro.income.vo.RevenueMaterialsVO;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2023/2/22 20:43
 */
@RestController
@RequestMapping("/report/")
public class BudgetReportController {

    @Autowired
    private IShareSubjectOrgApi shareSubjectOrgApi;

    @Autowired
    private IBudgetService budgetService;

    /**
     * 收入材料汇总明细表
     *
     * @param queryParam
     * @return
     */
    @PostMapping(value = "revenueMaterialsSummaryList")
    public CommonResponse<JSONObject> revenueMaterials(@RequestBody QueryParam queryParam) {
        QueryParam subjectQuery = new QueryParam();
        subjectQuery.getParams().put("subject_code", new Parameter(QueryParam.LIKE_RIGHT, "02"));
        subjectQuery.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));
        subjectQuery.getParams().put("dr", new Parameter(QueryParam.EQ, BaseVO.DR_UNDELETE));
        CommonResponse<List<SubjectOrgVO>> subjectOrgIds = shareSubjectOrgApi.querySubjectOrg(subjectQuery);
        queryParam.getParams().put("subjectIds", new Parameter(QueryParam.IN, subjectOrgIds.getData().stream().map(SubjectOrgVO::getId).collect(Collectors.toList())));

        return CommonResponse.success(budgetService.pageRevenueMaterials(queryParam));
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        QueryParam subjectQuery = new QueryParam();
        subjectQuery.getParams().put("subject_code", new Parameter(QueryParam.LIKE_RIGHT, "02"));
        subjectQuery.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));
        subjectQuery.getParams().put("dr", new Parameter(QueryParam.EQ, BaseVO.DR_UNDELETE));
        CommonResponse<List<SubjectOrgVO>> subjectOrgIds = shareSubjectOrgApi.querySubjectOrg(subjectQuery);
        param.getParams().put("subjectIds", new Parameter(QueryParam.IN, subjectOrgIds.getData().stream().map(SubjectOrgVO::getId).collect(Collectors.toList())));

        List<RevenueMaterialsVO> list = budgetService.getMaterialSummarylist(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("RevenueMaterialList-export.xlsx", beans, response);
    }

}
