package com.ejianc.business.pro.income.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.constructor.api.IZjllApi;
import com.ejianc.business.constructor.vo.ZjllVO;
import com.ejianc.business.cwdataexchange.PMContractPush.api.IPMContractApi;
import com.ejianc.business.cwdataexchange.PMContractPush.vo.PMContractVO;
import com.ejianc.business.market.api.IProjectPartApi;
import com.ejianc.business.market.vo.ProjectPartVO;
import com.ejianc.business.pro.income.bean.BudgetOtherEntity;
import com.ejianc.business.pro.income.bean.ContractReviewEntity;
import com.ejianc.business.pro.income.enums.BillPushStatusEnum;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.enums.ContractStatusEnum;
import com.ejianc.business.pro.income.mapper.ContractRegisterMapper;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IContractReviewService;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.pro.income.vo.CustomerInfoVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IShareCustomerApi;
import com.ejianc.foundation.support.vo.CustomerIncomeInfoVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Service("contractRegister")
public class ContractRegisterBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IContractRegisterService service;

    @Autowired
    private IPMContractApi contractApi;

    @Autowired
    private IProjectSetApi projectSetApi;

    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private IContractReviewService reviewService;

    @Autowired
    private IShareCustomerApi customerApi;


    @Autowired
    private ContractRegisterMapper contractRegisterMapper;

    @Autowired
    private IProjectPartApi projectPartApi;
    @Autowired
    private IZjllApi zjllApi;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO

        logger.info("提交回写合同状态开始");
        LambdaUpdateWrapper<ContractRegisterEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.set(ContractRegisterEntity::getContractStatus, ContractStatusEnum.履约中.getCode());
        wrapper.eq(ContractRegisterEntity::getId, billId);
        service.update(wrapper);

        logger.info("提交回写合同状态结束");

        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ContractRegisterEntity contractEntity = service.selectById(billId);
        //合同推送合同池
        boolean pushResult = service.pushContract(BeanMapper.map(contractEntity, ContractRegisterVO.class), false);
        if (pushResult) {
            contractEntity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
        } else {
            contractEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
        }
        /**
         * 第一份合同审批通过后，将计划开工日期、计划竣工日期、工期推送到项目基本信息、项目池
         *
         */

        Long projectId = contractEntity.getProjectId();
        List<ContractRegisterEntity> list = service.list(Wrappers.<ContractRegisterEntity>lambdaQuery()
                .eq(ContractRegisterEntity::getProjectId, projectId)
                .in(ContractRegisterEntity::getBillState, 1, 3)
                .eq(ContractRegisterEntity::getDr, 0)
                .eq(ContractRegisterEntity::getSupplementFlag, 0)
                .eq(ContractRegisterEntity::getIsEstimation, 0)
                .ne(ContractRegisterEntity::getId,contractEntity.getId())
        );

        if (ListUtil.isEmpty(list)) {
            //同步基本信息
            Boolean b = contractRegisterMapper.updatePlanDate(projectId,
                    contractEntity.getStartDate(),
                    contractEntity.getEndDate(),
                    contractEntity.getSchedule(),
                    contractEntity.getCwProjectCode(),
                    contractEntity.getCwProjectName(),
                    contractEntity.getContractValuationType()
            );
            if (b) {
                logger.info("同步项目基本信息成功！{}", projectId);
            } else {
                logger.info("同步项目基本信息失败！");
            }
            //TODO 同步项目池
            CommonResponse<ProjectPoolSetVO> projectVOCommonResponse = projectSetApi.getProjectId(projectId);
            if(projectVOCommonResponse.isSuccess()){
                logger.info("同步项目池开始！");
                ProjectPoolSetVO projectPoolSetVO = projectVOCommonResponse.getData();
                projectPoolSetVO.setPlanStartDate(contractEntity.getStartDate());
                projectPoolSetVO.setPlanEndDate(contractEntity.getEndDate());
                projectPoolSetVO.setPlanDateNum(contractEntity.getSchedule());
                logger.info("同步项目池结束！{}", projectPoolSetVO);

                projectSetApi.pushProjectPoolSetNoInitial(JSONObject.toJSONString(projectPoolSetVO).getBytes(StandardCharsets.UTF_8));


            }

        } else {
            logger.info("同步项目基本信息失败！已存在审批通过的正式施工合同！");

        }
        service.saveOrUpdate(contractEntity);


        /**
         * 修改文件评审归档状态
         */
        if (contractEntity.getReviewId() != null && contractEntity.getIsEstimation() != 1) {
            LambdaUpdateWrapper<ContractReviewEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.set(ContractReviewEntity::getFilingFlag, 1);
            wrapper.set(ContractReviewEntity::getFilingId, contractEntity.getId());
            wrapper.set(ContractReviewEntity::getFilingDate, new Date());
            wrapper.eq(ContractReviewEntity::getId, contractEntity.getReviewId());
            reviewService.update(wrapper);
        }

        /**
         * 推送财务中间表  ------------------------开始
         * 主合同
         * 补充协议
         * 暂估合同
         */
//		logger.info("推送财务中间表  ------------------------开始");
//		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
//
//		Integer supplementFlag = contractEntity.getSupplementFlag();//是否补充协议 1是 0否
//		Integer isEstimation = contractEntity.getIsEstimation();//是否暂估合同 1是 0否
//
//		//从项目池中获取数据获取
//		CommonResponse<ProjectPoolSetVO> projectPoolSetVO = projectSetApi.getProjectId(contractEntity.getProjectId());
//		PMContractVO pmContractVO = BeanMapper.map(contractEntity, PMContractVO.class);
//		if (isEstimation != null && isEstimation.equals(1)) {
//			pmContractVO.setZgbz(1);//是否是暂估合同  是
//			pmContractVO.setBslx("暂估合同");
//			pmContractVO.setContractStatus(0);//暂估合同都是未签订
//		}else {
//			pmContractVO.setZgbz(0);//是否是暂估合同  否
//			pmContractVO.setBslx("正式合同");
////			if(supplementFlag.equals(0)){
////				pmContractVO.setBslx("正式合同");
////			}else {
////				pmContractVO.setBslx("附加合同");
////			}
//
//		}
//
//		pmContractVO.setContractId(String.valueOf(billId));//合同id
//		if (contractEntity.getSignDate() != null) {
//			pmContractVO.setDjrq(sdf.format(contractEntity.getSignDate()));//单据日期
//			pmContractVO.setSignDate(sdf.format(contractEntity.getSignDate()));//合同签订日期
//		}
//		pmContractVO.setContractCode(contractEntity.getBillCode());//合同编号
//
//		if(contractEntity.getBaseTaxMoney() != null) {
//			pmContractVO.setHtljhsje(contractEntity.getBaseTaxMoney());//合同累计含税金额字段取 合同签订金额字段
//		}
//		if(contractEntity.getContractType() != null) {
//			CommonResponse<DefdocDetailVO> defDocBy = defdocApi.getDefDocById(contractEntity.getContractType());
//			if (defDocBy.getCode() == 0 && defDocBy.getData() != null) {
//				pmContractVO.setContractType(defDocBy.getData().getName());//合同类型
//			}
//		}
//		pmContractVO.setContractTypeName("施工合同");//合同类型2
//		/**
//		 * 项目池中获取数据
//		 */
//		if (projectPoolSetVO != null && projectPoolSetVO.getData() != null){
//			ProjectPoolSetVO data = projectPoolSetVO.getData();
//			if (data.getAreaName() != null){
//				pmContractVO.setSzs(data.getAreaName());//所在地区
//			}
//			if (data.getAddress() != null){
//				pmContractVO.setXxdz(data.getAddress());//详细地址
//			}
//			if (data.getEngineeringType() != null){
//				CommonResponse<DefdocDetailVO> defDocById = defdocApi.getDefDocById(data.getEngineeringType());
//				if (defDocById.getCode() == 0 && defDocById.getData() != null) {
//					pmContractVO.setGclb(defDocById.getData().getName());//工程类别
//				}
//			}
//			if (data.getMeasureType() != null  && data.getMeasureType().equals(1506803511994617857L) && data.getMeasureValue() != null){
//				pmContractVO.setJzmj(data.getMeasureValue());//建筑面积
//			}
//			if (data.getPlanStartDate() != null){
//				pmContractVO.setKgrq(sdf.format(data.getPlanStartDate()));//开工日期
//			}
//			if (data.getPlanEndDate() != null){
//				pmContractVO.setJgrq(sdf.format(data.getPlanEndDate()));//竣工日期
//			}
//			if (data.getProjectManagementName() != null){
//				pmContractVO.setXmfzr(data.getProjectManagementName());//项目负责人
//			}
//			if (data.getProjectManagementPhone() != null){
//				pmContractVO.setXmfzedh(data.getProjectManagementPhone());//项目负责人电话
//			}
//		}
//
//
//		CommonResponse<PMContractVO> pmContractVOCommonResponse = contractApi.saveContract(pmContractVO);
//
//
//
//		logger.info("推送财务中间表  ------------------------结束"+ JSON.toJSONString(pmContractVOCommonResponse));
        /**
         * 推送财务中间表  ------------------------结束
         */

        /**
         * 修改客户库的金额、数量以及等级信息
         */
        CustomerIncomeInfoVO customerInfoVO = service.queryCustomerInfo(contractEntity.getCustomerId());
        customerInfoVO.setCustomerId(contractEntity.getCustomerId());
        CommonResponse<String> stringCommonResponse = customerApi.updateIncomeMny(customerInfoVO);
        logger.info("修改客户信息返回信息:{}", JSON.toJSONString(stringCommonResponse));


        /**
         * 推送生成执行标段子表
         */
        logger.info("执行标段推送开始===============");
        ProjectPartVO projectPartVO = new ProjectPartVO();
        projectPartVO.setBidSummaryId(contractEntity.getSummaryId());
        projectPartVO.setEnrollId(contractEntity.getEnrollId());
        projectPartVO.setProjectId(contractEntity.getProjectId());
        projectPartVO.setProjectName(contractEntity.getProjectName());
        projectPartVO.setContractName(contractEntity.getContractName());        projectPartVO.setContractId(contractEntity.getId());
        projectPartVO.setContractMny(contractEntity.getContractMny());
        projectPartVO.setContractType(contractEntity.getContractType());
        CommonResponse<DefdocDetailVO> defDocBy = defdocApi.getDefDocById(contractEntity.getContractType());
        if (defDocBy.getCode() == 0 && defDocBy.getData() != null) {
            projectPartVO.setContractTypeName(defDocBy.getData().getName());
        }
//        projectPartVO.setChangeMny(contractEntity.getBeforeChangeMny());
        projectPartVO.setCwProjectCode(contractEntity.getCwProjectCode());
        projectPartVO.setCwProjectName(contractEntity.getCwProjectName());
        projectPartVO.setCwAccountCode(contractEntity.getCwAccountCode());
        projectPartVO.setCwProjectTypeName(contractEntity.getContractTypeName());
        projectPartVO.setSourceType("施工合同");
        CommonResponse<ProjectPoolSetVO> poolSetVOCommonResponse = projectSetApi.getProjectId(contractEntity.getProjectId());
        if (poolSetVOCommonResponse.getCode() == 0 && poolSetVOCommonResponse.getData() != null) {
            ProjectPoolSetVO projectPoolSetVO = poolSetVOCommonResponse.getData();
            if (projectPoolSetVO.getEngineeringTypeId() != null){
                CommonResponse<DefdocDetailVO> defDocById = defdocApi.getDefDocById(projectPoolSetVO.getEngineeringTypeId());
                if (defDocById.getCode() == 0 && defDocById.getData() != null) {
                    projectPartVO.setContractualModel(projectPoolSetVO.getEngineeringTypeId());
                    projectPartVO.setContractualModelName(defDocById.getData().getName());
                }
            }
            projectPartVO.setProjectType(projectPoolSetVO.getProjectType());

        }
        projectPartVO.setBidSummaryId(contractEntity.getSummaryId());
        CommonResponse<ProjectPartVO> partVOCommonResponse = projectPartApi.saveOrUpdate(projectPartVO);
        if(!partVOCommonResponse.isSuccess()){
//            return CommonResponse.error("生成执行标段失败!");
            logger.info("生成执行标段失败");
        }
        logger.info("执行标段推送结束===============");


        logger.info("推送在建履历开始===============");
        ProjectPartVO partVO = partVOCommonResponse.getData();
        Long summaryId = partVO.getBidSummaryId();
        Long enrollId = partVO.getEnrollId();

        QueryParam queryParam = new QueryParam();
        if (enrollId == null){
            throw new BusinessException("投标数据为空，请联系管理员！");
        }
        queryParam.getParams().put("projectId",new Parameter(QueryParam.EQ, enrollId));
        queryParam.getParams().put("yxzt",new Parameter(QueryParam.EQ, 0));
        CommonResponse<JSONArray> commonResponse = zjllApi.queryListByParam(queryParam);
        if(!commonResponse.isSuccess()){
            throw new BusinessException("在建履历查询失败!");
        }
        JSONArray data = commonResponse.getData();
        List<ZjllVO> zjllVOS = data.toJavaList(ZjllVO.class);
        for (ZjllVO zjllVO : zjllVOS) {
            //关闭历史在建履历
            zjllVO.setYxzt(1);
            zjllVO.setJssj(new Date());
            zjllVO.setXmId(zjllVO.getXmId());
            zjllVO.setChangeId(partVO.getId());
            zjllVO.setChangeType("执行标段");
            zjllApi.updateWrapper(zjllVO);
            //生成新的在建履历
            ZjllVO newZjllVO = new ZjllVO();
            newZjllVO.setXmId(zjllVO.getXmId());
            newZjllVO.setXmName(zjllVO.getXmName());
            newZjllVO.setGwId(zjllVO.getGwId());
            newZjllVO.setGw(zjllVO.getGw());
            newZjllVO.setProjectId(zjllVO.getProjectId());
            newZjllVO.setProjectName(zjllVO.getProjectName());
            newZjllVO.setKssj(new Date());
            newZjllVO.setZt(1);
            newZjllVO.setYxzt(0); //0:是 1 否
            newZjllVO.setSfgs(zjllVO.getSfgs());
            newZjllVO.setOrgId(zjllVO.getOrgId());
            newZjllVO.setOrgName(zjllVO.getOrgName());
            newZjllVO.setTags("在建履历");
            newZjllVO.setRemark("执行标段");
            newZjllVO.setProPid(partVO.getProjectId());
            newZjllVO.setProPname(partVO.getProjectName());
            newZjllVO.setProjectPartId(partVO.getId());
            newZjllVO.setContractId(partVO.getContractId());
            zjllApi.save(newZjllVO);
            logger.info("执行标段写入状态为2到 在建人员履历！");
        }

        logger.info("推送在建履历结束===============");

        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        ContractRegisterEntity entity = service.selectById(billId);
        if (entity.getSupplementFlag() == 1) {
            return CommonResponse.error("补充协议暂不支持回退功能!");
        } else {


            // 合同是否被其他单据引用
            CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
            logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());
            if (res.isSuccess()) {
                // 单据未被下游单据引用
                // 回写合同解除状态
                LambdaUpdateWrapper<ContractRegisterEntity> wrapper = new LambdaUpdateWrapper<>();
                wrapper.set(ContractRegisterEntity::getContractStatus, ContractStatusEnum.未签订.getCode());
                wrapper.eq(BaseEntity::getId, billId);


                //从合同池删除数据
                boolean delResult = service.delContractFromPool(billId);
                if (delResult) {
                    wrapper.set(ContractRegisterEntity::getBillPushFlag, BillPushStatusEnum.未成功推送.getStatus());
                    service.update(wrapper);
                }

                /**
                 * 修改客户库的金额、数量以及等级信息施工合同登记-补充撤回逻辑（客户库、归档状态）
                 */
                CustomerIncomeInfoVO customerInfoVO = service.queryCustomerInfo(entity.getCustomerId());
                customerInfoVO.setCustomerId(entity.getCustomerId());
                CommonResponse<String> stringCommonResponse = customerApi.updateIncomeMny(customerInfoVO);
                logger.info("修改客户信息返回信息:{}", JSON.toJSONString(stringCommonResponse));
                /**
                 * 修改文件评审归档状态
                 */
                if (entity.getReviewId() != null && entity.getIsEstimation() != 1) {
                    LambdaUpdateWrapper<ContractReviewEntity> updateWrapper = new LambdaUpdateWrapper<>();
                    updateWrapper.set(ContractReviewEntity::getFilingFlag, 0);
                    updateWrapper.set(ContractReviewEntity::getFilingId, null);
                    updateWrapper.set(ContractReviewEntity::getFilingDate, null);
                    updateWrapper.eq(ContractReviewEntity::getId, entity.getReviewId());
                    reviewService.update(updateWrapper);
                }
                /**
                 * 修改项目基本信息、项目池中合同开竣工日期
                 */
                //同步项目基本信息
                Boolean b = contractRegisterMapper.updatePlanDate(entity.getProjectId(),
                        null,
                        null,
                        null,
                        null,
                        null,
                        null
                );
                if (b) {
                    logger.info("同步项目基本信息成功！{}", entity.getProjectId());
                } else {
                    logger.info("同步项目基本信息失败！");
                }
                //同步基本信息
                CommonResponse<ProjectPoolSetVO> projectVOCommonResponse = projectSetApi.getProjectId(entity.getProjectId());
                if(projectVOCommonResponse.isSuccess()){
                    logger.info("同步项目池开始！");
                    ProjectPoolSetVO projectPoolSetVO = projectVOCommonResponse.getData();
                    projectPoolSetVO.setPlanStartDate(null);
                    projectPoolSetVO.setPlanEndDate(null);
                    projectPoolSetVO.setPlanDateNum(null);
                    logger.info("同步项目池结束！{}", projectPoolSetVO);

                    projectSetApi.pushProjectPoolSetNoInitial(JSONObject.toJSONString(projectPoolSetVO).getBytes(StandardCharsets.UTF_8));

                }

                //检查是否被财务引用，如果引用则不允许退回，若无引用，删除财务数据
                CommonResponse<List<PMContractVO>> listCommonResponse = contractApi.queryDetail(String.valueOf(billId), entity.getIsEstimation());
                if (listCommonResponse.getCode() == 0) {
                    List<PMContractVO> data = listCommonResponse.getData();
                    for (PMContractVO contractVO : data) {
                        if (contractVO.getYybs() == 1) {//被引用
                            return CommonResponse.error("已被财务系统使用！");
                        }
                    }
//                    CommonResponse<List<String>> updateContract = contractApi.updateContract(String.valueOf(billId), entity.getIsEstimation());
//                    if (updateContract.getCode() != 0) {
//                        return CommonResponse.error("修改财务中间表失败！");
//                    }

                }


                return CommonResponse.success();
            } else {
                return CommonResponse.error(res.getMsg());
            }


        }
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
