package com.ejianc.business.pro.warn;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.pro.income.bean.*;
import com.ejianc.business.pro.income.mapper.ContractRegisterMapper;
import com.ejianc.business.pro.income.service.*;
import com.ejianc.business.pro.income.utils.DateUtil;
import com.ejianc.business.pro.income.vo.BudgetVO;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Select;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/contractWarn/")
public class ContractWarnController {


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String PC_URL = "/ejc-proincome-frontend/#/contractRegister/card?id=";

    private static final String PC_B_URL = "/ejc-share-frontend/#/projectPool/projectPoolCard?id=";

    private static final String PC_C_URL = "/ejc-proincome-frontend/#/costAdjust/card?id=";

    private static final String PC_D_URL = "/ejc-proincome-frontend/#/contractReview/card?id=";

    private static final String PC_E_URL = "/ejc-proincome-frontend/#/claimRecords/card?id=";

    private static final String PC_A_URL = "/ejc-proincome-frontend/#/";

    @Autowired
    private IWarnCenterApi warnCenterApi;

    @Autowired
    private ITenantApi tenantApi;

    @Autowired
    private IContractRegisterService service;
    @Autowired
    private IBudgetService budgetService;
    @Autowired
    private  ICostAdjustService costAdjustService;

    @Autowired
    private IContractReviewService contractReviewService;

    @Autowired
    private IClaimService claimService;

    @Autowired
    private IClaimRecordsService claimRecordsService;

    @Autowired
    private IDutyApi dutyApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICostAdjustService cent;
    @Autowired
    private ContractRegisterMapper mapper;
    @Autowired
    private IProjectPoolApi projectSetApi;

    @PostMapping(value = "budgetWarnExecute")
    public CommonResponse<String> budgetWarnExecute(@RequestBody JSONArray jsonParam) {
        logger.info("接收到Task参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;

        for (int i = 0; i < jsonParam.size(); i++) {//循环每个租户数据
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
//            1、根据租户合同纬度，查询合同
//            2、根据合同的单据所属组织，找到对应的预警设置，也就是这条合同适用于那个设置
//            3、根据预警设置判断该合同数据属于哪个等级
//            4、符合等级，则拼接预警数据，并保存到list
//            5、发送数据
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
            List<Integer> billStatus = new ArrayList<>();
            billStatus.add(1);
            billStatus.add(3);
            param.getParams().put("bill_state", new Parameter(QueryParam.IN, billStatus));
            param.getParams().put("supplement_flag", new Parameter(QueryParam.EQ, 0));
            List<ContractRegisterEntity> contractEntities = service.queryList(param);
            if (ListUtil.isNotEmpty(contractEntities)) {
                for (ContractRegisterEntity contractEntity : contractEntities) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = contractEntity.getOrgId();
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if(orgVO==null){
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的innerCode进行父级查找
                     * */
                    logger.info("parentIds______"+innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0 ; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if(orgSet!=null){
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0 ; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }

                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
                        /** 查询该合同有无项目预算书 */
                        QueryParam param1 = new QueryParam();
                        param1.getParams().put("contractId", new Parameter(QueryParam.EQ, contractEntity.getId()));
                        param1.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
                        List<BudgetEntity> list = budgetService.queryList(param1);

                        /** 间隔天数 */
                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");

                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;
                        /*BigDecimal overAmtHigh = null;
                        BigDecimal overAmtMeddle = null;
                        BigDecimal overAmtLow = null;*/


                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            if ("高".equals(set.getString("warningLevel"))) {
                                BigDecimal parameterValue = set.getBigDecimal("parameterValue");
                                if (CollectionUtils.isEmpty(list) && DateUtil.getBetweenDays(new Date(),contractEntity.getSignDate()) > new Integer(parameterValue.toString())) {
                                    //overAmtHigh = set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractMoney);
                                    high = true;
                                    useSetHigh = set;
                                }
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                BigDecimal parameterValue = set.getBigDecimal("parameterValue");
                                if (CollectionUtils.isEmpty(list) && DateUtil.getBetweenDays(new Date(),contractEntity.getSignDate()) > new Integer(parameterValue.toString())) {
                                    //overAmtMeddle = set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractMoney);
                                    meddle = true;
                                    useSetMeddle = set;
                                }
                            }
                            if ("低".equals(set.getString("warningLevel"))) {
                                BigDecimal parameterValue = set.getBigDecimal("parameterValue");
                                if (CollectionUtils.isEmpty(list) && DateUtil.getBetweenDays(new Date(),contractEntity.getSignDate()) > new Integer(parameterValue.toString())) {
                                    //overAmtLow = set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractMoney);
                                    low = true;
                                    useSetLow = set;
                                }
                            }
                        }
                        //DecimalFormat df = new DecimalFormat("###,##0.00");
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName(orgSet.getString("moduleName") + "-" + contractEntity.getBillCode());
                            vo.setPcTitle("施工合同");
                            vo.setPcUrl(PC_URL + contractEntity.getId());
                            vo.setOrgId(contractEntity.getOrgId());
                            vo.setSendOrgId(contractEntity.getOrgId()+"");
                            vo.setOrgName(contractEntity.getOrgName());
                            vo.setSourceId(contractEntity.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#contractName#", contractEntity.getContractName())
                                                .replaceAll("#signDate#", sdf.format(contractEntity.getSignDate()))
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#contractName#", contractEntity.getContractName())
                                                .replaceAll("#signDate#", sdf.format(contractEntity.getSignDate()))
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#contractName#", contractEntity.getContractName())
                                                .replaceAll("#signDate#", sdf.format(contractEntity.getSignDate()))
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }

        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if(!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }

        return CommonResponse.success("任务接受处理成功！");
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenter(warnList, warnId);
        if(!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }

        return CommonResponse.success("任务接受处理成功！");
    }

    private List<EarlyWarnTransVO> transToWarnVO(List<Map<String, Object>> result, JSONObject defaultWarnInfo) {
        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for(Map<String, Object> m : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName((null != defaultWarnInfo.get("categoryName") ? defaultWarnInfo.get("categoryName").toString() + " - " : "")  + m.get("contractCode").toString());
            vo.setPcTitle("施工合同");
            vo.setPcUrl(PC_URL + m.get("contractId").toString());
            vo.setOrgId(Long.valueOf(m.get("orgId").toString()));
            vo.setOrgName(m.get("orgName").toString());
            vo.setSourceId(m.get("contractId").toString());
            vo.setTenantId(Long.valueOf(m.get("tenantId").toString()));
            vo.setWarnLevel(m.get("warnLevel").toString());
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));


            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(
                    tmpContent.replaceAll("#contractName#", m.get("contractName").toString())
                            .replaceAll("#signDate#", m.get("signDate").toString())
            );

            resp.add(vo);
        }

        logger.info("发送预警参数：{}", JSON.toJSONString(resp));
        return resp;
    }

    @PostMapping(value = "costWarnExecute")
    public CommonResponse<String> costWarnExecute(@RequestBody JSONArray jsonParam) {
        logger.info("接收到Task参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;

        CommonResponse<List<Map<String, Object>>> duty = dutyApi.queryDuty();
        if (!duty.isSuccess()){
            logger.error("查询目标责任成本失败！！");
            return CommonResponse.error("查询目标责任成本失败！");
        }
        logger.info("目标责任成本信息"+JSONObject.toJSONString(duty.getData()));
        Map<Object, Map<String, Object>> dutyMap = duty.getData().stream().collect(Collectors.toMap(e -> e.get("projectId"), Function.identity()));
        logger.info("目标责任成本Map信息"+JSONObject.toJSONString(dutyMap));

        for (int i = 0; i < jsonParam.size(); i++) {//循环每个租户数据
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
//            1、根据租户合同纬度，查询合同
//            2、根据合同的单据所属组织，找到对应的预警设置，也就是这条合同适用于那个设置
//            3、根据预警设置判断该合同数据属于哪个等级
//            4、符合等级，则拼接预警数据，并保存到list
//            5、发送数据
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
            List<Integer> billStatus = new ArrayList<>();
            billStatus.add(1);
            billStatus.add(3);
            param.getParams().put("bill_state", new Parameter(QueryParam.IN, billStatus));
            param.getParams().put("supplement_flag", new Parameter(QueryParam.EQ, 0));
            List<ContractRegisterEntity> contractEntities = service.queryList(param);
            if (ListUtil.isNotEmpty(contractEntities)) {
                for (ContractRegisterEntity contractEntity : contractEntities) {
                    if (null == contractEntity.getProjectId()){
                        continue;
                    }
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = contractEntity.getOrgId();
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if(orgVO==null){
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的innerCode进行父级查找
                     * */
                    logger.info("parentIds______"+innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0 ; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if(orgSet!=null){
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0 ; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }

                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {

                        Map<String, Object> map = dutyMap.get(contractEntity.getProjectId().toString());
                        logger.info("目标责任成本Map信息"+JSONObject.toJSONString(map));
                        if (null != map){
                            logger.info("costCount ===== "+JSONObject.toJSONString(Integer.parseInt(map.get("costCount").toString())));
                        }


                        /** 间隔天数 */
                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");

                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;
                        /*BigDecimal overAmtHigh = null;
                        BigDecimal overAmtMeddle = null;
                        BigDecimal overAmtLow = null;*/

                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            if ("高".equals(set.getString("warningLevel"))) {
                                BigDecimal parameterValue = set.getBigDecimal("parameterValue");
                                if ((null == map || Integer.parseInt(map.get("costCount").toString()) == 0) && DateUtil.getBetweenDays(new Date(),contractEntity.getSignDate()) > new Integer(parameterValue.toString())) {
                                    //overAmtHigh = set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractMoney);
                                    high = true;
                                    useSetHigh = set;
                                }
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                BigDecimal parameterValue = set.getBigDecimal("parameterValue");
                                if ((null == map || Integer.parseInt(map.get("costCount").toString()) == 0) && DateUtil.getBetweenDays(new Date(),contractEntity.getSignDate()) > new Integer(parameterValue.toString())) {
                                    //overAmtMeddle = set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractMoney);
                                    meddle = true;
                                    useSetMeddle = set;
                                }
                            }
                            if ("低".equals(set.getString("warningLevel"))) {
                                BigDecimal parameterValue = set.getBigDecimal("parameterValue");
                                if ((null == map || Integer.parseInt(map.get("costCount").toString()) == 0) && DateUtil.getBetweenDays(new Date(),contractEntity.getSignDate()) > new Integer(parameterValue.toString())) {
                                    //overAmtLow = set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractMoney);
                                    low = true;
                                    useSetLow = set;
                                }
                            }
                        }
                        //DecimalFormat df = new DecimalFormat("###,##0.00");
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName(orgSet.getString("moduleName") + "-" + contractEntity.getBillCode());
                            vo.setPcTitle("施工合同");
                            vo.setPcUrl(PC_URL + contractEntity.getId());
                            vo.setOrgId(contractEntity.getOrgId());
                            vo.setSendOrgId(contractEntity.getOrgId()+"");
                            vo.setOrgName(contractEntity.getOrgName());
                            vo.setSourceId(contractEntity.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#contractName#", contractEntity.getContractName())
                                                .replaceAll("#signDate#", sdf.format(contractEntity.getSignDate()))
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#contractName#", contractEntity.getContractName())
                                                .replaceAll("#signDate#", sdf.format(contractEntity.getSignDate()))
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#contractName#", contractEntity.getContractName())
                                                .replaceAll("#signDate#", sdf.format(contractEntity.getSignDate()))
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }

        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if(!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }

        return CommonResponse.success("任务接受处理成功！");

    }

    @PostMapping(value = "contractRegisterWarnExecute")
    public CommonResponse<String> contractRegisterWarnExecute(@RequestBody JSONArray jsonParam) {
        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            // 1、根据租户合同纬度，查询合同
            // 2、根据合同的单据所属组织，找到对应的预警设置，也就是这条合同适用于那个设置
            // 3、根据预警设置判断该合同数据属于哪个等级
            // 4、符合等级，则拼接预警数据，并保存到 list
            // 5、发送数据
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
            List<Integer> billStatus = new ArrayList<>();
            billStatus.add(1);
            billStatus.add(3);
            param.getParams().put("bill_state", new Parameter(QueryParam.IN, billStatus));
            param.getParams().put("supplement_flag", new Parameter(QueryParam.EQ, 0));
            List<ContractRegisterEntity> contractEntities = service.queryList(param);
            if (ListUtil.isNotEmpty(contractEntities)) {
                for (ContractRegisterEntity contractEntity : contractEntities) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = contractEntity.getOrgId();
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if (orgVO == null) {
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的 innerCode 进行父级查找
                     * */
                    logger.info("parentIds______" + innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if (orgSet != null) {
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
                        /** 查询该合同结算金额累计 */
                        QueryParam param1 = new QueryParam();
                        param1.getParams().put("contractId", new Parameter(QueryParam.EQ,
                                contractEntity.getId()));
                        param1.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
                        List<CostAdjustEntity> list =
                                cent.queryList(param1);
                        BigDecimal settlement = new BigDecimal("0.00");
                        if (ListUtil.isNotEmpty(list)) {
                            for (CostAdjustEntity entity : list) {
                                settlement = settlement.add(entity.getApplyChangeMny());
                            }
                        }
                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;
                        BigDecimal overAmtHigh = null;
                        BigDecimal overAmtMeddle = null;
                        BigDecimal overAmtLow = null;
                        BigDecimal contractMoney = contractEntity.getNotIncludeProvisionalMny() == null ? new
                                BigDecimal("0.00") : contractEntity.getNotIncludeProvisionalMny();
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            if ("高".equals(set.getString("warningLevel"))) {
                                if (set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractMoney).compareTo(settlement) < 1) {
                                    overAmtHigh = set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractMoney);
                                    high = true;
                                    useSetHigh = set;
                                }
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                if (set.getBigDecimal("parameterValue").divide(new
                                        BigDecimal("100")).multiply(contractMoney).compareTo(settlement) < 1) {
                                    overAmtMeddle = set.getBigDecimal("parameterValue").divide(new
                                            BigDecimal("100")).multiply(contractMoney);
                                    meddle = true;
                                    useSetMeddle = set;
                                }
                            }
                            if ("低".equals(set.getString("warningLevel"))) {
                                if (set.getBigDecimal("parameterValue").divide(new
                                        BigDecimal("100")).multiply(contractMoney).compareTo(settlement) < 1) {
                                    overAmtLow = set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractMoney);
                                    low = true;
                                    useSetLow = set;
                                }
                            }
                        }
                        DecimalFormat df = new DecimalFormat("###,##0.00");
                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName(orgSet.getString("moduleName") + "-" +
                                    contractEntity.getBillCode());
                            vo.setPcTitle("施工合同");
                            vo.setPcUrl(PC_URL + contractEntity.getId());
                            vo.setOrgId(contractEntity.getOrgId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(contractEntity.getOrgId() + "");
                            vo.setOrgName(contractEntity.getOrgName());
                            vo.setSourceId(contractEntity.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#contractName#",
                                                contractEntity.getContractName())
                                                .replaceAll("#totalApplyChangeMny#", df.format(settlement))
                                                .replaceAll("#notIncludeProvisionalMny#", df.format(contractMoney))
                                                .replaceAll("#percent#",
                                                        useSetHigh.getString("parameterValue"))
                                                .replaceAll("#overAmt#", df.format(overAmtHigh))
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#contractName#",
                                                contractEntity.getContractName())
                                                .replaceAll("#totalApplyChangeMny#", df.format(settlement))
                                                .replaceAll("#notIncludeProvisionalMny#", df.format(contractMoney))
                                                .replaceAll("#percent#", useSetMeddle.getString("parameterValue"))
                                                .replaceAll("#overAmt#", df.format(overAmtMeddle))
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#contractName#",
                                                contractEntity.getContractName())
                                                .replaceAll("#totalApplyChangeMny#", df.format(settlement))
                                                .replaceAll("#notIncludeProvisionalMny#", df.format(contractMoney))
                                                .replaceAll("#percent#",
                                                        useSetLow.getString("parameterValue"))
                                                .replaceAll("#overAmt#", df.format(overAmtLow))
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
      return sendWarnToTask(warnList,warnCode);
    }

    @PostMapping(value = "settleReportWarnExecute")
    public CommonResponse<String> settleReportWarnExecute(@RequestBody JSONArray jsonParam) {
        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            // 1、根据租户合同纬度，查询合同
            // 2、根据合同的单据所属组织，找到对应的预警设置，也就是这条合同适用于那个设置
            // 3、根据预警设置判断该合同数据属于哪个等级
            // 4、符合等级，则拼接预警数据，并保存到 list
            // 5、发送数据
            List<ContractRegisterVO> contractVOS = mapper.querySettleReportWarnContract(tenantId);
            if (ListUtil.isNotEmpty(contractVOS)) {
                for (ContractRegisterVO cvo : contractVOS) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = cvo.getOrgId();
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if (orgVO == null) {
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的 innerCode 进行父级查找
                     * */
                    logger.info("parentIds______" + innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if (orgSet != null) {
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            if ("高".equals(set.getString("warningLevel"))) {
                                if (cvo.getDays().compareTo(set.getBigDecimal("parameterValue")) > -1) {
                                    high = true;
                                    useSetHigh = set;
                                }
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                if (cvo.getDays().compareTo(set.getBigDecimal("parameterValue")) > -1) {
                                    meddle = true;
                                    useSetMeddle = set;
                                }
                            }
                            if ("低".equals(set.getString("warningLevel"))) {
                                if (cvo.getDays().compareTo(set.getBigDecimal("parameterValue")) > -1) {
                                    low = true;
                                    useSetLow = set;
                                }
                            }
                        }
                        DecimalFormat df = new DecimalFormat("###,##0.00");
                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName(orgSet.getString("moduleName") + "-" +
                                    cvo.getBillCode());
                            vo.setPcTitle("施工合同");
                            vo.setPcUrl(PC_URL + cvo.getId());
                            vo.setOrgId(cvo.getOrgId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(cvo.getOrgId() + "");
                            vo.setOrgName(cvo.getOrgName());
                            vo.setSourceId(cvo.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#contractName#", cvo.getContractName())
                                                .replaceAll("#days#", df.format(cvo.getDays()))
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#contractName#", cvo.getContractName())
                                                .replaceAll("#days#", df.format(cvo.getDays()))
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#contractName#", cvo.getContractName())
                                                .replaceAll("#days#", df.format(cvo.getDays()))
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
        return sendWarnToTask(warnList,warnCode);
    }

    @PostMapping(value = "finalizedWarnExecute")
    public CommonResponse<String> finalizedWarnExecute(@RequestBody JSONArray jsonParam) {
        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            // 1、根据租户合同纬度，查询合同
            // 2、根据合同的单据所属组织，找到对应的预警设置，也就是这条合同适用于那个设置
            // 3、根据预警设置判断该合同数据属于哪个等级
            // 4、符合等级，则拼接预警数据，并保存到 list
            // 5、发送数据
            List<ContractRegisterVO> contractVOS = mapper.queryFinalizedWarnContract(tenantId);
            if (ListUtil.isNotEmpty(contractVOS)) {
                for (ContractRegisterVO cvo : contractVOS) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = cvo.getOrgId();
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if (orgVO == null) {
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的 innerCode 进行父级查找
                     * */
                    logger.info("parentIds______" + innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if (orgSet != null) {
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            if ("高".equals(set.getString("warningLevel"))) {
                                if (cvo.getDays().compareTo(set.getBigDecimal("parameterValue")) > -1) {
                                    high = true;
                                    useSetHigh = set;
                                }
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                if (cvo.getDays().compareTo(set.getBigDecimal("parameterValue")) > -1) {
                                    meddle = true;
                                    useSetMeddle = set;
                                }
                            }
                            if ("低".equals(set.getString("warningLevel"))) {
                                if (cvo.getDays().compareTo(set.getBigDecimal("parameterValue")) > -1) {
                                    low = true;
                                    useSetLow = set;
                                }
                            }
                        }
                        DecimalFormat df = new DecimalFormat("###,##0.00");
                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName(orgSet.getString("moduleName") + "-" +
                                    cvo.getBillCode());
                            vo.setPcTitle("施工合同");
                            vo.setPcUrl(PC_URL + cvo.getId());
                            vo.setOrgId(cvo.getOrgId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(cvo.getOrgId() + "");
                            vo.setOrgName(cvo.getOrgName());
                            vo.setSourceId(cvo.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#contractName#", cvo.getContractName())
                                                .replaceAll("#days#", df.format(cvo.getDays()))
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#contractName#", cvo.getContractName())
                                                .replaceAll("#days#", df.format(cvo.getDays()))
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#contractName#", cvo.getContractName())
                                                .replaceAll("#days#", df.format(cvo.getDays()))
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
        return sendWarnToTask(warnList,warnCode);
    }

    @PostMapping(value = "budgetInWarnExecute")
    public CommonResponse<String> budgetInWarnExecute(@RequestBody JSONArray jsonParam) {
        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;
        List<ProjectPoolSetVO> proList = new ArrayList<>();
        CommonResponse<JSONArray> resp = projectSetApi.queryProjectPoolList(null,null,null);
        if(resp.isSuccess()){
            proList = JSONArray.parseArray(JSONObject.toJSONString(resp.getData()), ProjectPoolSetVO.class);
        } else {
            logger.error(resp.getMsg());
        }
        if (CollectionUtils.isEmpty(proList)){
            return CommonResponse.success();
        }
        Map<Long, List<ProjectPoolSetVO>> projectMap = proList.stream().collect(Collectors.groupingBy(ProjectPoolSetVO::getTenantId));
        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            // 1、根据租户合同纬度，查询合同
            // 2、根据合同的单据所属组织，找到对应的预警设置，也就是这条合同适用于那个设置
            // 3、根据预警设置判断该合同数据属于哪个等级
            // 4、符合等级，则拼接预警数据，并保存到 list
            // 5、发送数据
            if (!projectMap.containsKey(tenantId)){
                continue;
            }
            List<ProjectPoolSetVO> projectList = projectMap.get(tenantId);
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
            List<Integer> billStatus = new ArrayList<>();
            billStatus.add(1);
            billStatus.add(3);
            param.getParams().put("bill_state", new Parameter(QueryParam.IN, billStatus));
            List<BudgetEntity> budgetEntities = budgetService.queryList(param);
            List<BudgetVO> budgetVOS = BeanMapper.mapList(budgetEntities, BudgetVO.class);
            List<ProjectPoolSetVO> resultList = projectList.stream().filter(
                    (ProjectPoolSetVO) -> !budgetVOS.stream().map(BudgetVO::getProjectId).collect(Collectors.toList()).contains(ProjectPoolSetVO.getId()) && ProjectPoolSetVO.getProjectDate()!=null
            ).collect(Collectors.toList());
            if (ListUtil.isNotEmpty(resultList)) {
                for (ProjectPoolSetVO pvo : resultList) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = pvo.getProjectDepartmentId();
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if (orgVO == null) {
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的 innerCode 进行父级查找
                     * */
                    logger.info("parentIds______" + innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if (orgSet != null) {
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            if ("高".equals(set.getString("warningLevel"))) {
                                if (new BigDecimal(DateUtil.getBetweenDays(new Date(),pvo.getProjectDate()).toString()).compareTo(set.getBigDecimal("parameterValue")) > -1) {
                                    high = true;
                                    useSetHigh = set;
                                }
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                if (new BigDecimal(DateUtil.getBetweenDays(new Date(),pvo.getProjectDate()).toString()).compareTo(set.getBigDecimal("parameterValue")) > -1) {
                                    meddle = true;
                                    useSetMeddle = set;
                                }
                            }
                            if ("低".equals(set.getString("warningLevel"))) {
                                if (new BigDecimal(DateUtil.getBetweenDays(new Date(),pvo.getProjectDate()).toString()).compareTo(set.getBigDecimal("parameterValue")) > -1) {
                                    low = true;
                                    useSetLow = set;
                                }
                            }
                        }
                        DecimalFormat df = new DecimalFormat("###,##0.00");
                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName("项目" + "-" +
                                    pvo.getCode());
                            vo.setPcTitle("施工合同");
                            vo.setPcUrl(PC_B_URL + pvo.getId());
                            vo.setOrgId(pvo.getProjectDepartmentId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(pvo.getProjectDepartmentId() + "");
                            vo.setOrgName(orgVO.getName());
                            vo.setSourceId(pvo.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            BigDecimal days = new BigDecimal(DateUtil.getBetweenDays(new Date(),pvo.getProjectDate()).toString());
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", pvo.getName())
                                                .replaceAll("#days#", df.format(days))
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", pvo.getName())
                                                .replaceAll("#days#", df.format(days))
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", pvo.getName())
                                                .replaceAll("#days#", df.format(days))
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
        return sendWarnToTask(warnList,warnCode);
    }

    @PostMapping(value = "costAdjustWarnExecute")
    public CommonResponse<String> costAdjustWarnExecute(@RequestBody JSONArray jsonParam) {
        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            // 1、根据租户合同纬度，查询合同
            // 2、根据合同的单据所属组织，找到对应的预警设置，也就是这条合同适用于那个设置
            // 3、根据预警设置判断该合同数据属于哪个等级
            // 4、符合等级，则拼接预警数据，并保存到 list
            // 5、发送数据

            SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

            Calendar calendar=new GregorianCalendar();

            String endTime=sdf.format(calendar.getTime());

            calendar.add(calendar.DATE,-3);//把日期往后增加一天.整数往后推,负数往前移动

            String startTime=sdf.format(calendar.getTime());
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
            List<Integer> billStatus = new ArrayList<>();
            billStatus.add(1);
            billStatus.add(3);
            param.getParams().put("bill_state", new Parameter(QueryParam.IN, billStatus));
            param.getParams().put("create_time", new Parameter(QueryParam.BETWEEN,
                    startTime+","+endTime ));
            List<CostAdjustEntity> costAdjustEntities = costAdjustService.queryList(param);

            if (ListUtil.isNotEmpty(costAdjustEntities)) {
                for (CostAdjustEntity costAdjustEntity : costAdjustEntities) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = costAdjustEntity.getOrgId();
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if (orgVO == null) {
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的 innerCode 进行父级查找
                     * */
                    logger.info("parentIds______" + innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if (orgSet != null) {
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
                        /** 查询该合同 合同金额-暂列金额*/
                        ContractRegisterEntity contractRegisterEntity = service.selectById(costAdjustEntity.getContractId());
                        //notIncludeProvisionalMny 施工合同金额(不含暂列金额)


                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);

                            logger.info("施工合同金额(不含暂列金额)乘以管控值为{}",set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractRegisterEntity.getNotIncludeProvisionalMny()));
                            logger.info("工程造价申请金额为{}",costAdjustEntity.getApplyChangeMny());

                            if ("高".equals(set.getString("warningLevel"))) {
                                if (set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractRegisterEntity.getNotIncludeProvisionalMny())
                                        .compareTo(costAdjustEntity.getApplyChangeMny()) < 1) {
                                    high = true;
                                    useSetHigh = set;
                                }
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                if (set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractRegisterEntity.getNotIncludeProvisionalMny())
                                        .compareTo(costAdjustEntity.getApplyChangeMny()) < 1) {
                                    meddle = true;
                                    useSetMeddle = set;
                                }
                            }
                            if ("低".equals(set.getString("warningLevel"))) {
                                if (set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractRegisterEntity.getNotIncludeProvisionalMny())
                                        .compareTo(costAdjustEntity.getApplyChangeMny()) < 1) {
                                    low = true;
                                    useSetLow = set;
                                }
                            }
                        }

                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName(orgSet.getString("moduleName") + "-" +
                                    costAdjustEntity.getBillCode());
                            vo.setPcTitle("施工合同-工程造价调整");
                            vo.setPcUrl(PC_C_URL + costAdjustEntity.getId());
                            vo.setOrgId(costAdjustEntity.getOrgId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(costAdjustEntity.getOrgId() + "");
                            vo.setOrgName(costAdjustEntity.getOrgName());
                            vo.setSourceId(costAdjustEntity.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#project#",
                                                costAdjustEntity.getProjectName())
                                                .replaceAll("#contract#",
                                                        costAdjustEntity.getContractName())
                                                .replaceAll("#percent#",
                                                        useSetHigh.getString("parameterValue"))
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#project#",
                                                costAdjustEntity.getProjectName())
                                                .replaceAll("#contract#",
                                                        costAdjustEntity.getContractName())
                                                .replaceAll("#percent#",
                                                        useSetHigh.getString("parameterValue"))
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#project#",
                                                costAdjustEntity.getProjectName())
                                                .replaceAll("#contract#",
                                                        costAdjustEntity.getContractName())
                                                .replaceAll("#percent#",
                                                        useSetHigh.getString("parameterValue"))
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
        return sendWarnToTask(warnList,warnCode);
    }

    /**
     * 签证、变更、索赔 未甲方批复
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "claimWarnExecute")
    public CommonResponse<String> claimWarnExecute(@RequestBody JSONArray jsonParam) {
        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;

        Integer day = 30;
        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");

            // 1、根据租户合同纬度，查询合同
            // 2、根据合同的单据所属组织，找到对应的预警设置，也就是这条合同适用于那个设置
            // 3、根据预警设置判断该合同数据属于哪个等级
            // 4、符合等级，则拼接预警数据，并保存到 list
            // 5、发送数据


            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
            List<Integer> billStatus = new ArrayList<>();
            billStatus.add(1);
            billStatus.add(3);
            param.getParams().put("bill_state", new Parameter(QueryParam.IN, billStatus));
            param.getParams().put("reply_status", new Parameter(QueryParam.EQ, 0));
            param.getParams().put("is_replay_bill", new Parameter(QueryParam.EQ, 0));

            List<ClaimEntity> claimEntities = claimService.queryList(param);

            if (ListUtil.isNotEmpty(claimEntities)) {
                for (ClaimEntity costAdjustEntity : claimEntities) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = costAdjustEntity.getOrgId();
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if (orgVO == null) {
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的 innerCode 进行父级查找
                     * */
                    logger.info("parentIds______" + innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if (orgSet != null) {
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {

                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;


                        Date now = new Date();
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);

                            day = set.getBigDecimal("parameterValue").intValue();


                            if ("高".equals(set.getString("warningLevel"))) {
                                if ((now.getTime() - costAdjustEntity.getSubmitDate().getTime()) / (1000 * 60 * 60 * 24) >= day) {
                                    high = true;
                                    useSetHigh = set;
                                }
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                if ((now.getTime() - costAdjustEntity.getSubmitDate().getTime()) / (1000 * 60 * 60 * 24) >= day) {
                                    meddle = true;
                                    useSetMeddle = set;
                                }
                            }
                            if ("低".equals(set.getString("warningLevel"))) {
                                if ((now.getTime() - costAdjustEntity.getSubmitDate().getTime()) / (1000 * 60 * 60 * 24) >= day) {
                                    low = true;
                                    useSetLow = set;
                                }
                            }
                        }

                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName(orgSet.getString("moduleName") + "-" +
                                    costAdjustEntity.getBillCode());
                            vo.setPcTitle("施工合同-二次经营");
                            String url = PC_A_URL;
                            if ("QZ".equals(costAdjustEntity.getBillType())){
                                url = url+"visa/card?id=";
                            }else if("QS".equals(costAdjustEntity.getBillType())){
                                url = url+"negotiate/card?id=";
                            }else if("SP".equals(costAdjustEntity.getBillType())){
                                url = url+"claim/card?id=";
                            }
                            vo.setPcUrl(url + costAdjustEntity.getId());
                            vo.setOrgId(costAdjustEntity.getOrgId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(costAdjustEntity.getOrgId() + "");
                            vo.setOrgName(costAdjustEntity.getOrgName());
                            vo.setSourceId(costAdjustEntity.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#project#",
                                                costAdjustEntity.getProjectName())
                                                .replaceAll("#contract#",
                                                        costAdjustEntity.getContractName())
                                                .replaceAll("#day#",
                                                        day.toString())
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#project#",
                                                costAdjustEntity.getProjectName())
                                                .replaceAll("#contract#",
                                                        costAdjustEntity.getContractName())
                                                .replaceAll("#day#",
                                                        day.toString())
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#project#",
                                                costAdjustEntity.getProjectName())
                                                .replaceAll("#contract#",
                                                        costAdjustEntity.getContractName())
                                                .replaceAll("#day#",
                                                        day.toString())
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
        return sendWarnToTask(warnList,warnCode);
    }

    /**
     * 施工合同评审通过后，X天未返还
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "contractReviewWarnExecute")
    public CommonResponse<String> contractReviewWarnExecute(@RequestBody JSONArray jsonParam) {
        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;

        Integer day = 15;
        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");

            // 1、根据租户合同纬度，查询合同
            // 2、根据合同的单据所属组织，找到对应的预警设置，也就是这条合同适用于那个设置
            // 3、根据预警设置判断该合同数据属于哪个等级
            // 4、符合等级，则拼接预警数据，并保存到 list
            // 5、发送数据


            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
            List<Integer> billStatus = new ArrayList<>();
            billStatus.add(1);
            billStatus.add(3);
            param.getParams().put("bill_state", new Parameter(QueryParam.IN, billStatus));
            param.getParams().put("filing_flag", new Parameter(QueryParam.EQ, 0));

            List<ContractReviewEntity> contractReviewEntities = contractReviewService.queryList(param);

            if (ListUtil.isNotEmpty(contractReviewEntities)) {
                for (ContractReviewEntity costAdjustEntity : contractReviewEntities) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = costAdjustEntity.getOrgId();
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if (orgVO == null) {
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的 innerCode 进行父级查找
                     * */
                    logger.info("parentIds______" + innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if (orgSet != null) {
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {

                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;

                        Date now = new Date();
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);

                            day = set.getBigDecimal("parameterValue").intValue();

                            if ("高".equals(set.getString("warningLevel"))) {
                                if ((now.getTime() - costAdjustEntity.getCreateTime().getTime()) / (1000 * 60 * 60 * 24) >= day) {
                                    high = true;
                                    useSetHigh = set;
                                }
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                if ((now.getTime() - costAdjustEntity.getCreateTime().getTime()) / (1000 * 60 * 60 * 24) >= day) {
                                    meddle = true;
                                    useSetMeddle = set;
                                }
                            }
                            if ("低".equals(set.getString("warningLevel"))) {
                                if ((now.getTime() - costAdjustEntity.getCreateTime().getTime()) / (1000 * 60 * 60 * 24) >= day) {
                                    low = true;
                                    useSetLow = set;
                                }
                            }
                        }

                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName(orgSet.getString("moduleName") + "-" +
                                    costAdjustEntity.getBillCode());
                            vo.setPcTitle("施工合同-施工合同评审");
                            vo.setPcUrl(PC_D_URL + costAdjustEntity.getId());
                            vo.setOrgId(costAdjustEntity.getOrgId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(costAdjustEntity.getOrgId() + "");
                            vo.setOrgName(costAdjustEntity.getOrgName());
                            vo.setSourceId(costAdjustEntity.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#contract#",
                                                        costAdjustEntity.getContractName())
                                                .replaceAll("#day#", day.toString())
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#contract#",
                                                costAdjustEntity.getContractName())
                                                .replaceAll("#day#", day.toString())
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#contract#",
                                                costAdjustEntity.getContractName())
                                                .replaceAll("#day#", day.toString())
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
        return sendWarnToTask(warnList,warnCode);
    }

    /**
     * 一个月没有签证洽商索赔记录
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "claimRecordsWarnExecute")
    public CommonResponse<String> claimRecordsWarnExecute(@RequestBody JSONArray jsonParam) {
        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;

        Integer day = 30;
        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");

            // 1、根据租户合同纬度，查询合同
            // 2、根据合同的单据所属组织，找到对应的预警设置，也就是这条合同适用于那个设置
            // 3、根据预警设置判断该合同数据属于哪个等级
            // 4、符合等级，则拼接预警数据，并保存到 list
            // 5、发送数据


            SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

            Calendar calendar=new GregorianCalendar();

            String endTime=sdf.format(calendar.getTime());

            calendar.add(calendar.DATE,-30);//把日期往后增加一天.整数往后推,负数往前移动

            String startTime=sdf.format(calendar.getTime());

            QueryParam param = new QueryParam();
            param.getParams().put("supplementFlag", new Parameter("eq", 0));
            param.getParams().put("isFinish", new Parameter("eq", 0));
            param.getParams().put("isRelieve", new Parameter("eq", 0));
            param.getParams().put("isSuspend", new Parameter("eq", 0));
            param.getParams().put("create_time", new Parameter(QueryParam.BETWEEN,
                    "2000-01-01 01:01:01,"+startTime ));
            List<Integer> billStatus = new ArrayList<>();
            billStatus.add(1);
            billStatus.add(3);
            param.getParams().put("billState", new Parameter(QueryParam.IN, billStatus));

            List<ContractRegisterEntity> contractRegisterEntities = service.queryList(param);

            logger.info("查找出符合规定的合同个数：{}",contractRegisterEntities.size());

            if (ListUtil.isNotEmpty(contractRegisterEntities)) {
                for (ContractRegisterEntity contractRegisterEntity : contractRegisterEntities) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = contractRegisterEntity.getOrgId();
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if (orgVO == null) {
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的 innerCode 进行父级查找
                     * */
                    logger.info("parentIds______" + innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if (orgSet != null) {
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {

                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;

                        //获取记录的最后一次时间
                        Date lastRecordByContractId = claimRecordsService.getLastRecordByContractId(contractRegisterEntity.getId());


                        Date now = new Date();
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);

                            day = set.getBigDecimal("parameterValue").intValue();

                            if ("高".equals(set.getString("warningLevel"))) {
                                if (lastRecordByContractId == null || (now.getTime() - lastRecordByContractId.getTime()) / (1000 * 60 * 60 * 24) >= day) {
                                    high = true;
                                    useSetHigh = set;
                                }
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                if (lastRecordByContractId == null || (now.getTime() - lastRecordByContractId.getTime()) / (1000 * 60 * 60 * 24) >= day) {
                                    meddle = true;
                                    useSetMeddle = set;
                                }
                            }
                            if ("低".equals(set.getString("warningLevel"))) {
                                if (lastRecordByContractId == null || (now.getTime() - lastRecordByContractId.getTime()) / (1000 * 60 * 60 * 24) >= day) {
                                    low = true;
                                    useSetLow = set;
                                }
                            }
                        }

                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName(orgSet.getString("moduleName") + "-" +
                                    contractRegisterEntity.getBillCode());
                            vo.setPcTitle("施工合同-签证洽商索赔记录");
                            vo.setPcUrl(PC_E_URL + contractRegisterEntity.getId());
                            vo.setOrgId(contractRegisterEntity.getOrgId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(contractRegisterEntity.getOrgId() + "");
                            vo.setOrgName(contractRegisterEntity.getOrgName());
                            vo.setSourceId(contractRegisterEntity.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#contract#",
                                                contractRegisterEntity.getContractName())
                                                .replaceAll("#day#", day.toString())
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#contract#",
                                                contractRegisterEntity.getContractName())
                                                .replaceAll("#day#", day.toString())
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#contract#",
                                                contractRegisterEntity.getContractName())
                                                .replaceAll("#day#", day.toString())
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
        return sendWarnToTask(warnList,warnCode);
    }


    /**
     * 签证洽商索赔记录后，X天没做业务
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "claimRecordsNewWarnExecute")
    public CommonResponse<String> claimRecordsNewWarnExecute(@RequestBody JSONArray jsonParam) {
        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;

        Integer day = 30;
        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");

            // 1、根据租户合同纬度，查询合同
            // 2、根据合同的单据所属组织，找到对应的预警设置，也就是这条合同适用于那个设置
            // 3、根据预警设置判断该合同数据属于哪个等级
            // 4、符合等级，则拼接预警数据，并保存到 list
            // 5、发送数据



            QueryParam param = new QueryParam();
            param.getParams().put("isClose", new Parameter("eq", 0));//未关闭
            param.getParams().put("quoteStatus", new Parameter("eq", 0));//未引用

            List<Integer> billStatus = new ArrayList<>();
            billStatus.add(1);
            billStatus.add(3);
            param.getParams().put("billState", new Parameter(QueryParam.IN, billStatus));

            List<ClaimRecordsEntity> claimRecordsEntities = claimRecordsService.queryList(param);

            logger.info("查找出符合规定的记录个数：{}",claimRecordsEntities.size());

            if (ListUtil.isNotEmpty(claimRecordsEntities)) {
                for (ClaimRecordsEntity claimRecordsEntity : claimRecordsEntities) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = claimRecordsEntity.getOrgId();
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if (orgVO == null) {
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的 innerCode 进行父级查找
                     * */
                    logger.info("parentIds______" + innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if (orgSet != null) {
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {

                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;


                        Date now = new Date();
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);

                            day = set.getBigDecimal("parameterValue").intValue();

                            if ("高".equals(set.getString("warningLevel"))) {
                                if ((now.getTime() - claimRecordsEntity.getRecordDate().getTime()) / (1000 * 60 * 60 * 24) >= day) {
                                    high = true;
                                    useSetHigh = set;
                                }
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                if ( (now.getTime() - claimRecordsEntity.getRecordDate().getTime()) / (1000 * 60 * 60 * 24) >= day) {
                                    meddle = true;
                                    useSetMeddle = set;
                                }
                            }
                            if ("低".equals(set.getString("warningLevel"))) {
                                if ((now.getTime() - claimRecordsEntity.getRecordDate().getTime()) / (1000 * 60 * 60 * 24) >= day) {
                                    low = true;
                                    useSetLow = set;
                                }
                            }
                        }

                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName(orgSet.getString("moduleName") + "-" +
                                    claimRecordsEntity.getBillCode());
                            vo.setPcTitle("施工合同-签证洽商索赔记录");
                            vo.setPcUrl(PC_E_URL + claimRecordsEntity.getId());
                            vo.setOrgId(claimRecordsEntity.getOrgId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(claimRecordsEntity.getOrgId() + "");
                            vo.setOrgName(claimRecordsEntity.getOrgName());
                            vo.setSourceId(claimRecordsEntity.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#contract#",
                                                claimRecordsEntity.getContractName())
                                                .replaceAll("#day#", day.toString())
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#contract#",
                                                claimRecordsEntity.getContractName())
                                                .replaceAll("#day#", day.toString())
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#contract#",
                                                claimRecordsEntity.getContractName())
                                                .replaceAll("#day#", day.toString())
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
        return sendWarnToTask(warnList,warnCode);
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, String warnCode) {
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }
        return CommonResponse.success("任务接受处理成功！");
    }
}
