package com.ejianc.business.pro.income.service.impl;

import com.ejianc.business.pro.income.bean.QuoteEntity;
import com.ejianc.business.pro.income.bean.SettleReportEntity;
import com.ejianc.business.pro.income.service.IQuoteService;
//import com.ejianc.business.sealm.api.IInstoreApi;
//import com.ejianc.business.sealm.vo.YysqVO;
//import com.ejianc.business.sealm.vo.YzdjVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("quote") 
public class QuoteBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IQuoteService service;
	@Autowired
	private SessionManager sessionManager;
//	@Autowired
//	private IInstoreApi iInstoreApi;

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
//		QuoteEntity entity = service.getById(billId);
//		//审批通过对项目用印申请新增一条数据
//		YysqVO yysqVO = new YysqVO();
//		yysqVO.setBidId(billId);  //结算报审id
//		yysqVO.setOrgId(entity.getOrgId());  //组织id
//		yysqVO.setOrgName(entity.getOrgName());  //组织名称
//		yysqVO.setBidCode(entity.getBillCode());  //结算报审编码
//		yysqVO.setYysxId(561210955321589849L);
//		yysqVO.setYysxName("施工合同管理-对甲报量");
//		yysqVO.setYyReason("施工合同-对甲报量-" + entity.getBillCode());  //用印事由
//		yysqVO.setDjlj("/ejc-proincome-frontend/#/quote/card");//单据链接
//		yysqVO.setSqdwId(entity.getOrgId());  //申请单位id
//		yysqVO.setSqdwName(entity.getOrgName());  //申请单位name
//		yysqVO.setSqrId(sessionManager.getUserContext().getUserId());  //负责人id
//		yysqVO.setSqrName(sessionManager.getUserContext().getUserName());  //负责人name
//		yysqVO.setCreateUserCode(entity.getCreateUserCode());  //创建人
//		yysqVO.setCreateUserName(sessionManager.getUserContext().getUserName());  //负责人名称
//		yysqVO.setSqxmId(entity.getProjectId());  // 工程id
//		yysqVO.setSqxmName(entity.getProjectName());  // 工程名称
//		//审批通过的都是集团公章,所以，印章类别是实体章，印章级别是集团，用印类型是集团公章
//		//因为设计时，印章类别，印章级别，用印类型都是自定义档案，所以ID很长
//		CommonResponse<YzdjVO> yzdjVOCommonResponse = iInstoreApi.selectYzxxByCode("YZ-001");
//		if (!yzdjVOCommonResponse.isSuccess()) {
//			throw new BusinessException("通过印章编号获取印章登记信息失败！" + yzdjVOCommonResponse);
//		}
//		YzdjVO data = yzdjVOCommonResponse.getData();
//		yysqVO.setYzbhId(data.getId());
//		yysqVO.setYzlbId(data.getYzlbId());
//		yysqVO.setYzlbName(data.getYzlbName());
//		yysqVO.setYzjbId(data.getYzjbId());
//		yysqVO.setYzjbName(data.getYzjbName());
//		yysqVO.setYylxId(data.getYylxId());
//		yysqVO.setYylxName(data.getYylxName());
//		yysqVO.setBillState(3);  //推送数据默认为审批通过的
//		yysqVO.setMessageFrom(1);// 数据来源：0自建，1原始审批单据
//		yysqVO.setZkbmId(1502571153296723970L);//主控部门ID
//		yysqVO.setZkbmName("工程部");//主控部门name
//		yysqVO.setXgcs(0);//修改次数
//
//		CommonResponse<String> yysqBack = iInstoreApi.addYysq(yysqVO);
//		if(!yysqBack.isSuccess()){
//			throw new BusinessException("新增项目用印申请表数据失败，原因：xxxx" + yysqBack);
//		}
//		logger.info("发送结算报审数据：{终审审核完回调}");

		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		QuoteEntity entity = service.selectById(billId);
		//同一个合同只能存在一个自由态或审批中的单据
		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, entity.getContractId()));
		queryParam.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
		List<QuoteEntity> list = service.queryList(queryParam, false);
		if (CollectionUtils.isNotEmpty(list)) {
			throw new BusinessException("当前合同存在非审批通过态的对甲报量，不允许弃审!");
		}
		if(new Integer(1).equals(entity.getReplyStatus())){
			throw new BusinessException("对甲报量已批复，不允许弃审!");
		}
//		// 结算池撤回
//		boolean pool = service.delSettleFromPool(billId);
//		if(!pool){
//			return CommonResponse.error("弃审推送结算池失败");
//		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
