package com.ejianc.business.pro.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.vo.FinalizedVO;
import com.ejianc.business.pro.income.vo.SettleReportHistoryVO;
import com.ejianc.business.pro.income.vo.SettleReportVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.income.mapper.SettleReportMapper;
import com.ejianc.business.pro.income.bean.SettleReportEntity;
import com.ejianc.business.pro.income.service.ISettleReportService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 结算报审
 * 
 * @author generator
 * 
 */
@Service("settleReportService")
public class SettleReportServiceImpl extends BaseServiceImpl<SettleReportMapper, SettleReportEntity> implements ISettleReportService{
    @Autowired
    private IContractRegisterService registerService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISettlePoolApi settlePoolApi;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private IRoleApi roleApi;

    @Autowired
    private IContractRegisterService contractService;

    @Override
    public SettleReportHistoryVO querySettleReportHistory(Long id) {
        ContractRegisterEntity entity = registerService.selectById(id);
        SettleReportHistoryVO vo = new SettleReportHistoryVO();
        vo.setContractId(id);
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setIsFinish(entity.getIsFinish());
        vo.setIsRelieve(entity.getIsRelieve());
        vo.setIsSuspend(entity.getIsSuspend());

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, id));
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        queryParam.getOrderMap().put("reportDate", QueryParam.DESC);
        queryParam.getOrderMap().put("createTime", QueryParam.DESC);
        List<SettleReportEntity> list = super.queryList(queryParam);

        if(CollectionUtils.isEmpty(list)){
            return vo;
        }
        BigDecimal sumReportSettleMny = list.stream().map(SettleReportEntity::getReportSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumReportSettleTaxMny = list.stream().map(SettleReportEntity::getReportSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        vo.setSumReportSettleMny(sumReportSettleMny);// 报审结算总金额
        vo.setSumReportSettleTaxMny(sumReportSettleTaxMny);// 报审结算总金额(含税)
        vo.setReportRecord(BeanMapper.mapList(list, SettleReportVO.class));
        return vo;
    }

    @Override
    public boolean pushSettleToPool(SettleReportVO vo) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        try {
            logger.info("结算单对象 -> 结算池对象自动转换开始-----"+ JSONObject.toJSONString(vo));
            // 对象自动转换
            BeanConvertorUtil.convert(vo, spv);
            logger.info("结算单对象 -> 结算池对象自动转换结束，下面开始手动转换");

            // 个别字段需要手动封装
            convertSettleVOToSettlePoolVO(vo, spv);
            logger.info("推送参数----"+JSONObject.toJSONString(spv));
            CommonResponse<SettlePoolVO> res = settlePoolApi.saveOrUpdateSettle(spv);
            if(res.isSuccess()){
                flag = true;
                logger.info("结算单推送合同池成功---{}", res.getMsg());
            }else {
                logger.error("结算单推送合同池失败！结算单id-{}，{}",vo.getId(), res.getMsg());
            }
        } catch (Exception e) {
            logger.error("结算单推送合同池失败！结算单id-{}", vo.getId(), e);
            throw new BusinessException("结算单推送合同池异常!");
        }
        return flag;
    }

    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        spv.setSourceId(id);
        try {
            logger.info("结算单弃审推送结算池开始,结算单id-{}",id);
            CommonResponse<SettlePoolVO> res = settlePoolApi.deleteSettle(spv);
            if(res.isSuccess()){
                flag = true;
                logger.info("结算单弃审推送合同池成功---{}", res.getMsg());
            }else {
                logger.error("结算单推送合同池失败！结算单id-{}，{}",id, res.getMsg());
            }
        }catch (Exception e){
            logger.error("结算单弃审推送合同池失败！结算单id-{}", id, e);
            throw new BusinessException("结算单弃审推送合同池异常!");
        }
        return flag;
    }

    // 将SettleReportVO转换成settlePoolVO
    private void convertSettleVOToSettlePoolVO(SettleReportVO vo, SettlePoolVO spv) {
        spv.setSourceType("settle_verify");//结算类型
        spv.setId(vo.getId());
        spv.setSourceId(vo.getId());//结算单id
        spv.setId(vo.getId());
        spv.setSettleProperty(1);//属性类别=收入
        spv.setUltimateFlag(0);//是否最终结算=否
        spv.setCreateUserCode(vo.getCreateUserCode());//结算创建者账号
        spv.setCreateTime(vo.getCreateTime());//结算创建时间
        spv.setUpdateUserCode(vo.getUpdateUserCode());//结算修改者账号
        spv.setUpdateTime(vo.getUpdateTime());//结算修改时间
        spv.setBillCodeUrl("/ejc-proincome-frontend/#/settleReport/card?id=" + vo.getId());// 穿透地址
        if(vo.getContractId()!=null){//有合同需要推送的字段
            //查询合同
            ContractRegisterEntity contractEntity = contractService.selectById(vo.getContractId());
            spv.setContractType("contraction");
            spv.setContractFlag(1);//合同标识
            spv.setSupplementFlag(contractEntity.getSupplementFlag());//是否补充写协议
            spv.setMaiContractId(contractEntity.getMainContractId());//原合同id
            spv.setMaiContractName(contractEntity.getMainContractName());//原合同name
            spv.setMaiContractCode(contractEntity.getMainContractCode());//原合同code
            spv.setContractCode(contractEntity.getBillCode());//合同编码
            spv.setPartyaId(contractEntity.getCustomerId());//甲方id
            spv.setPartyaName(contractEntity.getCustomerName());//甲方name
            spv.setPartybId(contractEntity.getSupplierId());//乙方id
            spv.setPartybName(contractEntity.getSupplierName());//乙方name
            spv.setSignDate(contractEntity.getSignDate());//签订日期
            BigDecimal lastTaxMny = BigDecimal.ZERO; // 截止本期累计结算金额
            BigDecimal lastMny = BigDecimal.ZERO; // 截止本期累计结算金额（无税）
            BigDecimal lastTax = BigDecimal.ZERO; // 截止本期累计结算税额
            /*获取除本次累计结算金额*/
            LambdaQueryWrapper<SettleReportEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.orderByDesc(SettleReportEntity::getCreateTime);
            wrapper.in(SettleReportEntity::getBillState, 1,3);
            wrapper.eq(SettleReportEntity::getDr, 0);
            wrapper.eq(SettleReportEntity::getContractId, vo.getContractId());
            wrapper.ne(SettleReportEntity::getId,vo.getId());
            List<SettleReportEntity> list = super.list(wrapper);
            if(CollectionUtils.isNotEmpty(list)){
                for (SettleReportEntity settlementEntity : list) {
                    BigDecimal settTaxMny = settlementEntity.getReportSettleTaxMny()==null?BigDecimal.ZERO:settlementEntity.getReportSettleTaxMny();
                    BigDecimal settMny = settlementEntity.getReportSettleMny()==null?BigDecimal.ZERO:settlementEntity.getReportSettleMny();
                    BigDecimal settTax = settlementEntity.getTax()==null?BigDecimal.ZERO:settlementEntity.getTax();
                    lastTaxMny = lastTaxMny.add(settTaxMny);
                    lastMny = lastMny.add(settMny);
                    lastTax = lastTax.add(settTax);
                }
            }
            spv.setLastTaxMny(lastTaxMny);//截止本期已结算金额（含税，不含本期）
            spv.setLastMny(lastMny);//截止本期已结算金额(无税，不含本期)
            spv.setLastTax(lastTax);//截止本期税额（不含本期）
        }
        logger.info("结算单对象 -> 结算池对象手动转换完成");
    }
    @Value("${msg.anentId}")
    private String anentId;
    @Value("${msg.secret}")
    private String secret;
    @Value("${msg.enUrl}")
    private String enUrl;
    @Value("${msg.settleReport.roleId}")
    private Long roleId;

    @Override
    public boolean sendMsg(List<SettleReportVO> vos) {

        /**
         *  根据角色查找人员
         */
        List<Long> roleIds = new ArrayList<>();
        roleIds.add(roleId);
        CommonResponse<List<RoleUserRelationVO>> roleResp = roleApi.getRoleUser(roleIds, null);
        if(!roleResp.isSuccess()){
            throw new BusinessException("网络异常，获取发送信息角色， 请稍后再试");
        }
        List<RoleUserRelationVO> relationVOS = roleResp.getData();
        List<String> userIds = relationVOS.stream().map(RoleUserRelationVO::getUserId).map(Object::toString).collect(Collectors.toList());

        /**
         * 推送内容：
         * 合同名称：
         * 确认报审金额：（如有多个单据报审金额为累计金额）。
         */
        BigDecimal sumMny = vos.stream().map(SettleReportVO::getReportSettleTaxMny).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        String subject = "【" + vos.get(0).getContractName() + "】共" + vos.size() + "项结算报审已归档";
        String content = "合同名称:【" + vos.get(0).getContractName() + "】" + '\n' +
                "确认报审金额：" + sumMny + "元";
        String detail = "\n共" + vos.size() + "项结算报审已归档,请前往电脑端查看!";
        String pcUrl = "/ejc-proincome-frontend/#/settleReport/card?id=" + vos.get(0).getId();

        /**
         * 发送消息
         */
        for (String userId : userIds) {

            String moUrl = enUrl+"/portal/sso/index?&userid="+userId+
                    "&targeturl="+enUrl+"/ejc-proincome-frontend/#/settleReport/card?id="+vos.get(0).getId();
            PushMsgParameter parameter = new PushMsgParameter();
            List<String> channel = new ArrayList<>();
            channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);//发送企业微信标志
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);//
            String[] receivers = {userId};
            parameter.setReceivers(receivers);// 收信人
            parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
            parameter.setMsgType("notice");//预警消息
            parameter.setSubject(content+detail);// 标题
            parameter.setContent(content+detail);// 内容
            parameter.setPcUrl(pcUrl);// pc端url
            parameter.setMobileUrl(moUrl);// 移动端url
            parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
            parameter.setSendUserId(InvocationInfoProxy.getUserid());
            JSONObject weixineeParams = new JSONObject();
            weixineeParams.put("agentid", anentId);//企业微信应用id
            weixineeParams.put("secret", secret);//企业微信secret
            weixineeParams.put("msgtype", "textcard");
            weixineeParams.put("title", subject);
            weixineeParams.put("description", content);
            weixineeParams.put("url", (enUrl+"/portal/sso/index?&userid="+userId+
                    "&targeturl="+enUrl+"/ejc-proincome-frontend/#/settleReport/card?id="+vos.get(0).getId()));//移动端点击的urlweixineeParams.put("btntxt", "点击查看");
            parameter.setWeixineeParams(weixineeParams);

            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        }
        return true;

    }
}
