package com.ejianc.business.pro.g9.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.constructor.api.INbzzContractApi;
import com.ejianc.business.constructor.vo.NbzzContractVO;
import com.ejianc.business.pro.g9.bean.SettleReportFollowG9Entity;
import com.ejianc.business.pro.g9.bean.SettleReportFollowZiG9Entity;
import com.ejianc.business.pro.g9.bean.SettleReportG9Entity;
import com.ejianc.business.pro.g9.service.ISettleReportFollowG9Service;
import com.ejianc.business.pro.g9.service.ISettleReportG9Service;
import com.ejianc.business.pro.income.bean.SettleReportEntity;
import com.ejianc.business.pro.income.service.ISettleReportService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("settleReportFollowG9") 
public class SettleReportFollowG9BpmServiceImpl implements ICommonBusinessService {

	private final Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private ISettleReportFollowG9Service service;
	@Autowired
	private INbzzContractApi nbzzContractApi;

	@Autowired
	private ISettleReportService settleReportService;
	@Autowired
	private ISettleReportG9Service reportG9Service;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		SettleReportFollowG9Entity entity = service.selectById(billId);
		if (StringUtils.isNotEmpty(entity.getSourceType())){
			if("PM".equals(entity.getSourceType())){
				List<SettleReportFollowZiG9Entity> followZiG9List = entity.getSettleReportFollowZiG9List();
				if (CollectionUtils.isEmpty(followZiG9List)) {
					return CommonResponse.success("处理成功 - 无子单据需要更新");
				}
				// 批量查询所有需要更新的SettleReport
				List<Long> settleIds = followZiG9List.stream()
						.map(SettleReportFollowZiG9Entity::getSettleId)
						.filter(Objects::nonNull)
						.collect(Collectors.toList());
				if (settleIds.isEmpty()) {
					return CommonResponse.success("处理成功 - 无有效settleId");
				}
				Map<Long, SettleReportEntity> settleReportMap = settleReportService.listByIds(settleIds)
						.stream()
						.collect(Collectors.toMap(SettleReportEntity::getId, Function.identity()));

				List<SettleReportEntity> toUpdate = new ArrayList<>();
				for (SettleReportFollowZiG9Entity followZiG9Entity : followZiG9List) {
					Long settleId = followZiG9Entity.getSettleId();
					if (settleId != null) {
						SettleReportEntity settleReport = settleReportMap.get(settleId);
						if (settleReport != null) {
							settleReport.setReportProgress(followZiG9Entity.getReportProgress());
							settleReport.setFollowRemark(followZiG9Entity.getFollowRemark());
							toUpdate.add(settleReport);
						}
					}
				}

				if (!toUpdate.isEmpty()) {
					settleReportService.updateBatchById(toUpdate);
				}
			} else if("G9".equals(entity.getSourceType())){
				// G9类型直接处理
				Long settleId = entity.getSettleId();
				if (settleId == null) {
//					return CommonResponse.error("G9类型单据缺少settleId");
				} else {
					SettleReportG9Entity reportG9Entity = reportG9Service.selectById(settleId);
					if (reportG9Entity == null) {
						return CommonResponse.error("未找到对应的SettleReportG9记录");
					}
					reportG9Entity.setReportProgress(entity.getReportProgress());
					reportG9Service.saveOrUpdate(reportG9Entity);
				}



				CommonResponse<NbzzContractVO> commonResponse = nbzzContractApi.queryDetail(entity.getContractId());
				if (commonResponse.isSuccess()){
					NbzzContractVO data = commonResponse.getData();
					data.setReportProgress(entity.getReportProgress());
					data.setRemark(entity.getFollowRemark());
					nbzzContractApi.saveOrUpdate(data);
				}
			}
			return CommonResponse.success();
		}
		return CommonResponse.error("未找到来源类型！");
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 审批--获取当前节点的审批人---从服务中选择
	 *
	 * @param billId 单据id
	 * @param billTypeCode 单据类型编码
	 * @param sign 节点标志
	 * @return
	 */
	@Override
	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other){
		JSONArray arr = new JSONArray();
		logger.info("sign:{}",sign);

		//根据标识判断是否（）节点
		if ("businessUser".equals(sign)){
			//获取表单详情数据

			SettleReportFollowG9Entity entity = service.selectById(billId);
			Long contractId = entity.getContractId();

			JSONObject jsonObject = new JSONObject();
			QueryParam queryParam = new QueryParam();
			queryParam.getParams().put("id",new Parameter(QueryParam.EQ,contractId));

			if("G9".equals(entity.getSourceType())){
				CommonResponse<JSONArray> commonResponse = nbzzContractApi.queryListByParam(queryParam);


				if(!commonResponse.isSuccess()){
					throw new BusinessException("查询项目失败!");
				}
				JSONArray array = commonResponse.getData();
				List<NbzzContractVO> vos = JSONObject.parseArray(array.toJSONString(), NbzzContractVO.class);

				logger.info("vos:{}",JSONObject.toJSONString(vos));

				NbzzContractVO vo = vos.get(0);
				Long user = vo.getBusinessManager();
				String userName = vo.getBusinessManagerName();

				logger.info("userId:{}",user);
				logger.info("userName:{}",userName);


				jsonObject.put("userId",user);
				jsonObject.put("userName",userName);

				arr.add(jsonObject);
			}


		}
		return CommonResponse.success(arr);
	}
}
