package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.pro.income.bean.ContractHistoryPayNodeEntity;
import com.ejianc.business.pro.income.bean.ContractHistoryPayRemarkEntity;
import com.ejianc.business.pro.income.service.IContractHistoryPayNodeService;
import com.ejianc.business.pro.income.service.IContractHistoryPayRemarkService;
import com.ejianc.business.pro.income.vo.ContractRegisterHistoryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.income.mapper.ContractRegisterHistoryMapper;
import com.ejianc.business.pro.income.bean.ContractRegisterHistoryEntity;
import com.ejianc.business.pro.income.service.IContractRegisterHistoryService;

import java.util.List;

/**
 * 合同登记历史记录
 * 
 * @author generator
 * 
 */
@Service("contractRegisterHistoryService")
public class ContractRegisterHistoryServiceImpl extends BaseServiceImpl<ContractRegisterHistoryMapper, ContractRegisterHistoryEntity> implements IContractRegisterHistoryService{

    @Autowired
    private IContractHistoryPayRemarkService historyPayRemarkService;

    @Autowired
    private IContractHistoryPayNodeService historyPayNodeService;


    @Override
    public ContractRegisterHistoryVO queryDetailByChangeId(Long id) {
        LambdaQueryWrapper<ContractRegisterHistoryEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractRegisterHistoryEntity::getChangeId, id);
        ContractRegisterHistoryEntity entity = this.getOne(wrapper);

        List<ContractHistoryPayRemarkEntity> historyPayRemarkEntity = historyPayRemarkService.list(
                Wrappers.<ContractHistoryPayRemarkEntity>lambdaQuery()
                        .eq(ContractHistoryPayRemarkEntity::getZhuId, entity.getId()));

        List<ContractHistoryPayNodeEntity> historyPayNodeEntity = historyPayNodeService.list(
                Wrappers.<ContractHistoryPayNodeEntity>lambdaQuery()
                        .eq(ContractHistoryPayNodeEntity::getZhuId, entity.getId()));

        entity.setContractHistoryPayRemarkList(historyPayRemarkEntity);
        entity.setContractHistoryPayNodeList(historyPayNodeEntity);

        return BeanMapper.map(entity, ContractRegisterHistoryVO.class);
    }
}
