/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.bean.ProductionEntity;
import com.ejianc.business.pro.income.bean.SettleReportEntity;
import com.ejianc.business.pro.income.service.IFinalizedService;
import com.ejianc.business.pro.income.service.IProductionService;
import com.ejianc.business.pro.income.service.ISettleReportService;
import com.ejianc.business.pro.income.utils.BillTypeCodeEnum;
import com.ejianc.business.pro.income.utils.ValidateUtil;
import com.ejianc.business.pro.income.vo.ProductionVO;
import com.ejianc.business.pro.income.vo.SettleReportHistoryVO;
import com.ejianc.business.pro.income.vo.SettleReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"settleReport"})
public class SettleReportController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ValidateUtil validateUtil;
    private static final String BILL_CODE = "SETTLE_REPORT";
    @Autowired
    private ISettleReportService service;
    @Autowired
    private IProductionService productionService;
    @Autowired
    private IFinalizedService finalizedService;
    @Autowired
    private IProjectSetApi projectSetApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SettleReportVO> saveOrUpdate(@RequestBody SettleReportVO saveOrUpdateVO) {
        SettleReportEntity entity = (SettleReportEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SettleReportEntity.class));
        if (!this.validateUtil.validateUpStreamVersion(String.valueOf(saveOrUpdateVO.getContractId()), BillTypeCodeEnum.\u65bd\u5de5\u5408\u540c.getCode(), saveOrUpdateVO.getContractVersion()).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        SettleReportVO vo = (SettleReportVO)BeanMapper.map((Object)((Object)entity), SettleReportVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettleReportVO> queryDetail(Long id) {
        SettleReportEntity entity = (SettleReportEntity)((Object)this.service.selectById(id));
        SettleReportVO vo = (SettleReportVO)BeanMapper.map((Object)((Object)entity), SettleReportVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettleReportVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SettleReportVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettleReportVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List vos = BeanMapper.mapList((Iterable)list, SettleReportVO.class);
        vos.forEach(e -> e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription()));
        beans.put("records", vos);
        ExcelExport.getInstance().export("SettleReport-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSettleReportData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SettleReportVO>> refSettleReportData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getOrderMap().put("createTime", "desc");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"contractId")) {
                param.getParams().put("contractId", new Parameter("in", (Object)_con.getString("contractId")));
            }
            if (_con.containsKey((Object)"projectId")) {
                param.getParams().put("projectId", new Parameter("in", (Object)_con.getString("projectId")));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettleReportVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/validateContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> validateContract(@RequestParam(value="contractId") Long contractId, @RequestParam(value="id", required=false) Long id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.eq(BaseEntity::getDr, (Object)0);
        queryWrapper.notIn(SettleReportEntity::getBillState, new Object[]{1, 3});
        if (id != null) {
            queryWrapper.ne(BaseEntity::getId, (Object)id);
        }
        queryWrapper.eq(SettleReportEntity::getContractId, (Object)contractId);
        List list = this.service.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u4e0b\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u7ed3\u7b97\u62a5\u5ba1\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/getProductionMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ProductionVO>> getProductionMny(@RequestParam(value="contractId") Long contractId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.eq(BaseEntity::getDr, (Object)0);
        queryWrapper.in(ProductionEntity::getBillState, new Object[]{1, 3});
        queryWrapper.eq(ProductionEntity::getContractId, (Object)contractId);
        List list = this.productionService.list((Wrapper)queryWrapper);
        List vos = BeanMapper.mapList((Iterable)list, ProductionVO.class);
        return CommonResponse.success((Object)vos);
    }

    @RequestMapping(value={"/querySettleReportHistory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettleReportHistoryVO> querySettleReportHistory(@RequestParam Long id) {
        SettleReportHistoryVO vo = this.service.querySettleReportHistory(id);
        return CommonResponse.success((Object)vo);
    }

    @GetMapping(value={"/syncPushSettlePool"})
    @ResponseBody
    public CommonResponse<Boolean> syncPushSettlePool(@RequestParam(value="id") Long id) {
        SettleReportEntity settleReportEntity = (SettleReportEntity)((Object)this.service.selectById(id));
        SettleReportVO vo = (SettleReportVO)BeanMapper.map((Object)((Object)settleReportEntity), SettleReportVO.class);
        return CommonResponse.success((String)"\u540c\u6b65\u7ed3\u7b97\u6c60\u6210\u529f\uff01", (Object)this.service.pushSettleToPool(vo));
    }

    @RequestMapping(value={"/adjustGd"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> adjustGd(@RequestBody List<SettleReportVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        this.service.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(SettleReportEntity::getGdDate, (Object)new Date())).set(SettleReportEntity::getGdStatus, (Object)1)).in(BaseEntity::getId, ids));
        boolean sendFlag = this.service.sendMsg(vos);
        return CommonResponse.success((String)"\u4fee\u6539\u5df2\u5f52\u6863\u72b6\u6001\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/adjustUnGd"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> adjustUnGd(@RequestBody List<SettleReportVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        this.service.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(SettleReportEntity::getGdDate, (Object)new Date())).set(SettleReportEntity::getGdStatus, (Object)2)).in(BaseEntity::getId, ids));
        return CommonResponse.success((String)"\u4fee\u6539\u672a\u5f52\u6863\u72b6\u6001\u6210\u529f\uff01");
    }
}

