package com.ejianc.business.market.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 竣工报告
 * 
 * @author generator
 * 
 */
@ApiModel("竣工报告")
public class CompletionWorkReportVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("所属项目Id")
    private Long projectId;
    @ApiModelProperty("所属项目名称")
    private String projectName;
    @ApiModelProperty("单据编码")
    private String billCode;
    @ApiModelProperty("单据状态")
    private Integer billState;
    @ApiModelProperty("所属项目部Id")
    private Long orgId;
    @ApiModelProperty("所属项目部名称")
    private String orgName;
    @ApiModelProperty("项目组织编码")
    private String orgCode;
    @ApiModelProperty("项目部上级组织id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("经办人id")
    private Long employeeId;
    @ApiModelProperty("经办人")
    private String employeeName;
    @ApiModelProperty("经办人电话")
    private String employeePhone;
    @ApiModelProperty("经办人单位id")
    private Long departmentId;
    @ApiModelProperty("经办单位")
    private String departmentName;
    @ApiModelProperty("验收类型Id")
    private Long checkType;
    @ApiModelProperty("验收类型名称")
    private String checkTypeName;
    @ApiModelProperty("申请验收日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyCheckDate;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("单据状态名称")
    private String billStateName;
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date effectiveTime; // 生效时间
    private boolean completionAcceptanceFlag; // 是否竣工验收
    private String completionAcceptanceFlagStr; // 是否竣工验收
    @TableField(value="response_id")
    private Long responseId; // 项目负责人id
    @TableField(value="response_name")
    private String responseName; // 项目负责人name
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同价(万元)
    @TableField(value="settle_mny")
    private BigDecimal settleMny; //结算价或完成产值（万元）
    @TableField(value="self_mny")
    private BigDecimal selfMny; //自行完成（万元）
    @TableField(value="permission_code")
    private String permissionCode; //施工许可证编号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; //实际开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; //实际竣工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishDate; //交付日期
    @TableField(value="project_description")
    private String projectDescription; //工程概况（结构形式及规模数量）
    @TableField(value="finish_description")
    private String finishDescription; //竣工归档情况
    @TableField(value="award_description")
    private String awardDescription; //项目获奖情况

    public String getCompletionAcceptanceFlagStr() {
        return completionAcceptanceFlagStr;
    }

    public void setCompletionAcceptanceFlagStr(String completionAcceptanceFlagStr) {
        this.completionAcceptanceFlagStr = completionAcceptanceFlagStr;
    }
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getResponseId() {
        return responseId;
    }
    @ReferDeserialTransfer
    public void setResponseId(Long responseId) {
        this.responseId = responseId;
    }

    public String getResponseName() {
        return responseName;
    }

    public void setResponseName(String responseName) {
        this.responseName = responseName;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }

    public BigDecimal getSelfMny() {
        return selfMny;
    }

    public void setSelfMny(BigDecimal selfMny) {
        this.selfMny = selfMny;
    }

    public String getPermissionCode() {
        return permissionCode;
    }

    public void setPermissionCode(String permissionCode) {
        this.permissionCode = permissionCode;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }

    public String getProjectDescription() {
        return projectDescription;
    }

    public void setProjectDescription(String projectDescription) {
        this.projectDescription = projectDescription;
    }

    public String getFinishDescription() {
        return finishDescription;
    }

    public void setFinishDescription(String finishDescription) {
        this.finishDescription = finishDescription;
    }

    public String getAwardDescription() {
        return awardDescription;
    }

    public void setAwardDescription(String awardDescription) {
        this.awardDescription = awardDescription;
    }

    public boolean isCompletionAcceptanceFlag() {
        return completionAcceptanceFlag;
    }

    public void setCompletionAcceptanceFlag(boolean completionAcceptanceFlag) {
        this.completionAcceptanceFlag = completionAcceptanceFlag;
    }

    public Date getEffectiveTime() {
        return effectiveTime;
    }

    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }
    

    /**
     * 所属项目Id
     */
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 所属项目Id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 所属项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 所属项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 所属项目部Id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属项目部Id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目组织编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 项目组织编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 项目部上级组织id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 项目部上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 经办人id
     */
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人id
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办人电话
     */
    public String getEmployeePhone() {
        return employeePhone;
    }

    /**
     * 经办人电话
     */
    public void setEmployeePhone(String employeePhone) {
        this.employeePhone = employeePhone;
    }
    /**
     * 经办人单位id
     */
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办人单位id
     */
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办单位
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办单位
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 验收类型Id
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getCheckType() {
        return checkType;
    }

    /**
     * 验收类型Id
     */
    @ReferDeserialTransfer
    public void setCheckType(Long checkType) {
        this.checkType = checkType;
    }
    /**
     * 验收类型名称
     */
    public String getCheckTypeName() {
        return checkTypeName;
    }

    /**
     * 验收类型名称
     */
    public void setCheckTypeName(String checkTypeName) {
        this.checkTypeName = checkTypeName;
    }
    /**
     * 申请验收日期
     */
    public Date getApplyCheckDate() {
        return applyCheckDate;
    }

    /**
     * 申请验收日期
     */
    public void setApplyCheckDate(Date applyCheckDate) {
        this.applyCheckDate = applyCheckDate;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
}
