package com.ejianc.business.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * @author baipengyan
 * @date 2022/8/30
 * @description 资金管控状态
 */
public enum CapitalStatusEnum {
	开账正常("14"),
	资金冻结("15"),
	成本关门("16"),
	已销账("17");
	private final String code;

	CapitalStatusEnum(String code) {
		this.code = code;
	}

	public static String getNameByCode(String capitalStatus) {
		switch (capitalStatus) {
			case "14":
				return "开账正常";
			case "15":
				return "资金冻结";
			case "16":
				return "成本关门";
			case "17":
				return "已销账";
			default:
				return null;
		}
	}

	public String getCode() {
		return code;
	}

	public static String getCodeByName(String name) {
		if (StringUtils.isBlank(name)) {
			return null;
		}
		for (CapitalStatusEnum capitalStatusEnum : CapitalStatusEnum.values()) {
			if (name.equals(capitalStatusEnum.toString())) {
				return capitalStatusEnum.getCode();
			}
		}
		return null;
	}
}
