/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.market.bean.ProjectSetEntity;
import com.ejianc.business.market.mapper.ProjectSetMapper;
import com.ejianc.business.market.service.IProjectSetService;
import com.ejianc.business.market.vo.ProjectSetVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.nio.charset.StandardCharsets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectSetService")
public class ProjectSetServiceImpl
extends BaseServiceImpl<ProjectSetMapper, ProjectSetEntity>
implements IProjectSetService {
    @Autowired
    private IProjectSetApi iProjectSetApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectSetService service;

    @Override
    public CommonResponse<String> pushProjectPoolSet(ProjectSetEntity projectSetEntity, String billTypeCode) {
        CommonResponse resp;
        ProjectSetVO projectSetVO = (ProjectSetVO)BeanMapper.map((Object)((Object)projectSetEntity), ProjectSetVO.class);
        OrgVO projectDepartment = null;
        if (null == projectSetVO.getProjectDepartmentId()) {
            projectDepartment = this.generateProjectDepartment(projectSetVO, true);
            projectSetEntity.setProjectDepartmentId(projectDepartment.getId());
            projectSetEntity.setProjectDepartmentName(projectDepartment.getName());
        } else {
            projectDepartment = (OrgVO)this.orgApi.getOneById(projectSetVO.getProjectDepartmentId()).getData();
            if (projectDepartment != null) {
                projectDepartment.setProjectCode(projectSetVO.getCode());
            }
        }
        if (null != projectDepartment && !(resp = this.orgApi.saveOrgInfo(projectDepartment)).isSuccess()) {
            throw new BusinessException("\u63d0\u4ea4\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u4fdd\u5b58\u9879\u76ee\u90e8\u4fe1\u606f\u51fa\u9519: " + resp.getMsg());
        }
        this.service.saveOrUpdate((Object)projectSetEntity, false);
        ProjectPoolSetVO projectPoolSetVO = (ProjectPoolSetVO)BeanMapper.map((Object)((Object)projectSetEntity), ProjectPoolSetVO.class);
        return this.iProjectSetApi.pushProjectPoolSet(JSONObject.toJSONString((Object)projectPoolSetVO).getBytes(StandardCharsets.UTF_8));
    }

    private OrgVO generateProjectDepartment(ProjectSetVO projectSetVO, boolean isSyncProject) {
        if (projectSetVO.getOrgId() == null) {
            throw new BusinessException("\u63d0\u4ea4\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u9879\u76ee\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728\u3002");
        }
        CommonResponse response = this.orgApi.getOneById(projectSetVO.getOrgId());
        OrgVO parentOrg = null;
        if (!response.isSuccess()) {
            throw new BusinessException("\u63d0\u4ea4\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2\u9879\u76ee\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25: " + response.getMsg());
        }
        parentOrg = (OrgVO)response.getData();
        if (null == parentOrg) {
            throw new BusinessException("\u63d0\u4ea4\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u9879\u76ee\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728\u3002");
        }
        OrgVO projectDepartment = new OrgVO();
        OrgVO paramVo = new OrgVO();
        paramVo.setName(projectSetVO.getName());
        paramVo.setOrgType(Integer.valueOf(5));
        paramVo.setTenantId(InvocationInfoProxy.getTenantid());
        response = this.orgApi.findOneByOrgVO(paramVo);
        if (response.isSuccess()) {
            if (response.getData() != null) {
                projectDepartment = (OrgVO)response.getData();
            } else {
                projectDepartment.setId(Long.valueOf(IdWorker.getId()));
                projectDepartment.setTenantId(parentOrg.getTenantId());
                projectDepartment.setName(projectSetVO.getName());
                projectDepartment.setShortName(projectSetVO.getShortName());
                projectDepartment.setState(Integer.valueOf(1));
                projectDepartment.setOrgType(OrgVO.ORG_TYPE_DEPARTMENT);
            }
        } else {
            throw new BusinessException("\u63d0\u4ea4\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u6839\u636e\u9879\u76ee\u540d\u79f0\u67e5\u8be2\u5bf9\u5e94\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25: " + response.getMsg());
        }
        projectDepartment.setIsParent(Boolean.valueOf(false));
        projectDepartment.setProjectCode(projectSetVO.getCode());
        projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
        projectDepartment.setParentId(projectSetVO.getOrgId());
        return projectDepartment;
    }
}

