package com.ejianc.business.market.controller.api;

import com.ejianc.business.market.bean.ProjectSetEntity;
import com.ejianc.business.market.service.IProjectSetService;
import com.ejianc.business.market.vo.ProjectSetVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/api/project/")
public class ProjectApi {
    @Autowired
    private IProjectSetService service;

    @GetMapping("queryProjectDetail")
    public CommonResponse<ProjectSetVO> queryProjectDetail(@RequestParam(value = "projectId") Long projectId) {
        ProjectSetVO vo = new ProjectSetVO();
        ProjectSetEntity projectSetEntity = service.selectById(projectId);
        if(projectSetEntity!=null){
            vo = BeanMapper.map(projectSetEntity, ProjectSetVO.class);
        }
        return CommonResponse.success("查询成功！", vo);
    }
}
