/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.market.bean.AdjustApplicationEntity;
import com.ejianc.business.market.enums.ArchiveStatusEnum;
import com.ejianc.business.market.enums.BusinessStatusEnum;
import com.ejianc.business.market.enums.CapitalStatusEnum;
import com.ejianc.business.market.enums.SettleStatusEnum;
import com.ejianc.business.market.service.IAdjustApplicationService;
import com.ejianc.business.market.vo.AdjustApplicationVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"adjustApplication"})
public class AdjustApplicationController
implements Serializable {
    private static final long serialVersionUID = -6785045006497587831L;
    private static final String RULE_CODE = "ADJUST-APPLICATION";
    private static final String BILL_CODE = "EJCBT202208000028";
    private static final String BUSINESS_STATUS = "\u4e1a\u52a1\u72b6\u6001";
    private static final String SETTLE_STATUS = "\u7ed3\u7b97\u72b6\u6001";
    private static final String ARCHIVE_STATUS = "\u8d44\u6599\u5f52\u6863\u72b6\u6001";
    private static final String CAPITAL_STATUS = "\u8d44\u91d1\u7ba1\u63a7\u72b6\u6001";
    private static final String TEXT = "text";
    private static final String VALUE = "value";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SessionManager sessionManager;
    private final IBillTypeApi billTypeApi;
    private final IBillCodeApi billCodeApi;
    private final IOrgApi iOrgApi;
    private final IAdjustApplicationService service;

    public AdjustApplicationController(SessionManager sessionManager, IBillTypeApi billTypeApi, IBillCodeApi billCodeApi, IOrgApi iOrgApi, IAdjustApplicationService service) {
        this.sessionManager = sessionManager;
        this.billTypeApi = billTypeApi;
        this.billCodeApi = billCodeApi;
        this.iOrgApi = iOrgApi;
        this.service = service;
    }

    @PostMapping(value={"/saveOrUpdate"})
    public CommonResponse<AdjustApplicationVO> saveOrUpdate(@RequestBody AdjustApplicationVO saveOrUpdateVO) {
        AdjustApplicationEntity entity = (AdjustApplicationEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AdjustApplicationEntity.class));
        if (null == entity.getId() || 0L == entity.getId()) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)RULE_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setBillName("\u5de5\u7a0b\u72b6\u6001\u8c03\u6574\u7533\u8bf7");
        entity.setBillStateName(BillStateEnum.UNCOMMITED_STATE.getDescription());
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)BeanMapper.map((Object)this.service.selectById(entity.getId()), AdjustApplicationVO.class));
    }

    @GetMapping(value={"/queryDetail"})
    public CommonResponse<AdjustApplicationVO> queryDetail(@RequestParam(value="id", required=true) Long id) {
        AdjustApplicationEntity entity = (AdjustApplicationEntity)((Object)this.service.selectById(id));
        AdjustApplicationVO vo = (AdjustApplicationVO)BeanMapper.map((Object)((Object)entity), AdjustApplicationVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"/delete"})
    public CommonResponse<String> delete(@RequestBody List<AdjustApplicationVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (AdjustApplicationVO vo : vos) {
                CommonResponse resp = this.billTypeApi.checkQuote(BILL_CODE, vo.getId());
                if (resp.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01" + resp.getMsg()));
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"/queryList"})
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("memo");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        List adjust = BeanMapper.mapList((Iterable)page.getRecords(), AdjustApplicationVO.class);
        resp.put("current", (Object)page.getCurrent());
        resp.put("size", (Object)page.getSize());
        resp.put("pages", (Object)page.getPages());
        resp.put("total", (Object)page.getTotal());
        resp.put("records", (Object)adjust);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"/excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("memo");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        ArrayList adjusts = new ArrayList();
        page.getRecords().forEach(e -> {
            AdjustApplicationVO adjust = (AdjustApplicationVO)BeanMapper.map((Object)e, AdjustApplicationVO.class);
            adjust.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)adjust.getBillState()).getDescription());
            adjusts.add(adjust);
        });
        HashMap beans = new HashMap();
        beans.put("records", adjusts);
        ExcelExport.getInstance().export("AdjustApplication-export.xlsx", beans, response);
    }

    @GetMapping(value={"/checkOnly"})
    public CommonResponse<String> checkOnly(@RequestParam(value="id", required=false) Long id, @RequestParam(value="projectId", required=true) Long projectId) {
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        if (null != id) {
            lambdaQuery.ne(BaseEntity::getId, (Object)id);
        }
        lambdaQuery.eq(AdjustApplicationEntity::getProjectId, (Object)projectId);
        lambdaQuery.notIn(AdjustApplicationEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        int count = this.service.count((Wrapper)lambdaQuery);
        if (count > 0) {
            throw new BusinessException("\u7f16\u8f91\u5931\u8d25\uff01\u8be5\u9879\u76ee\u5b58\u5728\u672a\u751f\u6548\u7684\u7533\u8bf7\u5355\uff0c\u4e0d\u80fd\u7ee7\u7eed\u7533\u8bf7\u8c03\u6574\u3002");
        }
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f\uff01");
    }

    @GetMapping(value={"/fetchStateAfterAdjustment"})
    public CommonResponse<JSONObject> fetchStateAfterAdjustment(@RequestParam(value="adjustStateType", required=true) String adjustStateType) {
        JSONObject o;
        JSONObject jsonObject = new JSONObject();
        ArrayList<JSONObject> data = new ArrayList<JSONObject>();
        if (BUSINESS_STATUS.equals(adjustStateType)) {
            for (Enum enum_ : BusinessStatusEnum.values()) {
                o = new JSONObject();
                o.put(TEXT, (Object)enum_.toString());
                o.put(VALUE, (Object)enum_.toString());
                data.add(o);
            }
        }
        if (SETTLE_STATUS.equals(adjustStateType)) {
            for (Enum enum_ : SettleStatusEnum.values()) {
                o = new JSONObject();
                o.put(TEXT, (Object)enum_.toString());
                o.put(VALUE, (Object)enum_.toString());
                data.add(o);
            }
        }
        if (ARCHIVE_STATUS.equals(adjustStateType)) {
            for (Enum enum_ : ArchiveStatusEnum.values()) {
                o = new JSONObject();
                o.put(TEXT, (Object)enum_.toString());
                o.put(VALUE, (Object)enum_.toString());
                data.add(o);
            }
        }
        if (CAPITAL_STATUS.equals(adjustStateType)) {
            for (Enum enum_ : CapitalStatusEnum.values()) {
                o = new JSONObject();
                o.put(TEXT, (Object)enum_.toString());
                o.put(VALUE, (Object)enum_.toString());
                data.add(o);
            }
        }
        jsonObject.put("data", data);
        return CommonResponse.success((String)"\u8bf7\u6c42\u6210\u529f\uff01", (Object)jsonObject);
    }
}

