/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.api.BidManageApi;
import com.ejianc.business.market.bean.ProjectSetEntity;
import com.ejianc.business.market.service.IProjectSetService;
import com.ejianc.business.market.vo.ProjectSetVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projectSet"})
public class ProjectSetController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private BidManageApi bidManageApi;
    @Autowired
    private IDefdocApi defdocApi;
    private static final String BILL_CODE = "pro-market-project-001";
    @Autowired
    private IProjectSetService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectSetVO> saveOrUpdate(@RequestBody ProjectSetVO saveOrUpdateVO) {
        ProjectSetEntity entity = (ProjectSetEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ProjectSetEntity.class));
        QueryParam param = new QueryParam();
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (entity.getCode() == null) {
                if (billCode.isSuccess()) {
                    entity.setCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            if (saveOrUpdateVO.getProjectDepartmentId() != null) {
                param.getParams().put("projectDepartmentId", new Parameter("eq", (Object)saveOrUpdateVO.getProjectDepartmentId()));
                List list = this.service.queryList(param, false);
                if (!list.isEmpty()) {
                    return CommonResponse.error((String)"\u6240\u9009\u65bd\u5de5\u9879\u76ee\u90e8\u5df2\u7acb\u9879\uff0c\u65e0\u6cd5\u65b0\u589e\u7acb\u9879\uff01");
                }
            }
        } else if (saveOrUpdateVO.getProjectDepartmentId() != null) {
            param.getParams().put("projectDepartmentId", new Parameter("eq", (Object)saveOrUpdateVO.getProjectDepartmentId()));
            List list = this.service.queryList(param, false);
            if (!list.isEmpty() && !((ProjectSetEntity)((Object)list.get(0))).getId().equals(saveOrUpdateVO.getId())) {
                return CommonResponse.error((String)"\u6240\u9009\u65bd\u5de5\u9879\u76ee\u90e8\u5df2\u7acb\u9879\uff0c\u65e0\u6cd5\u4fee\u6539\u6210\u8be5\u65bd\u5de5\u9879\u76ee\u90e8\u7acb\u9879\uff01");
            }
        }
        if (null != entity.getMeasureType() && StringUtils.isNotBlank((CharSequence)entity.getMeasureValue())) {
            CommonResponse docResp = this.defdocApi.getDefDocById(entity.getMeasureType());
            if (!docResp.isSuccess() || null == docResp.getData()) {
                this.logger.error("\u6839\u636eId-{}\u67e5\u8be2\u5de5\u7a0b\u5ea6\u91cf\u65b9\u5f0f\u5931\u8d25\uff1a{}", (Object)entity.getMeasureType(), (Object)JSONObject.toJSONString((Object)docResp));
                return CommonResponse.error((String)"\u67e5\u8be2\u5ea6\u91cf\u65b9\u5f0f\u6863\u6848\u4fe1\u606f\u5931\u8d25\uff01");
            }
            String measureUnitName = ((DefdocDetailVO)docResp.getData()).getName();
            if (measureUnitName.contains("\uff08")) {
                measureUnitName = measureUnitName.replace("\uff08", "(");
                measureUnitName = measureUnitName.replace("\uff09", ")");
            }
            if (measureUnitName.contains("(")) {
                measureUnitName = measureUnitName.split("\\(")[1].split("\\)")[0];
            }
            entity.setMeasure(entity.getMeasureValue() + measureUnitName);
        }
        this.service.saveOrUpdate((Object)entity, false);
        ProjectSetVO vo = (ProjectSetVO)((Object)BeanMapper.map((Object)((Object)entity), ProjectSetVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/saveBid"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectSetVO> saveBid(@RequestBody ProjectSetVO saveOrUpdateVO) {
        ProjectSetEntity entity = (ProjectSetEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ProjectSetEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (null != entity.getMeasureType() && StringUtils.isNotBlank((CharSequence)entity.getMeasureValue())) {
            CommonResponse docResp = this.defdocApi.getDefDocById(entity.getMeasureType());
            if (!docResp.isSuccess() || null == docResp.getData()) {
                this.logger.error("\u6839\u636eId-{}\u67e5\u8be2\u5de5\u7a0b\u5ea6\u91cf\u65b9\u5f0f\u5931\u8d25\uff1a{}", (Object)entity.getMeasureType(), (Object)JSONObject.toJSONString((Object)docResp));
                return CommonResponse.error((String)"\u67e5\u8be2\u5ea6\u91cf\u65b9\u5f0f\u6863\u6848\u4fe1\u606f\u5931\u8d25\uff01");
            }
            entity.setMeasure(((DefdocDetailVO)docResp.getData()).getName() + entity.getMeasureValue());
        }
        this.service.saveOrUpdate((Object)entity, false);
        this.bidManageApi.changeUseFlag(entity.getSourceBillId(), Integer.valueOf(1));
        ProjectSetVO vo = (ProjectSetVO)((Object)BeanMapper.map((Object)((Object)entity), ProjectSetVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectSetVO> queryDetail(Long id) {
        ProjectSetEntity entity = (ProjectSetEntity)((Object)this.service.selectById(id));
        ProjectSetVO vo = (ProjectSetVO)((Object)BeanMapper.map((Object)((Object)entity), ProjectSetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectSetVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProjectSetVO projectSetVO : vos) {
            }
        }
        if (ListUtil.isNotEmpty(vos)) {
            for (ProjectSetVO vo : vos) {
                ProjectSetEntity entity = (ProjectSetEntity)((Object)this.service.selectById(vo.getId()));
                this.bidManageApi.changeUseFlag(entity.getSourceBillId(), Integer.valueOf(0));
                if (entity.getProjectDepartmentId() == null) continue;
                CommonResponse response = this.iOrgApi.getOneById(entity.getProjectDepartmentId());
                if (!response.isSuccess()) {
                    return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01\u67e5\u8be2\u65bd\u5de5\u9879\u76ee\u90e8\u4fe1\u606f\u51fa\u9519: " + response.getMsg()));
                }
                OrgVO orgVO = (OrgVO)response.getData();
                if (!StringUtils.isNotEmpty((CharSequence)orgVO.getProjectCode())) continue;
                orgVO.setProjectCode(null);
                CommonResponse resp = this.iOrgApi.saveOrgInfo(orgVO);
                if (resp.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01\u4fee\u6539\u65bd\u5de5\u9879\u76ee\u90e8\u4fe1\u606f\u51fa\u9519: " + resp.getMsg()));
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjectSetVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("shortName");
        param.getFuzzyFields().add("project_management_name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (commonOrgIds.size() != 0) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (departmentIds.size() != 0) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        } else {
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)new Page(1L, (long)param.getPageSize(), 0L));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectSetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("shortName");
        param.getFuzzyFields().add("code");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List voList = new ArrayList();
        if (list.size() > 0) {
            voList = BeanMapper.mapList((Iterable)list, ProjectSetVO.class);
            for (ProjectSetVO vo : voList) {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("projectSet-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProjectSetData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProjectSetVO>> refProjectSetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectSetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getCurrentOrgParentInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrgVO> getCurrentOrgParentInfo() {
        return this.iOrgApi.findParentByOrgId(InvocationInfoProxy.getOrgId());
    }

    @RequestMapping(value={"/getTotalInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> getTotalInfo(@RequestBody QueryParam param) {
        JSONObject res = new JSONObject();
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("project_management_name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (commonOrgIds.size() != 0) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (departmentIds.size() != 0) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        } else {
            res.put("total", (Object)0);
            res.put("fatherTotal", (Object)0);
            res.put("eTotal", (Object)0);
            return CommonResponse.success((Object)res);
        }
        List setEntities = this.service.queryList(param, false);
        res.put("total", (Object)setEntities.size());
        if (param.getParams().get("attribute") != null) {
            Parameter parameter = (Parameter)param.getParams().get("attribute");
            if ("1".equals(parameter.getValue())) {
                res.put("fatherTotal", (Object)setEntities.size());
                res.put("eTotal", (Object)0);
            } else {
                res.put("fatherTotal", (Object)0);
                res.put("eTotal", (Object)setEntities.size());
            }
        } else {
            param.getParams().put("attribute", new Parameter("eq", (Object)1));
            setEntities = this.service.queryList(param, false);
            res.put("fatherTotal", (Object)setEntities.size());
            param.getParams().put("attribute", new Parameter("eq", (Object)2));
            setEntities = this.service.queryList(param, false);
            res.put("eTotal", (Object)setEntities.size());
        }
        return CommonResponse.success((Object)res);
    }
}

