/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.bean.CompletionWorkReportEntity;
import com.ejianc.business.market.bean.FinishWorkReportEntity;
import com.ejianc.business.market.bean.StartWorkReportEntity;
import com.ejianc.business.market.mapper.FinishWorkReportMapper;
import com.ejianc.business.market.mapper.StartWorkReportMapper;
import com.ejianc.business.market.service.ICompletionWorkReportService;
import com.ejianc.business.market.service.IFinishWorkReportService;
import com.ejianc.business.market.service.IProjectSetService;
import com.ejianc.business.market.service.IStartWorkReportService;
import com.ejianc.business.market.utils.CommonUtils;
import com.ejianc.business.market.vo.StartWorkReportVO;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.consts.ProjectBusinessStatusEnum;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"startWorkReport"})
public class StartWorkReportController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private StartWorkReportMapper mapper;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDutyApi dutyApi;
    private static final String BILL_CODE = "START_WORK_REPORT";
    @Autowired
    private IStartWorkReportService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ICompletionWorkReportService completionWorkReportService;
    @Autowired
    private IFinishWorkReportService finishWorkReportService;
    @Autowired
    private IProjectSetService projectSetService;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private FinishWorkReportMapper finishWorkReportMapper;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<StartWorkReportVO> saveOrUpdate(@RequestBody StartWorkReportVO saveOrUpdateVO) {
        StartWorkReportEntity entity = (StartWorkReportEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), StartWorkReportEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse commonResponse = this.service.checkProject(saveOrUpdateVO.getProjectId());
            if (!commonResponse.isSuccess()) {
                return commonResponse;
            }
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        StartWorkReportVO vo = (StartWorkReportVO)((Object)BeanMapper.map((Object)((Object)entity), StartWorkReportVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<StartWorkReportVO> queryDetail(Long id) {
        StartWorkReportEntity entity = (StartWorkReportEntity)((Object)this.service.selectById(id));
        StartWorkReportVO vo = (StartWorkReportVO)((Object)BeanMapper.map((Object)((Object)entity), StartWorkReportVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<StartWorkReportVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (StartWorkReportVO startWorkReportVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<StartWorkReportVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("departmentName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), StartWorkReportVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("departmentName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        ArrayList exportVOS = new ArrayList();
        list.forEach(vo -> {
            StartWorkReportVO exportVO = (StartWorkReportVO)((Object)((Object)BeanMapper.map((Object)vo, StartWorkReportVO.class)));
            exportVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            exportVOS.add(exportVO);
        });
        HashMap beans = new HashMap();
        beans.put("records", exportVOS);
        ExcelExport.getInstance().export("StartWorkReport-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refStartWorkReportData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<StartWorkReportVO>> refStartWorkReportData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), StartWorkReportVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryDetailByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<StartWorkReportVO>> queryDetailByProjectId(Long projectId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List startWorkReportEntities = this.service.queryList(queryParam);
        List startWorkReportVOS = BeanMapper.mapList((Iterable)startWorkReportEntities, StartWorkReportVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)startWorkReportVOS);
    }

    @GetMapping(value={"/startWorkReportCheck"})
    @ResponseBody
    public CommonResponse<String> startWorkReportCheck(@RequestParam(value="projectId") Long projectId, @RequestParam(value="billId", required=false) Long billId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"bill_state", (Object)BillStateEnum.UNCOMMITED_STATE);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        StartWorkReportEntity one = (StartWorkReportEntity)((Object)this.service.getOne((Wrapper)query));
        if (!(one == null || null != billId && one.getId().equals(billId))) {
            return CommonResponse.error((String)"\u8be5\u9879\u76ee\u4e0b\u5df2\u5b58\u5728\u672a\u751f\u6548\u5355\u636e\uff01");
        }
        return CommonResponse.success((String)"\u8be5\u9879\u76ee\u9002\u7528\u5f53\u524d\u5355\u636e\uff01");
    }

    @PostMapping(value={"getBuildDutyInfo"})
    @ResponseBody
    public CommonResponse<JSONObject> getBuildDutyInfo(@RequestBody JSONObject params) {
        JSONObject resp = new JSONObject();
        Long orgId = InvocationInfoProxy.getOrgId();
        if (params.containsKey((Object)"orgId")) {
            orgId = params.getLong("orgId");
        }
        int nearlyDays = -30;
        if (params.containsKey((Object)"nearlyDays")) {
            nearlyDays = params.getInteger("nearlyDays");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getOrderMap().put("createTime", "desc");
        queryParam.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("start_work_date", new Parameter("ge", (Object)DateUtils.addDays((Date)new Date(), (int)nearlyDays)));
        List dbList = this.service.queryList(queryParam);
        this.logger.info("*********\u67e5\u8be2\u7b26\u53f7\u6761\u4ef6\u5f00\u5de5\u62a5\u544a\u6570\u91cf\uff1a{}\u4e2a", (Object)dbList.size());
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            List projectIds = dbList.stream().map(StartWorkReportEntity::getProjectId).collect(Collectors.toList());
            QueryParam prjQuery = new QueryParam();
            prjQuery.getParams().put("id", Parameter.getInInstance(projectIds));
            prjQuery.getParams().put("businessStatus", new Parameter("eq", (Object)ProjectBusinessStatusEnum.\u6b63\u5f0f\u5f00\u5de5.getBusinessStatus()));
            CommonResponse prjResp = this.projectPoolApi.queryArray(prjQuery);
            if (!prjResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u9879\u76eeIDs-\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c {}", JSONObject.toJSON(projectIds), (Object)prjResp);
                return CommonResponse.error((String)"\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
            }
            JSONArray projectJsonArr = (JSONArray)prjResp.getData();
            this.logger.info("*********\u5b58\u5728\u5f00\u5de5\u62a5\u544a\u7684 \u5728\u65bd\u9879\u76ee\u6570\uff1a{}", (Object)projectJsonArr.size());
            if (projectJsonArr.size() != 0) {
                ArrayList<Long> validProjectIds = new ArrayList<Long>();
                JSONObject tmp = null;
                for (Object o : projectJsonArr) {
                    tmp = JSONObject.parseObject((String)JSONObject.toJSONString(o));
                    validProjectIds.add(tmp.getLong("id"));
                }
                resp.put("needNum", (Object)validProjectIds.size());
                resp.put("needProjectIds", (Object)JSONObject.toJSONString(validProjectIds));
                CommonResponse extProjectIdsResp = this.dutyApi.queryDutyByProjectIds(validProjectIds);
                if (!extProjectIdsResp.isSuccess()) {
                    this.logger.error("\u6839\u636e\u9879\u76eeIDs-\u67e5\u8be2\u9879\u76ee\u7b56\u5212\u4fe1\u606f\u5931\u8d25\uff0c {}", JSONObject.toJSON(validProjectIds), (Object)extProjectIdsResp);
                    return CommonResponse.error((String)"\u67e5\u8be2\u9879\u76ee\u7b56\u5212\u4fe1\u606f\u5931\u8d25\uff01");
                }
                this.logger.info("******\u9879\u76ee\u7b56\u5212\u9879\u76ee\u6570\uff1a{}", (Object)((List)extProjectIdsResp.getData()).size());
                List extProjectIds = (List)extProjectIdsResp.getData();
                validProjectIds.removeAll(extProjectIds);
                resp.put("finishNum", (Object)extProjectIds.size());
                resp.put("finishProjectIds", (Object)extProjectIds);
                resp.put("unFinishNum", (Object)projectIds.size());
                resp.put("unFinishProjectIds", projectIds);
                return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
            }
        }
        resp.put("needNum", (Object)0);
        resp.put("needProjectIds", (Object)0);
        resp.put("finishNum", (Object)0);
        resp.put("finishProjectIds", new ArrayList());
        resp.put("unFinishNum", (Object)0);
        resp.put("unFinishProjectIds", new ArrayList());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"getProjectCostInfo"})
    @ResponseBody
    public CommonResponse<JSONObject> getProjectCostInfo(@RequestBody JSONObject params) {
        QueryParam prjQuery;
        CommonResponse prjResp;
        JSONObject resp = new JSONObject();
        Long orgId = InvocationInfoProxy.getOrgId();
        if (params.containsKey((Object)"orgId")) {
            orgId = params.getLong("orgId");
        }
        if (!(prjResp = this.projectPoolApi.queryProjectList(prjQuery = new QueryParam())).isSuccess()) {
            return CommonResponse.error((String)"\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List projectData = (List)prjResp.getData();
        this.logger.info("*********\u5b58\u5728\u5f00\u5de5\u62a5\u544a\u7684 \u5728\u65bd\u9879\u76ee\u6570\uff1a{}", (Object)projectData.size());
        if (projectData.size() != 0) {
            List filteredList;
            ArrayList<Long> validProjectIds = new ArrayList<Long>();
            for (ProjectPoolSetVO o : projectData) {
                validProjectIds.add(o.getId());
            }
            resp.put("projectNum", (Object)projectData.size());
            resp.put("projectNumIds", (Object)JSONObject.toJSONString(validProjectIds));
            List<Long> orgIds = ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
            ArrayList<Integer> billStateList = new ArrayList<Integer>();
            billStateList.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
            billStateList.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
            List<Long> approveNum = this.finishWorkReportMapper.getApproveNum(orgIds, billStateList);
            resp.put("spzNum", (Object)approveNum.size());
            resp.put("spzNumIds", (Object)JSONObject.toJSONString(approveNum));
            billStateList.clear();
            billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
            billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
            List<Long> approveFinishNum = this.finishWorkReportMapper.getApproveNum(orgIds, billStateList);
            resp.put("ywcNum", (Object)approveFinishNum.size());
            resp.put("ywcNumIds", (Object)JSONObject.toJSONString(approveFinishNum));
            List<Long> getutyNumIds = this.finishWorkReportMapper.getDutyNum();
            resp.put("bszhNum", (Object)0);
            if (CollectionUtils.isNotEmpty((Collection)projectData) && CollectionUtils.isNotEmpty(filteredList = projectData.stream().filter(project -> project.getProjectDate() != null).filter(project -> {
                LocalDate projectDate = project.getProjectDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                return projectDate.plusDays(30L).isBefore(LocalDate.now());
            }).collect(Collectors.toList()))) {
                List projectPoolSetVOS = filteredList.stream().filter(s -> !getutyNumIds.contains(s.getId())).collect(Collectors.toList());
                resp.put("bszhNum", (Object)projectPoolSetVOS.size());
            }
            Integer spzhNum = this.finishWorkReportMapper.getSpzhNum(orgIds);
            resp.put("spzhNum", (Object)spzhNum);
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
        }
        resp.put("projectNum", (Object)0);
        resp.put("spzNum", (Object)0);
        resp.put("ywcNum", (Object)0);
        resp.put("bszhNum", (Object)0);
        resp.put("spzhNum", (Object)0);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"getProjectProductData"})
    @ResponseBody
    public CommonResponse<JSONObject> getProjectProductData(@RequestBody JSONObject params) {
        QueryParam prjQuery;
        CommonResponse prjResp;
        JSONObject resp = new JSONObject();
        Long orgId = InvocationInfoProxy.getOrgId();
        if (params.containsKey((Object)"orgId")) {
            orgId = params.getLong("orgId");
        }
        if (!(prjResp = this.projectPoolApi.queryProjectList(prjQuery = new QueryParam())).isSuccess()) {
            return CommonResponse.error((String)"\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List projectData = (List)prjResp.getData();
        this.logger.info("*********\u5b58\u5728\u5f00\u5de5\u62a5\u544a\u7684 \u5728\u65bd\u9879\u76ee\u6570\uff1a{}", (Object)projectData.size());
        if (projectData.size() != 0) {
            List filteredList;
            ArrayList<Long> validProjectIds = new ArrayList<Long>();
            for (ProjectPoolSetVO o : projectData) {
                validProjectIds.add(o.getId());
            }
            resp.put("projectNum", (Object)projectData.size());
            resp.put("projectNumIds", (Object)JSONObject.toJSONString(validProjectIds));
            List<Long> orgIds = ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
            BigDecimal contractTaxMny = this.finishWorkReportMapper.getContractTaxMny(orgIds);
            resp.put("contractTaxMny", (Object)contractTaxMny);
            BigDecimal preSettleMny = projectData.stream().filter(s -> s.getPreSettleMny() != null).map(ProjectPoolSetVO::getPreSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            resp.put("preSettleMny", (Object)ComputeUtil.safeDiv((BigDecimal)preSettleMny, (BigDecimal)new BigDecimal(10000)));
            BigDecimal currentYearMny = this.finishWorkReportMapper.getCurrentYearMny(orgIds);
            resp.put("currentYearMny", (Object)currentYearMny);
            BigDecimal allMny = this.finishWorkReportMapper.getAllMny(orgIds);
            resp.put("allMny", (Object)allMny);
            BigDecimal allApproveMny = this.finishWorkReportMapper.getAllApproveMny(orgIds);
            resp.put("allApproveMny", (Object)allApproveMny);
            BigDecimal receivableMny = this.finishWorkReportMapper.getReceivableMny(orgIds);
            resp.put("receivableMny", (Object)receivableMny);
            BigDecimal amountsReceivedMny = this.finishWorkReportMapper.getAmountsReceivedMny(orgIds);
            resp.put("amountsReceivedMny", (Object)amountsReceivedMny);
            resp.put("backPayMny", (Object)ComputeUtil.safeSub((BigDecimal)receivableMny, (BigDecimal)amountsReceivedMny));
            ArrayList<Integer> billStateList = new ArrayList<Integer>();
            billStateList.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
            billStateList.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
            List<Long> approveNum = this.finishWorkReportMapper.getApproveNum(orgIds, billStateList);
            resp.put("spzNum", (Object)approveNum.size());
            billStateList.clear();
            billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
            billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
            List<Long> approveFinishNum = this.finishWorkReportMapper.getApproveNum(orgIds, billStateList);
            resp.put("ywcNum", (Object)approveFinishNum.size());
            List<Long> getutyNumIds = this.finishWorkReportMapper.getDutyNum();
            resp.put("bszhNum", (Object)0);
            if (CollectionUtils.isNotEmpty((Collection)projectData) && CollectionUtils.isNotEmpty(filteredList = projectData.stream().filter(project -> project.getProjectDate() != null).filter(project -> {
                LocalDate projectDate = project.getProjectDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                return projectDate.plusDays(30L).isBefore(LocalDate.now());
            }).collect(Collectors.toList()))) {
                List projectPoolSetVOS = filteredList.stream().filter(s -> !getutyNumIds.contains(s.getId())).collect(Collectors.toList());
                resp.put("bszhNum", (Object)projectPoolSetVOS.size());
            }
            Integer spzhNum = this.finishWorkReportMapper.getSpzhNum(orgIds);
            resp.put("spzhNum", (Object)spzhNum);
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
        }
        resp.put("projectNum", (Object)0);
        resp.put("contractTaxMny", (Object)0);
        resp.put("preSettleMny", (Object)0);
        resp.put("currentYearMny", (Object)0);
        resp.put("allMny", (Object)0);
        resp.put("allApproveMny", (Object)0);
        resp.put("receivableMny", (Object)0);
        resp.put("amountsReceivedMny", (Object)0);
        resp.put("backPayMny", (Object)0);
        resp.put("spzNum", (Object)0);
        resp.put("ywcNum", (Object)0);
        resp.put("bszhNum", (Object)0);
        resp.put("spzhNum", (Object)0);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"getVisaData"})
    @ResponseBody
    public CommonResponse<JSONObject> getVisaData(@RequestBody JSONObject params) {
        CommonResponse prjResp;
        JSONObject resp = new JSONObject();
        Long orgId = InvocationInfoProxy.getOrgId();
        if (params.containsKey((Object)"orgId")) {
            orgId = params.getLong("orgId");
        }
        QueryParam prjQuery = new QueryParam();
        Long projectId = null;
        if (params.containsKey((Object)"projectId")) {
            projectId = params.getLong("projectId");
            prjQuery.getParams().put("id", new Parameter("eq", (Object)projectId));
        }
        if (!(prjResp = this.projectPoolApi.queryProjectList(prjQuery)).isSuccess()) {
            return CommonResponse.error((String)"\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List projectData = (List)prjResp.getData();
        this.logger.info("*********\u5b58\u5728\u5f00\u5de5\u62a5\u544a\u7684 \u5728\u65bd\u9879\u76ee\u6570\uff1a{}", (Object)projectData.size());
        if (projectData.size() != 0) {
            ArrayList<Long> validProjectIds = new ArrayList<Long>();
            for (ProjectPoolSetVO o : projectData) {
                validProjectIds.add(o.getId());
            }
            resp.put("projectNum", (Object)projectData.size());
            resp.put("projectNumIds", (Object)JSONObject.toJSONString(validProjectIds));
            List<Long> orgIds = ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
            BigDecimal claimNum = this.finishWorkReportMapper.getClaimNum(orgIds, null, projectId);
            BigDecimal claimRecords = this.finishWorkReportMapper.getClaimRecords(orgIds);
            resp.put("bsRate", (Object)CommonUtils.calculateRate(claimNum, claimRecords));
            BigDecimal claimApproveNum = this.finishWorkReportMapper.getClaimNum(orgIds, 1, projectId);
            resp.put("qqRate", (Object)CommonUtils.calculateRate(claimApproveNum, claimNum));
            BigDecimal qzspMny = this.mapper.getQzspMny(projectId);
            qzspMny = qzspMny == null ? BigDecimal.ZERO : qzspMny;
            resp.put("claimMny", (Object)qzspMny);
            BigDecimal contractTaxMny = this.finishWorkReportMapper.getContractTaxMny(orgIds);
            resp.put("htzfRate", (Object)CommonUtils.calculateRate(qzspMny, ComputeUtil.safeMultiply((BigDecimal)contractTaxMny, (BigDecimal)new BigDecimal(10000))));
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
        }
        resp.put("projectNum", (Object)0);
        resp.put("bsRate", (Object)0);
        resp.put("qqRate", (Object)0);
        resp.put("claimMny", (Object)0);
        resp.put("htzfRate", (Object)0);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"getXVisaData"})
    @ResponseBody
    public CommonResponse<JSONObject> getXVisaData(@RequestBody JSONObject params) {
        JSONObject resp = new JSONObject();
        if (params.containsKey((Object)"projectId")) {
            Long projectId = params.getLong("projectId");
            Map<String, Object> count = this.mapper.getCountAndMny(projectId);
            resp.put("projectNum", count.get("nums"));
            Object money = count.get("money");
            BigDecimal ansMny = BigDecimal.ZERO;
            if (money != null) {
                ansMny = new BigDecimal(String.valueOf(money));
            }
            resp.put("claimMny", (Object)ansMny);
            BigDecimal expenditureContractAmount = this.getSubcontractAmount(projectId);
            resp.put("htzfRate", (Object)CommonUtils.calculateRate(ansMny, ComputeUtil.safeMultiply((BigDecimal)expenditureContractAmount, (BigDecimal)new BigDecimal(10000))));
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
        }
        resp.put("projectNum", (Object)0);
        resp.put("bsRate", (Object)0);
        resp.put("qqRate", (Object)0);
        resp.put("claimMny", (Object)0);
        resp.put("htzfRate", (Object)0);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    private BigDecimal getSubcontractAmount(Long projectId) {
        BigDecimal ans = BigDecimal.ZERO;
        BigDecimal subcontractAmount = this.mapper.getSubcontractAmount(projectId);
        ans = ans.add(subcontractAmount == null ? BigDecimal.ZERO : subcontractAmount);
        BigDecimal contractAmount = this.mapper.getContractAmount(projectId);
        ans = ans.add(contractAmount == null ? BigDecimal.ZERO : contractAmount);
        BigDecimal prormatContract = this.mapper.getPrormatContract(projectId);
        ans = ans.add(prormatContract == null ? BigDecimal.ZERO : prormatContract);
        BigDecimal rentContractAmount = this.mapper.getRentContractAmount(projectId);
        ans = ans.add(rentContractAmount == null ? BigDecimal.ZERO : rentContractAmount);
        BigDecimal purchaseContractAmount = this.mapper.getPurchaseContractAmount(projectId);
        ans = ans.add(purchaseContractAmount == null ? BigDecimal.ZERO : purchaseContractAmount);
        return ans;
    }

    @PostMapping(value={"getProjectData"})
    @ResponseBody
    public CommonResponse<JSONObject> getProjectData(@RequestBody JSONObject params) {
        QueryParam prjQuery;
        CommonResponse prjResp;
        JSONObject resp = new JSONObject();
        Long orgId = InvocationInfoProxy.getOrgId();
        if (params.containsKey((Object)"orgId")) {
            orgId = params.getLong("orgId");
        }
        if (!(prjResp = this.projectPoolApi.queryProjectList(prjQuery = new QueryParam())).isSuccess()) {
            return CommonResponse.error((String)"\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List projectData = (List)prjResp.getData();
        this.logger.info("*********\u5b58\u5728\u5f00\u5de5\u62a5\u544a\u7684 \u5728\u65bd\u9879\u76ee\u6570\uff1a{}", (Object)projectData.size());
        if (projectData.size() != 0) {
            ArrayList<Long> validProjectIds = new ArrayList<Long>();
            for (ProjectPoolSetVO o : projectData) {
                validProjectIds.add(o.getId());
            }
            List zjList = projectData.stream().filter(s -> "2".equals(s.getBusinessStatus())).collect(Collectors.toList());
            List zjListIds = zjList.stream().map(BaseVO::getId).collect(Collectors.toList());
            resp.put("zjNum", (Object)zjList.size());
            resp.put("zjNumIds", (Object)JSONObject.toJSONString(zjListIds));
            List thjList = projectData.stream().filter(s -> "3".equals(s.getBusinessStatus())).collect(Collectors.toList());
            List thjListIds = thjList.stream().map(BaseVO::getId).collect(Collectors.toList());
            resp.put("thjNum", (Object)thjList.size());
            resp.put("thjNumIds", (Object)JSONObject.toJSONString(thjListIds));
            List tcList = projectData.stream().filter(s -> "4".equals(s.getBusinessStatus())).collect(Collectors.toList());
            List tcListIds = tcList.stream().map(BaseVO::getId).collect(Collectors.toList());
            resp.put("tcNum", (Object)tcList.size());
            resp.put("tcNumIds", (Object)JSONObject.toJSONString(tcListIds));
            LambdaQueryWrapper finishWrapper = new LambdaQueryWrapper();
            finishWrapper.in(FinishWorkReportEntity::getBillState, new Object[]{1, 3});
            List finishWorkReportEntities = this.finishWorkReportService.list((Wrapper)finishWrapper);
            List wgProjectIds = finishWorkReportEntities.stream().map(FinishWorkReportEntity::getProjectId).collect(Collectors.toList());
            LambdaQueryWrapper completionWrapper = new LambdaQueryWrapper();
            completionWrapper.in(CompletionWorkReportEntity::getBillState, new Object[]{1, 3});
            completionWrapper.eq(CompletionWorkReportEntity::isCompletionAcceptanceFlag, (Object)true);
            List completionEntities = this.completionWorkReportService.list((Wrapper)completionWrapper);
            List ywyjList = completionEntities.stream().filter(s -> wgProjectIds.contains(s.getProjectId())).collect(Collectors.toList());
            List ywyjListIds = ywyjList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            resp.put("ywyjNum", (Object)ywyjList.size());
            List completionProjectIds = completionEntities.stream().map(CompletionWorkReportEntity::getProjectId).collect(Collectors.toList());
            List finishWorkReportEntityList = finishWorkReportEntities.stream().filter(s -> !completionProjectIds.contains(s.getProjectId())).collect(Collectors.toList());
            resp.put("ywwjNum", (Object)finishWorkReportEntityList.size());
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
        }
        resp.put("zjNum", (Object)0);
        resp.put("thjNum", (Object)0);
        resp.put("tcNum", (Object)0);
        resp.put("ywyjNum", (Object)0);
        resp.put("ywwjNum", (Object)0);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"getBudgetData"})
    @ResponseBody
    public CommonResponse<JSONObject> getBudgetData(@RequestBody JSONObject params) {
        QueryParam prjQuery;
        CommonResponse prjResp;
        JSONObject resp = new JSONObject();
        Long orgId = InvocationInfoProxy.getOrgId();
        if (params.containsKey((Object)"orgId")) {
            orgId = params.getLong("orgId");
        }
        if (!(prjResp = this.projectPoolApi.queryProjectList(prjQuery = new QueryParam())).isSuccess()) {
            return CommonResponse.error((String)"\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List projectData = (List)prjResp.getData();
        this.logger.info("*********\u5b58\u5728\u5f00\u5de5\u62a5\u544a\u7684 \u5728\u65bd\u9879\u76ee\u6570\uff1a{}", (Object)projectData.size());
        if (projectData.size() != 0) {
            ArrayList<Long> validProjectIds = new ArrayList<Long>();
            for (ProjectPoolSetVO o : projectData) {
                validProjectIds.add(o.getId());
            }
            resp.put("projectNum", (Object)projectData.size());
            resp.put("projectNumIds", (Object)JSONObject.toJSONString(validProjectIds));
            List<Long> orgIds = ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
            ArrayList<Integer> billStateList = new ArrayList<Integer>();
            billStateList.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
            billStateList.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
            List<Long> budgetApproveNum = this.finishWorkReportMapper.getBudgetApproveNum(orgIds, billStateList);
            List<Long> budgetApproveProjectNum = this.finishWorkReportMapper.getBudgetProjectNum(orgIds, billStateList);
            resp.put("budgetApproveNum", (Object)budgetApproveProjectNum.size());
            resp.put("budgetApproveNumIds", (Object)JSONObject.toJSONString(budgetApproveNum));
            billStateList.clear();
            billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
            billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
            List<Long> budgetFinishNum = this.finishWorkReportMapper.getBudgetApproveNum(orgIds, billStateList);
            List<Long> budgetApproveProjectFinishNum = this.finishWorkReportMapper.getBudgetProjectNum(orgIds, billStateList);
            resp.put("budgetFinishNum", (Object)budgetApproveProjectFinishNum.size());
            resp.put("budgetFinishNumIds", (Object)JSONObject.toJSONString(budgetFinishNum));
            Integer budgetBszhNum = this.finishWorkReportMapper.getBudgetBszhNum(orgIds);
            resp.put("budgetBszhNum", (Object)budgetBszhNum);
            Integer budgetSpzhNum = this.finishWorkReportMapper.getBudgetSpzhNum(orgIds);
            resp.put("budgetSpzhNum", (Object)budgetSpzhNum);
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
        }
        resp.put("zjNum", (Object)0);
        resp.put("thjNum", (Object)0);
        resp.put("tcNum", (Object)0);
        resp.put("ywyjNum", (Object)0);
        resp.put("ywwjNum", (Object)0);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }
}

