package com.ejianc.business.market.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * @author baipengyan
 * @date 2022/8/30
 * @description 业务状态
 */
public enum BusinessStatusEnum {
	开工准备("1"),
	在施("2"),
	停工("3"),
	完工("5"),
	项目中止("4"),
	竣工验收("6"),
	保修中("12"),
	保修结束("13");
	private final String code;

	BusinessStatusEnum(String code) {
		this.code = code;
	}

	public static Object getNameByCode(String businessStatus) {
		switch (businessStatus) {
			case "1":
				return "开工准备";
			case "2":
				return "在施";
			case "3":
				return "停工";
			case "4":
				return "项目中止";
			case "5":
				return "完工";
			case "6":
				return "竣工验收";
			case "12":
				return "保修中";
			case "13":
				return "保修结束";
			default:
				return null;
		}

	}

	public String getCode() {
		return code;
	}

	public static String getCodeByName(String name) {
		if (StringUtils.isBlank(name)) {
			return null;
		}
		for (BusinessStatusEnum businessStatusEnum : BusinessStatusEnum.values()) {
			if (name.equals(businessStatusEnum.toString())) {
				return businessStatusEnum.getCode();
			}
		}
		return null;
	}
}
