package com.ejianc.business.danger.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.constructor.vo.ZjlzfaVO;
import com.ejianc.business.danger.vo.DangerProjectDesktopDTO;
import com.ejianc.business.market.vo.CloseCostReportVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.danger.bean.DangerProjectEntity;
import com.ejianc.business.danger.service.IDangerProjectService;
import com.ejianc.business.danger.vo.DangerProjectVO;

/**
 * 危大工程登记
 *
 * @author generator
 */
@Controller
@RequestMapping("dangerProject")
public class DangerProjectController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "WDGC";//此处需要根据实际修改

    @Autowired
    private IDangerProjectService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DangerProjectVO> saveOrUpdate(@RequestBody DangerProjectVO saveOrUpdateVO) {
        DangerProjectEntity entity = BeanMapper.map(saveOrUpdateVO, DangerProjectEntity.class);
        UserContext userContextCache = sessionManager.getUserContext();
        if (entity.getId() == null || entity.getId() == 0) {
            //设置创建人姓名
            entity.setCreateUserName(userContextCache.getUserName());
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改删除本行或者上一行
            } else {
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
        } else {
            //设置修改人姓名
            entity.setUpdateUserName(userContextCache.getUserName());
        }
        service.saveOrUpdate(entity, false);
        DangerProjectVO vo = BeanMapper.map(entity, DangerProjectVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DangerProjectVO> queryDetail(Long id) {
        DangerProjectEntity entity = service.selectById(id);
        DangerProjectVO vo = BeanMapper.map(entity, DangerProjectVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DangerProjectVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DangerProjectVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(DangerProjectVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DangerProjectVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");//项目名称
        fuzzyFields.add("zjlzfzName");//方案编制
        fuzzyFields.add("dutyPerson");//责任人
        fuzzyFields.add("billCode");//责任人
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        List<OrgVO> orgVOList = null;
        if (param.getParams().containsKey("orgId")) {
            String orgId = param.getParams().get("orgId").getValue().toString();
            param.getParams().remove("orgId");
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(Long.valueOf(orgId)), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");

        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            commonOrgIds.add(org.getId());
        });
        param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));

        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<DangerProjectEntity> page = service.queryPage(param, false);
        IPage<DangerProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DangerProjectVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<DangerProjectEntity> list = service.queryList(param);
        for (DangerProjectEntity dangerProjectEntity : list) {
            if (dangerProjectEntity.getDangerType() != null) {
                if ("1".equals(dangerProjectEntity.getDangerType())) {
                    dangerProjectEntity.setDangerType("超危工程（论证）");
                } else if ("2".equals(dangerProjectEntity.getDangerType())) {
                    dangerProjectEntity.setDangerType("危大工程");
                }
            }
            if (dangerProjectEntity.getIsFinish() != null) {
                if ("1".equals(dangerProjectEntity.getIsFinish())) {
                    dangerProjectEntity.setIsFinish("是");
                } else if ("2".equals(dangerProjectEntity.getIsFinish())) {
                    dangerProjectEntity.setIsFinish("否");
                }
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DangerProject-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refDangerProjectData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DangerProjectVO>> refDangerProjectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DangerProjectEntity> page = service.queryPage(param, false);
        IPage<DangerProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DangerProjectVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @param projectId
     * @Description queryFaByProjectId 根据项目id查找专家论证方案
     */
    @RequestMapping(value = "/queryFaByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ZjlzfaVO> queryFaByProjectId(Long projectId) {
        //创建查询条件
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("gcxmmcId", new Parameter(QueryParam.EQ, projectId));
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));
        //排序
        LinkedHashMap<String, String> orderMap = queryParam.getOrderMap();
        orderMap.clear();
        orderMap.put("createTime", QueryParam.DESC);

        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(queryParam);
        List<ZjlzfaVO> zjlzfaVOS = service.queryFaByProjectId(wrapper);
        if (ListUtil.isNotEmpty(zjlzfaVOS)) {
            return CommonResponse.success("查询详情数据成功！", zjlzfaVOS.get(0));
        } else {
            return CommonResponse.error("查询失败，该项目无审批通过的专家论证方案！");
        }
    }


//    /**
//     * @param orgId
//     * @Description queryDetail 门户查询详情
//     */
//    @RequestMapping(value = "/queryDesktopDetail", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<List<DangerProjectDesktopDTO>> queryDesktopDetail(Long orgId) {
//        if (orgId == null){
//            orgId = InvocationInfoProxy.getOrgId();
//        }
//        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
//        List<Long> orgIdList = orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());
//
//        List<DangerProjectDesktopDTO> dangerProjectDesktopDTOS = service.queryDesktopDetail(orgIdList);
//        return CommonResponse.success("查询详情数据成功！", dangerProjectDesktopDTOS);
//    }

    /**
     * @param param
     * @Description queryDetail 门户查询详情
     */
    @RequestMapping(value = "/queryDesktopList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Page<DangerProjectDesktopDTO>> queryDesktopList(@RequestBody QueryParam param) {

        Long orgId = null;
        if (param.getParams().containsKey("orgId")){
            param.getParams().remove("orgId");
        }
        if (orgId == null){
            orgId = InvocationInfoProxy.getOrgId();
        }
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        List<Long> orgIdList = orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());


        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        Page<DangerProjectDesktopDTO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<DangerProjectDesktopDTO> dangerProjectDesktopDTOS = service.queryDesktopList(page,orgIdList);

        page.setRecords(dangerProjectDesktopDTOS);
        return CommonResponse.success("查询详情数据成功！", page);
    }


    @RequestMapping(value = "/queryDesktopDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Page<DangerProjectDesktopDTO>> queryDesktopDetail(Long orgId) {

        QueryParam param = new QueryParam();
        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        List<Long> orgIdList = orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIdList));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);


        Page<DangerProjectDesktopDTO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<DangerProjectDesktopDTO> dangerProjectDesktopDTOS = new ArrayList<>();
        List<DangerProjectVO> dangerProjectVOS = service.queryStatus(null, wrapper);

        /**
         * 已施完工
         */
        DangerProjectDesktopDTO dto1 = getDto("已施完工", dangerProjectVOS);
        DangerProjectDesktopDTO dto2 = getDto("本年在施", dangerProjectVOS);
        DangerProjectDesktopDTO dto3 = getDto("本年待施", dangerProjectVOS);
        DangerProjectDesktopDTO dto4 = getDto("超期未施", dangerProjectVOS);
        DangerProjectDesktopDTO dto5 = getDto("超期未完成", dangerProjectVOS);
        dangerProjectDesktopDTOS.add(dto1);
        dangerProjectDesktopDTOS.add(dto2);
        dangerProjectDesktopDTOS.add(dto3);
        dangerProjectDesktopDTOS.add(dto4);
        dangerProjectDesktopDTOS.add(dto5);
        page.setRecords(dangerProjectDesktopDTOS);
        return CommonResponse.success("查询详情数据成功！", page);
    }

    private DangerProjectDesktopDTO getDto(String name, List<DangerProjectVO> dangerProjectVOS) {
        List<DangerProjectVO> finishCw = new ArrayList<>();
        List<DangerProjectVO> finishWd = new ArrayList<>();
        Calendar cal = Calendar.getInstance();
        int year = cal.get(Calendar.YEAR);
        SimpleDateFormat getYearFormat = new SimpleDateFormat("yyyy");
        if (name.equals("本年在施")) {
            finishCw = dangerProjectVOS.stream().filter(
                    s -> StringUtils.isNotEmpty(s.getStatus()) && s.getStatus().equals("在施")
                            && s.getDangerType().equals("1")
                            && s.getImplDate() != null && getYearFormat.format(s.getImplDate()).equals(year+"")
            ).collect(Collectors.toList());
            finishWd = dangerProjectVOS.stream().filter(
                    s -> StringUtils.isNotEmpty(s.getStatus()) && s.getStatus().equals("在施")
                            && s.getDangerType().equals("2")
                            && s.getImplDate() != null && getYearFormat.format(s.getImplDate()).equals(year+"")
            ).collect(Collectors.toList());
        } else if (name.equals("本年待施")) {
            finishCw = dangerProjectVOS.stream().filter(
                    s -> StringUtils.isNotEmpty(s.getStatus()) && s.getStatus().equals("待施")
                            && s.getDangerType().equals("1")
                            && s.getEstimateImplDate() != null && getYearFormat.format(s.getEstimateImplDate()).equals(year+"")
            ).collect(Collectors.toList());
            finishWd = dangerProjectVOS.stream().filter(
                    s -> StringUtils.isNotEmpty(s.getStatus()) && s.getStatus().equals("待施")
                            && s.getDangerType().equals("2")
                            && s.getEstimateImplDate() != null && getYearFormat.format(s.getEstimateImplDate()).equals(year+"")
            ).collect(Collectors.toList());
        } else {
            finishCw = dangerProjectVOS.stream().filter(
                    s -> StringUtils.isNotEmpty(s.getStatus()) && s.getStatus().equals(name)
                            && s.getDangerType().equals("1")
            ).collect(Collectors.toList());
            finishWd = dangerProjectVOS.stream().filter(
                    s -> StringUtils.isNotEmpty(s.getStatus()) && s.getStatus().equals(name)
                            && s.getDangerType().equals("2")
            ).collect(Collectors.toList());
        }

        DangerProjectDesktopDTO dto = new DangerProjectDesktopDTO();
        dto.setName(name);
        dto.setCw(finishCw.size());
        dto.setWd(finishWd.size());
        return dto;
    }

    /**
     * @param param
     * @Description queryStatus 查询所有状态
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DangerProjectVO>> queryStatus(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");//项目名称
        fuzzyFields.add("zjlzfzName");//方案编制
        fuzzyFields.add("dutyPerson");//责任人
        fuzzyFields.add("billCode");//责任人

        /**
         * 组织隔离
         */
        List<OrgVO> orgVOList = null;
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");

        } else {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            param.getParams().remove("orgId");
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            commonOrgIds.add(org.getId());
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /**
         *实现分页
         */
        Page<DangerProjectVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        page.setRecords(service.queryStatus(page, wrapper));

        return CommonResponse.success("查询列表数据成功！", page);
    }
}
