package com.ejianc.business.project.controller.api;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.market.bean.ProjectSetEntity;
import com.ejianc.business.market.service.ICompletionWorkReportService;
import com.ejianc.business.market.service.IFinishWorkReportService;
import com.ejianc.business.market.service.IProjectSetService;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/***
 * @description:
 * @author
 * @date:
 */
@RestController
@RequestMapping
public class ProjectSetApi {

    @Autowired
    private ICompletionWorkReportService completionWorkReportService;

    @Autowired
    private IProjectSetApi projectSetApi;
    @Autowired
    private IProjectSetService projectSetService;

    @Autowired
    private IFinishWorkReportService finishWorkReportService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 根据项目ID(projectID)修改建造师
     * @param projectId
     * @return
     */
    @GetMapping("/api/projectSet/updateProjectJzsInfo")
    public CommonResponse<String> updateProjectJzsInfo(@RequestParam(value = "projectId") Long projectId,
                                                @RequestParam(value = "userId") Long userId,
                                                @RequestParam(value = "userName") String userName) {
//        LambdaQueryWrapper<ContractRegisterEntity> queryWrapper = new LambdaQueryWrapper<>();
//        queryWrapper.eq(ContractRegisterEntity::getProjectId,projectId);
//        queryWrapper.eq(ContractRegisterEntity::getDr,0);
//        queryWrapper.eq(ContractRegisterEntity::getSupplementFlag,0);
//        queryWrapper.eq(ContractRegisterEntity::getTenantId, InvocationInfoProxy.getTenantid());
//        queryWrapper.in(ContractRegisterEntity::getBillState, 1, 3);
//        List<ContractRegisterEntity> contractRegisterEntities = service.list(queryWrapper);
//        if (CollectionUtil.isNotEmpty(contractRegisterEntities)){
//            ContractRegisterEntity contractRegisterEntity = contractRegisterEntities.get(0);
//            contractRegisterEntity.set
//        }

        LambdaQueryWrapper<ProjectSetEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ProjectSetEntity::getId,projectId);
        queryWrapper.eq(ProjectSetEntity::getDr,0);
        //queryWrapper.eq(ContractReviewEntity::getSupplementFlag,0);
        queryWrapper.eq(ProjectSetEntity::getTenantId, InvocationInfoProxy.getTenantid());
        queryWrapper.in(ProjectSetEntity::getBillState, 1, 3);
        List<ProjectSetEntity> list = projectSetService.list(queryWrapper);
        logger.info("list=====================:{}", JSON.toJSONString(list));
        if (CollectionUtil.isNotEmpty(list)){
            for (ProjectSetEntity contractReviewEntity : list) {
                contractReviewEntity.setProjectManagementId(userId);
                contractReviewEntity.setProjectManagementName(userName);
                projectSetService.saveOrUpdate(contractReviewEntity);
                projectSetService.pushProjectPoolSetNoInitial(contractReviewEntity, "3");
            }
        }
        return CommonResponse.success("查询成功！");
    }


}
