package com.ejianc.business.market.service.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.api.IHomePortalApi;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.market.bean.CloseCostEntity;
import com.ejianc.business.enums.CapitalStatusEnum;
import com.ejianc.business.market.bean.ProjectSetEntity;
import com.ejianc.business.market.mapper.CloseCostMapper;
import com.ejianc.business.market.service.ICloseCostService;
import com.ejianc.business.market.service.IFinishWorkReportService;
import com.ejianc.business.market.service.IProjectSetService;
import com.ejianc.business.market.vo.CloseCostReportVO;
import com.ejianc.business.market.vo.TargetCostFitDTO;
import com.ejianc.business.outputvalcount.api.IOutputValueApi;
import com.ejianc.business.pro.income.api.IProincomeContractApi;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.pro.income.vo.FinalizedVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.profinance.api.IReceiptAndPaymentRegisterApi;
import com.ejianc.business.receipt.api.IReceiptRegisterApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.google.common.base.Stopwatch;
import org.apache.commons.collections.CollectionUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 成本关门
 *
 * @author baipengyan
 */
@Service("closeCostService")
public class CloseCostServiceImpl extends BaseServiceImpl<CloseCostMapper, CloseCostEntity> implements ICloseCostService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IProjectPoolApi projectPoolApi;
    private final IProjectSetApi projectSetApi;
    private final IFinishWorkReportService finishWorkReportService;
    @Value("${common.env.base-host}")
    private String BaseHost;

    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IProjectSetService projectSetService;

    public CloseCostServiceImpl(IProjectPoolApi projectPoolApi, IProjectSetApi projectSetApi, IFinishWorkReportService finishWorkReportService) {
        this.projectPoolApi = projectPoolApi;
        this.projectSetApi = projectSetApi;
        this.finishWorkReportService = finishWorkReportService;
    }

    @Override
    public void autoCloseCost() {
        HttpServletRequest request = ((ServletRequestAttributes) Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        HashMap<String, String> headers = new HashMap<>();
        headers.put("authority", request.getHeader("authority"));
        headers.put("ejc-token", request.getHeader("ejc-token"));

        ExecutorService executorService = Executors.newFixedThreadPool(1);
        CompletableFuture.runAsync(() -> {
            Stopwatch stopwatch = Stopwatch.createStarted();

            QueryParam param = new QueryParam();
            param.setPageIndex(1);
            param.setPageSize(-1);
            param.getParams().put("capitalStatus", new Parameter(QueryParam.NE, CapitalStatusEnum.成本关门.getCode()));
            String body = HttpRequest.post(BaseHost + "ejc-share-web/api/projectPool/queryProjectIPage")
                    .addHeaders(headers)
                    .body(JSON.toJSONString(param))
                    .timeout(60000)
                    .execute().body();
            JSONObject jsonObject = JSON.parseObject(body, JSONObject.class);
            JSONObject data = (JSONObject) jsonObject.get("data");
            JSONArray records = (JSONArray) data.get("records");
            logger.info("查询项目池用时「{}」秒", stopwatch.stop().elapsed(TimeUnit.SECONDS));

            stopwatch.reset().start();

            if (CollectionUtils.isNotEmpty(records)) {
                List<Long> projectIds = new ArrayList<>();
                for (Object record : records) {
                    JSONObject json = (JSONObject) record;
                    projectIds.add(Long.parseLong(String.valueOf(json.get("id"))));
                }
                List<Long> ids = finishWorkReportService.queryCanCloseCostProjectIds(projectIds);
                if (CollectionUtils.isNotEmpty(ids)) {
                    logger.info("ids：{}", ids);
                    for (Long projectId : ids) {
                        HashMap<String, Object> paramMaps = new HashMap<>();
                        paramMaps.put("projectId", projectId);
                        paramMaps.put("capitalStatus", CapitalStatusEnum.成本关门.getCode());
                        String responseBody = HttpUtil.createGet(BaseHost + "ejc-share-web/api/projectPoolSetApi/changeProjectStatus")
                                .addHeaders(headers)
                                .form(paramMaps)
                                .execute()
                                .body();
                        CommonResponse res = JSON.parseObject(responseBody, CommonResponse.class);
                        if (!res.isSuccess()) {
                            logger.info("自动成本关门更新【项目池】项目【{}】资金管控状态为【{}】失败，失败原因：{}", projectId, CapitalStatusEnum.成本关门, res.getMsg());
                        }else {
                            //更新项目基本信息
                            ProjectSetEntity projectSetEntity = projectSetService.selectById(projectId);
                            if(projectSetEntity != null) {
                                projectSetEntity.setCapitalStatus(CapitalStatusEnum.成本关门.getCode());
                                projectSetService.saveOrUpdate(projectSetEntity);
                            }
                        }
                    }
                }
            }
            logger.info("自动关门处理完成共用时「{}」秒", stopwatch.stop().elapsed(TimeUnit.SECONDS));
        }, executorService);
        executorService.shutdown();
    }


    @Autowired
    private IHomePortalApi iHomePortalApi;

    @Autowired
    private IOutputValueApi iOutputValueApi;

    @Autowired
    private IReceiptRegisterApi iReceiptRegisterApi;

    @Autowired
    private ISettlePoolApi iSettlePoolApi;

    @Autowired
    private IReceiptAndPaymentRegisterApi iReceiptAndPaymentRegisterApi;

    @Autowired
    private ICostDetailApi iCostDetailApi;

    @Autowired
    private IProincomeContractApi iProincomeContractApi;


    @Override
    public HashMap<String, BigDecimal> getDetailByProjectId(Long projectId) {
        HashMap<String, BigDecimal> result = new HashMap<>();
        CommonResponse<JSONObject> outputScale = iHomePortalApi.queryOutputScale(projectId);
        JSONObject jsonObject = outputScale.getData();

//		/**
//		 * 施工合同总金额(含工程造价调整金额)
//		 */
//		BigDecimal proIncomeMny = BigDecimal.ZERO;
//		List<ContractRegisterVO> registerVOS = baseMapper.queryProIncome(projectId);
//		if(ListUtil.isNotEmpty(registerVOS)){
//			for (ContractRegisterVO vo : registerVOS) {
//				//工程造价调整金额合计
//				if(vo.getTotalCostAdjustTaxMny() !=null){
//					proIncomeMny = proIncomeMny.add(vo.getTotalCostAdjustTaxMny());
//				} else {
//					proIncomeMny = proIncomeMny.add(vo.getContractTaxMny());
//				}
//
//			}
//		}
//		result.put("施工合同总金额(含工程造价调整金额)",proIncomeMny);
//		/**
//		 * 工程定案金额
//		 */
//		BigDecimal finalizedMny = BigDecimal.ZERO;
//		FinalizedVO finalizedVO = baseMapper.queryFinalized(projectId);
//		if(finalizedVO != null){
//			finalizedMny = finalizedVO.getCheckTaxMny();
//		}
//		result.put("工程定案金额",finalizedMny);
//
//		/**
//		 * 产值统计
//		 */
//		BigDecimal outputValue = BigDecimal.ZERO;
//		CommonResponse<OutputValueVO> sumByProjectId = iOutputValueApi.getSumByProjectId(projectId);
//		OutputValueVO outputValueVO = sumByProjectId.getData();
//		if(outputValueVO != null){
//			outputValue = outputValueVO.getSum();
//
//		}
//		result.put("完成产值(工程部)",outputValue);
////		/**
////		 *
////		 * 已收款额
////		 */
////		BigDecimal paymentMny = BigDecimal.ZERO;
////		CommonResponse<BigDecimal> queryRecMnyByProjectId = iReceiptRegisterApi.queryRecMnyByProjectId(projectId);
////		BigDecimal data = queryRecMnyByProjectId.getData();
////		if(data != null){
////			paymentMny = data;
////		}
////		result.put("已收款额",paymentMny);
////		/**
////		 *
////		 * 直接费结算总额
////		 */
////		BigDecimal settlePoolMny = BigDecimal.ZERO;
////		QueryParam queryParam = new QueryParam();
////		queryParam.getParams().put("projectId",new Parameter(QueryParam.EQ,projectId));
////		CommonResponse<Map<String, BigDecimal>> mapCommonResponse = iSettlePoolApi.queryContractsTotalSettleMny(queryParam);
////		Map<String, BigDecimal> settlePoolMap = mapCommonResponse.getData();
////		if(null != settlePoolMap){
////			for (Map.Entry<String, BigDecimal> entry : settlePoolMap.entrySet()) {
////				settlePoolMny = settlePoolMny.add(entry.getValue());
////			}
////		}
////		result.put("直接费结算总额",settlePoolMny);
////		/**
////		 *
////		 * 已支付直接费总额
////		 */
////		List<String> contractTypeList = Arrays.asList("contractAC","contractConcrete","contractMaterial",
////				"contractOther","equipmentPurchase","equipmentRent","laborSub","proSub","rmat");
////		BigDecimal pay = BigDecimal.ZERO;
////		for (String contractType : contractTypeList) {
////			CommonResponse<JSONObject> response = iReceiptAndPaymentRegisterApi.queryPayMnyByProjAndContType(projectId, contractType);
////			JSONObject paymentJSON = response.getData();
////			BigDecimal payMny = paymentJSON.getBigDecimal("payMny");
////			if(payMny != null){
////				pay = pay.add(payMny);
////			}
////		}
////		result.put("已支付直接费总额",pay);
//		/**
//		 * 间接费
//		 */
//		BigDecimal handShareMny = BigDecimal.ZERO;
//		CommonResponse<JSONObject> queryCostMnyByProjectId = iCostDetailApi.queryCostMnyByProjectId(projectId);
//		JSONObject costMnyByProjectIdData = queryCostMnyByProjectId.getData();
//		if(null != costMnyByProjectIdData){
//			handShareMny = costMnyByProjectIdData.getBigDecimal("costMny");
//		}
//		result.put("预计间接费总额",handShareMny);
//		result.put("已支付间接费总额",handShareMny);


        /**
         * 合同总价（合约部）
         *
         * 取工程造价调整后总金额(不含暂列金额),即内部管控金额
         */
        BigDecimal proIncomeMny = BigDecimal.ZERO;
        List<ContractRegisterVO> registerVOS = baseMapper.queryProIncome(projectId);
        if (ListUtil.isNotEmpty(registerVOS)) {
            for (ContractRegisterVO vo : registerVOS) {
                //工程造价调整后总金额(不含暂列金额)
                proIncomeMny = proIncomeMny.add(vo.getNicContractMny());

            }
        }
        result.put("合同总价(合约部)", proIncomeMny);

        /**
         * 合同变更协议(甲方签章)(合约部)
         *
         * 取补充协议类
         */
        List<JSONObject> totalContract = queryESContract(projectId, "srglsghttj");
        BigDecimal totalChangeContractMny = BigDecimal.ZERO;//合同变更金额
        BigDecimal totalQuoteMny = BigDecimal.ZERO;//对甲报量金额
        for (JSONObject contract : totalContract) {
            logger.info("施工合同履约情况台账数据1==========JSONObject{}", contract);
            logger.info("施工合同履约情况台账数据2==========JSONString{}", contract.toJSONString());
            BigDecimal base = contract.getBigDecimal("base");//原合同金额
            BigDecimal contractMny = contract.getBigDecimal("contractMny");//变更后合同金额
            BigDecimal changeContractMny = base.subtract(contractMny);//合同变更金额
            totalChangeContractMny = totalChangeContractMny.add(changeContractMny);


            BigDecimal quoteMny = contract.getBigDecimal("quoteMny");//对甲报量金额
            totalQuoteMny = totalQuoteMny.add(quoteMny);

        }
        result.put("合同变更协议(甲方签章)(合约部)", totalChangeContractMny);

//
//        /**
//         *
//         * 实际完成产值（工程部）
//         *
//         */
//        BigDecimal productionMny = BigDecimal.ZERO;
//        CommonResponse<BigDecimal> production = iProincomeContractApi.queryProductionByProject(projectId);
//        if (production.getData() != null) {
//            productionMny = production.getData();
//        }
//        result.put("实际完成产值(工程部)", productionMny);


        /**
         * 给甲方报量（或者给甲方报送的决算金额）
         */
        result.put("给甲方报量(或者给甲方报送的决算金额)", totalQuoteMny);

        /**
         * 工程结算定案金额
         *
         */
        BigDecimal finalizedMny = BigDecimal.ZERO;
        FinalizedVO finalizedVO = baseMapper.queryFinalized(projectId);
        if (finalizedVO != null) {
            finalizedMny = finalizedVO.getCheckTaxMny();
        }
        result.put("工程结算定案金额", finalizedMny);

        /**
         * 已收建设单位工程款（资金+抵账+其他）
         */
        BigDecimal paymentMny = BigDecimal.ZERO;
        CommonResponse<BigDecimal> queryRecMnyByProjectId = iReceiptRegisterApi.queryRecMnyByProjectId(projectId);
        if (queryRecMnyByProjectId.getData() != null) {
            paymentMny = queryRecMnyByProjectId.getData();
        }
        result.put("已收建设单位工程款(资金+抵账+其他)", paymentMny);


        return result;
    }


    /**
     * 成本关门从es出取出数据
     */
    //项目支出合同台账es索引名
    private final static String INDEX_EX_CONTRACTT = "ex_contractt";
    //从施工收入合同台账一览表（施工合同履约情况台账）索引名
    private final static String INDEX_srSGHTTZYL = "srglsghttj";

    //ES客户端
    @Autowired(required = false)
    private RestHighLevelClient client;

    public List<JSONObject> queryESContract(Long projectId, String index) {
        JSONObject result = new JSONObject();
        List<JSONObject> resultList = new ArrayList<>();
        //1.获取索引库
        SearchRequest searchRequest = new SearchRequest(index);
        //2.构建查询条件
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        //TODO 可以根据更多条件去查询
        //3.放入查询请求中
        if (INDEX_EX_CONTRACTT.equals(index)) {
            sourceBuilder.query(QueryBuilders.termQuery("projectId", projectId));
        } else if (INDEX_srSGHTTZYL.equals(index)) {
            sourceBuilder.query(QueryBuilders.termQuery("pId", projectId));
        }
        searchRequest.source(sourceBuilder);
        searchRequest.source().size(1000);
        logger.info("打印查询参数   sourceBuilder------------------：" + JSON.toJSONString(sourceBuilder));
        //4.发送查询请求
        try {
            //查询及转换
            SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
            logger.info("打印请求参数  searchRequest------------------：", searchRequest);

            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                logger.info("----------------ES获取数据为--------------：{}", sourceAsString);
                result = JSON.parseObject(sourceAsString);
                if (result.getBigDecimal("lu:yueqianfujine") != null) {
                    result.put("luyueqianfujine", result.getBigDecimal("lu:yueqianfujine"));
                }
                resultList.add(result);
            }
            //TODO 如需要可对数据进行二次加工处理

        } catch (IOException e) {
            logger.error(e.getMessage());
            throw new BusinessException("根据查询条件，查询全部记录索引失败，MSG：" + e.getMessage());
        }
        return resultList;
    }

    @Override
    public Page<CloseCostReportVO> queryReportList(QueryParam param) {
        String[] split = null;
        if (param.getParams().containsKey("proProFitPer")){
            String proProFitPer = param.getParams().get("proProFitPer").getValue().toString();
             split = proProFitPer.split(",");
            param.setPageSize(500);
            param.setPageIndex(1);
            param.getParams().remove("proProFitPer");
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        Page<CloseCostReportVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<CloseCostReportVO> closeCostReportVOS = baseMapper.queryReportList(page,wrapper);
        /**
         * 2024-3-26 均改为静态数据，
         * 只有项目定案金额、施工合同总额、已收款、取动态数据
         * 直接费占比、间接费占比、盈亏金额、利润率，有工程定案金额取定案金额，无则取施工合同总额,前端进行计算
         */
        CommonResponse<List<DefdocDetailVO>> apiDefDocByDefCode = defdocApi.getDefDocByDefCode("pro-market-project-engineeringType");
        Map<Long, String> map = new HashMap<>();
        if (apiDefDocByDefCode.isSuccess()) {
            List<DefdocDetailVO> data = apiDefDocByDefCode.getData();
            map = data.stream().collect(Collectors.toMap(DefdocDetailVO::getId, DefdocDetailVO::getName));
        }
        List<CloseCostReportVO> closeCostReporList = new ArrayList<>();
        for (CloseCostReportVO closeCostReportVO : closeCostReportVOS) {
            String name = map.get(closeCostReportVO.getEngineeringTypeId());
            if(StrUtil.isNotBlank(name)){
                closeCostReportVO.setEngineeringTypeName(name);
                Long projectId = closeCostReportVO.getProjectId();
                //工程造价调整后总金额(不含暂列金额)
                BigDecimal proIncomeMny = BigDecimal.ZERO;
                List<ContractRegisterVO> registerVOS = baseMapper.queryProIncome(projectId);
                if (ListUtil.isNotEmpty(registerVOS)) {
                    for (ContractRegisterVO vo : registerVOS) {
                        proIncomeMny = proIncomeMny.add(vo.getNicContractMny());
                    }

                    //实时的利润率
                    closeCostReportVO.setProProfitPer(proIncomeMny.subtract(closeCostReportVO.getTotalEstimatedPayMny()).divide(proIncomeMny,BigDecimal.ROUND_CEILING).multiply(new BigDecimal(100)).setScale(2,BigDecimal.ROUND_HALF_UP));
                    closeCostReportVO.setProProfit(proIncomeMny.subtract(closeCostReportVO.getTotalEstimatedPayMny()).setScale(2,BigDecimal.ROUND_HALF_UP));

                }
                //工程定案金额
                BigDecimal finalizedMny = BigDecimal.ZERO;
                FinalizedVO finalizedVO = baseMapper.queryFinalized(projectId);
                if (finalizedVO != null) {
                    finalizedMny = finalizedVO.getCheckTaxMny();
                    //实时的利润率
                    closeCostReportVO.setProProfitPer(finalizedMny.subtract(closeCostReportVO.getTotalEstimatedPayMny()).divide(finalizedMny,BigDecimal.ROUND_CEILING).multiply(new BigDecimal(100)).setScale(2,BigDecimal.ROUND_HALF_UP));
                    closeCostReportVO.setProProfit(finalizedMny.subtract(closeCostReportVO.getTotalEstimatedPayMny()).setScale(2,BigDecimal.ROUND_HALF_UP));
                }
                //已收款
                BigDecimal recMny = BigDecimal.ZERO;
                CommonResponse<BigDecimal> queryRecMnyByProjectId = iReceiptRegisterApi.queryRecMnyByProjectId(projectId);
                if (queryRecMnyByProjectId.getData() != null) {
                    recMny = queryRecMnyByProjectId.getData();
                }
                closeCostReportVO.setNicContractMny(proIncomeMny);
                closeCostReportVO.setFinalizedMny(finalizedMny);
                closeCostReportVO.setReceiveMny(recMny);

                if (split != null &&
                        closeCostReportVO.getProProfitPer().compareTo(new BigDecimal(split[0])) > -1  &&
                        closeCostReportVO.getProProfitPer().compareTo(new BigDecimal(split[1])) == -1
                    ){
                    closeCostReporList.add(closeCostReportVO);
                }
            }
        }

//        /**
//         * 从项目支出合同台账中，取直接费动态数据
//         */
//        for (CloseCostReportVO closeCostReportVO : closeCostReportVOS) {
//            String name = map.get(closeCostReportVO.getEngineeringTypeId());
//            if(StrUtil.isNotBlank(name)){
//                closeCostReportVO.setEngineeringTypeName(name);
//            }
//            List<JSONObject> exContractt = this.queryESContract(closeCostReportVO.getProjectId(), "ex_contractt");
//            //直接费总额
//            BigDecimal totalPayDirectFees = BigDecimal.ZERO;
//            //已支付直接费总额
//            BigDecimal totalPaidDirectFees = BigDecimal.ZERO;
//            for (JSONObject jsonObject : exContractt) {
//                //累计结算金额
//                BigDecimal sumsettleMny = jsonObject.getBigDecimal("sumsettleMny");
//                //含工资累计实付总额
//                BigDecimal hangongzileijishifuzonge = jsonObject.getBigDecimal("hangongzileijishifuzonge");
//                totalPayDirectFees = totalPayDirectFees.add(sumsettleMny);
//                totalPaidDirectFees = totalPaidDirectFees.add(hangongzileijishifuzonge);
//            }
//            closeCostReportVO.setTotalUnderPayDirectFees(BigDecimal.ZERO);
//            closeCostReportVO.setZhijiefeizhanbi(BigDecimal.ZERO);
//            closeCostReportVO.setJianjiefeizhanbi(BigDecimal.ZERO);
//            if(totalPayDirectFees != null && totalPaidDirectFees != null){
//                closeCostReportVO.setTotalUnderPayDirectFees(totalPayDirectFees.subtract(totalPaidDirectFees));
//            }
//            if(closeCostReportVO.getContractMny() != null && totalPayDirectFees != null){
//                closeCostReportVO.setZhijiefeizhanbi(totalPayDirectFees.divide(closeCostReportVO.getContractMny(),4,BigDecimal.ROUND_CEILING));
//            }
//            if(closeCostReportVO.getContractMny() != null && closeCostReportVO.getTotalEstimatedIndirectTaxMny() != null){
//                closeCostReportVO.setJianjiefeizhanbi(closeCostReportVO.getTotalEstimatedIndirectTaxMny().divide(closeCostReportVO.getContractMny(),BigDecimal.ROUND_CEILING));
//            }
//            closeCostReportVO.setTotalPayDirectFees(totalPayDirectFees);
//            closeCostReportVO.setTotalPaidDirectFees(totalPaidDirectFees);

//        }
        if (split != null){
            page.setRecords(closeCostReporList);
            page.setTotal(closeCostReporList.size());
        }else {
            page.setRecords(closeCostReportVOS);
        }
        return page;
    }

    @Override
    public TargetCostFitDTO getTargetReportFit(Long projectId) {
        return baseMapper.getTargetReportFit(projectId);
    }
}
