package com.ejianc.business.market.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.market.bean.AdjustAddressEntity;
import com.ejianc.business.market.bean.ProjectSetEntity;
import com.ejianc.business.market.service.IAdjustAddressService;
import com.ejianc.business.market.service.IProjectSetService;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.nio.charset.StandardCharsets;

@Service("adjustAddress") 
public class AdjustAddressBpmServiceImpl implements ICommonBusinessService {


	private final Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IProjectSetApi projectSetApi;

	@Autowired
	private IAdjustAddressService adjustAddressService;

	@Autowired
	private IProjectSetService projectSetService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 * @description
	 * 		将地址和经纬度坐标同步更新到项目基本信息、项目池中
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		AdjustAddressEntity adjustAddressEntity = adjustAddressService.selectById(billId);
		if(null != adjustAddressEntity){
			Long projectId = adjustAddressEntity.getProjectId();
			ProjectSetEntity projectSetEntity = projectSetService.selectById(projectId);
			if(projectSetEntity != null){
				projectSetEntity.setLat(adjustAddressEntity.getAddressLat());
				projectSetEntity.setLng(adjustAddressEntity.getAddressLng());
				projectSetEntity.setAddress(adjustAddressEntity.getAddress());
				logger.info("---------同步地址信息开始");
				logger.info("projectSetEntity:{}", JSONObject.toJSONString(projectSetEntity));
				//同步项目基本信息
				projectSetService.saveOrUpdate(projectSetEntity);
				//同步项目池
				ProjectPoolSetVO projectPoolSetVO = BeanMapper.map(projectSetEntity, ProjectPoolSetVO.class);
				projectSetApi.pushProjectPoolSetNoInitial(JSONObject.toJSONString(projectPoolSetVO).getBytes(StandardCharsets.UTF_8));
				logger.info("---------同步地址信息结束");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
//		return CommonResponse.error("该单据不允许撤回！如果需要修改，请重新生成单据！");
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
