package com.ejianc.business.danger.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.constructor.vo.ZjlzfaVO;
import com.ejianc.business.danger.vo.DangerProjectDesktopDTO;
import com.ejianc.business.danger.vo.DangerProjectVO;
import com.ejianc.business.market.vo.CloseCostReportVO;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.danger.bean.DangerProjectEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 危大工程登记
 *
 * @author generator
 */
@Mapper
public interface DangerProjectMapper extends BaseCrudMapper<DangerProjectEntity> {

    List<ZjlzfaVO> queryFaByProjectId(@Param(Constants.WRAPPER) QueryWrapper wrapper);


    /**
     * 门户查询详情
     */
    List<DangerProjectDesktopDTO> queryDesktopDetail(@Param("orgId") List<Long> orgId);


    /**
     * 门户查询列表
     */
    List<DangerProjectDesktopDTO> queryDesktopList(Page<DangerProjectDesktopDTO> page, @Param("orgId")List<Long> orgId);

    /**
     * 从视图所有状态
     *
     * @param
     * @return
     */
    List<DangerProjectVO> queryStatus(Page<DangerProjectVO> page, @Param(Constants.WRAPPER)QueryWrapper wrapper);


}
