package com.ejianc.business.market.service;

import com.ejianc.business.constructor.vo.NbzzFollowVO;
import com.ejianc.business.market.vo.CostDesktopVO;
import com.ejianc.business.project.vo.ProjectAddressVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.market.bean.ProjectSetEntity;

import java.util.List;

/**
 * 项目立项表
 * 
 * @author generator
 * 
 */
public interface IProjectSetService extends IBaseService<ProjectSetEntity> {

    CommonResponse<String> pushProjectPoolSet(ProjectSetEntity projectSetEntity, String billTypeCode);

    CommonResponse<String> pushProjectPoolSetNoInitial(ProjectSetEntity projectSetEntity, String billTypeCode);

    CommonResponse<List<ProjectAddressVO>> queryProjectAddress(QueryParam param, String year);

    CostDesktopVO queryProjectNumCostDesktop(String time);

    /**
     * 项目跟踪
     * @param projectId
     * @return
     */
    List<NbzzFollowVO> queryFollowListByProjectId(Long projectId);
}
