package com.ejianc.business.market.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * @author baipengyan
 * @date 2022/8/30
 * @description 归档状态
 */
public enum ArchiveStatusEnum {
	资料未归档("10"),
	资料已归档("11");
	private final String code;

	ArchiveStatusEnum(String code) {
		this.code = code;
	}

	public static String getNameByCode(String archiveStatus) {
		switch (archiveStatus) {
			case "10":
				return "资料未归档";
			case "11":
				return "资料已归档";
			default:
				return null;
		}

	}

	public String getCode() {
		return code;
	}

	public static String getCodeByName(String name) {
		if (StringUtils.isBlank(name)) {
			return null;
		}
		for (ArchiveStatusEnum archiveStatusEnum : ArchiveStatusEnum.values()) {
			if (name.equals(archiveStatusEnum.toString())) {
				return archiveStatusEnum.getCode();
			}
		}
		return null;
	}
}
