package com.ejianc.business.market.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 停工报告
 * 
 * @author generator
 * 
 */
 @TableName("ejc_promarket_stop_work_report")
public class StopWorkReportEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private Long projectId; // 所属项目Id
    @TableField(value="project_name")
    private String projectName; // 所属项目名称
    @TableField(value="project_code")
    private String projectCode; // 所属项目编码
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 所属项目部Id
    @TableField(value="org_name")
    private String orgName; // 所属项目部名称
    @TableField(value="org_code")
    private String orgCode; // 所属项目部编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="employee_phone")
    private String employeePhone; // 经办人电话
    @TableField(value="department_id")
    private Long departmentId; // 经办部门id
    @TableField(value="department_name")
    private String departmentName; // 经办部门
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="stop_work_create_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date stopWorkCreateDate; // 停工开始日期
    @TableField(value="stop_work_end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date stopWorkEndDate; // 停工结束日期
    @TableField(value="stop_work_eften")
    private Integer stopWorkEften; // 停工时常
    @TableField(value="memo")
    private String memo; // 停工事由

    @TableField(exist = false)
    private String billStateName;
    @TableField(value = "patrol_group_id")
    private Long patrolGroupId;// 所属巡检组id
    @TableField(value = "patrol_group")
    private String patrolGroup;// 所属巡检组名称
    @TableField(value = "build_unit_id")
    private Long buildUnitId;// 施工单位id
    @TableField(value = "build_unit_name")
    private String buildUnitName;// 施工单位名称

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getEmployeePhone() {
        return employeePhone;
    }

    public void setEmployeePhone(String employeePhone) {
        this.employeePhone = employeePhone;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Date getStopWorkCreateDate() {
        return stopWorkCreateDate;
    }

    public void setStopWorkCreateDate(Date stopWorkCreateDate) {
        this.stopWorkCreateDate = stopWorkCreateDate;
    }
    public Date getStopWorkEndDate() {
        return stopWorkEndDate;
    }

    public void setStopWorkEndDate(Date stopWorkEndDate) {
        this.stopWorkEndDate = stopWorkEndDate;
    }
    public Integer getStopWorkEften() {
        return stopWorkEften;
    }

    public void setStopWorkEften(Integer stopWorkEften) {
        this.stopWorkEften = stopWorkEften;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Long getPatrolGroupId() {
        return patrolGroupId;
    }

    public void setPatrolGroupId(Long patrolGroupId) {
        this.patrolGroupId = patrolGroupId;
    }

    public String getPatrolGroup() {
        return patrolGroup;
    }

    public void setPatrolGroup(String patrolGroup) {
        this.patrolGroup = patrolGroup;
    }

    public Long getBuildUnitId() {
        return buildUnitId;
    }

    public void setBuildUnitId(Long buildUnitId) {
        this.buildUnitId = buildUnitId;
    }

    public String getBuildUnitName() {
        return buildUnitName;
    }

    public void setBuildUnitName(String buildUnitName) {
        this.buildUnitName = buildUnitName;
    }
}
